"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListenerCertificate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A certificate source for an ELBv2 listener.
 *
 * @stability stable
 */
class ListenerCertificate {
    /**
     * @stability stable
     */
    constructor(certificateArn) {
        this.certificateArn = certificateArn;
    }
    /**
     * Use an ACM certificate as a listener certificate.
     *
     * @stability stable
     */
    static fromCertificateManager(acmCertificate) {
        return new ListenerCertificate(acmCertificate.certificateArn);
    }
    /**
     * Use any certificate, identified by its ARN, as a listener certificate.
     *
     * @stability stable
     */
    static fromArn(certificateArn) {
        return new ListenerCertificate(certificateArn);
    }
}
exports.ListenerCertificate = ListenerCertificate;
_a = JSII_RTTI_SYMBOL_1;
ListenerCertificate[_a] = { fqn: "@aws-cdk/aws-elasticloadbalancingv2.ListenerCertificate", version: "1.131.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGlzdGVuZXItY2VydGlmaWNhdGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsaXN0ZW5lci1jZXJ0aWZpY2F0ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7O0FBU0EsTUFBYSxtQkFBbUI7Ozs7SUFjOUIsWUFBc0IsY0FBc0I7UUFDMUMsSUFBSSxDQUFDLGNBQWMsR0FBRyxjQUFjLENBQUM7SUFDdkMsQ0FBQzs7Ozs7O0lBZE0sTUFBTSxDQUFDLHNCQUFzQixDQUFDLGNBQWdDO1FBQ25FLE9BQU8sSUFBSSxtQkFBbUIsQ0FBQyxjQUFjLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDaEUsQ0FBQzs7Ozs7O0lBR00sTUFBTSxDQUFDLE9BQU8sQ0FBQyxjQUFzQjtRQUMxQyxPQUFPLElBQUksbUJBQW1CLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakQsQ0FBQzs7QUFUSCxrREFpQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBhY20gZnJvbSAnQGF3cy1jZGsvYXdzLWNlcnRpZmljYXRlbWFuYWdlcic7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIElMaXN0ZW5lckNlcnRpZmljYXRlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNlcnRpZmljYXRlQXJuOiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgTGlzdGVuZXJDZXJ0aWZpY2F0ZSBpbXBsZW1lbnRzIElMaXN0ZW5lckNlcnRpZmljYXRlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUNlcnRpZmljYXRlTWFuYWdlcihhY21DZXJ0aWZpY2F0ZTogYWNtLklDZXJ0aWZpY2F0ZSkge1xuICAgIHJldHVybiBuZXcgTGlzdGVuZXJDZXJ0aWZpY2F0ZShhY21DZXJ0aWZpY2F0ZS5jZXJ0aWZpY2F0ZUFybik7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBmcm9tQXJuKGNlcnRpZmljYXRlQXJuOiBzdHJpbmcpIHtcbiAgICByZXR1cm4gbmV3IExpc3RlbmVyQ2VydGlmaWNhdGUoY2VydGlmaWNhdGVBcm4pO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBjZXJ0aWZpY2F0ZUFybjogc3RyaW5nO1xuXG4gIHByb3RlY3RlZCBjb25zdHJ1Y3RvcihjZXJ0aWZpY2F0ZUFybjogc3RyaW5nKSB7XG4gICAgdGhpcy5jZXJ0aWZpY2F0ZUFybiA9IGNlcnRpZmljYXRlQXJuO1xuICB9XG59XG4iXX0=