"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HugoDeploy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_certificatemanager_1 = require("aws-cdk-lib/aws-certificatemanager");
const aws_cloudfront_1 = require("aws-cdk-lib/aws-cloudfront");
const aws_cloudfront_origins_1 = require("aws-cdk-lib/aws-cloudfront-origins");
const aws_route53_1 = require("aws-cdk-lib/aws-route53");
const aws_route53_targets_1 = require("aws-cdk-lib/aws-route53-targets");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const aws_s3_deployment_1 = require("aws-cdk-lib/aws-s3-deployment");
const constructs_1 = require("constructs");
class HugoDeploy extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.publicDir = props.publicDir;
        this.domainName = props.domainName;
        this.region = props.region ? props.region : 'us-east-1';
        const bucket = new aws_s3_1.Bucket(this, 'WebsiteBucket', {
            publicReadAccess: false,
        });
        const zone = aws_route53_1.HostedZone.fromLookup(this, 'HostedZone', {
            domainName: this.domainName,
        });
        const certificate = new aws_certificatemanager_1.DnsValidatedCertificate(this, 'Certificate', {
            hostedZone: zone,
            domainName: this.domainName,
            region: this.region,
        });
        const cfFunction = new aws_cloudfront_1.Function(this, 'HugoPaths', {
            code: aws_cloudfront_1.FunctionCode.fromInline(`function handler(event) {
  var request = event.request;
  var uri = request.uri;
  if (uri.endsWith('/')) {
    request.uri += 'index.html';
  } else if (!uri.includes('.')) {
    request.uri += '/index.html';
  }
  return request;
}
`),
        });
        const distribution = new aws_cloudfront_1.Distribution(this, 'Distribution', {
            defaultBehavior: {
                origin: new aws_cloudfront_origins_1.S3Origin(bucket),
                viewerProtocolPolicy: aws_cloudfront_1.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
                allowedMethods: aws_cloudfront_1.AllowedMethods.ALLOW_GET_HEAD,
                cachePolicy: aws_cloudfront_1.CachePolicy.CACHING_OPTIMIZED,
                functionAssociations: [
                    {
                        function: cfFunction,
                        eventType: aws_cloudfront_1.FunctionEventType.VIEWER_REQUEST,
                    },
                ],
            },
            domainNames: [this.domainName],
            certificate,
            minimumProtocolVersion: aws_cloudfront_1.SecurityPolicyProtocol.TLS_V1_2_2021,
            errorResponses: [
                {
                    httpStatus: 403,
                    responsePagePath: '/index.html',
                    responseHttpStatus: 200,
                },
                {
                    httpStatus: 404,
                    responsePagePath: '/index.html',
                    responseHttpStatus: 200,
                },
            ],
        });
        // deploy code
        new aws_s3_deployment_1.BucketDeployment(this, 'BucketDeployment', {
            sources: [aws_s3_deployment_1.Source.asset(`${this.publicDir}/`)],
            destinationBucket: bucket,
            distribution,
            distributionPaths: ['/', '/index.html'],
        });
        // Route53
        new aws_route53_1.ARecord(this, 'Alias', {
            zone,
            recordName: this.domainName,
            target: aws_route53_1.RecordTarget.fromAlias(new aws_route53_targets_1.CloudFrontTarget(distribution)),
        });
    }
}
exports.HugoDeploy = HugoDeploy;
_a = JSII_RTTI_SYMBOL_1;
HugoDeploy[_a] = { fqn: "cdk-hugo-deploy.HugoDeploy", version: "0.0.10" };
//# sourceMappingURL=data:application/json;base64,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