/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.impl;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserIdentifierUtil {
    private static final Log LOG = LogFactory.getLog(UserIdentifierUtil.class);
    public static final String HMAC_ALGO = "HmacSHA1";

    private UserIdentifierUtil() {
    }

    public static String getUserId(X509Certificate signingCertificate) {
        X500Principal userPrincipal = signingCertificate.getSubjectX500Principal();
        String name = userPrincipal.toString();
        int serialNumberBeginIdx = name.indexOf("SERIALNUMBER=");
        if (-1 == serialNumberBeginIdx) {
            throw new SecurityException("SERIALNUMBER not found in X509 CN");
        }
        int serialNumberValueBeginIdx = serialNumberBeginIdx + "SERIALNUMBER=".length();
        int serialNumberValueEndIdx = name.indexOf(",", serialNumberValueBeginIdx);
        if (-1 == serialNumberValueEndIdx) {
            serialNumberValueEndIdx = name.length();
        }
        String userId = name.substring(serialNumberValueBeginIdx, serialNumberValueEndIdx);
        return userId;
    }

    public static String getNonReversibleCitizenIdentifier(String userId, String orgId, String appId, String secret) {
        Mac mac;
        byte[] secretKey;
        if (null == secret) {
            throw new IllegalArgumentException("secret key is null");
        }
        secret = secret.trim();
        if (null != orgId) {
            orgId = orgId.trim();
        } else {
            LOG.warn((Object)"it is advised to use an orgId");
        }
        if (null != appId) {
            appId = appId.trim();
        } else {
            LOG.warn((Object)"it is advised to use an appId");
        }
        try {
            secretKey = Hex.decodeHex((char[])secret.toCharArray());
        }
        catch (DecoderException e) {
            LOG.error((Object)("secret is not hexadecimal encoded: " + e.getMessage()));
            throw new IllegalArgumentException("secret is not hexadecimal encoded");
        }
        if (16 > secretKey.length) {
            LOG.warn((Object)"secret key is too short");
            throw new IllegalArgumentException("secret key is too short");
        }
        String input = userId;
        if (null != appId) {
            input = input + appId;
        }
        if (null != orgId) {
            input = input + orgId;
        }
        byte[] inputData = input.getBytes();
        SecretKeySpec macKey = new SecretKeySpec(secretKey, HMAC_ALGO);
        try {
            mac = Mac.getInstance(macKey.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("HMAC algo not available: " + e.getMessage());
        }
        try {
            mac.init(macKey);
        }
        catch (InvalidKeyException e) {
            LOG.error((Object)("invalid secret key: " + e.getMessage()), (Throwable)e);
            throw new RuntimeException("invalid secret");
        }
        mac.update(inputData);
        byte[] resultHMac = mac.doFinal();
        String resultHex = new String(Hex.encodeHex((byte[])resultHMac)).toUpperCase();
        return resultHex;
    }
}

