import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleCloudRunServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The location of the cloud run instance. eg us-central1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloud_run_service.html#location DataGoogleCloudRunService#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Name must be unique within a namespace, within a Cloud Run region.
     *
     * Is required when creating resources. Name is primarily intended
     * for creation idempotence and configuration definition. Cannot be updated.
     * More info: http://kubernetes.io/docs/user-guide/identifiers#names
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloud_run_service.html#name DataGoogleCloudRunService#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloud_run_service.html#project DataGoogleCloudRunService#project}.
     *
     * @stability stable
     */
    readonly project?: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudRunServiceMetadata extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get annotations(): any;
    /**
     * @stability stable
     */
    get generation(): number;
    /**
     * @stability stable
     */
    get labels(): any;
    /**
     * @stability stable
     */
    get namespace(): string;
    /**
     * @stability stable
     */
    get resourceVersion(): string;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    get uid(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudRunServiceStatusConditions extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get message(): string;
    /**
     * @stability stable
     */
    get reason(): string;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudRunServiceStatus extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get conditions(): any;
    /**
     * @stability stable
     */
    get latestCreatedRevisionName(): string;
    /**
     * @stability stable
     */
    get latestReadyRevisionName(): string;
    /**
     * @stability stable
     */
    get observedGeneration(): number;
    /**
     * @stability stable
     */
    get url(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudRunServiceTemplateMetadata extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get annotations(): any;
    /**
     * @stability stable
     */
    get generation(): number;
    /**
     * @stability stable
     */
    get labels(): any;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get namespace(): string;
    /**
     * @stability stable
     */
    get resourceVersion(): string;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    get uid(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnv extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRef extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get localObjectReference(): any;
    /**
     * @stability stable
     */
    get optional(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRef extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get localObjectReference(): any;
    /**
     * @stability stable
     */
    get optional(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFrom extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get configMapRef(): any;
    /**
     * @stability stable
     */
    get prefix(): string;
    /**
     * @stability stable
     */
    get secretRef(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudRunServiceTemplateSpecContainersPorts extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get containerPort(): number;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get protocol(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudRunServiceTemplateSpecContainersResources extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get limits(): any;
    /**
     * @stability stable
     */
    get requests(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudRunServiceTemplateSpecContainers extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get args(): string[];
    /**
     * @stability stable
     */
    get command(): string[];
    /**
     * @stability stable
     */
    get env(): any;
    /**
     * @stability stable
     */
    get envFrom(): any;
    /**
     * @stability stable
     */
    get image(): string;
    /**
     * @stability stable
     */
    get ports(): any;
    /**
     * @stability stable
     */
    get resources(): any;
    /**
     * @stability stable
     */
    get workingDir(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudRunServiceTemplateSpec extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get containerConcurrency(): number;
    /**
     * @stability stable
     */
    get containers(): any;
    /**
     * @stability stable
     */
    get serviceAccountName(): string;
    /**
     * @stability stable
     */
    get servingState(): string;
    /**
     * @stability stable
     */
    get timeoutSeconds(): number;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudRunServiceTemplate extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get metadata(): any;
    /**
     * @stability stable
     */
    get spec(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudRunServiceTraffic extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get latestRevision(): any;
    /**
     * @stability stable
     */
    get percent(): number;
    /**
     * @stability stable
     */
    get revisionName(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/cloud_run_service.html google_cloud_run_service}.
 *
 * @stability stable
 */
export declare class DataGoogleCloudRunService extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/cloud_run_service.html google_cloud_run_service} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleCloudRunServiceConfig);
    /**
     * @stability stable
     */
    get autogenerateRevisionName(): any;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    /**
     * @stability stable
     */
    metadata(index: string): DataGoogleCloudRunServiceMetadata;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    status(index: string): DataGoogleCloudRunServiceStatus;
    /**
     * @stability stable
     */
    template(index: string): DataGoogleCloudRunServiceTemplate;
    /**
     * @stability stable
     */
    traffic(index: string): DataGoogleCloudRunServiceTraffic;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
