import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface OrganizationIamAuditConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * The numeric ID of the organization in which you want to manage the audit logging config.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_audit_config.html#org_id OrganizationIamAuditConfig#org_id}
     *
     * @stability stable
     */
    readonly orgId: string;
    /**
     * Service which will be enabled for audit logging. The special value allServices covers all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_audit_config.html#service OrganizationIamAuditConfig#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * audit_log_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_audit_config.html#audit_log_config OrganizationIamAuditConfig#audit_log_config}
     *
     * @stability stable
     */
    readonly auditLogConfig: OrganizationIamAuditConfigAuditLogConfig[];
}
/**
 * @stability stable
 */
export interface OrganizationIamAuditConfigAuditLogConfig {
    /**
     * Identities that do not cause logging for this type of permission.
     *
     * Each entry can have one of the following values:user:{emailid}: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com. serviceAccount:{emailid}: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com. group:{emailid}: An email address that represents a Google group. For example, admins@example.com. domain:{domain}: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_audit_config.html#exempted_members OrganizationIamAuditConfig#exempted_members}
     *
     * @stability stable
     */
    readonly exemptedMembers?: string[];
    /**
     * Permission type for which logging is to be configured. Must be one of DATA_READ, DATA_WRITE, or ADMIN_READ.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_audit_config.html#log_type OrganizationIamAuditConfig#log_type}
     *
     * @stability stable
     */
    readonly logType: string;
}
export declare function organizationIamAuditConfigAuditLogConfigToTerraform(struct?: OrganizationIamAuditConfigAuditLogConfig): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/organization_iam_audit_config.html google_organization_iam_audit_config}.
 *
 * @stability stable
 */
export declare class OrganizationIamAuditConfig extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/organization_iam_audit_config.html google_organization_iam_audit_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: OrganizationIamAuditConfigConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _orgId?;
    /**
     * @stability stable
     */
    get orgId(): string;
    /**
     * @stability stable
     */
    set orgId(value: string);
    /**
     * @stability stable
     */
    get orgIdInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _auditLogConfig?;
    /**
     * @stability stable
     */
    get auditLogConfig(): OrganizationIamAuditConfigAuditLogConfig[];
    /**
     * @stability stable
     */
    set auditLogConfig(value: OrganizationIamAuditConfigAuditLogConfig[]);
    /**
     * @stability stable
     */
    get auditLogConfigInput(): OrganizationIamAuditConfigAuditLogConfig[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
