import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SccNotificationConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * This must be unique within the organization.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html#config_id SccNotificationConfig#config_id}
     *
     * @stability stable
     */
    readonly configId: string;
    /**
     * The description of the notification config (max of 1024 characters).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html#description SccNotificationConfig#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The organization whose Cloud Security Command Center the Notification Config lives in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html#organization SccNotificationConfig#organization}
     *
     * @stability stable
     */
    readonly organization: string;
    /**
     * The Pub/Sub topic to send notifications to. Its format is "projects/[project_id]/topics/[topic]".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html#pubsub_topic SccNotificationConfig#pubsub_topic}
     *
     * @stability stable
     */
    readonly pubsubTopic: string;
    /**
     * streaming_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html#streaming_config SccNotificationConfig#streaming_config}
     *
     * @stability stable
     */
    readonly streamingConfig: SccNotificationConfigStreamingConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html#timeouts SccNotificationConfig#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SccNotificationConfigTimeouts;
}
/**
 * @stability stable
 */
export interface SccNotificationConfigStreamingConfig {
    /**
     * Expression that defines the filter to apply across create/update events of assets or findings as specified by the event type.
     *
     * The
     * expression is a list of zero or more restrictions combined via
     * logical operators AND and OR. Parentheses are supported, and OR
     * has higher precedence than AND.
     *
     * Restrictions have the form <field> <operator> <value> and may have
     * a - character in front of them to indicate negation. The fields
     * map to those defined in the corresponding resource.
     *
     * The supported operators are:
     *
     * = for all value types.
     * >, <, >=, <= for integer values.
     * :, meaning substring matching, for strings.
     *
     * The supported value types are:
     *
     * string literals in quotes.
     * integer literals without quotes.
     * boolean literals true and false without quotes.
     *
     * See
     * [Filtering notifications](https://cloud.google.com/security-command-center/docs/how-to-api-filter-notifications)
     * for information on how to write a filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html#filter SccNotificationConfig#filter}
     *
     * @stability stable
     */
    readonly filter: string;
}
export declare function sccNotificationConfigStreamingConfigToTerraform(struct?: SccNotificationConfigStreamingConfigOutputReference | SccNotificationConfigStreamingConfig): any;
/**
 * @stability stable
 */
export declare class SccNotificationConfigStreamingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SccNotificationConfigStreamingConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SccNotificationConfigStreamingConfig | undefined);
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): string;
    /**
     * @stability stable
     */
    set filter(value: string);
    /**
     * @stability stable
     */
    get filterInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SccNotificationConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html#create SccNotificationConfig#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html#delete SccNotificationConfig#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html#update SccNotificationConfig#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function sccNotificationConfigTimeoutsToTerraform(struct?: SccNotificationConfigTimeoutsOutputReference | SccNotificationConfigTimeouts): any;
/**
 * @stability stable
 */
export declare class SccNotificationConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SccNotificationConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SccNotificationConfigTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html google_scc_notification_config}.
 *
 * @stability stable
 */
export declare class SccNotificationConfig extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html google_scc_notification_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SccNotificationConfigConfig);
    private _configId?;
    /**
     * @stability stable
     */
    get configId(): string;
    /**
     * @stability stable
     */
    set configId(value: string);
    /**
     * @stability stable
     */
    get configIdInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _organization?;
    /**
     * @stability stable
     */
    get organization(): string;
    /**
     * @stability stable
     */
    set organization(value: string);
    /**
     * @stability stable
     */
    get organizationInput(): string | undefined;
    private _pubsubTopic?;
    /**
     * @stability stable
     */
    get pubsubTopic(): string;
    /**
     * @stability stable
     */
    set pubsubTopic(value: string);
    /**
     * @stability stable
     */
    get pubsubTopicInput(): string | undefined;
    /**
     * @stability stable
     */
    get serviceAccount(): string;
    private _streamingConfig;
    /**
     * @stability stable
     */
    get streamingConfig(): SccNotificationConfigStreamingConfigOutputReference;
    /**
     * @stability stable
     */
    putStreamingConfig(value: SccNotificationConfigStreamingConfig): void;
    /**
     * @stability stable
     */
    get streamingConfigInput(): SccNotificationConfigStreamingConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SccNotificationConfigTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SccNotificationConfigTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SccNotificationConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
