# -*- coding: utf-8 -*-
# Generated by Django 1.10.5 on 2017-02-17 18:18
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import jsonfield.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Canvas',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.TextField()),
                ('short_id', models.CharField(max_length=255)),
                ('uri', models.URLField()),
                ('iiif_image_id', models.URLField()),
                ('thumbnail', models.BooleanField(default=False)),
                ('order', models.PositiveIntegerField()),
            ],
            options={
                'ordering': ['manifest', 'order'],
                'verbose_name': 'IIIF Canvas',
                'verbose_name_plural': 'IIIF Canvases',
            },
        ),
        migrations.CreateModel(
            name='Manifest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.TextField()),
                ('short_id', models.CharField(max_length=255, unique=True)),
                ('uri', models.URLField()),
                ('metadata', jsonfield.fields.JSONField()),
                ('created', models.DateField(auto_now_add=True)),
                ('last_modified', models.DateField(auto_now=True)),
            ],
            options={
                'verbose_name': 'IIIF Manifest',
            },
        ),
        migrations.AddField(
            model_name='canvas',
            name='manifest',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='canvases', to='djiffy.Manifest'),
        ),
        migrations.AddField(
            model_name='manifest',
            name='extra_data',
            field=jsonfield.fields.JSONField(default=dict),
        ),
        migrations.AlterUniqueTogether(
            name='canvas',
            unique_together=set([('short_id', 'manifest')]),
        ),
    ]
