# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['mergegi']

package_data = \
{'': ['*']}

install_requires = \
['click>=8.1.3,<9.0.0']

extras_require = \
{'sequana': ['snakemake>=7.19.1,<8.0.0', 'sequana_pipetools>=0.10.0,<0.11.0']}

entry_points = \
{'console_scripts': ['mergegi = mergegi:main',
                     'mergegi_convert = mergegi.cli:convert',
                     'sequana_mergegi = sequana_pipelines.mergegi.main:main']}

setup_kwargs = {
    'name': 'mergegi',
    'version': '0.2.1',
    'description': 'Merge MGI fastq files',
    'long_description': '# MergeGI\n\n[![Tests](https://github.com/sequana/MergeGI/actions/workflows/main.yml/badge.svg)](https://github.com/sequana/MergeGI/actions/workflows/main.yml)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mergegi)\n[![Coverage Status](https://coveralls.io/repos/github/sequana/MergeGI/badge.svg?branch=main)](https://coveralls.io/github/sequana/MergeGI?branch=main)\n[![PyPI version](https://badge.fury.io/py/mergegi.svg)](https://badge.fury.io/py/mergegi)\n\n\n**MergeGI** provides a single command line to merge and select barcoded raw data from [MGI](https://en.mgi-tech.com/products/) sequencing runs into a set of FastQ files ready for subsequent bioinformatics analysis.\n\n\n- [Installation](#installation)\n- [Getting Started](#getting-started)\n- [General Usage](#general-usage)\n\n\n## Installation\n\nWe provide **MergeGI** as a Python library available on [Pypi](https://pypi.python.org). The standalone application is called **mergegi** and can be installed in an environment with Python>3.7 as follows:\n\n    pip install mergegi\n\nThere is no dependencies except for **click** package so that installation should be straightforward. \n\n\nFor developers:\n\n    git clone git@github.com:sequana/MergeGI.git\n    cd MergeGI\n    poetry install\n    poetry shell\n\nWe also provide a pipeline for demultiplexing MGI data in Snakemake, which can be installed as an extra package:\n\n    pip install mergegi[sequana]\n\nIt installs **snakemake** and **sequana_pipetools** and you have access to **sequana_mergegi** command.\n\nFor developers:\n\n    git clone git@github.com:sequana/MergeGI.git\n    cd MergeGI\n    poetry install --all-extras\n    poetry shell\n\n## Apptainers\n\nMergeGI is available as an apptainer image within the https://damona.readthedocs.io project. For example, the version 0.1.0 is available here:  https://sandbox.zenodo.org/record/1134857/files/mergegi_0.0.1.img  (60Mb).\n\n## Overview\n\nThe main goal of **MergeGI** is to select and merge the FastQ files generated by a MGI sequencer into a list of FastQ files directly usable for subsequent bioinformatics analysis. Why do we need to do this preprocessing ? \n\nFirst, MGI generates one FastQ file per barcode. You may not need all those barcodes yet the demultiplexing performs a systematic search of all barcodes. Consequently, you will end up with FastQ files corresponding to your barcode and a bunch of FastQ files  that should be ignored. Given the information from your wetlab colleagues you should have the list of samples and their relevant barcodes. \n\nSecond, MGI technologies imposes that barcodes being processed in a specific manner meaning that a given sample may be split into several barcodse (files). Therefore we need a tool to merge such files. Again, the wetlab should provide the barcodes corresponding to a given sample. See image below for more explanation\n\nThird, a MGI flowcell has several lanes. You may want to merge the lanes or not. \n\nThose 3 steps should be managed seemlessly by our tool given a sample sheet and the output directory of the MGI runs.\n\n## General Usage and Examples\n\nThe data structure expected by **MergeGI** is the expected output directoy of MGI runs:\n\n    OutputFq/Flowcell/L01\n    OutputFq/Flowcell/L02\n\nWhere L01/L02 stands for lane 1 and 2.\n\nThe software needs a sample sheet that describe the sample name, the associated barcode identifier, the project name (it will be used to create the new output directory), and the lane where is the sample/barcode pair. Here is an example:\n\n```csv\nsamplename,barcode,project,lane\nA,         1,      projectA, 1\nB,         20,     projectA, 1\nA,         1,      projectA, 2\nC,         20,     projectB, 2\nC,         30,     projectB, 1\nB,         30,     projectA, 2\n```\n\nIf you have pooled a sample on the four lanes, meaning it is the same barcode on each lane, you can use the * character to simplify the sample sheet:\n\n```csv\nsamplename,barcode,project,lane\nA,         1,     ,projectA, *\nB,         20,    ,projectA, *\n```\n\n> **_IMPORTANT NOTE:_**  The header must be present. The header names are not important but columns must be sorted with the expected order: sample name, barcode, project name, lane. \n\n\nGiven the sample sheet, and the input directory (top level of the MGI runs), this command should create a new clean directory with the relevant FastQ files (here in merge_data directory):\n\n```bash\nmergegi --samplesheet samplesheet.csv --input-directory mgi_raw_data --output-directory merge_data \n```\n\nIf the data is paired, add *--paired* argument\n\n```bash\nmergegi --samplesheet samplesheet.csv --input-directory mgi_raw_data --output-directory merge_data --paired\n```\n\n\nBy default, lanes are merged. If this is not what you want you may disable this option:\n\n```bash\nmergegi --samplesheet samplesheet.csv --input-directory mgi_raw_data --output-directory merge_data --paired --no-merge\n```\n\n## Changelog\n\n| Version  | Description  |  \n|----------|---\n| 0.2.1    | use poetry and add sequana_mergegi as extra dependencies |\n| 0.1.0    | simplify CI and use pyproject |\n| 0.0.0    | firs release  |\n\n\n## Barcode distribution example\n\n<img src="doc/bccode.png" width="50%">\n\n\n\n\n\n',
    'author': 'Sequana Team',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8.1,<4.0.0',
}


setup(**setup_kwargs)
