#!/usr/bin/env python

"""The setup script."""

from setuptools import setup, find_packages

with open("README.rst") as readme_file:
    readme = readme_file.read()

with open("HISTORY.rst") as history_file:
    history = history_file.read()

requirements = ["Click>=7.0", "numpy", "pandas", "statsmodels", 'sklearn', 'fbprophet']

setup_requirements = [
    "pytest-runner",
]

test_requirements = [
    "pytest>=3",
]

setup(
    author="Jim Vogel",
    author_email="james.vogel@capspire.com",
    python_requires=">=3.7",
    classifiers=[
        "Development Status :: 2 - Pre-Alpha",
        "Intended Audience :: Developers",
        "Natural Language :: English",
        "Programming Language :: Python :: 3.8",        
        "Programming Language :: Python :: 3.7",

    ],
    description="small package for generating forecasts for gas tanks",
    entry_points={"console_scripts": ["tank_forecaster=tank_forecaster.cli:main",],},
    install_requires=requirements,
    long_description=readme + "\n\n" + history,
    include_package_data=True,
    keywords="tank_forecaster",
    name="tank_forecaster",
    packages=find_packages(include=["tank_forecaster", "tank_forecaster.*"]),
    setup_requires=setup_requirements,
    test_suite="tests",
    tests_require=test_requirements,
    url="https://www.capspire.com",
    version="0.1.34",
    zip_safe=False,
)
