# Generated by Django 2.2.1 on 2019-05-12 13:44

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import lactolyse.models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('lactolyse', '0005_conconi_report_location'),
    ]

    operations = [
        migrations.CreateModel(
            name='LactateThresholdRunAnalyses',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('created', models.DateField(auto_now_add=True)),
                (
                    'report',
                    models.FileField(
                        upload_to=lactolyse.models.generate_lactate_threshold_name
                    ),
                ),
                ('result_dmax', models.IntegerField(null=True)),
                ('result_cross', models.IntegerField(null=True)),
                ('result_at2', models.IntegerField(null=True)),
                ('result_at4', models.IntegerField(null=True)),
                (
                    'athlete',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to='lactolyse.Athlete',
                    ),
                ),
                (
                    'contributor',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='LactateRunMeasurement',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('pace', models.IntegerField()),
                ('heart_rate', models.IntegerField()),
                ('lactate', models.DecimalField(decimal_places=2, max_digits=4)),
                (
                    'analyses',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to='lactolyse.LactateThresholdRunAnalyses',
                    ),
                ),
            ],
        ),
    ]
