/// <reference types="node" />
import * as https from 'https';
export declare const external: {
    sendHttpRequest: typeof defaultSendHttpRequest;
    log: typeof defaultLog;
    includeStackTraces: boolean;
    userHandlerIndex: string;
};
export declare type Response = AWSLambda.CloudFormationCustomResourceEvent & HandlerResponse;
export declare type Handler = (event: AWSLambda.CloudFormationCustomResourceEvent, context: AWSLambda.Context) => Promise<HandlerResponse | void>;
export declare type HandlerResponse = undefined | {
    Data?: any;
    PhysicalResourceId?: string;
    Reason?: string;
    NoEcho?: boolean;
};
export declare function handler(event: AWSLambda.CloudFormationCustomResourceEvent, context: AWSLambda.Context): Promise<void>;
declare function defaultSendHttpRequest(options: https.RequestOptions, responseBody: string): Promise<void>;
declare function defaultLog(fmt: string, ...params: any[]): void;
export {};
