from openfisca_us.model_api import *


class pui(Variable):
    value_type = float
    entity = TaxUnit
    label = "Unemployment insurance (primary taxpayer)"
    unit = USD
    documentation = "Unemployment Compensation received - primary taxpayer."
    definition_period = YEAR

    def formula(tax_unit, period, parameters):
        person = tax_unit.members
        is_primary = person("is_tax_unit_head", period)
        unemployment_insurance = person("unemployment_insurance", period)
        return tax_unit.sum(unemployment_insurance * is_primary)
