/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.sagemaker.featurestore.sparksdk;

import java.io.Serializable;
import java.util.Collection;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.FeatureDefinition;
import software.amazon.awssdk.services.sagemaker.model.FeatureType;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.SageMakerFeatureStoreRuntimeClient;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.PutRecordRequest;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.PutRecordResponse;
import software.amazon.sagemaker.featurestore.sparksdk.exceptions.ValidationError;
import software.amazon.sagemaker.featurestore.sparksdk.helpers.ClientFactory$;
import software.amazon.sagemaker.featurestore.sparksdk.helpers.DataFrameRepartitioner$;
import software.amazon.sagemaker.featurestore.sparksdk.helpers.FeatureGroupArnResolver;
import software.amazon.sagemaker.featurestore.sparksdk.helpers.FeatureGroupHelper$;
import software.amazon.sagemaker.featurestore.sparksdk.helpers.SparkSessionInitializer$;
import software.amazon.sagemaker.featurestore.sparksdk.validators.InputDataSchemaValidator$;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0006\r\u0001]AQ!\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013\u0005a\u0005\u0003\u0004L\u0001\u0001\u0006Ia\n\u0005\u0006\u0019\u0002!\t!\u0014\u0005\bY\u0002\t\n\u0011\"\u0001n\u0011\u0015A\b\u0001\"\u0001z\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u001fAq!a\u0006\u0001\t\u0013\tI\u0002C\u0004\u0002T\u0001!I!!\u0016\t\u000f\u00055\u0004\u0001\"\u0003\u0002p\t\u0019b)Z1ukJ,7\u000b^8sK6\u000bg.Y4fe*\u0011QBD\u0001\tgB\f'o[:eW*\u0011q\u0002E\u0001\rM\u0016\fG/\u001e:fgR|'/\u001a\u0006\u0003#I\t\u0011b]1hK6\f7.\u001a:\u000b\u0005M!\u0012AB1nCj|gNC\u0001\u0016\u0003!\u0019xN\u001a;xCJ,7\u0001A\n\u0004\u0001aq\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g\r\u0005\u0002\u001a?%\u0011\u0001E\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0002\"\u0001\n\u0001\u000e\u00031\tad\u0015)B%.{F+\u0017)F?R{uLR#B)V\u0013Vi\u0018+Z!\u0016{V*\u0011)\u0016\u0003\u001d\u0002B\u0001K\u00183\u0001:\u0011\u0011&\f\t\u0003Uii\u0011a\u000b\u0006\u0003YY\ta\u0001\u0010:p_Rt\u0014B\u0001\u0018\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001'\r\u0002\u0004\u001b\u0006\u0004(B\u0001\u0018\u001b!\t\u0019d(D\u00015\u0015\t)d'A\u0003usB,7O\u0003\u00028q\u0005\u00191/\u001d7\u000b\u0005eR\u0014!B:qCJ\\'BA\u001e=\u0003\u0019\t\u0007/Y2iK*\tQ(A\u0002pe\u001eL!a\u0010\u001b\u0003\u0011\u0011\u000bG/\u0019+za\u0016\u0004\"!Q%\u000e\u0003\tS!a\u0011#\u0002\u000b5|G-\u001a7\u000b\u0005E)%B\u0001$H\u0003!\u0019XM\u001d<jG\u0016\u001c(B\u0001%\u0013\u0003\u0019\two]:eW&\u0011!J\u0011\u0002\f\r\u0016\fG/\u001e:f)f\u0004X-A\u0010T!\u0006\u00136j\u0018+Z!\u0016{FkT0G\u000b\u0006#VKU#`)f\u0003ViX'B!\u0002\n!\"\u001b8hKN$H)\u0019;b)\u0011q\u0015KY4\u0011\u0005ey\u0015B\u0001)\u001b\u0005\u0011)f.\u001b;\t\u000bI#\u0001\u0019A*\u0002\u001d%t\u0007/\u001e;ECR\fgI]1nKB\u0011Ak\u0018\b\u0003+vs!A\u0016/\u000f\u0005][fB\u0001-[\u001d\tQ\u0013,C\u0001>\u0013\tYD(\u0003\u0002:u%\u0011q\u0007O\u0005\u0003=Z\nq\u0001]1dW\u0006<W-\u0003\u0002aC\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003=ZBQa\u0019\u0003A\u0002\u0011\fqBZ3biV\u0014Xm\u0012:pkB\f%O\u001c\t\u0003Q\u0015L!AZ\u0019\u0003\rM#(/\u001b8h\u0011\u001dAG\u0001%AA\u0002%\f!\u0003Z5sK\u000e$xJ\u001a4mS:,7\u000b^8sKB\u0011\u0011D[\u0005\u0003Wj\u0011qAQ8pY\u0016\fg.\u0001\u000bj]\u001e,7\u000f\u001e#bi\u0006$C-\u001a4bk2$HeM\u000b\u0002]*\u0012\u0011n\\\u0016\u0002aB\u0011\u0011O^\u0007\u0002e*\u00111\u000f^\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u001e\u000e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002xe\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002A1|\u0017\r\u001a$fCR,(/\u001a#fM&t\u0017\u000e^5p]N4%o\\7TG\",W.\u0019\u000b\u0004u\u0006-\u0001#B>\u0002\u0002\u0005\u0015Q\"\u0001?\u000b\u0005ut\u0018\u0001B;uS2T\u0011a`\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0004q\u0014A\u0001T5tiB\u0019\u0011)a\u0002\n\u0007\u0005%!IA\tGK\u0006$XO]3EK\u001aLg.\u001b;j_:DQA\u0015\u0004A\u0002M\u000b1d\u001d;sK\u0006l\u0017J\\4fgRLe\u000e^8P]2Lg.Z*u_J,G#\u0002(\u0002\u0012\u0005U\u0001BBA\n\u000f\u0001\u0007A-\u0001\tgK\u0006$XO]3He>,\bOT1nK\")!k\u0002a\u0001'\u0006a\u0002/\u001e;P]2Lg.\u001a*fG>\u0014Hm\u001d$peB\u000b'\u000f^5uS>tG#\u0003(\u0002\u001c\u0005]\u0012\u0011HA\"\u0011\u001d\ti\u0002\u0003a\u0001\u0003?\tAA]8xgB1\u0011\u0011EA\u0015\u0003_qA!a\t\u0002(9\u0019!&!\n\n\u0003mI!A\u0018\u000e\n\t\u0005-\u0012Q\u0006\u0002\t\u0013R,'/\u0019;pe*\u0011aL\u0007\t\u0005\u0003c\t\u0019$D\u00017\u0013\r\t)D\u000e\u0002\u0004%><\bBBA\n\u0011\u0001\u0007A\rC\u0004\u0002<!\u0001\r!!\u0010\u0002\u000f\r|G.^7ogB!\u0011$a\u0010e\u0013\r\t\tE\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0003\u000bB\u0001\u0019AA$\u00035\u0011XO\u001c+j[\u0016\u001cE.[3oiB!\u0011\u0011JA(\u001b\t\tYEC\u0002\u0002N\u0015\u000bAd]1hK6\f7.\u001a:gK\u0006$XO]3ti>\u0014XM];oi&lW-\u0003\u0003\u0002R\u0005-#AI*bO\u0016l\u0015m[3s\r\u0016\fG/\u001e:f'R|'/\u001a*v]RLW.Z\"mS\u0016tG/A\u000ecCR\u001c\u0007.\u00138hKN$\u0018J\u001c;p\u001f\u001a4G.\u001b8f'R|'/\u001a\u000b\n\u001d\u0006]\u00131LA3\u0003SBa!!\u0017\n\u0001\u0004\u0019\u0016!\u00033bi\u00064%/Y7f\u0011\u001d\ti&\u0003a\u0001\u0003?\n\u0001\u0003Z3tGJL'-\u001a*fgB|gn]3\u0011\u0007\u0005\u000b\t'C\u0002\u0002d\t\u0013A\u0004R3tGJL'-\u001a$fCR,(/Z$s_V\u0004(+Z:q_:\u001cX\r\u0003\u0004\u0002h%\u0001\r\u0001Z\u0001\u0015KZ,g\u000e\u001e+j[\u00164U-\u0019;ve\u0016t\u0015-\\3\t\r\u0005-\u0014\u00021\u0001e\u0003\u0019\u0011XmZ5p]\u0006yq-\u001a;GK\u0006$XO]3He>,\b\u000f\u0006\u0003\u0002`\u0005E\u0004BBA\n\u0015\u0001\u0007A\r")
public class FeatureStoreManager
implements scala.Serializable {
    private final Map<DataType, FeatureType> SPARK_TYPE_TO_FEATURE_TYPE_MAP = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StringType$.MODULE$), (Object)FeatureType.STRING), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DoubleType$.MODULE$), (Object)FeatureType.FRACTIONAL), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FloatType$.MODULE$), (Object)FeatureType.FRACTIONAL), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ByteType$.MODULE$), (Object)FeatureType.INTEGRAL), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ShortType$.MODULE$), (Object)FeatureType.INTEGRAL), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)IntegerType$.MODULE$), (Object)FeatureType.INTEGRAL), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LongType$.MODULE$), (Object)FeatureType.INTEGRAL)}));

    public Map<DataType, FeatureType> SPARK_TYPE_TO_FEATURE_TYPE_MAP() {
        return this.SPARK_TYPE_TO_FEATURE_TYPE_MAP;
    }

    public void ingestData(Dataset<Row> inputDataFrame, String featureGroupArn, boolean directOfflineStore) {
        SparkSessionInitializer$.MODULE$.initializeSparkSession(inputDataFrame.sparkSession());
        FeatureGroupArnResolver featureGroupArnResolver = new FeatureGroupArnResolver(featureGroupArn);
        String featureGroupName = featureGroupArnResolver.resolveFeatureGroupName();
        String region = featureGroupArnResolver.resolveRegion();
        DescribeFeatureGroupResponse describeResponse = this.getFeatureGroup(featureGroupName);
        FeatureGroupHelper$.MODULE$.checkIfFeatureGroupArnIdentical(describeResponse, featureGroupArn);
        FeatureGroupHelper$.MODULE$.checkIfFeatureGroupIsCreated(describeResponse);
        FeatureGroupHelper$.MODULE$.checkDirectOfflineStore(describeResponse, directOfflineStore);
        String eventTimeFeatureName = describeResponse.eventTimeFeatureName();
        Dataset<Row> validatedInputDataFrame = InputDataSchemaValidator$.MODULE$.validateInputDataFrame(inputDataFrame, describeResponse);
        if (directOfflineStore || !FeatureGroupHelper$.MODULE$.isFeatureGroupOnlineStoreEnabled(describeResponse)) {
            this.batchIngestIntoOfflineStore(validatedInputDataFrame, describeResponse, eventTimeFeatureName, region);
        } else {
            this.streamIngestIntoOnlineStore(featureGroupName, validatedInputDataFrame);
        }
    }

    public boolean ingestData$default$3() {
        return false;
    }

    public java.util.List<FeatureDefinition> loadFeatureDefinitionsFromSchema(Dataset<Row> inputDataFrame) {
        StructField[] fields = inputDataFrame.schema().fields();
        List featureDefinitions = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(resultList, field) -> {
            Option option = this.SPARK_TYPE_TO_FEATURE_TYPE_MAP().get((Object)field.dataType());
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    DataType arg$macro$1 = field.dataType();
                    throw new ValidationError(new StringOps("Found unsupported data type from schema '%s' which cannot be converted to a corresponding feature type.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1})));
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            FeatureType featureType = (FeatureType)some.value();
            List list = (List)resultList.$colon$plus(FeatureDefinition.builder().featureName(field.name()).featureType(featureType).build(), List$.MODULE$.canBuildFrom());
            return list;
        });
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)featureDefinitions).asJava();
    }

    private void streamIngestIntoOnlineStore(String featureGroupName, Dataset<Row> inputDataFrame) {
        String[] columns = inputDataFrame.schema().names();
        Dataset<Row> repartitionedDataFrame = DataFrameRepartitioner$.MODULE$.repartition(inputDataFrame);
        repartitionedDataFrame.foreachPartition((Function1 & Serializable & scala.Serializable)rows -> {
            this.putOnlineRecordsForPartition((Iterator<Row>)rows, featureGroupName, columns, (SageMakerFeatureStoreRuntimeClient)ClientFactory$.MODULE$.sageMakerFeatureStoreRuntimeClientBuilder().build());
            return BoxedUnit.UNIT;
        });
    }

    private void putOnlineRecordsForPartition(Iterator<Row> rows, String featureGroupName, String[] columns, SageMakerFeatureStoreRuntimeClient runTimeClient) {
        rows.foreach((Function1 & Serializable & scala.Serializable)row -> {
            PutRecordResponse putRecordResponse;
            ListBuffer record = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columns)).foreach((Function1 & Serializable & scala.Serializable)columnName -> {
                BoxedUnit boxedUnit;
                try {
                    if (!row.isNullAt(row.fieldIndex(columnName))) {
                        Object featureValue = row.getAs(columnName);
                        boxedUnit = record.$plus$eq(FeatureValue.builder().featureName(columnName).valueAsString(featureValue.toString()).build());
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                return boxedUnit;
            });
            try {
                PutRecordRequest putRecordRequest = (PutRecordRequest)PutRecordRequest.builder().featureGroupName(featureGroupName).record((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)record).asJava()).build();
                putRecordResponse = runTimeClient.putRecord(putRecordRequest);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return putRecordResponse;
        });
    }

    private void batchIngestIntoOfflineStore(Dataset<Row> dataFrame, DescribeFeatureGroupResponse describeResponse, String eventTimeFeatureName, String region) {
        if (!FeatureGroupHelper$.MODULE$.isFeatureGroupOfflineStoreEnabled(describeResponse)) {
            throw new ValidationError(new StringBuilder(48).append("OfflineStore of FeatureGroup: '").append(describeResponse.featureGroupName()).append("' is not enabled.").toString());
        }
        String offlineStoreEncryptionKeyId = describeResponse.offlineStoreConfig().s3StorageConfig().kmsKeyId();
        SparkSessionInitializer$.MODULE$.initializeSparkSessionForOfflineStore(dataFrame.sparkSession(), offlineStoreEncryptionKeyId, region);
        String destinationFilePath = FeatureGroupHelper$.MODULE$.generateDestinationFilePath(describeResponse);
        Dataset tempDataFrame = dataFrame.withColumn("temp_event_time_col", functions$.MODULE$.col(eventTimeFeatureName).cast("Timestamp")).withColumn("year", functions$.MODULE$.date_format(functions$.MODULE$.col("temp_event_time_col"), "yyyy")).withColumn("month", functions$.MODULE$.date_format(functions$.MODULE$.col("temp_event_time_col"), "MM")).withColumn("day", functions$.MODULE$.date_format(functions$.MODULE$.col("temp_event_time_col"), "dd")).withColumn("hour", functions$.MODULE$.date_format(functions$.MODULE$.col("temp_event_time_col"), "HH")).withColumn("api_invocation_time", functions$.MODULE$.current_timestamp()).withColumn("write_time", functions$.MODULE$.current_timestamp()).withColumn("is_deleted", functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)false))).drop("temp_event_time_col");
        tempDataFrame.repartition((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("year"), functions$.MODULE$.col("month"), functions$.MODULE$.col("day"), functions$.MODULE$.col("hour")})).write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"year", "month", "day", "hour"})).option("compression", "none").mode("append").parquet(destinationFilePath);
    }

    private DescribeFeatureGroupResponse getFeatureGroup(String featureGroupName) {
        DescribeFeatureGroupRequest describeRequest = (DescribeFeatureGroupRequest)DescribeFeatureGroupRequest.builder().featureGroupName(featureGroupName).build();
        return ClientFactory$.MODULE$.sageMakerClient().describeFeatureGroup(describeRequest);
    }
}

