/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.sagemaker.featurestore.sparksdk.helpers;

import java.util.regex.Pattern;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.util.matching.Regex;
import software.amazon.sagemaker.featurestore.sparksdk.exceptions.ValidationError;

@ScalaSignature(bytes="\u0006\u0001\u001d3Aa\u0003\u0007\u00013!A\u0001\u0005\u0001BC\u0002\u0013\u0005\u0011\u0005\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003#\u0011\u0015q\u0003\u0001\"\u00010\u0011\u001d\u0019\u0004A1A\u0005\u000eQBa\u0001\u000f\u0001!\u0002\u001b)\u0004bB\u001d\u0001\u0005\u0004%iA\u000f\u0005\u0007}\u0001\u0001\u000bQB\u001e\t\u000b}\u0002A\u0011\u0001!\t\u000b\u0005\u0003A\u0011\u0001!\t\u000b\t\u0003A\u0011B\"\u0003/\u0019+\u0017\r^;sK\u001e\u0013x.\u001e9Be:\u0014Vm]8mm\u0016\u0014(BA\u0007\u000f\u0003\u001dAW\r\u001c9feNT!a\u0004\t\u0002\u0011M\u0004\u0018M]6tI.T!!\u0005\n\u0002\u0019\u0019,\u0017\r^;sKN$xN]3\u000b\u0005M!\u0012!C:bO\u0016l\u0017m[3s\u0015\t)b#\u0001\u0004b[\u0006TxN\u001c\u0006\u0002/\u0005A1o\u001c4uo\u0006\u0014Xm\u0001\u0001\u0014\u0005\u0001Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g-A\bgK\u0006$XO]3He>,\b/\u0011:o+\u0005\u0011\u0003CA\u0012+\u001d\t!\u0003\u0006\u0005\u0002&95\taE\u0003\u0002(1\u00051AH]8pizJ!!\u000b\u000f\u0002\rA\u0013X\rZ3g\u0013\tYCF\u0001\u0004TiJLgn\u001a\u0006\u0003Sq\t\u0001CZ3biV\u0014Xm\u0012:pkB\f%O\u001c\u0011\u0002\rqJg.\u001b;?)\t\u0001$\u0007\u0005\u00022\u00015\tA\u0002C\u0003!\u0007\u0001\u0007!%A\rG\u000b\u0006#VKU#`\u000fJ{U\u000bU0B%:{\u0006+\u0011+U\u000bJsU#A\u001b\u0010\u0003Y\n\u0013aN\u0001ACJt'(Y<t7\u0006l#\u0010X\u0017^Ui\u001a\u0018mZ3nC.,'OO.b[i\u0004T&\u000f/.;*R4\fM\u0017:;n\f$' \u001egK\u0006$XO]3.OJ|W\u000f]\u0018/U\u0005Qb)R!U+J+ul\u0012*P+B{\u0016I\u0015(`!\u0006#F+\u0012*OA\u0005!b-Z1ukJ,wI]8va\u0006\u0013h\u000eU1siN,\u0012a\u000f\t\u00047q\u0012\u0013BA\u001f\u001d\u0005\u0015\t%O]1z\u0003U1W-\u0019;ve\u0016<%o\\;q\u0003Jt\u0007+\u0019:ug\u0002\nqC]3t_24XMR3biV\u0014Xm\u0012:pkBt\u0015-\\3\u0015\u0003\t\nQB]3t_24XMU3hS>t\u0017!\u0006<fe&4\u0017PR3biV\u0014Xm\u0012:pkB\f%O\u001c\u000b\u0002\tB\u00111$R\u0005\u0003\rr\u0011A!\u00168ji\u0002")
public class FeatureGroupArnResolver {
    private final String featureGroupArn;
    private final String[] featureGroupArnParts;

    public String featureGroupArn() {
        return this.featureGroupArn;
    }

    private final String FEATURE_GROUP_ARN_PATTERN() {
        return "arn:aws[a-z\\-]*:sagemaker:[a-z0-9\\-]*:[0-9]{12}:feature-group/.*";
    }

    private final String[] featureGroupArnParts() {
        return this.featureGroupArnParts;
    }

    public String resolveFeatureGroupName() {
        return new StringOps(Predef$.MODULE$.augmentString(this.featureGroupArn())).split('/')[1];
    }

    public String resolveRegion() {
        return this.featureGroupArnParts()[3];
    }

    private void verifyFeatureGroupArn() {
        Pattern pattern = new Regex("arn:aws[a-z\\-]*:sagemaker:[a-z0-9\\-]*:[0-9]{12}:feature-group/.*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).pattern();
        if (!pattern.matcher(this.featureGroupArn()).matches()) {
            throw new ValidationError("Provided feature group arn is not valid.");
        }
    }

    public FeatureGroupArnResolver(String featureGroupArn) {
        this.featureGroupArn = featureGroupArn;
        this.verifyFeatureGroupArn();
        this.featureGroupArnParts = new StringOps(Predef$.MODULE$.augmentString(featureGroupArn)).split(':');
    }
}

