# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetSentryKeyResult',
    'AwaitableGetSentryKeyResult',
    'get_sentry_key',
    'get_sentry_key_output',
]

@pulumi.output_type
class GetSentryKeyResult:
    """
    A collection of values returned by getSentryKey.
    """
    def __init__(__self__, dsn_csp=None, dsn_public=None, dsn_secret=None, first=None, id=None, is_active=None, name=None, organization=None, project=None, project_id=None, public=None, rate_limit_count=None, rate_limit_window=None, secret=None):
        if dsn_csp and not isinstance(dsn_csp, str):
            raise TypeError("Expected argument 'dsn_csp' to be a str")
        pulumi.set(__self__, "dsn_csp", dsn_csp)
        if dsn_public and not isinstance(dsn_public, str):
            raise TypeError("Expected argument 'dsn_public' to be a str")
        pulumi.set(__self__, "dsn_public", dsn_public)
        if dsn_secret and not isinstance(dsn_secret, str):
            raise TypeError("Expected argument 'dsn_secret' to be a str")
        pulumi.set(__self__, "dsn_secret", dsn_secret)
        if first and not isinstance(first, bool):
            raise TypeError("Expected argument 'first' to be a bool")
        pulumi.set(__self__, "first", first)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_active and not isinstance(is_active, bool):
            raise TypeError("Expected argument 'is_active' to be a bool")
        pulumi.set(__self__, "is_active", is_active)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization and not isinstance(organization, str):
            raise TypeError("Expected argument 'organization' to be a str")
        pulumi.set(__self__, "organization", organization)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if project_id and not isinstance(project_id, int):
            raise TypeError("Expected argument 'project_id' to be a int")
        pulumi.set(__self__, "project_id", project_id)
        if public and not isinstance(public, str):
            raise TypeError("Expected argument 'public' to be a str")
        pulumi.set(__self__, "public", public)
        if rate_limit_count and not isinstance(rate_limit_count, int):
            raise TypeError("Expected argument 'rate_limit_count' to be a int")
        pulumi.set(__self__, "rate_limit_count", rate_limit_count)
        if rate_limit_window and not isinstance(rate_limit_window, int):
            raise TypeError("Expected argument 'rate_limit_window' to be a int")
        pulumi.set(__self__, "rate_limit_window", rate_limit_window)
        if secret and not isinstance(secret, str):
            raise TypeError("Expected argument 'secret' to be a str")
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="dsnCsp")
    def dsn_csp(self) -> str:
        """
        DSN for the Content Security Policy (CSP) for the key.
        """
        return pulumi.get(self, "dsn_csp")

    @property
    @pulumi.getter(name="dsnPublic")
    def dsn_public(self) -> str:
        """
        DSN for the key.
        """
        return pulumi.get(self, "dsn_public")

    @property
    @pulumi.getter(name="dsnSecret")
    def dsn_secret(self) -> str:
        """
        DSN (Deprecated) for the key.
        """
        return pulumi.get(self, "dsn_secret")

    @property
    @pulumi.getter
    def first(self) -> Optional[bool]:
        return pulumi.get(self, "first")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> bool:
        """
        Flag indicating the key is active.
        """
        return pulumi.get(self, "is_active")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def organization(self) -> str:
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> int:
        """
        The ID of the project that the key belongs to.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def public(self) -> str:
        """
        Public key portion of the client key.
        """
        return pulumi.get(self, "public")

    @property
    @pulumi.getter(name="rateLimitCount")
    def rate_limit_count(self) -> int:
        """
        Number of events that can be reported within the rate limit window.
        """
        return pulumi.get(self, "rate_limit_count")

    @property
    @pulumi.getter(name="rateLimitWindow")
    def rate_limit_window(self) -> int:
        """
        Length of time that will be considered when checking the rate limit.
        """
        return pulumi.get(self, "rate_limit_window")

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        Secret key portion of the client key.
        """
        return pulumi.get(self, "secret")


class AwaitableGetSentryKeyResult(GetSentryKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSentryKeyResult(
            dsn_csp=self.dsn_csp,
            dsn_public=self.dsn_public,
            dsn_secret=self.dsn_secret,
            first=self.first,
            id=self.id,
            is_active=self.is_active,
            name=self.name,
            organization=self.organization,
            project=self.project,
            project_id=self.project_id,
            public=self.public,
            rate_limit_count=self.rate_limit_count,
            rate_limit_window=self.rate_limit_window,
            secret=self.secret)


def get_sentry_key(first: Optional[bool] = None,
                   name: Optional[str] = None,
                   organization: Optional[str] = None,
                   project: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSentryKeyResult:
    """
    ## # SentryKey Data Source

    Sentry Key data source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sentry as sentry

    default = sentry.get_sentry_key(name="Default",
        organization="my-organization",
        project="web-app")
    ```


    :param bool first: Boolean flag indicating that we want the first key of the returned keys.
    :param str name: The name of the key to retrieve.
    :param str organization: The slug of the organization the key should be created for.
    :param str project: The slug of the project the key should be created for.
    """
    __args__ = dict()
    __args__['first'] = first
    __args__['name'] = name
    __args__['organization'] = organization
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
    __ret__ = pulumi.runtime.invoke('sentry:index/getSentryKey:getSentryKey', __args__, opts=opts, typ=GetSentryKeyResult).value

    return AwaitableGetSentryKeyResult(
        dsn_csp=__ret__.dsn_csp,
        dsn_public=__ret__.dsn_public,
        dsn_secret=__ret__.dsn_secret,
        first=__ret__.first,
        id=__ret__.id,
        is_active=__ret__.is_active,
        name=__ret__.name,
        organization=__ret__.organization,
        project=__ret__.project,
        project_id=__ret__.project_id,
        public=__ret__.public,
        rate_limit_count=__ret__.rate_limit_count,
        rate_limit_window=__ret__.rate_limit_window,
        secret=__ret__.secret)


@_utilities.lift_output_func(get_sentry_key)
def get_sentry_key_output(first: Optional[pulumi.Input[Optional[bool]]] = None,
                          name: Optional[pulumi.Input[Optional[str]]] = None,
                          organization: Optional[pulumi.Input[str]] = None,
                          project: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSentryKeyResult]:
    """
    ## # SentryKey Data Source

    Sentry Key data source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sentry as sentry

    default = sentry.get_sentry_key(name="Default",
        organization="my-organization",
        project="web-app")
    ```


    :param bool first: Boolean flag indicating that we want the first key of the returned keys.
    :param str name: The name of the key to retrieve.
    :param str organization: The slug of the organization the key should be created for.
    :param str project: The slug of the project the key should be created for.
    """
    ...
