# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['SentryOrganizationArgs', 'SentryOrganization']

@pulumi.input_type
class SentryOrganizationArgs:
    def __init__(__self__, *,
                 agree_terms: pulumi.Input[bool],
                 name: Optional[pulumi.Input[str]] = None,
                 slug: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SentryOrganization resource.
        :param pulumi.Input[bool] agree_terms: You agree to the applicable terms of service and privacy policy.
        :param pulumi.Input[str] name: The human readable name for the organization.
        :param pulumi.Input[str] slug: The unique URL slug for this organization. If this is not provided a slug is automatically generated based on the name.
        """
        pulumi.set(__self__, "agree_terms", agree_terms)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if slug is not None:
            pulumi.set(__self__, "slug", slug)

    @property
    @pulumi.getter(name="agreeTerms")
    def agree_terms(self) -> pulumi.Input[bool]:
        """
        You agree to the applicable terms of service and privacy policy.
        """
        return pulumi.get(self, "agree_terms")

    @agree_terms.setter
    def agree_terms(self, value: pulumi.Input[bool]):
        pulumi.set(self, "agree_terms", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The human readable name for the organization.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def slug(self) -> Optional[pulumi.Input[str]]:
        """
        The unique URL slug for this organization. If this is not provided a slug is automatically generated based on the name.
        """
        return pulumi.get(self, "slug")

    @slug.setter
    def slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slug", value)


@pulumi.input_type
class _SentryOrganizationState:
    def __init__(__self__, *,
                 agree_terms: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 slug: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SentryOrganization resources.
        :param pulumi.Input[bool] agree_terms: You agree to the applicable terms of service and privacy policy.
        :param pulumi.Input[str] name: The human readable name for the organization.
        :param pulumi.Input[str] slug: The unique URL slug for this organization. If this is not provided a slug is automatically generated based on the name.
        """
        if agree_terms is not None:
            pulumi.set(__self__, "agree_terms", agree_terms)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if slug is not None:
            pulumi.set(__self__, "slug", slug)

    @property
    @pulumi.getter(name="agreeTerms")
    def agree_terms(self) -> Optional[pulumi.Input[bool]]:
        """
        You agree to the applicable terms of service and privacy policy.
        """
        return pulumi.get(self, "agree_terms")

    @agree_terms.setter
    def agree_terms(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "agree_terms", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The human readable name for the organization.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def slug(self) -> Optional[pulumi.Input[str]]:
        """
        The unique URL slug for this organization. If this is not provided a slug is automatically generated based on the name.
        """
        return pulumi.get(self, "slug")

    @slug.setter
    def slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slug", value)


class SentryOrganization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agree_terms: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 slug: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # SentryOrganization Resource

        Sentry Organization resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_sentry as sentry

        # Create an organization
        default = sentry.SentryOrganization("default",
            agree_terms=True,
            slug="my-organization")
        ```

        ## Import

        This resource can be imported using an ID made up of the organization slugbash

        ```sh
         $ pulumi import sentry:index/sentryOrganization:SentryOrganization default org-slug
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] agree_terms: You agree to the applicable terms of service and privacy policy.
        :param pulumi.Input[str] name: The human readable name for the organization.
        :param pulumi.Input[str] slug: The unique URL slug for this organization. If this is not provided a slug is automatically generated based on the name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SentryOrganizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # SentryOrganization Resource

        Sentry Organization resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_sentry as sentry

        # Create an organization
        default = sentry.SentryOrganization("default",
            agree_terms=True,
            slug="my-organization")
        ```

        ## Import

        This resource can be imported using an ID made up of the organization slugbash

        ```sh
         $ pulumi import sentry:index/sentryOrganization:SentryOrganization default org-slug
        ```

        :param str resource_name: The name of the resource.
        :param SentryOrganizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SentryOrganizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agree_terms: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 slug: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SentryOrganizationArgs.__new__(SentryOrganizationArgs)

            if agree_terms is None and not opts.urn:
                raise TypeError("Missing required property 'agree_terms'")
            __props__.__dict__["agree_terms"] = agree_terms
            __props__.__dict__["name"] = name
            __props__.__dict__["slug"] = slug
        super(SentryOrganization, __self__).__init__(
            'sentry:index/sentryOrganization:SentryOrganization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agree_terms: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            slug: Optional[pulumi.Input[str]] = None) -> 'SentryOrganization':
        """
        Get an existing SentryOrganization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] agree_terms: You agree to the applicable terms of service and privacy policy.
        :param pulumi.Input[str] name: The human readable name for the organization.
        :param pulumi.Input[str] slug: The unique URL slug for this organization. If this is not provided a slug is automatically generated based on the name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SentryOrganizationState.__new__(_SentryOrganizationState)

        __props__.__dict__["agree_terms"] = agree_terms
        __props__.__dict__["name"] = name
        __props__.__dict__["slug"] = slug
        return SentryOrganization(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agreeTerms")
    def agree_terms(self) -> pulumi.Output[bool]:
        """
        You agree to the applicable terms of service and privacy policy.
        """
        return pulumi.get(self, "agree_terms")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The human readable name for the organization.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def slug(self) -> pulumi.Output[str]:
        """
        The unique URL slug for this organization. If this is not provided a slug is automatically generated based on the name.
        """
        return pulumi.get(self, "slug")

