# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['marshmallow_geojson']

package_data = \
{'': ['*']}

install_requires = \
['marshmallow>=3.8.0,<4.0.0', 'ujson>=3.2.0,<4.0.0']

setup_kwargs = {
    'name': 'marshmallow-geojson',
    'version': '0.1.18',
    'description': 'Marshmallow schema validation for GeoJson',
    'long_description': '.. image:: https://travis-ci.org/folt/marshmallow-geojson.svg\n   :target: https://travis-ci.org/github/folt/marshmallow-geojson\n   :alt: Travis\n\n.. image:: https://codecov.io/gh/folt/marshmallow-geojson/branch/master/graph/badge.svg?token=B5ATYXLBHO\n   :target: https://codecov.io/gh/folt/marshmallow-geojson\n   :alt: Codecov\n\n.. image:: https://pepy.tech/badge/marshmallow-geojson\n   :target: https://pepy.tech/project/marshmallow-geojson\n   :alt: Downloads\n\nmarshmallow_geojson 🌍\n======================\n\n====================   =======\nGeoJSON Objects        Status\n====================   =======\nPoint_                 ✅\nMultiPoint_            ✅\nLineString_            ✅\nMultiLineString_       ✅\nPolygon_               ✅\nMultiPolygon_          ✅\nGeometryCollection_    ✅\nFeature_               ❌\nFeatureCollection_     ❌\n====================   =======\n\nInstallation\n------------\n\nmarshmallow_geojson is compatible with Python 3.7 and 3.8.\nThe recommended way to install is via poetry_:\n\n.. code::\n\n  poetry add marshmallow_geojson\n\nUsing pip to install is also possible.\n\n.. code::\n\n  pip install marshmallow_geojson\n\nGEOJSON\n-------\nGeoJSON_ is a format for encoding a variety of geographic data structures.\n\n.. code-block::\n\n  {\n    "type": "Feature",\n    "geometry": {\n      "type": "Point",\n      "coordinates": [125.6, 10.1]\n    },\n    "properties": {\n      "name": "Dinagat Islands"\n    }\n  }\n\nGeoJSON supports the following geometry types: Point, LineString, Polygon,\nMultiPoint, MultiLineString, and MultiPolygon. Geometric objects with\nadditional properties are Feature objects. Sets of features are contained by\nFeatureCollection objects.\n\nPoint\n------------------\nSimple example data:\n\n.. code-block::\n\n  >>> from marshmallow_geojson import GeoJSONSchema\n  >>> data_string = \'{"type": "Point","coordinates": [-105.01621, 39.57422]}\'\n  >>> geojson_schema = GeoJSONSchema()\n  >>> geojson_schema.loads(geojson_text)\n  {\'type\': \'Point\', \'coordinates\': (-105.01621, 39.57422)}\n\n\nMultiPoint\n------------------\nSimple example data:\n\n.. code-block::\n\n  >>> from marshmallow_geojson import GeoJSONSchema\n  >>> data_string = \'{"type": "MultiPoint", "coordinates": [ [-105.01621, 39.57422], [-80.666513, 35.053994] ]}\'\n  >>> geojson_schema = GeoJSONSchema()\n  >>> geojson_schema.loads(geojson_text)\n  {\'type\': \'MultiPoint\', \'coordinates\': [(-105.01621, 39.57422), (-80.666513, 35.053994)]}\n\n\nLineString\n------------------\nSimple example data:\n\n.. code-block::\n\n  >>> from marshmallow_geojson import GeoJSONSchema\n  >>> data_string = \'{"type": "LineString", "coordinates": [ [-99.113159, 38.869651], [-99.0802, 38.85682], [-98.822021, 38.85682], [-98.448486, 38.848264] ]}\'\n  >>> geojson_schema = GeoJSONSchema()\n  >>> geojson_schema.loads(geojson_text)\n  {\'type\': \'LineString\', \'coordinates\': [(-99.113159, 38.869651), (-99.0802, 38.85682), (-98.822021, 38.85682), (-98.448486, 38.848264)]}\n\n\n\nMultiLineString\n------------------\nSimple example data:\n\n.. code-block::\n\n  >>> from marshmallow_geojson import GeoJSONSchema\n  >>> data_string = \'{"type": "MultiLineString", "coordinates": [ [ [-105.019898, 39.574997], [-105.019598, 39.574898], [-105.019061, 39.574782] ], [ [-105.017173, 39.574402], [-105.01698, 39.574385], [-105.016636, 39.574385], [-105.016508, 39.574402], [-105.01595, 39.57427] ], [ [-105.014276, 39.573972], [-105.014126, 39.574038], [-105.013825, 39.57417], [-105.01331, 39.574452] ] ]}\'\n  >>> geojson_schema = GeoJSONSchema()\n  >>> geojson_schema.loads(geojson_text)\n  {\'type\': \'MultiLineString\', \'coordinates\': [[(-105.019898, 39.574997), (-105.019598, 39.574898), (-105.019061, 39.574782)], [(-105.017173, 39.574402), (-105.01698, 39.574385), (-105.016636, 39.574385), (-105.016508, 39.574402), (-105.01595, 39.57427)], [(-105.014276, 39.573972), (-105.014126, 39.574038), (-105.013825, 39.57417), (-105.01331, 39.574452)]]}\n\n\nPolygon\n------------------\nSimple example data:\n\n.. code-block::\n\n  >>> from marshmallow_geojson import GeoJSONSchema\n  >>> data_string = \'{"type": "Polygon", "coordinates": [ [ [100, 0], [101, 0], [101, 1], [100, 1], [100, 0] ] ]}\'\n  >>> geojson_schema = GeoJSONSchema()\n  >>> geojson_schema.loads(geojson_text)\n  {\'type\': \'Polygon\', \'coordinates\': [[(100.0, 0.0), (101.0, 0.0), (101.0, 1.0), (100.0, 1.0), (100.0, 0.0)]]}\n\n\nMultiPolygon\n------------------\nSimple example data:\n\n.. code-block::\n\n  >>> from marshmallow_geojson import GeoJSONSchema\n  >>> data_string = \'{"type": "MultiPolygon", "coordinates": [ [ [ [107, 7], [108, 7], [108, 8], [107, 8], [107, 7] ] ], [ [ [100, 0], [101, 0], [101, 1], [100, 1], [100, 0] ] ] ]}\'\n  >>> geojson_schema = GeoJSONSchema()\n  >>> geojson_schema.loads(geojson_text)\n  {\'type\': \'MultiPolygon\', \'coordinates\': [[[(107.0, 7.0), (108.0, 7.0), (108.0, 8.0), (107.0, 8.0), (107.0, 7.0)]], [[(100.0, 0.0), (101.0, 0.0), (101.0, 1.0), (100.0, 1.0), (100.0, 0.0)]]]}\n\n\nGeometryCollection\n------------------\nSimple example data:\n\n.. code-block::\n\n  >>> from marshmallow_geojson import GeoJSONSchema\n  >>> data_string = \'{"type": "GeometryCollection", "geometries": [{"type": "Point", "coordinates": [-80.660805, 35.049392]}, {"type": "Polygon", "coordinates": [ [ [-80.664582, 35.044965], [-80.663874, 35.04428], [-80.662586, 35.04558], [-80.663444, 35.046036], [-80.664582, 35.044965] ] ]}, {"type": "LineString", "coordinates": [[-80.662372, 35.059509], [-80.662693, 35.059263], [-80.662844, 35.05893] ]}]}\'\n  >>> geojson_schema = GeoJSONSchema()\n  >>> geojson_schema.loads(geojson_text)\n  {\'type\': \'GeometryCollection\', \'geometries\': [{\'type\': \'Point\', \'coordinates\': (-80.660805, 35.049392)}, {\'type\': \'Polygon\', \'coordinates\': [[(-80.664582, 35.044965), (-80.663874, 35.04428), (-80.662586, 35.04558), (-80.663444, 35.046036), (-80.664582, 35.044965)]]}, {\'type\': \'LineString\', \'coordinates\': [(-80.662372, 35.059509), (-80.662693, 35.059263), (-80.662844, 35.05893)]}]}\n\n\nFeature\n------------------\nSimple example data:\n\n.. code-block::\n\n  {\n    "type": "Feature",\n    "geometry": {\n        "type": "Polygon",\n        "coordinates": [\n            [\n                [\n                    -80.724878,\n                    35.265454\n                ],\n                [\n                    -80.722646,\n                    35.260338\n                ],\n                [\n                    -80.720329,\n                    35.260618\n                ],\n                [\n                    -80.71681,\n                    35.255361\n                ],\n                [\n                    -80.704793,\n                    35.268397\n                ],\n                [\n                    -80.715179,\n                    35.267696\n                ],\n                [\n                    -80.721359,\n                    35.267276\n                ],\n                [\n                    -80.724878,\n                    35.265454\n                ]\n            ]\n        ]\n    },\n    "properties": {\n        "name": "Plaza Road Park"\n    }\n  }\n\n\nFeatureCollection\n------------------\nSimple example data:\n\n.. code-block::\n\n  {\n    "type": "FeatureCollection",\n    "features": [\n        {\n            "type": "Feature",\n            "geometry": {\n                "type": "Point",\n                "coordinates": [\n                    -80.870885,\n                    35.215151\n                ]\n            },\n            "properties": {\n                "name": "ABBOTT NEIGHBORHOOD PARK",\n                "address": "1300  SPRUCE ST"\n            }\n        },\n        {\n            "type": "Feature",\n            "geometry": {\n                "type": "Polygon",\n                "coordinates": [\n                    [\n                        [\n                            -80.724878,\n                            35.265454\n                        ],\n                        [\n                            -80.722646,\n                            35.260338\n                        ],\n                        [\n                            -80.720329,\n                            35.260618\n                        ],\n                        [\n                            -80.704793,\n                            35.268397\n                        ],\n\n                        [\n                            -80.724878,\n                            35.265454\n                        ]\n                    ]\n                ]\n            },\n            "properties": {\n                "name": "Plaza Road Park"\n            }\n        }\n    ]\n  }\n\n.. _GeoJSON: http://geojson.org/\n.. _poetry: https://python-poetry.org/\n',
    'author': 'Aliaksandr Vaskevich',
    'author_email': 'vaskevic.an@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/folt/marshmallow-geojson',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
