"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const s3 = require("@aws-cdk/aws-s3");
const sns = require("@aws-cdk/aws-sns");
const cdk = require("@aws-cdk/core");
const ses = require("../lib");
const stack = new cdk.Stack();
/// !show
const bucket = new s3.Bucket(stack, 'Bucket');
const topic = new sns.Topic(stack, 'Topic');
new ses.ReceiptRuleSet(stack, 'RuleSet', {
    rules: [
        {
            recipients: ['hello@aws.com'],
            actions: [
                new ses.ReceiptRuleAddHeaderAction({
                    name: 'X-Special-Header',
                    value: 'aws'
                }),
                new ses.ReceiptRuleS3Action({
                    bucket,
                    objectKeyPrefix: 'emails/',
                    topic
                })
            ],
        },
        {
            recipients: ['aws.com'],
            actions: [
                new ses.ReceiptRuleSnsAction({
                    topic
                })
            ]
        }
    ]
});
/// !hide
//# sourceMappingURL=data:application/json;base64,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