"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const kms = require("@aws-cdk/aws-kms");
const lambda = require("@aws-cdk/aws-lambda");
const s3 = require("@aws-cdk/aws-s3");
const sns = require("@aws-cdk/aws-sns");
const cdk = require("@aws-cdk/core");
const ses = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-ses-receipt');
const topic = new sns.Topic(stack, 'Topic');
const fn = new lambda.Function(stack, 'Function', {
    code: lambda.Code.fromInline('exports.handler = async (event) => event;'),
    handler: 'index.handler',
    runtime: lambda.Runtime.NODEJS_8_10
});
const bucket = new s3.Bucket(stack, 'Bucket');
const kmsKey = new kms.Key(stack, 'Key');
const ruleSet = new ses.ReceiptRuleSet(stack, 'RuleSet', {
    dropSpam: true
});
const firstRule = ruleSet.addRule('FirstRule', {
    actions: [
        new ses.ReceiptRuleAddHeaderAction({
            name: 'X-My-Header',
            value: 'value'
        }),
        new ses.ReceiptRuleLambdaAction({
            function: fn,
            invocationType: ses.LambdaInvocationType.REQUEST_RESPONSE,
            topic
        }),
        new ses.ReceiptRuleS3Action({
            bucket,
            kmsKey,
            objectKeyPrefix: 'emails/',
            topic
        }),
        new ses.ReceiptRuleSnsAction({
            encoding: ses.EmailEncoding.BASE64,
            topic
        })
    ],
    receiptRuleName: 'FirstRule',
    recipients: ['cdk-ses-receipt-test@yopmail.com'],
    scanEnabled: true,
    tlsPolicy: ses.TlsPolicy.REQUIRE,
});
firstRule.addAction(new ses.ReceiptRuleBounceAction({
    sender: 'cdk-ses-receipt-test@yopmail.com',
    template: ses.ReceiptRuleBounceActionTemplate.MESSAGE_CONTENT_REJECTED,
    topic
}));
const secondRule = ruleSet.addRule('SecondRule');
secondRule.addAction(new ses.ReceiptRuleStopAction({
    topic
}));
new ses.WhiteListReceiptFilter(stack, 'WhiteList', {
    ips: [
        '10.0.0.0/16'
    ]
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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