"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClusterParameterGroup = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const redshift_generated_1 = require("./redshift.generated");
/**
 * A new cluster or instance parameter group
 */
class ClusterParameterGroupBase extends core_1.Resource {
}
/**
 * A cluster parameter group
 *
 * @resource AWS::Redshift::ClusterParameterGroup
 */
class ClusterParameterGroup extends ClusterParameterGroupBase {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_redshift_ClusterParameterGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ClusterParameterGroup);
            }
            throw error;
        }
        const resource = new redshift_generated_1.CfnClusterParameterGroup(this, 'Resource', {
            description: props.description || 'Cluster parameter group for family redshift-1.0',
            parameterGroupFamily: 'redshift-1.0',
            parameters: Object.entries(props.parameters).map(([name, value]) => {
                return { parameterName: name, parameterValue: value };
            }),
        });
        this.clusterParameterGroupName = resource.ref;
    }
    /**
     * Imports a parameter group
     */
    static fromClusterParameterGroupName(scope, id, clusterParameterGroupName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.clusterParameterGroupName = clusterParameterGroupName;
            }
        }
        return new Import(scope, id);
    }
}
exports.ClusterParameterGroup = ClusterParameterGroup;
_a = JSII_RTTI_SYMBOL_1;
ClusterParameterGroup[_a] = { fqn: "@aws-cdk/aws-redshift.ClusterParameterGroup", version: "1.165.0" };
//# sourceMappingURL=data:application/json;base64,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