#!/usr/bin/python3

"""Setuptools configuration for srv_test."""
from setuptools.command.install import install
from setuptools import setup
from setuptools import find_packages
import subprocess
import os
from distutils.command.clean import clean as Clean
import pathlib

HERE = pathlib.Path(__file__).parent

with open("README.rst", "r") as readmefile:
    README = readmefile.read()

class CustomInstallCommand(install):

  def run(self):
    install.run(self)
    current_dir_path = os.path.dirname(os.path.realpath(__file__))
    create_service_script_path = os.path.join(current_dir_path, 'srv_test',  'srv_test.install.sh')
    create_service_script_path = f"{create_service_script_path}"
    #subprocess.check_output([create_service_script_path, '-i'])

class CustomCleanCommand(Clean):
    CLEAN_FILES = './build ./dist ./*.pyc ./*.tgz ./*.egg-info'.split(' ')
    def run(self):
        Clean.run(self)
        self.all = True
        print('rm---')
        for path_spec in self.CLEAN_FILES:
            print(path_spec)
            pass
            #abs_paths = glob.glob(os.path.normpath(os.path.join(path_spec)))
            #for path in [str(p) for p in abs_paths]:
            #    if not path.startswith(''):
           #        # Die if path in CLEAN_FILES is absolute + outside this directory
            #        raise ValueError("%s is not a path inside " % (path))
            #    print('removing %s' % os.path.relpath(path))

            #rmtree("dist")

setup(
    name='srv_test',
    version='0.4.13',
    description='SRV TEST',
    long_description=README,
    long_description_content_type="text/markdown",
    url='http://github/bartoszkaron/srv_test/',
    author='Bartosz Karon',
    author_email='bartosz.karon@gmail.com',
    license='MIT',
    packages=find_packages(include=['srv_test', 'srv_test.modules'], exclude=["tests", "build", "dist", "docs","*.egg-info"]),
    package_data={'srv_test': ['*.md', '*.services']},
    include_package_data=True,
    install_requires=[
        "pyyaml",
    #    "pyhttp",
        "pysocket"
    ],
    zip_safe=False,
    scripts=[
        'srv_test/srv_test.install.sh'
    ],
    data_files=[
        ('etc/srv_test', ['srv_test/srv_test.yml',  'srv_test/srv_test.install.sh']),
        ('etc/systemd/system' , ['srv_test/srv_test.service', 'srv_test/srv_test.socket']),
        ('usr/local/lib/srv_test', ['srv_test/srv_test.py'])
    ],
    cmdclass={
        '_install': CustomInstallCommand,
        'clean': CustomCleanCommand,
    },
    classifiers = [ 
        "Programming Language :: Python :: 3.10", 
    ]
)


    #entry_points={
        #"console_scripts": [
        #    "cli-srv_test = srv_test.modules.hello_world",
        #],
        #"srv_test.extensions": [
        #]
    #},