#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['furo']

package_data = \
{'': ['*'],
 'furo': ['assets/*',
          'assets/scripts/*',
          'assets/styles/*',
          'assets/styles/base/*',
          'assets/styles/components/*',
          'assets/styles/content/*',
          'assets/styles/extensions/*',
          'assets/styles/variables/*',
          'theme/*',
          'theme/furo/*',
          'theme/furo/partials/*',
          'theme/furo/sidebar/*',
          'theme/furo/static/*',
          'theme/furo/static/scripts/*',
          'theme/furo/static/styles/*']}

package_dir = \
{'': 'src'}

install_requires = \
['beautifulsoup4', 'sphinx ~= 3.0']

extras_require = \
{'doc': ['myst-parser', 'sphinx-inline-tabs'],
 'test': ['pytest', 'pytest-cov', 'pytest-xdist']}

entry_points = \
{'sphinx.html_themes': ['furo = furo']}

setup(name='furo',
      version='2020.12.28b22',
      description='A clean customisable Sphinx documentation theme.',
      author='Pradyun Gedam',
      author_email='mail@pradyunsg.me',
      url='https://github.com/pradyunsg/furo',
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.5',
     )
