"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Listener = exports.ClientAffinity = exports.ConnectionProtocol = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const endpoint_group_1 = require("./endpoint-group");
const ga = require("./globalaccelerator.generated");
/**
 * The protocol for the connections from clients to the accelerator.
 *
 * @stability stable
 */
var ConnectionProtocol;
(function (ConnectionProtocol) {
    ConnectionProtocol["TCP"] = "TCP";
    ConnectionProtocol["UDP"] = "UDP";
})(ConnectionProtocol = exports.ConnectionProtocol || (exports.ConnectionProtocol = {}));
/**
 * Client affinity gives you control over whether to always route each client to the same specific endpoint.
 *
 * @see https://docs.aws.amazon.com/global-accelerator/latest/dg/about-listeners.html#about-listeners-client-affinity
 * @stability stable
 */
var ClientAffinity;
(function (ClientAffinity) {
    ClientAffinity["NONE"] = "NONE";
    ClientAffinity["SOURCE_IP"] = "SOURCE_IP";
})(ClientAffinity = exports.ClientAffinity || (exports.ClientAffinity = {}));
/**
 * The construct for the Listener.
 *
 * @stability stable
 */
class Listener extends cdk.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        const resource = new ga.CfnListener(this, 'Resource', {
            acceleratorArn: props.accelerator.acceleratorArn,
            portRanges: props.portRanges.map(m => {
                var _b;
                return ({
                    fromPort: m.fromPort,
                    toPort: (_b = m.toPort) !== null && _b !== void 0 ? _b : m.fromPort,
                });
            }),
            protocol: (_b = props.protocol) !== null && _b !== void 0 ? _b : ConnectionProtocol.TCP,
            clientAffinity: (_c = props.clientAffinity) !== null && _c !== void 0 ? _c : ClientAffinity.NONE,
        });
        this.listenerArn = resource.attrListenerArn;
        this.listenerName = (_d = props.listenerName) !== null && _d !== void 0 ? _d : resource.logicalId;
    }
    /**
     * import from ARN.
     *
     * @stability stable
     */
    static fromListenerArn(scope, id, listenerArn) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.listenerArn = listenerArn;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Add a new endpoint group to this listener.
     *
     * @stability stable
     */
    addEndpointGroup(id, options = {}) {
        return new endpoint_group_1.EndpointGroup(this, id, {
            listener: this,
            ...options,
        });
    }
}
exports.Listener = Listener;
_a = JSII_RTTI_SYMBOL_1;
Listener[_a] = { fqn: "@aws-cdk/aws-globalaccelerator.Listener", version: "1.116.0" };
//# sourceMappingURL=data:application/json;base64,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