# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/Block.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import digitaleye_msgs.msg

class Block(genpy.Message):
  _md5sum = "8170dc62be5685b742630e3bb5d8a9ad"
  _type = "digitaleye_msgs/Block"
  _has_header = False  # flag to mark the presence of a Header object
  _full_text = """# Block definition

# unique id
uint32 id

# other linked block ids
uint32[] link_ids

# Volume definition
digitaleye_msgs/Volume volume

# category of allocations eligible to use this Block, use BLOCK_CAT_ in ConstantsAllocations
uint32[] eligible_categories

# specific entities eligible to use this Block, can be empty if not restricted
string[] eligible_entities

================================================================================
MSG: digitaleye_msgs/Volume
# Volume definition

# Volume shape, use SHAPE_
uint32 shape

uint32 SHAPE_PRISM=1
uint32 SHAPE_SPHERE=2
uint32 SHAPE_CYLINDER=3

# Parameters of the volume
uint32[] int_param
float64[] float_param

# Prism: characterised by 2 bases of same nb of point (x,y,z), ordered the same way
# size of float param is nb points*PRISM_FLOAT_PARAM_SIZE*2
# (number of points * number of coordinates/float param per point  * 2 bases)
# Prism int parameters indexes
uint32 PRISM_INT_NB_POINTS=0
uint32 PRISM_INT_PARAM_SIZE=1 # constant (not index) - size of int_param
# Prism float parameters indexes
uint32 PRISM_FLOAT_X=0
uint32 PRISM_FLOAT_Y=1
uint32 PRISM_FLOAT_Z=2
uint32 PRISM_FLOAT_PARAM_SIZE=3  # constant (not index) - size of each point / nb of float params per point

# Sphere: characterised by radius and centre point (x,y,z)
# Sphere no int parameters
uint32 SPHERE_INT_PARAM_SIZE=0 # constant (not index) - size of int_param
# Sphere float parameters indexes
uint32 SPHERE_FLOAT_RADIUS=0
uint32 SPHERE_FLOAT_X=1
uint32 SPHERE_FLOAT_Y=2
uint32 SPHERE_FLOAT_Z=3
uint32 SPHERE_FLOAT_PARAM_SIZE=4 # constant (not index) - size of float_param

# Cylinder: characterised by 2 bases with each:
#   centre point (x,y,z), radius, termination: spherical/flat (use TERM_)
# Cylinder int parameters indexes
uint32 CYLINDER_INT_TERM1=0
uint32 CYLINDER_INT_TERM2=1
uint32 CYLINDER_INT_PARAM_SIZE=2 # constant (not index) - size of int_param

# Cylinder float parameters indexes
uint32 CYLINDER_FLOAT_X1=0
uint32 CYLINDER_FLOAT_Y1=1
uint32 CYLINDER_FLOAT_Z1=2
uint32 CYLINDER_FLOAT_RADIUS1=3
uint32 CYLINDER_FLOAT_X2=4
uint32 CYLINDER_FLOAT_Y2=5
uint32 CYLINDER_FLOAT_Z2=6
uint32 CYLINDER_FLOAT_RADIUS2=7
uint32 CYLINDER_FLOAT_PARAM_SIZE=8 # constant (not index) - size of float_param

# termination of volume, spherical or flat
uint32 TERM_SPHERE=0
uint32 TERM_FLAT=1
"""
  __slots__ = ['id','link_ids','volume','eligible_categories','eligible_entities']
  _slot_types = ['uint32','uint32[]','digitaleye_msgs/Volume','uint32[]','string[]']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       id,link_ids,volume,eligible_categories,eligible_entities

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(Block, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.id is None:
        self.id = 0
      if self.link_ids is None:
        self.link_ids = []
      if self.volume is None:
        self.volume = digitaleye_msgs.msg.Volume()
      if self.eligible_categories is None:
        self.eligible_categories = []
      if self.eligible_entities is None:
        self.eligible_entities = []
    else:
      self.id = 0
      self.link_ids = []
      self.volume = digitaleye_msgs.msg.Volume()
      self.eligible_categories = []
      self.eligible_entities = []

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self.id
      buff.write(_get_struct_I().pack(_x))
      length = len(self.link_ids)
      buff.write(_struct_I.pack(length))
      pattern = '<%sI'%length
      buff.write(struct.Struct(pattern).pack(*self.link_ids))
      _x = self.volume.shape
      buff.write(_get_struct_I().pack(_x))
      length = len(self.volume.int_param)
      buff.write(_struct_I.pack(length))
      pattern = '<%sI'%length
      buff.write(struct.Struct(pattern).pack(*self.volume.int_param))
      length = len(self.volume.float_param)
      buff.write(_struct_I.pack(length))
      pattern = '<%sd'%length
      buff.write(struct.Struct(pattern).pack(*self.volume.float_param))
      length = len(self.eligible_categories)
      buff.write(_struct_I.pack(length))
      pattern = '<%sI'%length
      buff.write(struct.Struct(pattern).pack(*self.eligible_categories))
      length = len(self.eligible_entities)
      buff.write(_struct_I.pack(length))
      for val1 in self.eligible_entities:
        length = len(val1)
        if python3 or type(val1) == unicode:
          val1 = val1.encode('utf-8')
          length = len(val1)
        buff.write(struct.Struct('<I%ss'%length).pack(length, val1))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.volume is None:
        self.volume = digitaleye_msgs.msg.Volume()
      end = 0
      start = end
      end += 4
      (self.id,) = _get_struct_I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sI'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.link_ids = s.unpack(str[start:end])
      start = end
      end += 4
      (self.volume.shape,) = _get_struct_I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sI'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.volume.int_param = s.unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sd'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.volume.float_param = s.unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sI'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.eligible_categories = s.unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.eligible_entities = []
      for i in range(0, length):
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1 = str[start:end].decode('utf-8', 'rosmsg')
        else:
          val1 = str[start:end]
        self.eligible_entities.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self.id
      buff.write(_get_struct_I().pack(_x))
      length = len(self.link_ids)
      buff.write(_struct_I.pack(length))
      pattern = '<%sI'%length
      buff.write(self.link_ids.tostring())
      _x = self.volume.shape
      buff.write(_get_struct_I().pack(_x))
      length = len(self.volume.int_param)
      buff.write(_struct_I.pack(length))
      pattern = '<%sI'%length
      buff.write(self.volume.int_param.tostring())
      length = len(self.volume.float_param)
      buff.write(_struct_I.pack(length))
      pattern = '<%sd'%length
      buff.write(self.volume.float_param.tostring())
      length = len(self.eligible_categories)
      buff.write(_struct_I.pack(length))
      pattern = '<%sI'%length
      buff.write(self.eligible_categories.tostring())
      length = len(self.eligible_entities)
      buff.write(_struct_I.pack(length))
      for val1 in self.eligible_entities:
        length = len(val1)
        if python3 or type(val1) == unicode:
          val1 = val1.encode('utf-8')
          length = len(val1)
        buff.write(struct.Struct('<I%ss'%length).pack(length, val1))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.volume is None:
        self.volume = digitaleye_msgs.msg.Volume()
      end = 0
      start = end
      end += 4
      (self.id,) = _get_struct_I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sI'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.link_ids = numpy.frombuffer(str[start:end], dtype=numpy.uint32, count=length)
      start = end
      end += 4
      (self.volume.shape,) = _get_struct_I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sI'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.volume.int_param = numpy.frombuffer(str[start:end], dtype=numpy.uint32, count=length)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sd'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.volume.float_param = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=length)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sI'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.eligible_categories = numpy.frombuffer(str[start:end], dtype=numpy.uint32, count=length)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.eligible_entities = []
      for i in range(0, length):
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1 = str[start:end].decode('utf-8', 'rosmsg')
        else:
          val1 = str[start:end]
        self.eligible_entities.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
