# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/Conformance.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct


class Conformance(genpy.Message):
  _md5sum = "7c100785a8accf587048ae11af13fe68"
  _type = "digitaleye_msgs/Conformance"
  _has_header = False  # flag to mark the presence of a Header object
  _full_text = """# conformance definition of an entity

# entity
uint64 entity_id

# current booking id, 0 if none
uint32 booking_id

# generation increment of allocations, 0 if none
uint32 allocation_gen_increment

# current allocation(s) of the entity
# if ok conformance, means allocation(s)' presence
# if ko conformance, means allocation to conform to
uint32[] allocation_ids

# current sector(s) of the entity (i.e. presence)
uint32[] sector_ids

# conformance status, use CONF_ constants
uint32 conf_status

# Metrics for conformance
# index: 0: closeness to path, 1: closeness to other paths/allocations,
# 2:closeness to other known entities
float64[] conf_metrics
"""
  __slots__ = ['entity_id','booking_id','allocation_gen_increment','allocation_ids','sector_ids','conf_status','conf_metrics']
  _slot_types = ['uint64','uint32','uint32','uint32[]','uint32[]','uint32','float64[]']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       entity_id,booking_id,allocation_gen_increment,allocation_ids,sector_ids,conf_status,conf_metrics

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(Conformance, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.entity_id is None:
        self.entity_id = 0
      if self.booking_id is None:
        self.booking_id = 0
      if self.allocation_gen_increment is None:
        self.allocation_gen_increment = 0
      if self.allocation_ids is None:
        self.allocation_ids = []
      if self.sector_ids is None:
        self.sector_ids = []
      if self.conf_status is None:
        self.conf_status = 0
      if self.conf_metrics is None:
        self.conf_metrics = []
    else:
      self.entity_id = 0
      self.booking_id = 0
      self.allocation_gen_increment = 0
      self.allocation_ids = []
      self.sector_ids = []
      self.conf_status = 0
      self.conf_metrics = []

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self
      buff.write(_get_struct_Q2I().pack(_x.entity_id, _x.booking_id, _x.allocation_gen_increment))
      length = len(self.allocation_ids)
      buff.write(_struct_I.pack(length))
      pattern = '<%sI'%length
      buff.write(struct.Struct(pattern).pack(*self.allocation_ids))
      length = len(self.sector_ids)
      buff.write(_struct_I.pack(length))
      pattern = '<%sI'%length
      buff.write(struct.Struct(pattern).pack(*self.sector_ids))
      _x = self.conf_status
      buff.write(_get_struct_I().pack(_x))
      length = len(self.conf_metrics)
      buff.write(_struct_I.pack(length))
      pattern = '<%sd'%length
      buff.write(struct.Struct(pattern).pack(*self.conf_metrics))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      end = 0
      _x = self
      start = end
      end += 16
      (_x.entity_id, _x.booking_id, _x.allocation_gen_increment,) = _get_struct_Q2I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sI'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.allocation_ids = s.unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sI'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.sector_ids = s.unpack(str[start:end])
      start = end
      end += 4
      (self.conf_status,) = _get_struct_I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sd'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.conf_metrics = s.unpack(str[start:end])
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self
      buff.write(_get_struct_Q2I().pack(_x.entity_id, _x.booking_id, _x.allocation_gen_increment))
      length = len(self.allocation_ids)
      buff.write(_struct_I.pack(length))
      pattern = '<%sI'%length
      buff.write(self.allocation_ids.tostring())
      length = len(self.sector_ids)
      buff.write(_struct_I.pack(length))
      pattern = '<%sI'%length
      buff.write(self.sector_ids.tostring())
      _x = self.conf_status
      buff.write(_get_struct_I().pack(_x))
      length = len(self.conf_metrics)
      buff.write(_struct_I.pack(length))
      pattern = '<%sd'%length
      buff.write(self.conf_metrics.tostring())
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      end = 0
      _x = self
      start = end
      end += 16
      (_x.entity_id, _x.booking_id, _x.allocation_gen_increment,) = _get_struct_Q2I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sI'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.allocation_ids = numpy.frombuffer(str[start:end], dtype=numpy.uint32, count=length)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sI'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.sector_ids = numpy.frombuffer(str[start:end], dtype=numpy.uint32, count=length)
      start = end
      end += 4
      (self.conf_status,) = _get_struct_I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sd'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.conf_metrics = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=length)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_Q2I = None
def _get_struct_Q2I():
    global _struct_Q2I
    if _struct_Q2I is None:
        _struct_Q2I = struct.Struct("<Q2I")
    return _struct_Q2I
