# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/ConformanceStatus.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import digitaleye_msgs.msg
import geometry_msgs.msg
import std_msgs.msg

class ConformanceStatus(genpy.Message):
  _md5sum = "8c1df718980d8927b8a5ea3a527d6e63"
  _type = "digitaleye_msgs/ConformanceStatus"
  _has_header = True  # flag to mark the presence of a Header object
  _full_text = """# conformance status of all UAV objects 

# information on the time at which the status(es)
# was reported (epoch time)
std_msgs/Header header

# list of conforming status of all UAV(s)
digitaleye_msgs/ConformanceUavStatus[] uavs_conforming_status

================================================================================
MSG: std_msgs/Header
# Standard metadata for higher-level stamped data types.
# This is generally used to communicate timestamped data 
# in a particular coordinate frame.
# 
# sequence ID: consecutively increasing ID 
uint32 seq
#Two-integer timestamp that is expressed as:
# * stamp.sec: seconds (stamp_secs) since epoch (in Python the variable is called 'secs')
# * stamp.nsec: nanoseconds since stamp_secs (in Python the variable is called 'nsecs')
# time-handling sugar is provided by the client library
time stamp
#Frame this data is associated with
string frame_id

================================================================================
MSG: digitaleye_msgs/ConformanceUavStatus
# Conformance status details for a UAV

# unique internal UAV id
uint64 uav_id

# state of the conformance of the UAV
# using CONF_ constants below
uint32 conformance_state

# indicator of the position of the UAV
# - true: inside Managed Volume
# - false: outside of Managed Volume
bool is_inside_MV

# coordinates of the object’s estimated position
# in the local reference frame (meters)
geometry_msgs/Point position

uint32 CONF_MIN_STATE=9200 # for bounds check
uint32 CONF_KO_UNKNOWN=9200
uint32 CONF_KO_AIR_ENTRY=9201
uint32 CONF_KO_GROUND_ENTRY=9202
uint32 CONF_KO_ALL_ENTRIES=9203
uint32 CONF_KO_FLIGHTPATH=9204
uint32 CONF_OK_AIR_ENTRY=9205
uint32 CONF_OK_GROUND_ENTRY=9206
uint32 CONF_OK_FLIGHTPATH=9207
uint32 CONF_OK_AIR_EXIT=9208
uint32 CONF_OK_GROUND=9209
uint32 CONF_OK_AIR=9210
uint32 CONF_READY_TO_LAND=9211
uint32 CONF_READY_TO_FLY_OUT=9212
uint32 CONF_MAX_STATE=9212 # for bounds check

================================================================================
MSG: geometry_msgs/Point
# This contains the position of a point in free space
float64 x
float64 y
float64 z
"""
  __slots__ = ['header','uavs_conforming_status']
  _slot_types = ['std_msgs/Header','digitaleye_msgs/ConformanceUavStatus[]']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       header,uavs_conforming_status

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(ConformanceStatus, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.uavs_conforming_status is None:
        self.uavs_conforming_status = []
    else:
      self.header = std_msgs.msg.Header()
      self.uavs_conforming_status = []

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self
      buff.write(_get_struct_3I().pack(_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs))
      _x = self.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      length = len(self.uavs_conforming_status)
      buff.write(_struct_I.pack(length))
      for val1 in self.uavs_conforming_status:
        _x = val1
        buff.write(_get_struct_QIB().pack(_x.uav_id, _x.conformance_state, _x.is_inside_MV))
        _v1 = val1.position
        _x = _v1
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.uavs_conforming_status is None:
        self.uavs_conforming_status = None
      end = 0
      _x = self
      start = end
      end += 12
      (_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.header.frame_id = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.uavs_conforming_status = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.ConformanceUavStatus()
        _x = val1
        start = end
        end += 13
        (_x.uav_id, _x.conformance_state, _x.is_inside_MV,) = _get_struct_QIB().unpack(str[start:end])
        val1.is_inside_MV = bool(val1.is_inside_MV)
        _v2 = val1.position
        _x = _v2
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        self.uavs_conforming_status.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self
      buff.write(_get_struct_3I().pack(_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs))
      _x = self.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      length = len(self.uavs_conforming_status)
      buff.write(_struct_I.pack(length))
      for val1 in self.uavs_conforming_status:
        _x = val1
        buff.write(_get_struct_QIB().pack(_x.uav_id, _x.conformance_state, _x.is_inside_MV))
        _v3 = val1.position
        _x = _v3
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.uavs_conforming_status is None:
        self.uavs_conforming_status = None
      end = 0
      _x = self
      start = end
      end += 12
      (_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.header.frame_id = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.uavs_conforming_status = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.ConformanceUavStatus()
        _x = val1
        start = end
        end += 13
        (_x.uav_id, _x.conformance_state, _x.is_inside_MV,) = _get_struct_QIB().unpack(str[start:end])
        val1.is_inside_MV = bool(val1.is_inside_MV)
        _v4 = val1.position
        _x = _v4
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        self.uavs_conforming_status.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_3I = None
def _get_struct_3I():
    global _struct_3I
    if _struct_3I is None:
        _struct_3I = struct.Struct("<3I")
    return _struct_3I
_struct_3d = None
def _get_struct_3d():
    global _struct_3d
    if _struct_3d is None:
        _struct_3d = struct.Struct("<3d")
    return _struct_3d
_struct_QIB = None
def _get_struct_QIB():
    global _struct_QIB
    if _struct_QIB is None:
        _struct_QIB = struct.Struct("<QIB")
    return _struct_QIB
