# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/Object.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import digitaleye_msgs.msg
import genpy
import geometry_msgs.msg
import std_msgs.msg

class Object(genpy.Message):
  _md5sum = "725c242e665d51caa43275268c7f22a0"
  _type = "digitaleye_msgs/Object"
  _has_header = True  # flag to mark the presence of a Header object
  _full_text = """# Description of an object in the Monitored Space

# information on the time at which the object
# was reported (epoch time) and its reference frame
std_msgs/Header header

# id assigned to the reported object
uint64 object_id

# list of ID(s) of reported object(s) which
# constitute it (if fused)
uint64[] fused_ids

# coordinates of the object’s estimated position
# in the local reference frame (meters)
geometry_msgs/Point position

# 3D covariance of the object position, represents the quality
# of the position estimate, higher covariances mean
# a worse estimate. XX, XY, XZ, YX, YY, YZ, ZX, ZY, ZZ
float32[9] pos_covariance

# estimated accuracy radius of object's position (meters)
float32 accuracy

# estimated velocity of the object (m/s)
geometry_msgs/Vector3 velocity

# estimated acceleration of the object (m/s2)
geometry_msgs/Accel acceleration

# estimated size of the object (meters)
geometry_msgs/Point scale

# object’s category
# e.g. Personnel, Package, Passenger, UAV, etc.
string classification

# list of zone(s) in which the object is
ZoneObjectStatus[] zones

# object’s name
# e.g. Minion-01 Minion-02, etc.
string name

# object’s UUID
string uuid

================================================================================
MSG: std_msgs/Header
# Standard metadata for higher-level stamped data types.
# This is generally used to communicate timestamped data 
# in a particular coordinate frame.
# 
# sequence ID: consecutively increasing ID 
uint32 seq
#Two-integer timestamp that is expressed as:
# * stamp.sec: seconds (stamp_secs) since epoch (in Python the variable is called 'secs')
# * stamp.nsec: nanoseconds since stamp_secs (in Python the variable is called 'nsecs')
# time-handling sugar is provided by the client library
time stamp
#Frame this data is associated with
string frame_id

================================================================================
MSG: geometry_msgs/Point
# This contains the position of a point in free space
float64 x
float64 y
float64 z

================================================================================
MSG: geometry_msgs/Vector3
# This represents a vector in free space. 
# It is only meant to represent a direction. Therefore, it does not
# make sense to apply a translation to it (e.g., when applying a 
# generic rigid transformation to a Vector3, tf2 will only apply the
# rotation). If you want your data to be translatable too, use the
# geometry_msgs/Point message instead.

float64 x
float64 y
float64 z
================================================================================
MSG: geometry_msgs/Accel
# This expresses acceleration in free space broken into its linear and angular parts.
Vector3  linear
Vector3  angular

================================================================================
MSG: digitaleye_msgs/ZoneObjectStatus
# Status of the object within the specified zone

# identifier of the zone the object is in
uint32 zone_id

# whether or not the object is allowed in the zone
bool allowed

# time the object was first detected in this zone
# (ros timestamp in epoch time)
time first_detected

# time the object was last detected in this zone
# (ros timestamp in epoch time)
time last_detected
"""
  __slots__ = ['header','object_id','fused_ids','position','pos_covariance','accuracy','velocity','acceleration','scale','classification','zones','name','uuid']
  _slot_types = ['std_msgs/Header','uint64','uint64[]','geometry_msgs/Point','float32[9]','float32','geometry_msgs/Vector3','geometry_msgs/Accel','geometry_msgs/Point','string','digitaleye_msgs/ZoneObjectStatus[]','string','string']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       header,object_id,fused_ids,position,pos_covariance,accuracy,velocity,acceleration,scale,classification,zones,name,uuid

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(Object, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.object_id is None:
        self.object_id = 0
      if self.fused_ids is None:
        self.fused_ids = []
      if self.position is None:
        self.position = geometry_msgs.msg.Point()
      if self.pos_covariance is None:
        self.pos_covariance = [0.] * 9
      if self.accuracy is None:
        self.accuracy = 0.
      if self.velocity is None:
        self.velocity = geometry_msgs.msg.Vector3()
      if self.acceleration is None:
        self.acceleration = geometry_msgs.msg.Accel()
      if self.scale is None:
        self.scale = geometry_msgs.msg.Point()
      if self.classification is None:
        self.classification = ''
      if self.zones is None:
        self.zones = []
      if self.name is None:
        self.name = ''
      if self.uuid is None:
        self.uuid = ''
    else:
      self.header = std_msgs.msg.Header()
      self.object_id = 0
      self.fused_ids = []
      self.position = geometry_msgs.msg.Point()
      self.pos_covariance = [0.] * 9
      self.accuracy = 0.
      self.velocity = geometry_msgs.msg.Vector3()
      self.acceleration = geometry_msgs.msg.Accel()
      self.scale = geometry_msgs.msg.Point()
      self.classification = ''
      self.zones = []
      self.name = ''
      self.uuid = ''

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self
      buff.write(_get_struct_3I().pack(_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs))
      _x = self.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.object_id
      buff.write(_get_struct_Q().pack(_x))
      length = len(self.fused_ids)
      buff.write(_struct_I.pack(length))
      pattern = '<%sQ'%length
      buff.write(struct.Struct(pattern).pack(*self.fused_ids))
      _x = self
      buff.write(_get_struct_3d().pack(_x.position.x, _x.position.y, _x.position.z))
      buff.write(_get_struct_9f().pack(*self.pos_covariance))
      _x = self
      buff.write(_get_struct_f12d().pack(_x.accuracy, _x.velocity.x, _x.velocity.y, _x.velocity.z, _x.acceleration.linear.x, _x.acceleration.linear.y, _x.acceleration.linear.z, _x.acceleration.angular.x, _x.acceleration.angular.y, _x.acceleration.angular.z, _x.scale.x, _x.scale.y, _x.scale.z))
      _x = self.classification
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      length = len(self.zones)
      buff.write(_struct_I.pack(length))
      for val1 in self.zones:
        _x = val1
        buff.write(_get_struct_IB().pack(_x.zone_id, _x.allowed))
        _v1 = val1.first_detected
        _x = _v1
        buff.write(_get_struct_2I().pack(_x.secs, _x.nsecs))
        _v2 = val1.last_detected
        _x = _v2
        buff.write(_get_struct_2I().pack(_x.secs, _x.nsecs))
      _x = self.name
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.uuid
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.position is None:
        self.position = geometry_msgs.msg.Point()
      if self.velocity is None:
        self.velocity = geometry_msgs.msg.Vector3()
      if self.acceleration is None:
        self.acceleration = geometry_msgs.msg.Accel()
      if self.scale is None:
        self.scale = geometry_msgs.msg.Point()
      if self.zones is None:
        self.zones = None
      end = 0
      _x = self
      start = end
      end += 12
      (_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.header.frame_id = str[start:end]
      start = end
      end += 8
      (self.object_id,) = _get_struct_Q().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sQ'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.fused_ids = s.unpack(str[start:end])
      _x = self
      start = end
      end += 24
      (_x.position.x, _x.position.y, _x.position.z,) = _get_struct_3d().unpack(str[start:end])
      start = end
      end += 36
      self.pos_covariance = _get_struct_9f().unpack(str[start:end])
      _x = self
      start = end
      end += 100
      (_x.accuracy, _x.velocity.x, _x.velocity.y, _x.velocity.z, _x.acceleration.linear.x, _x.acceleration.linear.y, _x.acceleration.linear.z, _x.acceleration.angular.x, _x.acceleration.angular.y, _x.acceleration.angular.z, _x.scale.x, _x.scale.y, _x.scale.z,) = _get_struct_f12d().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.classification = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.classification = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.zones = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.ZoneObjectStatus()
        _x = val1
        start = end
        end += 5
        (_x.zone_id, _x.allowed,) = _get_struct_IB().unpack(str[start:end])
        val1.allowed = bool(val1.allowed)
        _v3 = val1.first_detected
        _x = _v3
        start = end
        end += 8
        (_x.secs, _x.nsecs,) = _get_struct_2I().unpack(str[start:end])
        _v4 = val1.last_detected
        _x = _v4
        start = end
        end += 8
        (_x.secs, _x.nsecs,) = _get_struct_2I().unpack(str[start:end])
        self.zones.append(val1)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.name = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.name = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.uuid = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.uuid = str[start:end]
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self
      buff.write(_get_struct_3I().pack(_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs))
      _x = self.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.object_id
      buff.write(_get_struct_Q().pack(_x))
      length = len(self.fused_ids)
      buff.write(_struct_I.pack(length))
      pattern = '<%sQ'%length
      buff.write(self.fused_ids.tostring())
      _x = self
      buff.write(_get_struct_3d().pack(_x.position.x, _x.position.y, _x.position.z))
      buff.write(self.pos_covariance.tostring())
      _x = self
      buff.write(_get_struct_f12d().pack(_x.accuracy, _x.velocity.x, _x.velocity.y, _x.velocity.z, _x.acceleration.linear.x, _x.acceleration.linear.y, _x.acceleration.linear.z, _x.acceleration.angular.x, _x.acceleration.angular.y, _x.acceleration.angular.z, _x.scale.x, _x.scale.y, _x.scale.z))
      _x = self.classification
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      length = len(self.zones)
      buff.write(_struct_I.pack(length))
      for val1 in self.zones:
        _x = val1
        buff.write(_get_struct_IB().pack(_x.zone_id, _x.allowed))
        _v5 = val1.first_detected
        _x = _v5
        buff.write(_get_struct_2I().pack(_x.secs, _x.nsecs))
        _v6 = val1.last_detected
        _x = _v6
        buff.write(_get_struct_2I().pack(_x.secs, _x.nsecs))
      _x = self.name
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.uuid
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.position is None:
        self.position = geometry_msgs.msg.Point()
      if self.velocity is None:
        self.velocity = geometry_msgs.msg.Vector3()
      if self.acceleration is None:
        self.acceleration = geometry_msgs.msg.Accel()
      if self.scale is None:
        self.scale = geometry_msgs.msg.Point()
      if self.zones is None:
        self.zones = None
      end = 0
      _x = self
      start = end
      end += 12
      (_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.header.frame_id = str[start:end]
      start = end
      end += 8
      (self.object_id,) = _get_struct_Q().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sQ'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.fused_ids = numpy.frombuffer(str[start:end], dtype=numpy.uint64, count=length)
      _x = self
      start = end
      end += 24
      (_x.position.x, _x.position.y, _x.position.z,) = _get_struct_3d().unpack(str[start:end])
      start = end
      end += 36
      self.pos_covariance = numpy.frombuffer(str[start:end], dtype=numpy.float32, count=9)
      _x = self
      start = end
      end += 100
      (_x.accuracy, _x.velocity.x, _x.velocity.y, _x.velocity.z, _x.acceleration.linear.x, _x.acceleration.linear.y, _x.acceleration.linear.z, _x.acceleration.angular.x, _x.acceleration.angular.y, _x.acceleration.angular.z, _x.scale.x, _x.scale.y, _x.scale.z,) = _get_struct_f12d().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.classification = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.classification = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.zones = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.ZoneObjectStatus()
        _x = val1
        start = end
        end += 5
        (_x.zone_id, _x.allowed,) = _get_struct_IB().unpack(str[start:end])
        val1.allowed = bool(val1.allowed)
        _v7 = val1.first_detected
        _x = _v7
        start = end
        end += 8
        (_x.secs, _x.nsecs,) = _get_struct_2I().unpack(str[start:end])
        _v8 = val1.last_detected
        _x = _v8
        start = end
        end += 8
        (_x.secs, _x.nsecs,) = _get_struct_2I().unpack(str[start:end])
        self.zones.append(val1)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.name = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.name = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.uuid = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.uuid = str[start:end]
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_2I = None
def _get_struct_2I():
    global _struct_2I
    if _struct_2I is None:
        _struct_2I = struct.Struct("<2I")
    return _struct_2I
_struct_3I = None
def _get_struct_3I():
    global _struct_3I
    if _struct_3I is None:
        _struct_3I = struct.Struct("<3I")
    return _struct_3I
_struct_3d = None
def _get_struct_3d():
    global _struct_3d
    if _struct_3d is None:
        _struct_3d = struct.Struct("<3d")
    return _struct_3d
_struct_9f = None
def _get_struct_9f():
    global _struct_9f
    if _struct_9f is None:
        _struct_9f = struct.Struct("<9f")
    return _struct_9f
_struct_IB = None
def _get_struct_IB():
    global _struct_IB
    if _struct_IB is None:
        _struct_IB = struct.Struct("<IB")
    return _struct_IB
_struct_Q = None
def _get_struct_Q():
    global _struct_Q
    if _struct_Q is None:
        _struct_Q = struct.Struct("<Q")
    return _struct_Q
_struct_f12d = None
def _get_struct_f12d():
    global _struct_f12d
    if _struct_f12d is None:
        _struct_f12d = struct.Struct("<f12d")
    return _struct_f12d
