# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/UavFlightData.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import digitaleye_msgs.msg
import geometry_msgs.msg
import std_msgs.msg

class UavFlightData(genpy.Message):
  _md5sum = "3044fea7236c913d55d5b35448da568c"
  _type = "digitaleye_msgs/UavFlightData"
  _has_header = True  # flag to mark the presence of a Header object
  _full_text = """# Specific flight data for a given UAV

# standard header
std_msgs/Header header

# agent registration of the UAV
uint64 agent_reg

# list of point(s) linked to msg_type
digitaleye_msgs/Flightpath flight_path

# type of flight data
uint32 msg_type

# optional:
# start time of zone (included) (Epoch timestamp in seconds)
uint64 start

# end time of zone (included) (Epoch timestamp in seconds)
uint64 end

# msg_type constants
# Take off data (hover point)
uint32 TAKE_OFF=9400
# Landing data (landing point)
uint32 LANDING=9401
# Reset (no flight data associated)
uint32 RESET=9402
# flight exiting the MGS
uint32 FLIGHT_OUT=9403
# flight entering the MGS
uint32 FLIGHT_IN=9404
# entry point data: TOLZ id
uint32 TOLZ_ENTRY=9405
# entry point data: local coordinates (meters)
uint32 COORD_ENTRY=9406
# handover out: local coordinates (meters)
uint32 HAND_OUT=9407

================================================================================
MSG: std_msgs/Header
# Standard metadata for higher-level stamped data types.
# This is generally used to communicate timestamped data 
# in a particular coordinate frame.
# 
# sequence ID: consecutively increasing ID 
uint32 seq
#Two-integer timestamp that is expressed as:
# * stamp.sec: seconds (stamp_secs) since epoch (in Python the variable is called 'secs')
# * stamp.nsec: nanoseconds since stamp_secs (in Python the variable is called 'nsecs')
# time-handling sugar is provided by the client library
time stamp
#Frame this data is associated with
string frame_id

================================================================================
MSG: digitaleye_msgs/Flightpath
# Fligh path definition

# TOLZ id (0 = N/A)
uint32 tolz_id

# list of flight point(s)
digitaleye_msgs/Flightpoint[] flight_points

================================================================================
MSG: digitaleye_msgs/Flightpoint
# Flight point definition

# local coordinates of point (meters)
geometry_msgs/Point coord

# desired speed to reach this point (m/s)
float32 speed

================================================================================
MSG: geometry_msgs/Point
# This contains the position of a point in free space
float64 x
float64 y
float64 z
"""
  # Pseudo-constants
  TAKE_OFF = 9400
  LANDING = 9401
  RESET = 9402
  FLIGHT_OUT = 9403
  FLIGHT_IN = 9404
  TOLZ_ENTRY = 9405
  COORD_ENTRY = 9406
  HAND_OUT = 9407

  __slots__ = ['header','agent_reg','flight_path','msg_type','start','end']
  _slot_types = ['std_msgs/Header','uint64','digitaleye_msgs/Flightpath','uint32','uint64','uint64']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       header,agent_reg,flight_path,msg_type,start,end

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(UavFlightData, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.agent_reg is None:
        self.agent_reg = 0
      if self.flight_path is None:
        self.flight_path = digitaleye_msgs.msg.Flightpath()
      if self.msg_type is None:
        self.msg_type = 0
      if self.start is None:
        self.start = 0
      if self.end is None:
        self.end = 0
    else:
      self.header = std_msgs.msg.Header()
      self.agent_reg = 0
      self.flight_path = digitaleye_msgs.msg.Flightpath()
      self.msg_type = 0
      self.start = 0
      self.end = 0

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self
      buff.write(_get_struct_3I().pack(_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs))
      _x = self.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self
      buff.write(_get_struct_QI().pack(_x.agent_reg, _x.flight_path.tolz_id))
      length = len(self.flight_path.flight_points)
      buff.write(_struct_I.pack(length))
      for val1 in self.flight_path.flight_points:
        _v1 = val1.coord
        _x = _v1
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
        _x = val1.speed
        buff.write(_get_struct_f().pack(_x))
      _x = self
      buff.write(_get_struct_I2Q().pack(_x.msg_type, _x.start, _x.end))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.flight_path is None:
        self.flight_path = digitaleye_msgs.msg.Flightpath()
      end = 0
      _x = self
      start = end
      end += 12
      (_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.header.frame_id = str[start:end]
      _x = self
      start = end
      end += 12
      (_x.agent_reg, _x.flight_path.tolz_id,) = _get_struct_QI().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.flight_path.flight_points = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Flightpoint()
        _v2 = val1.coord
        _x = _v2
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        start = end
        end += 4
        (val1.speed,) = _get_struct_f().unpack(str[start:end])
        self.flight_path.flight_points.append(val1)
      _x = self
      start = end
      end += 20
      (_x.msg_type, _x.start, _x.end,) = _get_struct_I2Q().unpack(str[start:end])
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self
      buff.write(_get_struct_3I().pack(_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs))
      _x = self.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self
      buff.write(_get_struct_QI().pack(_x.agent_reg, _x.flight_path.tolz_id))
      length = len(self.flight_path.flight_points)
      buff.write(_struct_I.pack(length))
      for val1 in self.flight_path.flight_points:
        _v3 = val1.coord
        _x = _v3
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
        _x = val1.speed
        buff.write(_get_struct_f().pack(_x))
      _x = self
      buff.write(_get_struct_I2Q().pack(_x.msg_type, _x.start, _x.end))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.flight_path is None:
        self.flight_path = digitaleye_msgs.msg.Flightpath()
      end = 0
      _x = self
      start = end
      end += 12
      (_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.header.frame_id = str[start:end]
      _x = self
      start = end
      end += 12
      (_x.agent_reg, _x.flight_path.tolz_id,) = _get_struct_QI().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.flight_path.flight_points = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Flightpoint()
        _v4 = val1.coord
        _x = _v4
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        start = end
        end += 4
        (val1.speed,) = _get_struct_f().unpack(str[start:end])
        self.flight_path.flight_points.append(val1)
      _x = self
      start = end
      end += 20
      (_x.msg_type, _x.start, _x.end,) = _get_struct_I2Q().unpack(str[start:end])
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_3I = None
def _get_struct_3I():
    global _struct_3I
    if _struct_3I is None:
        _struct_3I = struct.Struct("<3I")
    return _struct_3I
_struct_3d = None
def _get_struct_3d():
    global _struct_3d
    if _struct_3d is None:
        _struct_3d = struct.Struct("<3d")
    return _struct_3d
_struct_I2Q = None
def _get_struct_I2Q():
    global _struct_I2Q
    if _struct_I2Q is None:
        _struct_I2Q = struct.Struct("<I2Q")
    return _struct_I2Q
_struct_QI = None
def _get_struct_QI():
    global _struct_QI
    if _struct_QI is None:
        _struct_QI = struct.Struct("<QI")
    return _struct_QI
_struct_f = None
def _get_struct_f():
    global _struct_f
    if _struct_f is None:
        _struct_f = struct.Struct("<f")
    return _struct_f
