# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/Volume.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct


class Volume(genpy.Message):
  _md5sum = "fbcf9b994a602be0bba54ba9f58305bf"
  _type = "digitaleye_msgs/Volume"
  _has_header = False  # flag to mark the presence of a Header object
  _full_text = """# Volume definition

# Volume shape, use SHAPE_
uint32 shape

uint32 SHAPE_PRISM=1
uint32 SHAPE_SPHERE=2
uint32 SHAPE_CYLINDER=3

# Parameters of the volume
uint32[] int_param
float64[] float_param

# Prism: characterised by 2 bases of same nb of point (x,y,z), ordered the same way
# size of float param is nb points*PRISM_FLOAT_PARAM_SIZE*2
# (number of points * number of coordinates/float param per point  * 2 bases)
# Prism int parameters indexes
uint32 PRISM_INT_NB_POINTS=0
uint32 PRISM_INT_PARAM_SIZE=1 # constant (not index) - size of int_param
# Prism float parameters indexes
uint32 PRISM_FLOAT_X=0
uint32 PRISM_FLOAT_Y=1
uint32 PRISM_FLOAT_Z=2
uint32 PRISM_FLOAT_PARAM_SIZE=3  # constant (not index) - size of each point / nb of float params per point

# Sphere: characterised by radius and centre point (x,y,z)
# Sphere no int parameters
uint32 SPHERE_INT_PARAM_SIZE=0 # constant (not index) - size of int_param
# Sphere float parameters indexes
uint32 SPHERE_FLOAT_RADIUS=0
uint32 SPHERE_FLOAT_X=1
uint32 SPHERE_FLOAT_Y=2
uint32 SPHERE_FLOAT_Z=3
uint32 SPHERE_FLOAT_PARAM_SIZE=4 # constant (not index) - size of float_param

# Cylinder: characterised by 2 bases with each:
#   centre point (x,y,z), radius, termination: spherical/flat (use TERM_)
# Cylinder int parameters indexes
uint32 CYLINDER_INT_TERM1=0
uint32 CYLINDER_INT_TERM2=1
uint32 CYLINDER_INT_PARAM_SIZE=2 # constant (not index) - size of int_param

# Cylinder float parameters indexes
uint32 CYLINDER_FLOAT_X1=0
uint32 CYLINDER_FLOAT_Y1=1
uint32 CYLINDER_FLOAT_Z1=2
uint32 CYLINDER_FLOAT_RADIUS1=3
uint32 CYLINDER_FLOAT_X2=4
uint32 CYLINDER_FLOAT_Y2=5
uint32 CYLINDER_FLOAT_Z2=6
uint32 CYLINDER_FLOAT_RADIUS2=7
uint32 CYLINDER_FLOAT_PARAM_SIZE=8 # constant (not index) - size of float_param

# termination of volume, spherical or flat
uint32 TERM_SPHERE=0
uint32 TERM_FLAT=1
"""
  # Pseudo-constants
  SHAPE_PRISM = 1
  SHAPE_SPHERE = 2
  SHAPE_CYLINDER = 3
  PRISM_INT_NB_POINTS = 0
  PRISM_INT_PARAM_SIZE = 1
  PRISM_FLOAT_X = 0
  PRISM_FLOAT_Y = 1
  PRISM_FLOAT_Z = 2
  PRISM_FLOAT_PARAM_SIZE = 3
  SPHERE_INT_PARAM_SIZE = 0
  SPHERE_FLOAT_RADIUS = 0
  SPHERE_FLOAT_X = 1
  SPHERE_FLOAT_Y = 2
  SPHERE_FLOAT_Z = 3
  SPHERE_FLOAT_PARAM_SIZE = 4
  CYLINDER_INT_TERM1 = 0
  CYLINDER_INT_TERM2 = 1
  CYLINDER_INT_PARAM_SIZE = 2
  CYLINDER_FLOAT_X1 = 0
  CYLINDER_FLOAT_Y1 = 1
  CYLINDER_FLOAT_Z1 = 2
  CYLINDER_FLOAT_RADIUS1 = 3
  CYLINDER_FLOAT_X2 = 4
  CYLINDER_FLOAT_Y2 = 5
  CYLINDER_FLOAT_Z2 = 6
  CYLINDER_FLOAT_RADIUS2 = 7
  CYLINDER_FLOAT_PARAM_SIZE = 8
  TERM_SPHERE = 0
  TERM_FLAT = 1

  __slots__ = ['shape','int_param','float_param']
  _slot_types = ['uint32','uint32[]','float64[]']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       shape,int_param,float_param

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(Volume, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.shape is None:
        self.shape = 0
      if self.int_param is None:
        self.int_param = []
      if self.float_param is None:
        self.float_param = []
    else:
      self.shape = 0
      self.int_param = []
      self.float_param = []

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self.shape
      buff.write(_get_struct_I().pack(_x))
      length = len(self.int_param)
      buff.write(_struct_I.pack(length))
      pattern = '<%sI'%length
      buff.write(struct.Struct(pattern).pack(*self.int_param))
      length = len(self.float_param)
      buff.write(_struct_I.pack(length))
      pattern = '<%sd'%length
      buff.write(struct.Struct(pattern).pack(*self.float_param))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      end = 0
      start = end
      end += 4
      (self.shape,) = _get_struct_I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sI'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.int_param = s.unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sd'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.float_param = s.unpack(str[start:end])
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self.shape
      buff.write(_get_struct_I().pack(_x))
      length = len(self.int_param)
      buff.write(_struct_I.pack(length))
      pattern = '<%sI'%length
      buff.write(self.int_param.tostring())
      length = len(self.float_param)
      buff.write(_struct_I.pack(length))
      pattern = '<%sd'%length
      buff.write(self.float_param.tostring())
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      end = 0
      start = end
      end += 4
      (self.shape,) = _get_struct_I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sI'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.int_param = numpy.frombuffer(str[start:end], dtype=numpy.uint32, count=length)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sd'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.float_param = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=length)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
