# generated by datamodel-codegen:
#   filename:  acme_config.json
#   timestamp: 2022-07-22T10:25:55+00:00

from __future__ import annotations

from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, Extra, Field, constr


class MetaItem(BaseModel):
    uri: Optional[str] = None


class RegistrationItem(BaseModel):
    uri: Optional[str] = None


class Account(BaseModel):
    class Config:
        extra = Extra.forbid

    account_id: constr(regex=r"^\d+$")
    endpoint: str = Field(
        ..., description="ACME API endpoint the account is registered with"
    )
    created_on: Optional[str] = Field(None, description="created_dt from meta.json")
    dirname: constr(regex=r"^[a-zA-Z\d]+$") = Field(
        ..., description="The hash of the directory to store the files into"
    )
    privateKey: Optional[Union[Dict[str, Any], str]] = None
    meta: Optional[Union[MetaItem, str]] = None
    registration: Optional[Union[RegistrationItem, str]] = None

    def is_staging(self) -> bool:
        if "acme-staging" in self.endpoint:
            return True
        return False


class AcmeConfig(BaseModel):
    accounts: List[Account]
