import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ManagedDatabaseLogicalDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Default character set for the database (LC_CTYPE)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_logical_database#character_set ManagedDatabaseLogicalDatabase#character_set}
    */
    readonly characterSet?: string;
    /**
    * Default collation for the database (LC_COLLATE)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_logical_database#collation ManagedDatabaseLogicalDatabase#collation}
    */
    readonly collation?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_logical_database#id ManagedDatabaseLogicalDatabase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the logical database
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_logical_database#name ManagedDatabaseLogicalDatabase#name}
    */
    readonly name: string;
    /**
    * Service's UUID for which this user belongs to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_logical_database#service ManagedDatabaseLogicalDatabase#service}
    */
    readonly service: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_logical_database upcloud_managed_database_logical_database}
*/
export declare class ManagedDatabaseLogicalDatabase extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_managed_database_logical_database";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_logical_database upcloud_managed_database_logical_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManagedDatabaseLogicalDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: ManagedDatabaseLogicalDatabaseConfig);
    private _characterSet?;
    get characterSet(): string;
    set characterSet(value: string);
    resetCharacterSet(): void;
    get characterSetInput(): string | undefined;
    private _collation?;
    get collation(): string;
    set collation(value: string);
    resetCollation(): void;
    get collationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
