# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/41_tabular.data.ipynb (unless otherwise specified).

__all__ = ['TabularDataLoaders']

# Cell
from ..torch_basics import *
from ..data.all import *
from .core import *

# Cell
class TabularDataLoaders(DataLoaders):
    "Basic wrapper around several `DataLoader`s with factory methods for tabular data"
    @classmethod
    @delegates(Tabular.dataloaders, but=["dl_type", "dl_kwargs"])
    def from_df(cls, df, path='.', procs=None, cat_names=None, cont_names=None, y_names=None, y_block=None,
                valid_idx=None, **kwargs):
        "Create from `df` in `path` using `procs`"
        if cat_names is None: cat_names = []
        if cont_names is None: cont_names = list(set(df)-set(L(cat_names))-set(L(y_names)))
        splits = RandomSplitter()(df) if valid_idx is None else IndexSplitter(valid_idx)(df)
        to = TabularPandas(df, procs, cat_names, cont_names, y_names, splits=splits, y_block=y_block)
        return to.dataloaders(path=path, **kwargs)

    @classmethod
    def from_csv(cls, csv, skipinitialspace=True, **kwargs):
        "Create from `csv` file in `path` using `procs`"
        return cls.from_df(pd.read_csv(csv, skipinitialspace=skipinitialspace), **kwargs)

    @delegates(TabDataLoader.__init__)
    def test_dl(self, test_items, rm_type_tfms=None, process=True, inplace=False, **kwargs):
        to = self.train_ds.new(test_items, inplace=inplace)
        if process: to.process()
        return self.valid.new(to, **kwargs)

Tabular._dbunch_type = TabularDataLoaders
TabularDataLoaders.from_csv = delegates(to=TabularDataLoaders.from_df)(TabularDataLoaders.from_csv)