# mypy-boto3-dataexchange

[![PyPI - mypy-boto3-dataexchange](https://img.shields.io/pypi/v/mypy-boto3-dataexchange.svg?color=blue)](https://pypi.org/project/mypy-boto3-dataexchange)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-dataexchange.svg?color=blue)](https://pypi.org/project/mypy-boto3-dataexchange)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.DataExchange 1.14.22](https://boto3.amazonaws.com/v1/documentation/api/1.14.22/reference/services/dataexchange.html#DataExchange) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `DataExchange` service.

```bash
python -m pip install boto3-stubs[dataexchange]
```

## How to use

### Client annotations

`DataExchangeClient` provides annotations for `boto3.client("dataexchange")`.

```python
import boto3

from mypy_boto3_dataexchange import DataExchangeClient
from mypy_boto3_dataexchange.paginator import (
    ListDataSetRevisionsPaginator,
    ListDataSetsPaginator,
    ListJobsPaginator,
    ListRevisionAssetsPaginator,
)
from mypy_boto3_dataexchange.type_defs import AssetDestinationEntryTypeDef, ...

client: DataExchangeClient = boto3.client("dataexchange")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: DataExchangeClient = session.client("dataexchange")
```

### Paginators annotations

`mypy_boto3_dataexchange.paginator` module contains type annotations for all paginators.

```python

client: DataExchangeClient = boto3.client("dataexchange")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_data_set_revisions_paginator: ListDataSetRevisionsPaginator = client.get_paginator("list_data_set_revisions")
list_data_sets_paginator: ListDataSetsPaginator = client.get_paginator("list_data_sets")
list_jobs_paginator: ListJobsPaginator = client.get_paginator("list_jobs")
list_revision_assets_paginator: ListRevisionAssetsPaginator = client.get_paginator("list_revision_assets")
```







### Typed dictionations

`mypy_boto3_dataexchange.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> AssetDestinationEntryTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_dataexchange` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("dataexchange")

session_client = boto3.Session().client("dataexchange")
```
