# API Reference

**Classes**

Name|Description
----|-----------
[ArgoCdApplication](#opencdk8s-cdk8s-argocd-resources-argocdapplication)|*No description*
[ArgoCdProject](#opencdk8s-cdk8s-argocd-resources-argocdproject)|*No description*
[k8s.IntOrString](#opencdk8s-cdk8s-argocd-resources-k8s-intorstring)|*No description*
[k8s.KubeApiService](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservice)|APIService represents a server for a particular GroupVersion.
[k8s.KubeApiServiceList](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicelist)|APIServiceList is a list of APIService objects.
[k8s.KubeApiServiceListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicelistv1beta1)|APIServiceList is a list of APIService objects.
[k8s.KubeApiServiceV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicev1beta1)|APIService represents a server for a particular GroupVersion.
[k8s.KubeAuditSinkListV1Alpha1](#opencdk8s-cdk8s-argocd-resources-k8s-kubeauditsinklistv1alpha1)|AuditSinkList is a list of AuditSink items.
[k8s.KubeAuditSinkV1Alpha1](#opencdk8s-cdk8s-argocd-resources-k8s-kubeauditsinkv1alpha1)|AuditSink represents a cluster level audit sink.
[k8s.KubeBinding](#opencdk8s-cdk8s-argocd-resources-k8s-kubebinding)|Binding ties one object to another;
[k8s.KubeCertificateSigningRequestListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubecertificatesigningrequestlistv1beta1)|*No description*
[k8s.KubeCertificateSigningRequestV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubecertificatesigningrequestv1beta1)|Describes a certificate signing request.
[k8s.KubeClusterRole](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrole)|ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.
[k8s.KubeClusterRoleBinding](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebinding)|ClusterRoleBinding references a ClusterRole, but not contain it.
[k8s.KubeClusterRoleBindingList](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindinglist)|ClusterRoleBindingList is a collection of ClusterRoleBindings.
[k8s.KubeClusterRoleBindingListV1Alpha1](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindinglistv1alpha1)|ClusterRoleBindingList is a collection of ClusterRoleBindings.
[k8s.KubeClusterRoleBindingListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindinglistv1beta1)|ClusterRoleBindingList is a collection of ClusterRoleBindings.
[k8s.KubeClusterRoleBindingV1Alpha1](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingv1alpha1)|ClusterRoleBinding references a ClusterRole, but not contain it.
[k8s.KubeClusterRoleBindingV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingv1beta1)|ClusterRoleBinding references a ClusterRole, but not contain it.
[k8s.KubeClusterRoleList](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolelist)|ClusterRoleList is a collection of ClusterRoles.
[k8s.KubeClusterRoleListV1Alpha1](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolelistv1alpha1)|ClusterRoleList is a collection of ClusterRoles.
[k8s.KubeClusterRoleListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolelistv1beta1)|ClusterRoleList is a collection of ClusterRoles.
[k8s.KubeClusterRoleV1Alpha1](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolev1alpha1)|ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.
[k8s.KubeClusterRoleV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolev1beta1)|ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.
[k8s.KubeComponentStatus](#opencdk8s-cdk8s-argocd-resources-k8s-kubecomponentstatus)|ComponentStatus (and ComponentStatusList) holds the cluster validation info.
[k8s.KubeComponentStatusList](#opencdk8s-cdk8s-argocd-resources-k8s-kubecomponentstatuslist)|Status of all the conditions for the component as a list of ComponentStatus objects.
[k8s.KubeConfigMap](#opencdk8s-cdk8s-argocd-resources-k8s-kubeconfigmap)|ConfigMap holds configuration data for pods to consume.
[k8s.KubeConfigMapList](#opencdk8s-cdk8s-argocd-resources-k8s-kubeconfigmaplist)|ConfigMapList is a resource containing a list of ConfigMap objects.
[k8s.KubeControllerRevision](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevision)|ControllerRevision implements an immutable snapshot of state data.
[k8s.KubeControllerRevisionList](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionlist)|ControllerRevisionList is a resource containing a list of ControllerRevision objects.
[k8s.KubeControllerRevisionListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionlistv1beta1)|ControllerRevisionList is a resource containing a list of ControllerRevision objects.
[k8s.KubeControllerRevisionListV1Beta2](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionlistv1beta2)|ControllerRevisionList is a resource containing a list of ControllerRevision objects.
[k8s.KubeControllerRevisionV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionv1beta1)|DEPRECATED - This group version of ControllerRevision is deprecated by apps/v1beta2/ControllerRevision.
[k8s.KubeControllerRevisionV1Beta2](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionv1beta2)|DEPRECATED - This group version of ControllerRevision is deprecated by apps/v1/ControllerRevision.
[k8s.KubeCronJobListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjoblistv1beta1)|CronJobList is a collection of cron jobs.
[k8s.KubeCronJobListV2Alpha1](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjoblistv2alpha1)|CronJobList is a collection of cron jobs.
[k8s.KubeCronJobV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjobv1beta1)|CronJob represents the configuration of a single cron job.
[k8s.KubeCronJobV2Alpha1](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjobv2alpha1)|CronJob represents the configuration of a single cron job.
[k8s.KubeCsiDriverListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsidriverlistv1beta1)|CSIDriverList is a collection of CSIDriver objects.
[k8s.KubeCsiDriverV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsidriverv1beta1)|CSIDriver captures information about a Container Storage Interface (CSI) volume driver deployed on the cluster.
[k8s.KubeCsiNodeListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsinodelistv1beta1)|CSINodeList is a collection of CSINode objects.
[k8s.KubeCsiNodeV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsinodev1beta1)|CSINode holds information about all CSI drivers installed on a node.
[k8s.KubeCustomResourceDefinitionListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubecustomresourcedefinitionlistv1beta1)|CustomResourceDefinitionList is a list of CustomResourceDefinition objects.
[k8s.KubeCustomResourceDefinitionV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubecustomresourcedefinitionv1beta1)|CustomResourceDefinition represents a resource that should be exposed on the API server.
[k8s.KubeDaemonSet](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonset)|DaemonSet represents the configuration of a daemon set.
[k8s.KubeDaemonSetList](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetlist)|DaemonSetList is a collection of daemon sets.
[k8s.KubeDaemonSetListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetlistv1beta1)|DaemonSetList is a collection of daemon sets.
[k8s.KubeDaemonSetListV1Beta2](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetlistv1beta2)|DaemonSetList is a collection of daemon sets.
[k8s.KubeDaemonSetV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetv1beta1)|DEPRECATED - This group version of DaemonSet is deprecated by apps/v1beta2/DaemonSet.
[k8s.KubeDaemonSetV1Beta2](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetv1beta2)|DEPRECATED - This group version of DaemonSet is deprecated by apps/v1/DaemonSet.
[k8s.KubeDeployment](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeployment)|Deployment enables declarative updates for Pods and ReplicaSets.
[k8s.KubeDeploymentList](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentlist)|DeploymentList is a list of Deployments.
[k8s.KubeDeploymentListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentlistv1beta1)|DeploymentList is a list of Deployments.
[k8s.KubeDeploymentListV1Beta2](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentlistv1beta2)|DeploymentList is a list of Deployments.
[k8s.KubeDeploymentV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentv1beta1)|DEPRECATED - This group version of Deployment is deprecated by apps/v1beta2/Deployment.
[k8s.KubeDeploymentV1Beta2](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentv1beta2)|DEPRECATED - This group version of Deployment is deprecated by apps/v1/Deployment.
[k8s.KubeEndpoints](#opencdk8s-cdk8s-argocd-resources-k8s-kubeendpoints)|Endpoints is a collection of endpoints that implement the actual service.
[k8s.KubeEndpointsList](#opencdk8s-cdk8s-argocd-resources-k8s-kubeendpointslist)|EndpointsList is a list of endpoints.
[k8s.KubeEvent](#opencdk8s-cdk8s-argocd-resources-k8s-kubeevent)|Event is a report of an event somewhere in the cluster.
[k8s.KubeEventList](#opencdk8s-cdk8s-argocd-resources-k8s-kubeeventlist)|EventList is a list of events.
[k8s.KubeEventListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubeeventlistv1beta1)|EventList is a list of Event objects.
[k8s.KubeEventV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubeeventv1beta1)|Event is a report of an event somewhere in the cluster.
[k8s.KubeEvictionV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubeevictionv1beta1)|Eviction evicts a pod from its node subject to certain policies and safety constraints.
[k8s.KubeHorizontalPodAutoscaler](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscaler)|configuration of a horizontal pod autoscaler.
[k8s.KubeHorizontalPodAutoscalerList](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerlist)|list of horizontal pod autoscaler objects.
[k8s.KubeHorizontalPodAutoscalerListV2Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerlistv2beta1)|HorizontalPodAutoscaler is a list of horizontal pod autoscaler objects.
[k8s.KubeHorizontalPodAutoscalerListV2Beta2](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerlistv2beta2)|HorizontalPodAutoscalerList is a list of horizontal pod autoscaler objects.
[k8s.KubeHorizontalPodAutoscalerV2Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerv2beta1)|HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.
[k8s.KubeHorizontalPodAutoscalerV2Beta2](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerv2beta2)|HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.
[k8s.KubeIngressListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubeingresslistv1beta1)|IngressList is a collection of Ingress.
[k8s.KubeIngressV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubeingressv1beta1)|Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend.
[k8s.KubeJob](#opencdk8s-cdk8s-argocd-resources-k8s-kubejob)|Job represents the configuration of a single job.
[k8s.KubeJobList](#opencdk8s-cdk8s-argocd-resources-k8s-kubejoblist)|JobList is a collection of jobs.
[k8s.KubeLease](#opencdk8s-cdk8s-argocd-resources-k8s-kubelease)|Lease defines a lease concept.
[k8s.KubeLeaseList](#opencdk8s-cdk8s-argocd-resources-k8s-kubeleaselist)|LeaseList is a list of Lease objects.
[k8s.KubeLeaseListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubeleaselistv1beta1)|LeaseList is a list of Lease objects.
[k8s.KubeLeaseV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubeleasev1beta1)|Lease defines a lease concept.
[k8s.KubeLimitRange](#opencdk8s-cdk8s-argocd-resources-k8s-kubelimitrange)|LimitRange sets resource usage limits for each kind of resource in a Namespace.
[k8s.KubeLimitRangeList](#opencdk8s-cdk8s-argocd-resources-k8s-kubelimitrangelist)|LimitRangeList is a list of LimitRange items.
[k8s.KubeLocalSubjectAccessReview](#opencdk8s-cdk8s-argocd-resources-k8s-kubelocalsubjectaccessreview)|LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace.
[k8s.KubeLocalSubjectAccessReviewV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubelocalsubjectaccessreviewv1beta1)|LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace.
[k8s.KubeMutatingWebhookConfigurationListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubemutatingwebhookconfigurationlistv1beta1)|MutatingWebhookConfigurationList is a list of MutatingWebhookConfiguration.
[k8s.KubeMutatingWebhookConfigurationV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubemutatingwebhookconfigurationv1beta1)|MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object.
[k8s.KubeNamespace](#opencdk8s-cdk8s-argocd-resources-k8s-kubenamespace)|Namespace provides a scope for Names.
[k8s.KubeNamespaceList](#opencdk8s-cdk8s-argocd-resources-k8s-kubenamespacelist)|NamespaceList is a list of Namespaces.
[k8s.KubeNetworkPolicy](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicy)|NetworkPolicy describes what network traffic is allowed for a set of Pods.
[k8s.KubeNetworkPolicyList](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicylist)|NetworkPolicyList is a list of NetworkPolicy objects.
[k8s.KubeNetworkPolicyListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicylistv1beta1)|DEPRECATED 1.9 - This group version of NetworkPolicyList is deprecated by networking/v1/NetworkPolicyList. Network Policy List is a list of NetworkPolicy objects.
[k8s.KubeNetworkPolicyV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicyv1beta1)|DEPRECATED 1.9 - This group version of NetworkPolicy is deprecated by networking/v1/NetworkPolicy. NetworkPolicy describes what network traffic is allowed for a set of Pods.
[k8s.KubeNode](#opencdk8s-cdk8s-argocd-resources-k8s-kubenode)|Node is a worker node in Kubernetes.
[k8s.KubeNodeList](#opencdk8s-cdk8s-argocd-resources-k8s-kubenodelist)|NodeList is the whole list of all Nodes which have been registered with master.
[k8s.KubePersistentVolume](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolume)|PersistentVolume (PV) is a storage resource provisioned by an administrator.
[k8s.KubePersistentVolumeClaim](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeclaim)|PersistentVolumeClaim is a user's request for and claim to a persistent volume.
[k8s.KubePersistentVolumeClaimList](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeclaimlist)|PersistentVolumeClaimList is a list of PersistentVolumeClaim items.
[k8s.KubePersistentVolumeList](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumelist)|PersistentVolumeList is a list of PersistentVolume items.
[k8s.KubePod](#opencdk8s-cdk8s-argocd-resources-k8s-kubepod)|Pod is a collection of containers that can run on a host.
[k8s.KubePodDisruptionBudgetListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubepoddisruptionbudgetlistv1beta1)|PodDisruptionBudgetList is a collection of PodDisruptionBudgets.
[k8s.KubePodDisruptionBudgetV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubepoddisruptionbudgetv1beta1)|PodDisruptionBudget is an object to define the max disruption that can be caused to a collection of pods.
[k8s.KubePodList](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodlist)|PodList is a list of Pods.
[k8s.KubePodPresetListV1Alpha1](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodpresetlistv1alpha1)|PodPresetList is a list of PodPreset objects.
[k8s.KubePodPresetV1Alpha1](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodpresetv1alpha1)|PodPreset is a policy resource that defines additional runtime requirements for a Pod.
[k8s.KubePodSecurityPolicyListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodsecuritypolicylistv1beta1)|PodSecurityPolicyList is a list of PodSecurityPolicy objects.
[k8s.KubePodSecurityPolicyV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodsecuritypolicyv1beta1)|PodSecurityPolicy governs the ability to make requests that affect the Security Context that will be applied to a pod and container.
[k8s.KubePodTemplate](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodtemplate)|PodTemplate describes a template for creating copies of a predefined pod.
[k8s.KubePodTemplateList](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodtemplatelist)|PodTemplateList is a list of PodTemplates.
[k8s.KubePriorityClass](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclass)|PriorityClass defines mapping from a priority class name to the priority integer value.
[k8s.KubePriorityClassList](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclasslist)|PriorityClassList is a collection of priority classes.
[k8s.KubePriorityClassListV1Alpha1](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclasslistv1alpha1)|PriorityClassList is a collection of priority classes.
[k8s.KubePriorityClassListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclasslistv1beta1)|PriorityClassList is a collection of priority classes.
[k8s.KubePriorityClassV1Alpha1](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassv1alpha1)|DEPRECATED - This group version of PriorityClass is deprecated by scheduling.k8s.io/v1/PriorityClass. PriorityClass defines mapping from a priority class name to the priority integer value. The value can be any valid integer.
[k8s.KubePriorityClassV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassv1beta1)|DEPRECATED - This group version of PriorityClass is deprecated by scheduling.k8s.io/v1/PriorityClass. PriorityClass defines mapping from a priority class name to the priority integer value. The value can be any valid integer.
[k8s.KubeReplicaSet](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicaset)|ReplicaSet ensures that a specified number of pod replicas are running at any given time.
[k8s.KubeReplicaSetList](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetlist)|ReplicaSetList is a collection of ReplicaSets.
[k8s.KubeReplicaSetListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetlistv1beta1)|ReplicaSetList is a collection of ReplicaSets.
[k8s.KubeReplicaSetListV1Beta2](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetlistv1beta2)|ReplicaSetList is a collection of ReplicaSets.
[k8s.KubeReplicaSetV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetv1beta1)|DEPRECATED - This group version of ReplicaSet is deprecated by apps/v1beta2/ReplicaSet.
[k8s.KubeReplicaSetV1Beta2](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetv1beta2)|DEPRECATED - This group version of ReplicaSet is deprecated by apps/v1/ReplicaSet.
[k8s.KubeReplicationController](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicationcontroller)|ReplicationController represents the configuration of a replication controller.
[k8s.KubeReplicationControllerList](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicationcontrollerlist)|ReplicationControllerList is a collection of replication controllers.
[k8s.KubeResourceQuota](#opencdk8s-cdk8s-argocd-resources-k8s-kuberesourcequota)|ResourceQuota sets aggregate quota restrictions enforced per namespace.
[k8s.KubeResourceQuotaList](#opencdk8s-cdk8s-argocd-resources-k8s-kuberesourcequotalist)|ResourceQuotaList is a list of ResourceQuota items.
[k8s.KubeRole](#opencdk8s-cdk8s-argocd-resources-k8s-kuberole)|Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.
[k8s.KubeRoleBinding](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebinding)|RoleBinding references a role, but does not contain it.
[k8s.KubeRoleBindingList](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindinglist)|RoleBindingList is a collection of RoleBindings.
[k8s.KubeRoleBindingListV1Alpha1](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindinglistv1alpha1)|RoleBindingList is a collection of RoleBindings.
[k8s.KubeRoleBindingListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindinglistv1beta1)|RoleBindingList is a collection of RoleBindings.
[k8s.KubeRoleBindingV1Alpha1](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingv1alpha1)|RoleBinding references a role, but does not contain it.
[k8s.KubeRoleBindingV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingv1beta1)|RoleBinding references a role, but does not contain it.
[k8s.KubeRoleList](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolelist)|RoleList is a collection of Roles.
[k8s.KubeRoleListV1Alpha1](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolelistv1alpha1)|RoleList is a collection of Roles.
[k8s.KubeRoleListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolelistv1beta1)|RoleList is a collection of Roles.
[k8s.KubeRoleV1Alpha1](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolev1alpha1)|Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.
[k8s.KubeRoleV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolev1beta1)|Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.
[k8s.KubeRuntimeClassListV1Alpha1](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclasslistv1alpha1)|RuntimeClassList is a list of RuntimeClass objects.
[k8s.KubeRuntimeClassListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclasslistv1beta1)|RuntimeClassList is a list of RuntimeClass objects.
[k8s.KubeRuntimeClassV1Alpha1](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclassv1alpha1)|RuntimeClass defines a class of container runtime supported in the cluster.
[k8s.KubeRuntimeClassV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclassv1beta1)|RuntimeClass defines a class of container runtime supported in the cluster.
[k8s.KubeScale](#opencdk8s-cdk8s-argocd-resources-k8s-kubescale)|Scale represents a scaling request for a resource.
[k8s.KubeScaleV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubescalev1beta1)|represents a scaling request for a resource.
[k8s.KubeScaleV1Beta2](#opencdk8s-cdk8s-argocd-resources-k8s-kubescalev1beta2)|Scale represents a scaling request for a resource.
[k8s.KubeSecret](#opencdk8s-cdk8s-argocd-resources-k8s-kubesecret)|Secret holds secret data of a certain type.
[k8s.KubeSecretList](#opencdk8s-cdk8s-argocd-resources-k8s-kubesecretlist)|SecretList is a list of Secret.
[k8s.KubeSelfSubjectAccessReview](#opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectaccessreview)|SelfSubjectAccessReview checks whether or the current user can perform an action.
[k8s.KubeSelfSubjectAccessReviewV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectaccessreviewv1beta1)|SelfSubjectAccessReview checks whether or the current user can perform an action.
[k8s.KubeSelfSubjectRulesReview](#opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectrulesreview)|SelfSubjectRulesReview enumerates the set of actions the current user can perform within a namespace.
[k8s.KubeSelfSubjectRulesReviewV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectrulesreviewv1beta1)|SelfSubjectRulesReview enumerates the set of actions the current user can perform within a namespace.
[k8s.KubeService](#opencdk8s-cdk8s-argocd-resources-k8s-kubeservice)|Service is a named abstraction of software service (for example, mysql) consisting of local port (for example 3306) that the proxy listens on, and the selector that determines which pods will answer requests sent through the proxy.
[k8s.KubeServiceAccount](#opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceaccount)|ServiceAccount binds together: * a name, understood by users, and perhaps by peripheral systems, for an identity * a principal that can be authenticated and authorized * a set of secrets.
[k8s.KubeServiceAccountList](#opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceaccountlist)|ServiceAccountList is a list of ServiceAccount objects.
[k8s.KubeServiceList](#opencdk8s-cdk8s-argocd-resources-k8s-kubeservicelist)|ServiceList holds a list of services.
[k8s.KubeStatefulSet](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulset)|StatefulSet represents a set of pods with consistent identities.
[k8s.KubeStatefulSetList](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetlist)|StatefulSetList is a collection of StatefulSets.
[k8s.KubeStatefulSetListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetlistv1beta1)|StatefulSetList is a collection of StatefulSets.
[k8s.KubeStatefulSetListV1Beta2](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetlistv1beta2)|StatefulSetList is a collection of StatefulSets.
[k8s.KubeStatefulSetV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetv1beta1)|DEPRECATED - This group version of StatefulSet is deprecated by apps/v1beta2/StatefulSet.
[k8s.KubeStatefulSetV1Beta2](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetv1beta2)|DEPRECATED - This group version of StatefulSet is deprecated by apps/v1/StatefulSet.
[k8s.KubeStatus](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatus)|Status is a return value for calls that don't return other objects.
[k8s.KubeStorageClass](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclass)|StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.
[k8s.KubeStorageClassList](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclasslist)|StorageClassList is a collection of storage classes.
[k8s.KubeStorageClassListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclasslistv1beta1)|StorageClassList is a collection of storage classes.
[k8s.KubeStorageClassV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclassv1beta1)|StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.
[k8s.KubeSubjectAccessReview](#opencdk8s-cdk8s-argocd-resources-k8s-kubesubjectaccessreview)|SubjectAccessReview checks whether or not a user or group can perform an action.
[k8s.KubeSubjectAccessReviewV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubesubjectaccessreviewv1beta1)|SubjectAccessReview checks whether or not a user or group can perform an action.
[k8s.KubeTokenReview](#opencdk8s-cdk8s-argocd-resources-k8s-kubetokenreview)|TokenReview attempts to authenticate a token to a known user.
[k8s.KubeTokenReviewV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubetokenreviewv1beta1)|TokenReview attempts to authenticate a token to a known user.
[k8s.KubeValidatingWebhookConfigurationListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubevalidatingwebhookconfigurationlistv1beta1)|ValidatingWebhookConfigurationList is a list of ValidatingWebhookConfiguration.
[k8s.KubeValidatingWebhookConfigurationV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubevalidatingwebhookconfigurationv1beta1)|ValidatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and object without changing it.
[k8s.KubeVolumeAttachment](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachment)|VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.
[k8s.KubeVolumeAttachmentList](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentlist)|VolumeAttachmentList is a collection of VolumeAttachment objects.
[k8s.KubeVolumeAttachmentListV1Alpha1](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentlistv1alpha1)|VolumeAttachmentList is a collection of VolumeAttachment objects.
[k8s.KubeVolumeAttachmentListV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentlistv1beta1)|VolumeAttachmentList is a collection of VolumeAttachment objects.
[k8s.KubeVolumeAttachmentV1Alpha1](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentv1alpha1)|VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.
[k8s.KubeVolumeAttachmentV1Beta1](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentv1beta1)|VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.
[k8s.Quantity](#opencdk8s-cdk8s-argocd-resources-k8s-quantity)|*No description*


**Structs**

Name|Description
----|-----------
[ApplicationDestination](#opencdk8s-cdk8s-argocd-resources-applicationdestination)|*No description*
[ApplicationDirectory](#opencdk8s-cdk8s-argocd-resources-applicationdirectory)|*No description*
[ApplicationPlugin](#opencdk8s-cdk8s-argocd-resources-applicationplugin)|*No description*
[ApplicationSource](#opencdk8s-cdk8s-argocd-resources-applicationsource)|*No description*
[ApplicationSyncPolicy](#opencdk8s-cdk8s-argocd-resources-applicationsyncpolicy)|*No description*
[ArgoCdApplicationProps](#opencdk8s-cdk8s-argocd-resources-argocdapplicationprops)|*No description*
[ArgoCdApplicationSpec](#opencdk8s-cdk8s-argocd-resources-argocdapplicationspec)|*No description*
[ArgoCdProjectProps](#opencdk8s-cdk8s-argocd-resources-argocdprojectprops)|*No description*
[ArgoCdProjectSpec](#opencdk8s-cdk8s-argocd-resources-argocdprojectspec)|*No description*
[ProjectRoles](#opencdk8s-cdk8s-argocd-resources-projectroles)|*No description*
[ResourceRef](#opencdk8s-cdk8s-argocd-resources-resourceref)|*No description*
[RetryBackoff](#opencdk8s-cdk8s-argocd-resources-retrybackoff)|*No description*
[SyncPolicyAutomated](#opencdk8s-cdk8s-argocd-resources-syncpolicyautomated)|*No description*
[SyncRetry](#opencdk8s-cdk8s-argocd-resources-syncretry)|*No description*
[k8s.Affinity](#opencdk8s-cdk8s-argocd-resources-k8s-affinity)|Affinity is a group of affinity scheduling rules.
[k8s.AggregationRule](#opencdk8s-cdk8s-argocd-resources-k8s-aggregationrule)|AggregationRule describes how to locate ClusterRoles to aggregate into the ClusterRole.
[k8s.AllowedCsiDriver](#opencdk8s-cdk8s-argocd-resources-k8s-allowedcsidriver)|AllowedCSIDriver represents a single inline CSI Driver that is allowed to be used.
[k8s.AllowedFlexVolume](#opencdk8s-cdk8s-argocd-resources-k8s-allowedflexvolume)|AllowedFlexVolume represents a single Flexvolume that is allowed to be used.
[k8s.AllowedHostPath](#opencdk8s-cdk8s-argocd-resources-k8s-allowedhostpath)|AllowedHostPath defines the host volume conditions that will be enabled by a policy for pods to use.
[k8s.ApiServiceSpec](#opencdk8s-cdk8s-argocd-resources-k8s-apiservicespec)|APIServiceSpec contains information for locating and communicating with a server.
[k8s.AuditSinkSpec](#opencdk8s-cdk8s-argocd-resources-k8s-auditsinkspec)|AuditSinkSpec holds the spec for the audit sink.
[k8s.AwsElasticBlockStoreVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-awselasticblockstorevolumesource)|Represents a Persistent Disk resource in AWS.
[k8s.AzureDiskVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-azurediskvolumesource)|AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
[k8s.AzureFilePersistentVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-azurefilepersistentvolumesource)|AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
[k8s.AzureFileVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-azurefilevolumesource)|AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
[k8s.Capabilities](#opencdk8s-cdk8s-argocd-resources-k8s-capabilities)|Adds and removes POSIX capabilities from running containers.
[k8s.CephFsPersistentVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-cephfspersistentvolumesource)|Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.
[k8s.CephFsVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-cephfsvolumesource)|Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.
[k8s.CertificateSigningRequestSpec](#opencdk8s-cdk8s-argocd-resources-k8s-certificatesigningrequestspec)|This information is immutable after the request is created.
[k8s.CinderPersistentVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-cinderpersistentvolumesource)|Represents a cinder volume resource in Openstack.
[k8s.CinderVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-cindervolumesource)|Represents a cinder volume resource in Openstack.
[k8s.ClientIpConfig](#opencdk8s-cdk8s-argocd-resources-k8s-clientipconfig)|ClientIPConfig represents the configurations of Client IP based session affinity.
[k8s.ComponentCondition](#opencdk8s-cdk8s-argocd-resources-k8s-componentcondition)|Information about the condition of a component.
[k8s.ConfigMapEnvSource](#opencdk8s-cdk8s-argocd-resources-k8s-configmapenvsource)|ConfigMapEnvSource selects a ConfigMap to populate the environment variables with.
[k8s.ConfigMapKeySelector](#opencdk8s-cdk8s-argocd-resources-k8s-configmapkeyselector)|Selects a key from a ConfigMap.
[k8s.ConfigMapNodeConfigSource](#opencdk8s-cdk8s-argocd-resources-k8s-configmapnodeconfigsource)|ConfigMapNodeConfigSource contains the information to reference a ConfigMap as a config source for the Node.
[k8s.ConfigMapProjection](#opencdk8s-cdk8s-argocd-resources-k8s-configmapprojection)|Adapts a ConfigMap into a projected volume.
[k8s.ConfigMapVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-configmapvolumesource)|Adapts a ConfigMap into a volume.
[k8s.Container](#opencdk8s-cdk8s-argocd-resources-k8s-container)|A single application container that you want to run within a pod.
[k8s.ContainerPort](#opencdk8s-cdk8s-argocd-resources-k8s-containerport)|ContainerPort represents a network port in a single container.
[k8s.CronJobSpec](#opencdk8s-cdk8s-argocd-resources-k8s-cronjobspec)|CronJobSpec describes how the job execution will look like and when it will actually run.
[k8s.CrossVersionObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-crossversionobjectreference)|CrossVersionObjectReference contains enough information to let you identify the referred resource.
[k8s.CsiDriverSpec](#opencdk8s-cdk8s-argocd-resources-k8s-csidriverspec)|CSIDriverSpec is the specification of a CSIDriver.
[k8s.CsiNodeDriver](#opencdk8s-cdk8s-argocd-resources-k8s-csinodedriver)|CSINodeDriver holds information about the specification of one CSI driver installed on a node.
[k8s.CsiNodeSpec](#opencdk8s-cdk8s-argocd-resources-k8s-csinodespec)|CSINodeSpec holds information about the specification of all CSI drivers installed on a node.
[k8s.CsiPersistentVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-csipersistentvolumesource)|Represents storage that is managed by an external CSI volume driver (Beta feature).
[k8s.CsiVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-csivolumesource)|Represents a source location of a volume to mount, managed by an external CSI driver.
[k8s.CustomResourceColumnDefinition](#opencdk8s-cdk8s-argocd-resources-k8s-customresourcecolumndefinition)|CustomResourceColumnDefinition specifies a column for server side printing.
[k8s.CustomResourceConversion](#opencdk8s-cdk8s-argocd-resources-k8s-customresourceconversion)|CustomResourceConversion describes how to convert different versions of a CR.
[k8s.CustomResourceDefinitionNames](#opencdk8s-cdk8s-argocd-resources-k8s-customresourcedefinitionnames)|CustomResourceDefinitionNames indicates the names to serve this CustomResourceDefinition.
[k8s.CustomResourceDefinitionSpec](#opencdk8s-cdk8s-argocd-resources-k8s-customresourcedefinitionspec)|CustomResourceDefinitionSpec describes how a user wants their resource to appear.
[k8s.CustomResourceDefinitionVersion](#opencdk8s-cdk8s-argocd-resources-k8s-customresourcedefinitionversion)|CustomResourceDefinitionVersion describes a version for CRD.
[k8s.CustomResourceSubresourceScale](#opencdk8s-cdk8s-argocd-resources-k8s-customresourcesubresourcescale)|CustomResourceSubresourceScale defines how to serve the scale subresource for CustomResources.
[k8s.CustomResourceSubresources](#opencdk8s-cdk8s-argocd-resources-k8s-customresourcesubresources)|CustomResourceSubresources defines the status and scale subresources for CustomResources.
[k8s.CustomResourceValidation](#opencdk8s-cdk8s-argocd-resources-k8s-customresourcevalidation)|CustomResourceValidation is a list of validation methods for CustomResources.
[k8s.DaemonSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-daemonsetspec)|DaemonSetSpec is the specification of a daemon set.
[k8s.DaemonSetUpdateStrategy](#opencdk8s-cdk8s-argocd-resources-k8s-daemonsetupdatestrategy)|*No description*
[k8s.DeleteOptions](#opencdk8s-cdk8s-argocd-resources-k8s-deleteoptions)|DeleteOptions may be provided when deleting an API object.
[k8s.DeploymentSpec](#opencdk8s-cdk8s-argocd-resources-k8s-deploymentspec)|DeploymentSpec is the specification of the desired behavior of the Deployment.
[k8s.DeploymentStrategy](#opencdk8s-cdk8s-argocd-resources-k8s-deploymentstrategy)|DeploymentStrategy describes how to replace existing pods with new ones.
[k8s.DownwardApiProjection](#opencdk8s-cdk8s-argocd-resources-k8s-downwardapiprojection)|Represents downward API info for projecting into a projected volume.
[k8s.DownwardApiVolumeFile](#opencdk8s-cdk8s-argocd-resources-k8s-downwardapivolumefile)|DownwardAPIVolumeFile represents information to create the file containing the pod field.
[k8s.DownwardApiVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-downwardapivolumesource)|DownwardAPIVolumeSource represents a volume containing downward API info.
[k8s.EmptyDirVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-emptydirvolumesource)|Represents an empty directory for a pod.
[k8s.EndpointAddress](#opencdk8s-cdk8s-argocd-resources-k8s-endpointaddress)|EndpointAddress is a tuple that describes single IP address.
[k8s.EndpointPort](#opencdk8s-cdk8s-argocd-resources-k8s-endpointport)|EndpointPort is a tuple that describes a single port.
[k8s.EndpointSubset](#opencdk8s-cdk8s-argocd-resources-k8s-endpointsubset)|EndpointSubset is a group of addresses with a common set of ports.
[k8s.EnvFromSource](#opencdk8s-cdk8s-argocd-resources-k8s-envfromsource)|EnvFromSource represents the source of a set of ConfigMaps.
[k8s.EnvVar](#opencdk8s-cdk8s-argocd-resources-k8s-envvar)|EnvVar represents an environment variable present in a Container.
[k8s.EnvVarSource](#opencdk8s-cdk8s-argocd-resources-k8s-envvarsource)|EnvVarSource represents a source for the value of an EnvVar.
[k8s.EventSeries](#opencdk8s-cdk8s-argocd-resources-k8s-eventseries)|EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time.
[k8s.EventSource](#opencdk8s-cdk8s-argocd-resources-k8s-eventsource)|EventSource contains information for an event.
[k8s.ExecAction](#opencdk8s-cdk8s-argocd-resources-k8s-execaction)|ExecAction describes a "run in container" action.
[k8s.ExternalDocumentation](#opencdk8s-cdk8s-argocd-resources-k8s-externaldocumentation)|ExternalDocumentation allows referencing an external resource for extended documentation.
[k8s.ExternalMetricSource](#opencdk8s-cdk8s-argocd-resources-k8s-externalmetricsource)|ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
[k8s.FcVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-fcvolumesource)|Represents a Fibre Channel volume.
[k8s.FlexPersistentVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-flexpersistentvolumesource)|FlexPersistentVolumeSource represents a generic persistent volume resource that is provisioned/attached using an exec based plugin.
[k8s.FlexVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-flexvolumesource)|FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.
[k8s.FlockerVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-flockervolumesource)|Represents a Flocker volume mounted by the Flocker agent.
[k8s.FsGroupStrategyOptions](#opencdk8s-cdk8s-argocd-resources-k8s-fsgroupstrategyoptions)|FSGroupStrategyOptions defines the strategy type and options used to create the strategy.
[k8s.GcePersistentDiskVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-gcepersistentdiskvolumesource)|Represents a Persistent Disk resource in Google Compute Engine.
[k8s.GitRepoVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-gitrepovolumesource)|Represents a volume that is populated with the contents of a git repository.
[k8s.GlusterfsPersistentVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-glusterfspersistentvolumesource)|Represents a Glusterfs mount that lasts the lifetime of a pod.
[k8s.GlusterfsVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-glusterfsvolumesource)|Represents a Glusterfs mount that lasts the lifetime of a pod.
[k8s.Handler](#opencdk8s-cdk8s-argocd-resources-k8s-handler)|Handler defines a specific action that should be taken.
[k8s.HorizontalPodAutoscalerSpec](#opencdk8s-cdk8s-argocd-resources-k8s-horizontalpodautoscalerspec)|HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.
[k8s.HostAlias](#opencdk8s-cdk8s-argocd-resources-k8s-hostalias)|HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
[k8s.HostPathVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-hostpathvolumesource)|Represents a host path mapped into a pod.
[k8s.HostPortRange](#opencdk8s-cdk8s-argocd-resources-k8s-hostportrange)|HostPortRange defines a range of host ports that will be enabled by a policy for pods to use.
[k8s.HttpGetAction](#opencdk8s-cdk8s-argocd-resources-k8s-httpgetaction)|HTTPGetAction describes an action based on HTTP Get requests.
[k8s.HttpHeader](#opencdk8s-cdk8s-argocd-resources-k8s-httpheader)|HTTPHeader describes a custom header to be used in HTTP probes.
[k8s.HttpIngressPath](#opencdk8s-cdk8s-argocd-resources-k8s-httpingresspath)|HTTPIngressPath associates a path regex with a backend.
[k8s.HttpIngressRuleValue](#opencdk8s-cdk8s-argocd-resources-k8s-httpingressrulevalue)|HTTPIngressRuleValue is a list of http selectors pointing to backends.
[k8s.IdRange](#opencdk8s-cdk8s-argocd-resources-k8s-idrange)|IDRange provides a min/max of an allowed range of IDs.
[k8s.IngressBackend](#opencdk8s-cdk8s-argocd-resources-k8s-ingressbackend)|IngressBackend describes all endpoints for a given service and port.
[k8s.IngressRule](#opencdk8s-cdk8s-argocd-resources-k8s-ingressrule)|IngressRule represents the rules mapping the paths under a specified host to the related backend services.
[k8s.IngressSpec](#opencdk8s-cdk8s-argocd-resources-k8s-ingressspec)|IngressSpec describes the Ingress the user wishes to exist.
[k8s.IngressTls](#opencdk8s-cdk8s-argocd-resources-k8s-ingresstls)|IngressTLS describes the transport layer security associated with an Ingress.
[k8s.Initializer](#opencdk8s-cdk8s-argocd-resources-k8s-initializer)|Initializer is information about an initializer that has not yet completed.
[k8s.Initializers](#opencdk8s-cdk8s-argocd-resources-k8s-initializers)|Initializers tracks the progress of initialization.
[k8s.IpBlock](#opencdk8s-cdk8s-argocd-resources-k8s-ipblock)|IPBlock describes a particular CIDR (Ex.
[k8s.IscsiPersistentVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-iscsipersistentvolumesource)|ISCSIPersistentVolumeSource represents an ISCSI disk.
[k8s.IscsiVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-iscsivolumesource)|Represents an ISCSI disk.
[k8s.JobSpec](#opencdk8s-cdk8s-argocd-resources-k8s-jobspec)|JobSpec describes how the job execution will look like.
[k8s.JobTemplateSpec](#opencdk8s-cdk8s-argocd-resources-k8s-jobtemplatespec)|JobTemplateSpec describes the data a Job should have when created from a template.
[k8s.JsonSchemaProps](#opencdk8s-cdk8s-argocd-resources-k8s-jsonschemaprops)|JSONSchemaProps is a JSON-Schema following Specification Draft 4 (http://json-schema.org/).
[k8s.KeyToPath](#opencdk8s-cdk8s-argocd-resources-k8s-keytopath)|Maps a string key to a path within a volume.
[k8s.KubeApiServiceListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicelistprops)|APIServiceList is a list of APIService objects.
[k8s.KubeApiServiceListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicelistv1beta1props)|APIServiceList is a list of APIService objects.
[k8s.KubeApiServiceProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiserviceprops)|APIService represents a server for a particular GroupVersion.
[k8s.KubeApiServiceV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicev1beta1props)|APIService represents a server for a particular GroupVersion.
[k8s.KubeAuditSinkListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeauditsinklistv1alpha1props)|AuditSinkList is a list of AuditSink items.
[k8s.KubeAuditSinkV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeauditsinkv1alpha1props)|AuditSink represents a cluster level audit sink.
[k8s.KubeBindingProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubebindingprops)|Binding ties one object to another;
[k8s.KubeCertificateSigningRequestListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecertificatesigningrequestlistv1beta1props)|*No description*
[k8s.KubeCertificateSigningRequestV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecertificatesigningrequestv1beta1props)|Describes a certificate signing request.
[k8s.KubeClusterRoleBindingListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindinglistprops)|ClusterRoleBindingList is a collection of ClusterRoleBindings.
[k8s.KubeClusterRoleBindingListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindinglistv1alpha1props)|ClusterRoleBindingList is a collection of ClusterRoleBindings.
[k8s.KubeClusterRoleBindingListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindinglistv1beta1props)|ClusterRoleBindingList is a collection of ClusterRoleBindings.
[k8s.KubeClusterRoleBindingProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingprops)|ClusterRoleBinding references a ClusterRole, but not contain it.
[k8s.KubeClusterRoleBindingV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingv1alpha1props)|ClusterRoleBinding references a ClusterRole, but not contain it.
[k8s.KubeClusterRoleBindingV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingv1beta1props)|ClusterRoleBinding references a ClusterRole, but not contain it.
[k8s.KubeClusterRoleListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolelistprops)|ClusterRoleList is a collection of ClusterRoles.
[k8s.KubeClusterRoleListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolelistv1alpha1props)|ClusterRoleList is a collection of ClusterRoles.
[k8s.KubeClusterRoleListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolelistv1beta1props)|ClusterRoleList is a collection of ClusterRoles.
[k8s.KubeClusterRoleProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterroleprops)|ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.
[k8s.KubeClusterRoleV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolev1alpha1props)|ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.
[k8s.KubeClusterRoleV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolev1beta1props)|ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.
[k8s.KubeComponentStatusListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubecomponentstatuslistprops)|Status of all the conditions for the component as a list of ComponentStatus objects.
[k8s.KubeComponentStatusProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubecomponentstatusprops)|ComponentStatus (and ComponentStatusList) holds the cluster validation info.
[k8s.KubeConfigMapListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeconfigmaplistprops)|ConfigMapList is a resource containing a list of ConfigMap objects.
[k8s.KubeConfigMapProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeconfigmapprops)|ConfigMap holds configuration data for pods to consume.
[k8s.KubeControllerRevisionListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionlistprops)|ControllerRevisionList is a resource containing a list of ControllerRevision objects.
[k8s.KubeControllerRevisionListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionlistv1beta1props)|ControllerRevisionList is a resource containing a list of ControllerRevision objects.
[k8s.KubeControllerRevisionListV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionlistv1beta2props)|ControllerRevisionList is a resource containing a list of ControllerRevision objects.
[k8s.KubeControllerRevisionProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionprops)|ControllerRevision implements an immutable snapshot of state data.
[k8s.KubeControllerRevisionV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionv1beta1props)|DEPRECATED - This group version of ControllerRevision is deprecated by apps/v1beta2/ControllerRevision.
[k8s.KubeControllerRevisionV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionv1beta2props)|DEPRECATED - This group version of ControllerRevision is deprecated by apps/v1/ControllerRevision.
[k8s.KubeCronJobListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjoblistv1beta1props)|CronJobList is a collection of cron jobs.
[k8s.KubeCronJobListV2Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjoblistv2alpha1props)|CronJobList is a collection of cron jobs.
[k8s.KubeCronJobV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjobv1beta1props)|CronJob represents the configuration of a single cron job.
[k8s.KubeCronJobV2Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjobv2alpha1props)|CronJob represents the configuration of a single cron job.
[k8s.KubeCsiDriverListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsidriverlistv1beta1props)|CSIDriverList is a collection of CSIDriver objects.
[k8s.KubeCsiDriverV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsidriverv1beta1props)|CSIDriver captures information about a Container Storage Interface (CSI) volume driver deployed on the cluster.
[k8s.KubeCsiNodeListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsinodelistv1beta1props)|CSINodeList is a collection of CSINode objects.
[k8s.KubeCsiNodeV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsinodev1beta1props)|CSINode holds information about all CSI drivers installed on a node.
[k8s.KubeCustomResourceDefinitionListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecustomresourcedefinitionlistv1beta1props)|CustomResourceDefinitionList is a list of CustomResourceDefinition objects.
[k8s.KubeCustomResourceDefinitionV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecustomresourcedefinitionv1beta1props)|CustomResourceDefinition represents a resource that should be exposed on the API server.
[k8s.KubeDaemonSetListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetlistprops)|DaemonSetList is a collection of daemon sets.
[k8s.KubeDaemonSetListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetlistv1beta1props)|DaemonSetList is a collection of daemon sets.
[k8s.KubeDaemonSetListV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetlistv1beta2props)|DaemonSetList is a collection of daemon sets.
[k8s.KubeDaemonSetProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetprops)|DaemonSet represents the configuration of a daemon set.
[k8s.KubeDaemonSetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetv1beta1props)|DEPRECATED - This group version of DaemonSet is deprecated by apps/v1beta2/DaemonSet.
[k8s.KubeDaemonSetV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetv1beta2props)|DEPRECATED - This group version of DaemonSet is deprecated by apps/v1/DaemonSet.
[k8s.KubeDeploymentListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentlistprops)|DeploymentList is a list of Deployments.
[k8s.KubeDeploymentListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentlistv1beta1props)|DeploymentList is a list of Deployments.
[k8s.KubeDeploymentListV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentlistv1beta2props)|DeploymentList is a list of Deployments.
[k8s.KubeDeploymentProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentprops)|Deployment enables declarative updates for Pods and ReplicaSets.
[k8s.KubeDeploymentV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentv1beta1props)|DEPRECATED - This group version of Deployment is deprecated by apps/v1beta2/Deployment.
[k8s.KubeDeploymentV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentv1beta2props)|DEPRECATED - This group version of Deployment is deprecated by apps/v1/Deployment.
[k8s.KubeEndpointsListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeendpointslistprops)|EndpointsList is a list of endpoints.
[k8s.KubeEndpointsProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeendpointsprops)|Endpoints is a collection of endpoints that implement the actual service.
[k8s.KubeEventListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeeventlistprops)|EventList is a list of events.
[k8s.KubeEventListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeeventlistv1beta1props)|EventList is a list of Event objects.
[k8s.KubeEventProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeeventprops)|Event is a report of an event somewhere in the cluster.
[k8s.KubeEventV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeeventv1beta1props)|Event is a report of an event somewhere in the cluster.
[k8s.KubeEvictionV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeevictionv1beta1props)|Eviction evicts a pod from its node subject to certain policies and safety constraints.
[k8s.KubeHorizontalPodAutoscalerListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerlistprops)|list of horizontal pod autoscaler objects.
[k8s.KubeHorizontalPodAutoscalerListV2Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerlistv2beta1props)|HorizontalPodAutoscaler is a list of horizontal pod autoscaler objects.
[k8s.KubeHorizontalPodAutoscalerListV2Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerlistv2beta2props)|HorizontalPodAutoscalerList is a list of horizontal pod autoscaler objects.
[k8s.KubeHorizontalPodAutoscalerProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerprops)|configuration of a horizontal pod autoscaler.
[k8s.KubeHorizontalPodAutoscalerV2Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerv2beta1props)|HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.
[k8s.KubeHorizontalPodAutoscalerV2Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerv2beta2props)|HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.
[k8s.KubeIngressListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeingresslistv1beta1props)|IngressList is a collection of Ingress.
[k8s.KubeIngressV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeingressv1beta1props)|Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend.
[k8s.KubeJobListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubejoblistprops)|JobList is a collection of jobs.
[k8s.KubeJobProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubejobprops)|Job represents the configuration of a single job.
[k8s.KubeLeaseListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeleaselistprops)|LeaseList is a list of Lease objects.
[k8s.KubeLeaseListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeleaselistv1beta1props)|LeaseList is a list of Lease objects.
[k8s.KubeLeaseProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeleaseprops)|Lease defines a lease concept.
[k8s.KubeLeaseV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeleasev1beta1props)|Lease defines a lease concept.
[k8s.KubeLimitRangeListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubelimitrangelistprops)|LimitRangeList is a list of LimitRange items.
[k8s.KubeLimitRangeProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubelimitrangeprops)|LimitRange sets resource usage limits for each kind of resource in a Namespace.
[k8s.KubeLocalSubjectAccessReviewProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubelocalsubjectaccessreviewprops)|LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace.
[k8s.KubeLocalSubjectAccessReviewV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubelocalsubjectaccessreviewv1beta1props)|LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace.
[k8s.KubeMutatingWebhookConfigurationListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubemutatingwebhookconfigurationlistv1beta1props)|MutatingWebhookConfigurationList is a list of MutatingWebhookConfiguration.
[k8s.KubeMutatingWebhookConfigurationV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubemutatingwebhookconfigurationv1beta1props)|MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object.
[k8s.KubeNamespaceListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenamespacelistprops)|NamespaceList is a list of Namespaces.
[k8s.KubeNamespaceProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenamespaceprops)|Namespace provides a scope for Names.
[k8s.KubeNetworkPolicyListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicylistprops)|NetworkPolicyList is a list of NetworkPolicy objects.
[k8s.KubeNetworkPolicyListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicylistv1beta1props)|DEPRECATED 1.9 - This group version of NetworkPolicyList is deprecated by networking/v1/NetworkPolicyList. Network Policy List is a list of NetworkPolicy objects.
[k8s.KubeNetworkPolicyProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicyprops)|NetworkPolicy describes what network traffic is allowed for a set of Pods.
[k8s.KubeNetworkPolicyV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicyv1beta1props)|DEPRECATED 1.9 - This group version of NetworkPolicy is deprecated by networking/v1/NetworkPolicy. NetworkPolicy describes what network traffic is allowed for a set of Pods.
[k8s.KubeNodeListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenodelistprops)|NodeList is the whole list of all Nodes which have been registered with master.
[k8s.KubeNodeProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenodeprops)|Node is a worker node in Kubernetes.
[k8s.KubePersistentVolumeClaimListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeclaimlistprops)|PersistentVolumeClaimList is a list of PersistentVolumeClaim items.
[k8s.KubePersistentVolumeClaimProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeclaimprops)|PersistentVolumeClaim is a user's request for and claim to a persistent volume.
[k8s.KubePersistentVolumeListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumelistprops)|PersistentVolumeList is a list of PersistentVolume items.
[k8s.KubePersistentVolumeProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeprops)|PersistentVolume (PV) is a storage resource provisioned by an administrator.
[k8s.KubePodDisruptionBudgetListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepoddisruptionbudgetlistv1beta1props)|PodDisruptionBudgetList is a collection of PodDisruptionBudgets.
[k8s.KubePodDisruptionBudgetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepoddisruptionbudgetv1beta1props)|PodDisruptionBudget is an object to define the max disruption that can be caused to a collection of pods.
[k8s.KubePodListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodlistprops)|PodList is a list of Pods.
[k8s.KubePodPresetListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodpresetlistv1alpha1props)|PodPresetList is a list of PodPreset objects.
[k8s.KubePodPresetV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodpresetv1alpha1props)|PodPreset is a policy resource that defines additional runtime requirements for a Pod.
[k8s.KubePodProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodprops)|Pod is a collection of containers that can run on a host.
[k8s.KubePodSecurityPolicyListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodsecuritypolicylistv1beta1props)|PodSecurityPolicyList is a list of PodSecurityPolicy objects.
[k8s.KubePodSecurityPolicyV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodsecuritypolicyv1beta1props)|PodSecurityPolicy governs the ability to make requests that affect the Security Context that will be applied to a pod and container.
[k8s.KubePodTemplateListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodtemplatelistprops)|PodTemplateList is a list of PodTemplates.
[k8s.KubePodTemplateProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodtemplateprops)|PodTemplate describes a template for creating copies of a predefined pod.
[k8s.KubePriorityClassListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclasslistprops)|PriorityClassList is a collection of priority classes.
[k8s.KubePriorityClassListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclasslistv1alpha1props)|PriorityClassList is a collection of priority classes.
[k8s.KubePriorityClassListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclasslistv1beta1props)|PriorityClassList is a collection of priority classes.
[k8s.KubePriorityClassProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassprops)|PriorityClass defines mapping from a priority class name to the priority integer value.
[k8s.KubePriorityClassV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassv1alpha1props)|DEPRECATED - This group version of PriorityClass is deprecated by scheduling.k8s.io/v1/PriorityClass. PriorityClass defines mapping from a priority class name to the priority integer value. The value can be any valid integer.
[k8s.KubePriorityClassV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassv1beta1props)|DEPRECATED - This group version of PriorityClass is deprecated by scheduling.k8s.io/v1/PriorityClass. PriorityClass defines mapping from a priority class name to the priority integer value. The value can be any valid integer.
[k8s.KubeReplicaSetListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetlistprops)|ReplicaSetList is a collection of ReplicaSets.
[k8s.KubeReplicaSetListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetlistv1beta1props)|ReplicaSetList is a collection of ReplicaSets.
[k8s.KubeReplicaSetListV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetlistv1beta2props)|ReplicaSetList is a collection of ReplicaSets.
[k8s.KubeReplicaSetProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetprops)|ReplicaSet ensures that a specified number of pod replicas are running at any given time.
[k8s.KubeReplicaSetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetv1beta1props)|DEPRECATED - This group version of ReplicaSet is deprecated by apps/v1beta2/ReplicaSet.
[k8s.KubeReplicaSetV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetv1beta2props)|DEPRECATED - This group version of ReplicaSet is deprecated by apps/v1/ReplicaSet.
[k8s.KubeReplicationControllerListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicationcontrollerlistprops)|ReplicationControllerList is a collection of replication controllers.
[k8s.KubeReplicationControllerProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicationcontrollerprops)|ReplicationController represents the configuration of a replication controller.
[k8s.KubeResourceQuotaListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberesourcequotalistprops)|ResourceQuotaList is a list of ResourceQuota items.
[k8s.KubeResourceQuotaProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberesourcequotaprops)|ResourceQuota sets aggregate quota restrictions enforced per namespace.
[k8s.KubeRoleBindingListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindinglistprops)|RoleBindingList is a collection of RoleBindings.
[k8s.KubeRoleBindingListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindinglistv1alpha1props)|RoleBindingList is a collection of RoleBindings.
[k8s.KubeRoleBindingListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindinglistv1beta1props)|RoleBindingList is a collection of RoleBindings.
[k8s.KubeRoleBindingProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingprops)|RoleBinding references a role, but does not contain it.
[k8s.KubeRoleBindingV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingv1alpha1props)|RoleBinding references a role, but does not contain it.
[k8s.KubeRoleBindingV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingv1beta1props)|RoleBinding references a role, but does not contain it.
[k8s.KubeRoleListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolelistprops)|RoleList is a collection of Roles.
[k8s.KubeRoleListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolelistv1alpha1props)|RoleList is a collection of Roles.
[k8s.KubeRoleListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolelistv1beta1props)|RoleList is a collection of Roles.
[k8s.KubeRoleProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberoleprops)|Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.
[k8s.KubeRoleV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolev1alpha1props)|Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.
[k8s.KubeRoleV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolev1beta1props)|Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.
[k8s.KubeRuntimeClassListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclasslistv1alpha1props)|RuntimeClassList is a list of RuntimeClass objects.
[k8s.KubeRuntimeClassListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclasslistv1beta1props)|RuntimeClassList is a list of RuntimeClass objects.
[k8s.KubeRuntimeClassV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclassv1alpha1props)|RuntimeClass defines a class of container runtime supported in the cluster.
[k8s.KubeRuntimeClassV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclassv1beta1props)|RuntimeClass defines a class of container runtime supported in the cluster.
[k8s.KubeScaleProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubescaleprops)|Scale represents a scaling request for a resource.
[k8s.KubeScaleV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubescalev1beta1props)|represents a scaling request for a resource.
[k8s.KubeScaleV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubescalev1beta2props)|Scale represents a scaling request for a resource.
[k8s.KubeSecretListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubesecretlistprops)|SecretList is a list of Secret.
[k8s.KubeSecretProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubesecretprops)|Secret holds secret data of a certain type.
[k8s.KubeSelfSubjectAccessReviewProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectaccessreviewprops)|SelfSubjectAccessReview checks whether or the current user can perform an action.
[k8s.KubeSelfSubjectAccessReviewV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectaccessreviewv1beta1props)|SelfSubjectAccessReview checks whether or the current user can perform an action.
[k8s.KubeSelfSubjectRulesReviewProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectrulesreviewprops)|SelfSubjectRulesReview enumerates the set of actions the current user can perform within a namespace.
[k8s.KubeSelfSubjectRulesReviewV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectrulesreviewv1beta1props)|SelfSubjectRulesReview enumerates the set of actions the current user can perform within a namespace.
[k8s.KubeServiceAccountListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceaccountlistprops)|ServiceAccountList is a list of ServiceAccount objects.
[k8s.KubeServiceAccountProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceaccountprops)|ServiceAccount binds together: * a name, understood by users, and perhaps by peripheral systems, for an identity * a principal that can be authenticated and authorized * a set of secrets.
[k8s.KubeServiceListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeservicelistprops)|ServiceList holds a list of services.
[k8s.KubeServiceProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceprops)|Service is a named abstraction of software service (for example, mysql) consisting of local port (for example 3306) that the proxy listens on, and the selector that determines which pods will answer requests sent through the proxy.
[k8s.KubeStatefulSetListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetlistprops)|StatefulSetList is a collection of StatefulSets.
[k8s.KubeStatefulSetListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetlistv1beta1props)|StatefulSetList is a collection of StatefulSets.
[k8s.KubeStatefulSetListV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetlistv1beta2props)|StatefulSetList is a collection of StatefulSets.
[k8s.KubeStatefulSetProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetprops)|StatefulSet represents a set of pods with consistent identities.
[k8s.KubeStatefulSetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetv1beta1props)|DEPRECATED - This group version of StatefulSet is deprecated by apps/v1beta2/StatefulSet.
[k8s.KubeStatefulSetV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetv1beta2props)|DEPRECATED - This group version of StatefulSet is deprecated by apps/v1/StatefulSet.
[k8s.KubeStatusProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatusprops)|Status is a return value for calls that don't return other objects.
[k8s.KubeStorageClassListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclasslistprops)|StorageClassList is a collection of storage classes.
[k8s.KubeStorageClassListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclasslistv1beta1props)|StorageClassList is a collection of storage classes.
[k8s.KubeStorageClassProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclassprops)|StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.
[k8s.KubeStorageClassV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclassv1beta1props)|StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.
[k8s.KubeSubjectAccessReviewProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubesubjectaccessreviewprops)|SubjectAccessReview checks whether or not a user or group can perform an action.
[k8s.KubeSubjectAccessReviewV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubesubjectaccessreviewv1beta1props)|SubjectAccessReview checks whether or not a user or group can perform an action.
[k8s.KubeTokenReviewProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubetokenreviewprops)|TokenReview attempts to authenticate a token to a known user.
[k8s.KubeTokenReviewV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubetokenreviewv1beta1props)|TokenReview attempts to authenticate a token to a known user.
[k8s.KubeValidatingWebhookConfigurationListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevalidatingwebhookconfigurationlistv1beta1props)|ValidatingWebhookConfigurationList is a list of ValidatingWebhookConfiguration.
[k8s.KubeValidatingWebhookConfigurationV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevalidatingwebhookconfigurationv1beta1props)|ValidatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and object without changing it.
[k8s.KubeVolumeAttachmentListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentlistprops)|VolumeAttachmentList is a collection of VolumeAttachment objects.
[k8s.KubeVolumeAttachmentListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentlistv1alpha1props)|VolumeAttachmentList is a collection of VolumeAttachment objects.
[k8s.KubeVolumeAttachmentListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentlistv1beta1props)|VolumeAttachmentList is a collection of VolumeAttachment objects.
[k8s.KubeVolumeAttachmentProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentprops)|VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.
[k8s.KubeVolumeAttachmentV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentv1alpha1props)|VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.
[k8s.KubeVolumeAttachmentV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentv1beta1props)|VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.
[k8s.LabelSelector](#opencdk8s-cdk8s-argocd-resources-k8s-labelselector)|A label selector is a label query over a set of resources.
[k8s.LabelSelectorRequirement](#opencdk8s-cdk8s-argocd-resources-k8s-labelselectorrequirement)|A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.
[k8s.LeaseSpec](#opencdk8s-cdk8s-argocd-resources-k8s-leasespec)|LeaseSpec is a specification of a Lease.
[k8s.Lifecycle](#opencdk8s-cdk8s-argocd-resources-k8s-lifecycle)|Lifecycle describes actions that the management system should take in response to container lifecycle events.
[k8s.LimitRangeItem](#opencdk8s-cdk8s-argocd-resources-k8s-limitrangeitem)|LimitRangeItem defines a min/max usage limit for any resource that matches on kind.
[k8s.LimitRangeSpec](#opencdk8s-cdk8s-argocd-resources-k8s-limitrangespec)|LimitRangeSpec defines a min/max usage limit for resources that match on kind.
[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)|ListMeta describes metadata that synthetic resources must have, including lists and various status objects.
[k8s.LocalObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-localobjectreference)|LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.
[k8s.LocalVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-localvolumesource)|Local represents directly-attached storage with node affinity (Beta feature).
[k8s.ManagedFieldsEntry](#opencdk8s-cdk8s-argocd-resources-k8s-managedfieldsentry)|ManagedFieldsEntry is a workflow-id, a FieldSet and the group version of the resource that the fieldset applies to.
[k8s.MetricIdentifier](#opencdk8s-cdk8s-argocd-resources-k8s-metricidentifier)|MetricIdentifier defines the name and optionally selector for a metric.
[k8s.MetricSpec](#opencdk8s-cdk8s-argocd-resources-k8s-metricspec)|MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).
[k8s.MetricTarget](#opencdk8s-cdk8s-argocd-resources-k8s-metrictarget)|MetricTarget defines the target value, average value, or average utilization of a specific metric.
[k8s.MutatingWebhook](#opencdk8s-cdk8s-argocd-resources-k8s-mutatingwebhook)|MutatingWebhook describes an admission webhook and the resources and operations it applies to.
[k8s.NamespaceSpec](#opencdk8s-cdk8s-argocd-resources-k8s-namespacespec)|NamespaceSpec describes the attributes on a Namespace.
[k8s.NetworkPolicyEgressRule](#opencdk8s-cdk8s-argocd-resources-k8s-networkpolicyegressrule)|NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods matched by a NetworkPolicySpec's podSelector.
[k8s.NetworkPolicyIngressRule](#opencdk8s-cdk8s-argocd-resources-k8s-networkpolicyingressrule)|NetworkPolicyIngressRule describes a particular set of traffic that is allowed to the pods matched by a NetworkPolicySpec's podSelector.
[k8s.NetworkPolicyPeer](#opencdk8s-cdk8s-argocd-resources-k8s-networkpolicypeer)|NetworkPolicyPeer describes a peer to allow traffic from.
[k8s.NetworkPolicyPort](#opencdk8s-cdk8s-argocd-resources-k8s-networkpolicyport)|NetworkPolicyPort describes a port to allow traffic on.
[k8s.NetworkPolicySpec](#opencdk8s-cdk8s-argocd-resources-k8s-networkpolicyspec)|NetworkPolicySpec provides the specification of a NetworkPolicy.
[k8s.NfsVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-nfsvolumesource)|Represents an NFS mount that lasts the lifetime of a pod.
[k8s.NodeAffinity](#opencdk8s-cdk8s-argocd-resources-k8s-nodeaffinity)|Node affinity is a group of node affinity scheduling rules.
[k8s.NodeConfigSource](#opencdk8s-cdk8s-argocd-resources-k8s-nodeconfigsource)|NodeConfigSource specifies a source of node configuration.
[k8s.NodeSelector](#opencdk8s-cdk8s-argocd-resources-k8s-nodeselector)|A node selector represents the union of the results of one or more label queries over a set of nodes;
[k8s.NodeSelectorRequirement](#opencdk8s-cdk8s-argocd-resources-k8s-nodeselectorrequirement)|A node selector requirement is a selector that contains values, a key, and an operator that relates the key and values.
[k8s.NodeSelectorTerm](#opencdk8s-cdk8s-argocd-resources-k8s-nodeselectorterm)|A null or empty node selector term matches no objects.
[k8s.NodeSpec](#opencdk8s-cdk8s-argocd-resources-k8s-nodespec)|NodeSpec describes the attributes that a node is created with.
[k8s.NonResourceAttributes](#opencdk8s-cdk8s-argocd-resources-k8s-nonresourceattributes)|NonResourceAttributes includes the authorization attributes available for non-resource requests to the Authorizer interface.
[k8s.ObjectFieldSelector](#opencdk8s-cdk8s-argocd-resources-k8s-objectfieldselector)|ObjectFieldSelector selects an APIVersioned field of an object.
[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)|ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.
[k8s.ObjectMetricSource](#opencdk8s-cdk8s-argocd-resources-k8s-objectmetricsource)|ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)|ObjectReference contains enough information to let you inspect or modify the referred object.
[k8s.OwnerReference](#opencdk8s-cdk8s-argocd-resources-k8s-ownerreference)|OwnerReference contains enough information to let you identify an owning object.
[k8s.PersistentVolumeClaimSpec](#opencdk8s-cdk8s-argocd-resources-k8s-persistentvolumeclaimspec)|PersistentVolumeClaimSpec describes the common attributes of storage devices and allows a Source for provider-specific attributes.
[k8s.PersistentVolumeClaimVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-persistentvolumeclaimvolumesource)|PersistentVolumeClaimVolumeSource references the user's PVC in the same namespace.
[k8s.PersistentVolumeSpec](#opencdk8s-cdk8s-argocd-resources-k8s-persistentvolumespec)|PersistentVolumeSpec is the specification of a persistent volume.
[k8s.PhotonPersistentDiskVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-photonpersistentdiskvolumesource)|Represents a Photon Controller persistent disk resource.
[k8s.PodAffinity](#opencdk8s-cdk8s-argocd-resources-k8s-podaffinity)|Pod affinity is a group of inter pod affinity scheduling rules.
[k8s.PodAffinityTerm](#opencdk8s-cdk8s-argocd-resources-k8s-podaffinityterm)|Defines a set of pods (namely those matching the labelSelector relative to the given namespace(s)) that this pod should be co-located (affinity) or not co-located (anti-affinity) with, where co-located is defined as running on a node whose value of the label with key <topologyKey> matches that of any node on which a pod of the set of pods is running.
[k8s.PodAntiAffinity](#opencdk8s-cdk8s-argocd-resources-k8s-podantiaffinity)|Pod anti affinity is a group of inter pod anti affinity scheduling rules.
[k8s.PodDisruptionBudgetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-poddisruptionbudgetspec)|PodDisruptionBudgetSpec is a description of a PodDisruptionBudget.
[k8s.PodDnsConfig](#opencdk8s-cdk8s-argocd-resources-k8s-poddnsconfig)|PodDNSConfig defines the DNS parameters of a pod in addition to those generated from DNSPolicy.
[k8s.PodDnsConfigOption](#opencdk8s-cdk8s-argocd-resources-k8s-poddnsconfigoption)|PodDNSConfigOption defines DNS resolver options of a pod.
[k8s.PodPresetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-podpresetspec)|PodPresetSpec is a description of a pod preset.
[k8s.PodReadinessGate](#opencdk8s-cdk8s-argocd-resources-k8s-podreadinessgate)|PodReadinessGate contains the reference to a pod condition.
[k8s.PodSecurityContext](#opencdk8s-cdk8s-argocd-resources-k8s-podsecuritycontext)|PodSecurityContext holds pod-level security attributes and common container settings.
[k8s.PodSecurityPolicySpec](#opencdk8s-cdk8s-argocd-resources-k8s-podsecuritypolicyspec)|PodSecurityPolicySpec defines the policy enforced.
[k8s.PodSpec](#opencdk8s-cdk8s-argocd-resources-k8s-podspec)|PodSpec is a description of a pod.
[k8s.PodTemplateSpec](#opencdk8s-cdk8s-argocd-resources-k8s-podtemplatespec)|PodTemplateSpec describes the data a pod should have when created from a template.
[k8s.PodsMetricSource](#opencdk8s-cdk8s-argocd-resources-k8s-podsmetricsource)|PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second).
[k8s.Policy](#opencdk8s-cdk8s-argocd-resources-k8s-policy)|Policy defines the configuration of how audit events are logged.
[k8s.PolicyRule](#opencdk8s-cdk8s-argocd-resources-k8s-policyrule)|PolicyRule holds information that describes a policy rule, but does not contain information about who the rule applies to or which namespace the rule applies to.
[k8s.PortworxVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-portworxvolumesource)|PortworxVolumeSource represents a Portworx volume resource.
[k8s.Preconditions](#opencdk8s-cdk8s-argocd-resources-k8s-preconditions)|Preconditions must be fulfilled before an operation (update, delete, etc.) is carried out.
[k8s.PreferredSchedulingTerm](#opencdk8s-cdk8s-argocd-resources-k8s-preferredschedulingterm)|An empty preferred scheduling term matches all objects with implicit weight 0 (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op).
[k8s.Probe](#opencdk8s-cdk8s-argocd-resources-k8s-probe)|Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
[k8s.ProjectedVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-projectedvolumesource)|Represents a projected volume source.
[k8s.QuobyteVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-quobytevolumesource)|Represents a Quobyte mount that lasts the lifetime of a pod.
[k8s.RawExtension](#opencdk8s-cdk8s-argocd-resources-k8s-rawextension)|RawExtension is used to hold extensions in external versions.
[k8s.RbdPersistentVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-rbdpersistentvolumesource)|Represents a Rados Block Device mount that lasts the lifetime of a pod.
[k8s.RbdVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-rbdvolumesource)|Represents a Rados Block Device mount that lasts the lifetime of a pod.
[k8s.ReplicaSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-replicasetspec)|ReplicaSetSpec is the specification of a ReplicaSet.
[k8s.ReplicationControllerSpec](#opencdk8s-cdk8s-argocd-resources-k8s-replicationcontrollerspec)|ReplicationControllerSpec is the specification of a replication controller.
[k8s.ResourceAttributes](#opencdk8s-cdk8s-argocd-resources-k8s-resourceattributes)|ResourceAttributes includes the authorization attributes available for resource requests to the Authorizer interface.
[k8s.ResourceFieldSelector](#opencdk8s-cdk8s-argocd-resources-k8s-resourcefieldselector)|ResourceFieldSelector represents container resources (cpu, memory) and their output format.
[k8s.ResourceMetricSource](#opencdk8s-cdk8s-argocd-resources-k8s-resourcemetricsource)|ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.
[k8s.ResourceQuotaSpec](#opencdk8s-cdk8s-argocd-resources-k8s-resourcequotaspec)|ResourceQuotaSpec defines the desired hard limits to enforce for Quota.
[k8s.ResourceRequirements](#opencdk8s-cdk8s-argocd-resources-k8s-resourcerequirements)|ResourceRequirements describes the compute resource requirements.
[k8s.RoleRef](#opencdk8s-cdk8s-argocd-resources-k8s-roleref)|RoleRef contains information that points to the role being used.
[k8s.RollingUpdateDaemonSet](#opencdk8s-cdk8s-argocd-resources-k8s-rollingupdatedaemonset)|Spec to control the desired behavior of daemon set rolling update.
[k8s.RollingUpdateDeployment](#opencdk8s-cdk8s-argocd-resources-k8s-rollingupdatedeployment)|Spec to control the desired behavior of rolling update.
[k8s.RollingUpdateStatefulSetStrategy](#opencdk8s-cdk8s-argocd-resources-k8s-rollingupdatestatefulsetstrategy)|RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.
[k8s.RuleWithOperations](#opencdk8s-cdk8s-argocd-resources-k8s-rulewithoperations)|RuleWithOperations is a tuple of Operations and Resources.
[k8s.RunAsGroupStrategyOptions](#opencdk8s-cdk8s-argocd-resources-k8s-runasgroupstrategyoptions)|RunAsGroupStrategyOptions defines the strategy type and any options used to create the strategy.
[k8s.RunAsUserStrategyOptions](#opencdk8s-cdk8s-argocd-resources-k8s-runasuserstrategyoptions)|RunAsUserStrategyOptions defines the strategy type and any options used to create the strategy.
[k8s.RuntimeClassSpec](#opencdk8s-cdk8s-argocd-resources-k8s-runtimeclassspec)|RuntimeClassSpec is a specification of a RuntimeClass.
[k8s.RuntimeClassStrategyOptions](#opencdk8s-cdk8s-argocd-resources-k8s-runtimeclassstrategyoptions)|RuntimeClassStrategyOptions define the strategy that will dictate the allowable RuntimeClasses for a pod.
[k8s.ScaleIoPersistentVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-scaleiopersistentvolumesource)|ScaleIOPersistentVolumeSource represents a persistent ScaleIO volume.
[k8s.ScaleIoVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-scaleiovolumesource)|ScaleIOVolumeSource represents a persistent ScaleIO volume.
[k8s.ScaleSpec](#opencdk8s-cdk8s-argocd-resources-k8s-scalespec)|ScaleSpec describes the attributes of a scale subresource.
[k8s.ScopeSelector](#opencdk8s-cdk8s-argocd-resources-k8s-scopeselector)|A scope selector represents the AND of the selectors represented by the scoped-resource selector requirements.
[k8s.ScopedResourceSelectorRequirement](#opencdk8s-cdk8s-argocd-resources-k8s-scopedresourceselectorrequirement)|A scoped-resource selector requirement is a selector that contains values, a scope name, and an operator that relates the scope name and values.
[k8s.SeLinuxOptions](#opencdk8s-cdk8s-argocd-resources-k8s-selinuxoptions)|SELinuxOptions are the labels to be applied to the container.
[k8s.SeLinuxStrategyOptions](#opencdk8s-cdk8s-argocd-resources-k8s-selinuxstrategyoptions)|SELinuxStrategyOptions defines the strategy type and any options used to create the strategy.
[k8s.SecretEnvSource](#opencdk8s-cdk8s-argocd-resources-k8s-secretenvsource)|SecretEnvSource selects a Secret to populate the environment variables with.
[k8s.SecretKeySelector](#opencdk8s-cdk8s-argocd-resources-k8s-secretkeyselector)|SecretKeySelector selects a key of a Secret.
[k8s.SecretProjection](#opencdk8s-cdk8s-argocd-resources-k8s-secretprojection)|Adapts a secret into a projected volume.
[k8s.SecretReference](#opencdk8s-cdk8s-argocd-resources-k8s-secretreference)|SecretReference represents a Secret Reference.
[k8s.SecretVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-secretvolumesource)|Adapts a Secret into a volume.
[k8s.SecurityContext](#opencdk8s-cdk8s-argocd-resources-k8s-securitycontext)|SecurityContext holds security configuration that will be applied to a container.
[k8s.SelfSubjectAccessReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-selfsubjectaccessreviewspec)|SelfSubjectAccessReviewSpec is a description of the access request.
[k8s.SelfSubjectRulesReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-selfsubjectrulesreviewspec)|*No description*
[k8s.ServiceAccountTokenProjection](#opencdk8s-cdk8s-argocd-resources-k8s-serviceaccounttokenprojection)|ServiceAccountTokenProjection represents a projected service account token volume.
[k8s.ServicePort](#opencdk8s-cdk8s-argocd-resources-k8s-serviceport)|ServicePort contains information on service's port.
[k8s.ServiceReference](#opencdk8s-cdk8s-argocd-resources-k8s-servicereference)|ServiceReference holds a reference to Service.legacy.k8s.io.
[k8s.ServiceSpec](#opencdk8s-cdk8s-argocd-resources-k8s-servicespec)|ServiceSpec describes the attributes that a user creates on a service.
[k8s.SessionAffinityConfig](#opencdk8s-cdk8s-argocd-resources-k8s-sessionaffinityconfig)|SessionAffinityConfig represents the configurations of session affinity.
[k8s.StatefulSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-statefulsetspec)|A StatefulSetSpec is the specification of a StatefulSet.
[k8s.StatefulSetUpdateStrategy](#opencdk8s-cdk8s-argocd-resources-k8s-statefulsetupdatestrategy)|StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates.
[k8s.StatusCause](#opencdk8s-cdk8s-argocd-resources-k8s-statuscause)|StatusCause provides more information about an api.Status failure, including cases when multiple errors are encountered.
[k8s.StatusDetails](#opencdk8s-cdk8s-argocd-resources-k8s-statusdetails)|StatusDetails is a set of additional properties that MAY be set by the server to provide additional information about a response.
[k8s.StorageOsPersistentVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-storageospersistentvolumesource)|Represents a StorageOS persistent volume resource.
[k8s.StorageOsVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-storageosvolumesource)|Represents a StorageOS persistent volume resource.
[k8s.Subject](#opencdk8s-cdk8s-argocd-resources-k8s-subject)|Subject contains a reference to the object or user identities a role binding applies to.
[k8s.SubjectAccessReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-subjectaccessreviewspec)|SubjectAccessReviewSpec is a description of the access request.
[k8s.SupplementalGroupsStrategyOptions](#opencdk8s-cdk8s-argocd-resources-k8s-supplementalgroupsstrategyoptions)|SupplementalGroupsStrategyOptions defines the strategy type and options used to create the strategy.
[k8s.Sysctl](#opencdk8s-cdk8s-argocd-resources-k8s-sysctl)|Sysctl defines a kernel parameter to be set.
[k8s.Taint](#opencdk8s-cdk8s-argocd-resources-k8s-taint)|The node this Taint is attached to has the "effect" on any pod that does not tolerate the Taint.
[k8s.TcpSocketAction](#opencdk8s-cdk8s-argocd-resources-k8s-tcpsocketaction)|TCPSocketAction describes an action based on opening a socket.
[k8s.TokenReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-tokenreviewspec)|TokenReviewSpec is a description of the token authentication request.
[k8s.Toleration](#opencdk8s-cdk8s-argocd-resources-k8s-toleration)|The pod this Toleration is attached to tolerates any taint that matches the triple <key,value,effect> using the matching operator <operator>.
[k8s.TopologySelectorLabelRequirement](#opencdk8s-cdk8s-argocd-resources-k8s-topologyselectorlabelrequirement)|A topology selector requirement is a selector that matches given label.
[k8s.TopologySelectorTerm](#opencdk8s-cdk8s-argocd-resources-k8s-topologyselectorterm)|A topology selector term represents the result of label queries.
[k8s.TypedLocalObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-typedlocalobjectreference)|TypedLocalObjectReference contains enough information to let you locate the typed referenced object inside the same namespace.
[k8s.ValidatingWebhook](#opencdk8s-cdk8s-argocd-resources-k8s-validatingwebhook)|ValidatingWebhook describes an admission webhook and the resources and operations it applies to.
[k8s.Volume](#opencdk8s-cdk8s-argocd-resources-k8s-volume)|Volume represents a named volume in a pod that may be accessed by any container in the pod.
[k8s.VolumeAttachmentSource](#opencdk8s-cdk8s-argocd-resources-k8s-volumeattachmentsource)|VolumeAttachmentSource represents a volume that should be attached.
[k8s.VolumeAttachmentSpec](#opencdk8s-cdk8s-argocd-resources-k8s-volumeattachmentspec)|VolumeAttachmentSpec is the specification of a VolumeAttachment request.
[k8s.VolumeDevice](#opencdk8s-cdk8s-argocd-resources-k8s-volumedevice)|volumeDevice describes a mapping of a raw block device within a container.
[k8s.VolumeMount](#opencdk8s-cdk8s-argocd-resources-k8s-volumemount)|VolumeMount describes a mounting of a Volume within a container.
[k8s.VolumeNodeAffinity](#opencdk8s-cdk8s-argocd-resources-k8s-volumenodeaffinity)|VolumeNodeAffinity defines constraints that limit what nodes this volume can be accessed from.
[k8s.VolumeProjection](#opencdk8s-cdk8s-argocd-resources-k8s-volumeprojection)|Projection that may be projected along with other supported volume types.
[k8s.VsphereVirtualDiskVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-vspherevirtualdiskvolumesource)|Represents a vSphere volume resource.
[k8s.Webhook](#opencdk8s-cdk8s-argocd-resources-k8s-webhook)|Webhook holds the configuration of the webhook.
[k8s.WebhookClientConfig](#opencdk8s-cdk8s-argocd-resources-k8s-webhookclientconfig)|WebhookClientConfig contains the information to make a TLS connection with the webhook.
[k8s.WebhookThrottleConfig](#opencdk8s-cdk8s-argocd-resources-k8s-webhookthrottleconfig)|WebhookThrottleConfig holds the configuration for throttling events.
[k8s.WeightedPodAffinityTerm](#opencdk8s-cdk8s-argocd-resources-k8s-weightedpodaffinityterm)|The weights of all of the matched WeightedPodAffinityTerm fields are added per-node to find the most preferred node(s).
[k8s.WindowsSecurityContextOptions](#opencdk8s-cdk8s-argocd-resources-k8s-windowssecuritycontextoptions)|WindowsSecurityContextOptions contain Windows-specific options and credentials.


**Enums**

Name|Description
----|-----------
[k8s.IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind](#opencdk8s-cdk8s-argocd-resources-k8s-iok8sapimachinerypkgapismetav1deleteoptionskind)|Kind is a string value representing the REST resource this object represents.



## class ArgoCdApplication 🔹 <a id="opencdk8s-cdk8s-argocd-resources-argocdapplication"></a>



__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines an "extentions" API object for AWS Load Balancer Controller - https://github.com/kubernetes-sigs/aws-load-balancer-controller.

```ts
new ArgoCdApplication(scope: Construct, id: string, props: ArgoCdApplicationProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[ArgoCdApplicationProps](#opencdk8s-cdk8s-argocd-resources-argocdapplicationprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[ArgoCdApplicationSpec](#opencdk8s-cdk8s-argocd-resources-argocdapplicationspec)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | <span></span>

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-argocdapplication-manifest"></a>

Renders a Kubernetes manifest for an ingress object. https://github.com/kubernetes-sigs/aws-load-balancer-controller.

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: ArgoCdApplicationProps): any
```

* **props** (<code>[ArgoCdApplicationProps](#opencdk8s-cdk8s-argocd-resources-argocdapplicationprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[ArgoCdApplicationSpec](#opencdk8s-cdk8s-argocd-resources-argocdapplicationspec)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class ArgoCdProject 🔹 <a id="opencdk8s-cdk8s-argocd-resources-argocdproject"></a>



__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines an "extentions" API object for AWS Load Balancer Controller - https://github.com/kubernetes-sigs/aws-load-balancer-controller.

```ts
new ArgoCdProject(scope: Construct, id: string, props: ArgoCdProjectProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[ArgoCdProjectProps](#opencdk8s-cdk8s-argocd-resources-argocdprojectprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[ArgoCdProjectSpec](#opencdk8s-cdk8s-argocd-resources-argocdprojectspec)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | <span></span>

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-argocdproject-manifest"></a>

Renders a Kubernetes manifest for an ingress object. https://github.com/kubernetes-sigs/aws-load-balancer-controller.

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: ArgoCdProjectProps): any
```

* **props** (<code>[ArgoCdProjectProps](#opencdk8s-cdk8s-argocd-resources-argocdprojectprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[ArgoCdProjectSpec](#opencdk8s-cdk8s-argocd-resources-argocdprojectspec)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class IntOrString 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-intorstring"></a>



__Submodule__: k8s


### Methods


#### *static* fromNumber(value)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-intorstring-fromnumber"></a>



```ts
static fromNumber(value: number): IntOrString
```

* **value** (<code>number</code>)  *No description*

__Returns__:
* <code>[k8s.IntOrString](#opencdk8s-cdk8s-argocd-resources-k8s-intorstring)</code>

#### *static* fromString(value)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-intorstring-fromstring"></a>



```ts
static fromString(value: string): IntOrString
```

* **value** (<code>string</code>)  *No description*

__Returns__:
* <code>[k8s.IntOrString](#opencdk8s-cdk8s-argocd-resources-k8s-intorstring)</code>



## class KubeApiService 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservice"></a>

APIService represents a server for a particular GroupVersion.

Name must be "version.group".

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService" API object.

```ts
new k8s.KubeApiService(scope: Construct, id: string, props?: KubeApiServiceProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeApiServiceProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiserviceprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[k8s.ApiServiceSpec](#opencdk8s-cdk8s-argocd-resources-k8s-apiservicespec)</code>)  Spec contains information for locating and communicating with a server. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservice-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeApiServiceProps): any
```

* **props** (<code>[k8s.KubeApiServiceProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiserviceprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[k8s.ApiServiceSpec](#opencdk8s-cdk8s-argocd-resources-k8s-apiservicespec)</code>)  Spec contains information for locating and communicating with a server. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeApiServiceList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicelist"></a>

APIServiceList is a list of APIService objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList" API object.

```ts
new k8s.KubeApiServiceList(scope: Construct, id: string, props: KubeApiServiceListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeApiServiceListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicelistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeApiServiceProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiserviceprops)></code>)  *No description* 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicelist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeApiServiceListProps): any
```

* **props** (<code>[k8s.KubeApiServiceListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicelistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeApiServiceProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiserviceprops)></code>)  *No description* 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class KubeApiServiceListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicelistv1beta1"></a>

APIServiceList is a list of APIService objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceList" API object.

```ts
new k8s.KubeApiServiceListV1Beta1(scope: Construct, id: string, props: KubeApiServiceListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeApiServiceListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicelistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeApiServiceV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicev1beta1props)></code>)  *No description* 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicelistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeApiServiceListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeApiServiceListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicelistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeApiServiceV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicev1beta1props)></code>)  *No description* 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class KubeApiServiceV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicev1beta1"></a>

APIService represents a server for a particular GroupVersion.

Name must be "version.group".

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIService" API object.

```ts
new k8s.KubeApiServiceV1Beta1(scope: Construct, id: string, props?: KubeApiServiceV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeApiServiceV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicev1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[k8s.ApiServiceSpec](#opencdk8s-cdk8s-argocd-resources-k8s-apiservicespec)</code>)  Spec contains information for locating and communicating with a server. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIService".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicev1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIService".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeApiServiceV1Beta1Props): any
```

* **props** (<code>[k8s.KubeApiServiceV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicev1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[k8s.ApiServiceSpec](#opencdk8s-cdk8s-argocd-resources-k8s-apiservicespec)</code>)  Spec contains information for locating and communicating with a server. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeAuditSinkListV1Alpha1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeauditsinklistv1alpha1"></a>

AuditSinkList is a list of AuditSink items.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.auditregistration.v1alpha1.AuditSinkList" API object.

```ts
new k8s.KubeAuditSinkListV1Alpha1(scope: Construct, id: string, props: KubeAuditSinkListV1Alpha1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeAuditSinkListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeauditsinklistv1alpha1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeAuditSinkV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeauditsinkv1alpha1props)></code>)  List of audit configurations. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.auditregistration.v1alpha1.AuditSinkList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeauditsinklistv1alpha1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.auditregistration.v1alpha1.AuditSinkList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeAuditSinkListV1Alpha1Props): any
```

* **props** (<code>[k8s.KubeAuditSinkListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeauditsinklistv1alpha1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeAuditSinkV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeauditsinkv1alpha1props)></code>)  List of audit configurations. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class KubeAuditSinkV1Alpha1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeauditsinkv1alpha1"></a>

AuditSink represents a cluster level audit sink.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.auditregistration.v1alpha1.AuditSink" API object.

```ts
new k8s.KubeAuditSinkV1Alpha1(scope: Construct, id: string, props?: KubeAuditSinkV1Alpha1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeAuditSinkV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeauditsinkv1alpha1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[k8s.AuditSinkSpec](#opencdk8s-cdk8s-argocd-resources-k8s-auditsinkspec)</code>)  Spec defines the audit configuration spec. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.auditregistration.v1alpha1.AuditSink".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeauditsinkv1alpha1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.auditregistration.v1alpha1.AuditSink".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeAuditSinkV1Alpha1Props): any
```

* **props** (<code>[k8s.KubeAuditSinkV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeauditsinkv1alpha1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[k8s.AuditSinkSpec](#opencdk8s-cdk8s-argocd-resources-k8s-auditsinkspec)</code>)  Spec defines the audit configuration spec. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeBinding 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubebinding"></a>

Binding ties one object to another;

for example, a pod is bound to a node by a scheduler. Deprecated in 1.7, please use the bindings subresource of pods instead.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.Binding" API object.

```ts
new k8s.KubeBinding(scope: Construct, id: string, props: KubeBindingProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeBindingProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubebindingprops)</code>)  initialization props.
  * **target** (<code>[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)</code>)  The target object that you want to bind to the standard object. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.Binding".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubebinding-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.Binding".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeBindingProps): any
```

* **props** (<code>[k8s.KubeBindingProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubebindingprops)</code>)  initialization props.
  * **target** (<code>[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)</code>)  The target object that you want to bind to the standard object. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeCertificateSigningRequestListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecertificatesigningrequestlistv1beta1"></a>



__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.certificates.v1beta1.CertificateSigningRequestList" API object.

```ts
new k8s.KubeCertificateSigningRequestListV1Beta1(scope: Construct, id: string, props: KubeCertificateSigningRequestListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeCertificateSigningRequestListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecertificatesigningrequestlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeCertificateSigningRequestV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecertificatesigningrequestv1beta1props)></code>)  *No description* 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.certificates.v1beta1.CertificateSigningRequestList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecertificatesigningrequestlistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.certificates.v1beta1.CertificateSigningRequestList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeCertificateSigningRequestListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeCertificateSigningRequestListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecertificatesigningrequestlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeCertificateSigningRequestV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecertificatesigningrequestv1beta1props)></code>)  *No description* 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class KubeCertificateSigningRequestV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecertificatesigningrequestv1beta1"></a>

Describes a certificate signing request.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.certificates.v1beta1.CertificateSigningRequest" API object.

```ts
new k8s.KubeCertificateSigningRequestV1Beta1(scope: Construct, id: string, props?: KubeCertificateSigningRequestV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeCertificateSigningRequestV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecertificatesigningrequestv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[k8s.CertificateSigningRequestSpec](#opencdk8s-cdk8s-argocd-resources-k8s-certificatesigningrequestspec)</code>)  The certificate request itself and any additional information. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.certificates.v1beta1.CertificateSigningRequest".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecertificatesigningrequestv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.certificates.v1beta1.CertificateSigningRequest".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeCertificateSigningRequestV1Beta1Props): any
```

* **props** (<code>[k8s.KubeCertificateSigningRequestV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecertificatesigningrequestv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[k8s.CertificateSigningRequestSpec](#opencdk8s-cdk8s-argocd-resources-k8s-certificatesigningrequestspec)</code>)  The certificate request itself and any additional information. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeClusterRole 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrole"></a>

ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1.ClusterRole" API object.

```ts
new k8s.KubeClusterRole(scope: Construct, id: string, props?: KubeClusterRoleProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeClusterRoleProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterroleprops)</code>)  initialization props.
  * **aggregationRule** (<code>[k8s.AggregationRule](#opencdk8s-cdk8s-argocd-resources-k8s-aggregationrule)</code>)  AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **rules** (<code>Array<[k8s.PolicyRule](#opencdk8s-cdk8s-argocd-resources-k8s-policyrule)></code>)  Rules holds all the PolicyRules for this ClusterRole. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRole".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrole-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRole".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeClusterRoleProps): any
```

* **props** (<code>[k8s.KubeClusterRoleProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterroleprops)</code>)  initialization props.
  * **aggregationRule** (<code>[k8s.AggregationRule](#opencdk8s-cdk8s-argocd-resources-k8s-aggregationrule)</code>)  AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **rules** (<code>Array<[k8s.PolicyRule](#opencdk8s-cdk8s-argocd-resources-k8s-policyrule)></code>)  Rules holds all the PolicyRules for this ClusterRole. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeClusterRoleBinding 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebinding"></a>

ClusterRoleBinding references a ClusterRole, but not contain it.

It can reference a ClusterRole in the global namespace, and adds who information via Subject.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1.ClusterRoleBinding" API object.

```ts
new k8s.KubeClusterRoleBinding(scope: Construct, id: string, props: KubeClusterRoleBindingProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeClusterRoleBindingProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingprops)</code>)  initialization props.
  * **roleRef** (<code>[k8s.RoleRef](#opencdk8s-cdk8s-argocd-resources-k8s-roleref)</code>)  RoleRef can only reference a ClusterRole in the global namespace. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **subjects** (<code>Array<[k8s.Subject](#opencdk8s-cdk8s-argocd-resources-k8s-subject)></code>)  Subjects holds references to the objects the role applies to. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRoleBinding".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebinding-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRoleBinding".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeClusterRoleBindingProps): any
```

* **props** (<code>[k8s.KubeClusterRoleBindingProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingprops)</code>)  initialization props.
  * **roleRef** (<code>[k8s.RoleRef](#opencdk8s-cdk8s-argocd-resources-k8s-roleref)</code>)  RoleRef can only reference a ClusterRole in the global namespace. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **subjects** (<code>Array<[k8s.Subject](#opencdk8s-cdk8s-argocd-resources-k8s-subject)></code>)  Subjects holds references to the objects the role applies to. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeClusterRoleBindingList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindinglist"></a>

ClusterRoleBindingList is a collection of ClusterRoleBindings.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1.ClusterRoleBindingList" API object.

```ts
new k8s.KubeClusterRoleBindingList(scope: Construct, id: string, props: KubeClusterRoleBindingListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeClusterRoleBindingListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindinglistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeClusterRoleBindingProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingprops)></code>)  Items is a list of ClusterRoleBindings. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRoleBindingList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindinglist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRoleBindingList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeClusterRoleBindingListProps): any
```

* **props** (<code>[k8s.KubeClusterRoleBindingListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindinglistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeClusterRoleBindingProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingprops)></code>)  Items is a list of ClusterRoleBindings. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeClusterRoleBindingListV1Alpha1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindinglistv1alpha1"></a>

ClusterRoleBindingList is a collection of ClusterRoleBindings.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1alpha1.ClusterRoleBindingList" API object.

```ts
new k8s.KubeClusterRoleBindingListV1Alpha1(scope: Construct, id: string, props: KubeClusterRoleBindingListV1Alpha1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeClusterRoleBindingListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindinglistv1alpha1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeClusterRoleBindingV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingv1alpha1props)></code>)  Items is a list of ClusterRoleBindings. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.ClusterRoleBindingList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindinglistv1alpha1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.ClusterRoleBindingList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeClusterRoleBindingListV1Alpha1Props): any
```

* **props** (<code>[k8s.KubeClusterRoleBindingListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindinglistv1alpha1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeClusterRoleBindingV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingv1alpha1props)></code>)  Items is a list of ClusterRoleBindings. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeClusterRoleBindingListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindinglistv1beta1"></a>

ClusterRoleBindingList is a collection of ClusterRoleBindings.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1beta1.ClusterRoleBindingList" API object.

```ts
new k8s.KubeClusterRoleBindingListV1Beta1(scope: Construct, id: string, props: KubeClusterRoleBindingListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeClusterRoleBindingListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindinglistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeClusterRoleBindingV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingv1beta1props)></code>)  Items is a list of ClusterRoleBindings. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1beta1.ClusterRoleBindingList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindinglistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1beta1.ClusterRoleBindingList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeClusterRoleBindingListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeClusterRoleBindingListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindinglistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeClusterRoleBindingV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingv1beta1props)></code>)  Items is a list of ClusterRoleBindings. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeClusterRoleBindingV1Alpha1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingv1alpha1"></a>

ClusterRoleBinding references a ClusterRole, but not contain it.

It can reference a ClusterRole in the global namespace, and adds who information via Subject.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1alpha1.ClusterRoleBinding" API object.

```ts
new k8s.KubeClusterRoleBindingV1Alpha1(scope: Construct, id: string, props: KubeClusterRoleBindingV1Alpha1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeClusterRoleBindingV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingv1alpha1props)</code>)  initialization props.
  * **roleRef** (<code>[k8s.RoleRef](#opencdk8s-cdk8s-argocd-resources-k8s-roleref)</code>)  RoleRef can only reference a ClusterRole in the global namespace. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **subjects** (<code>Array<[k8s.Subject](#opencdk8s-cdk8s-argocd-resources-k8s-subject)></code>)  Subjects holds references to the objects the role applies to. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.ClusterRoleBinding".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingv1alpha1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.ClusterRoleBinding".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeClusterRoleBindingV1Alpha1Props): any
```

* **props** (<code>[k8s.KubeClusterRoleBindingV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingv1alpha1props)</code>)  initialization props.
  * **roleRef** (<code>[k8s.RoleRef](#opencdk8s-cdk8s-argocd-resources-k8s-roleref)</code>)  RoleRef can only reference a ClusterRole in the global namespace. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **subjects** (<code>Array<[k8s.Subject](#opencdk8s-cdk8s-argocd-resources-k8s-subject)></code>)  Subjects holds references to the objects the role applies to. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeClusterRoleBindingV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingv1beta1"></a>

ClusterRoleBinding references a ClusterRole, but not contain it.

It can reference a ClusterRole in the global namespace, and adds who information via Subject.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1beta1.ClusterRoleBinding" API object.

```ts
new k8s.KubeClusterRoleBindingV1Beta1(scope: Construct, id: string, props: KubeClusterRoleBindingV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeClusterRoleBindingV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingv1beta1props)</code>)  initialization props.
  * **roleRef** (<code>[k8s.RoleRef](#opencdk8s-cdk8s-argocd-resources-k8s-roleref)</code>)  RoleRef can only reference a ClusterRole in the global namespace. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **subjects** (<code>Array<[k8s.Subject](#opencdk8s-cdk8s-argocd-resources-k8s-subject)></code>)  Subjects holds references to the objects the role applies to. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1beta1.ClusterRoleBinding".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1beta1.ClusterRoleBinding".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeClusterRoleBindingV1Beta1Props): any
```

* **props** (<code>[k8s.KubeClusterRoleBindingV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingv1beta1props)</code>)  initialization props.
  * **roleRef** (<code>[k8s.RoleRef](#opencdk8s-cdk8s-argocd-resources-k8s-roleref)</code>)  RoleRef can only reference a ClusterRole in the global namespace. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **subjects** (<code>Array<[k8s.Subject](#opencdk8s-cdk8s-argocd-resources-k8s-subject)></code>)  Subjects holds references to the objects the role applies to. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeClusterRoleList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolelist"></a>

ClusterRoleList is a collection of ClusterRoles.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1.ClusterRoleList" API object.

```ts
new k8s.KubeClusterRoleList(scope: Construct, id: string, props: KubeClusterRoleListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeClusterRoleListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolelistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeClusterRoleProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterroleprops)></code>)  Items is a list of ClusterRoles. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRoleList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolelist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRoleList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeClusterRoleListProps): any
```

* **props** (<code>[k8s.KubeClusterRoleListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolelistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeClusterRoleProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterroleprops)></code>)  Items is a list of ClusterRoles. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeClusterRoleListV1Alpha1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolelistv1alpha1"></a>

ClusterRoleList is a collection of ClusterRoles.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1alpha1.ClusterRoleList" API object.

```ts
new k8s.KubeClusterRoleListV1Alpha1(scope: Construct, id: string, props: KubeClusterRoleListV1Alpha1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeClusterRoleListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolelistv1alpha1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeClusterRoleV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolev1alpha1props)></code>)  Items is a list of ClusterRoles. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.ClusterRoleList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolelistv1alpha1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.ClusterRoleList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeClusterRoleListV1Alpha1Props): any
```

* **props** (<code>[k8s.KubeClusterRoleListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolelistv1alpha1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeClusterRoleV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolev1alpha1props)></code>)  Items is a list of ClusterRoles. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeClusterRoleListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolelistv1beta1"></a>

ClusterRoleList is a collection of ClusterRoles.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1beta1.ClusterRoleList" API object.

```ts
new k8s.KubeClusterRoleListV1Beta1(scope: Construct, id: string, props: KubeClusterRoleListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeClusterRoleListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolelistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeClusterRoleV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolev1beta1props)></code>)  Items is a list of ClusterRoles. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1beta1.ClusterRoleList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolelistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1beta1.ClusterRoleList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeClusterRoleListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeClusterRoleListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolelistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeClusterRoleV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolev1beta1props)></code>)  Items is a list of ClusterRoles. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeClusterRoleV1Alpha1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolev1alpha1"></a>

ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1alpha1.ClusterRole" API object.

```ts
new k8s.KubeClusterRoleV1Alpha1(scope: Construct, id: string, props?: KubeClusterRoleV1Alpha1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeClusterRoleV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolev1alpha1props)</code>)  initialization props.
  * **aggregationRule** (<code>[k8s.AggregationRule](#opencdk8s-cdk8s-argocd-resources-k8s-aggregationrule)</code>)  AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **rules** (<code>Array<[k8s.PolicyRule](#opencdk8s-cdk8s-argocd-resources-k8s-policyrule)></code>)  Rules holds all the PolicyRules for this ClusterRole. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.ClusterRole".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolev1alpha1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.ClusterRole".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeClusterRoleV1Alpha1Props): any
```

* **props** (<code>[k8s.KubeClusterRoleV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolev1alpha1props)</code>)  initialization props.
  * **aggregationRule** (<code>[k8s.AggregationRule](#opencdk8s-cdk8s-argocd-resources-k8s-aggregationrule)</code>)  AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **rules** (<code>Array<[k8s.PolicyRule](#opencdk8s-cdk8s-argocd-resources-k8s-policyrule)></code>)  Rules holds all the PolicyRules for this ClusterRole. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeClusterRoleV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolev1beta1"></a>

ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1beta1.ClusterRole" API object.

```ts
new k8s.KubeClusterRoleV1Beta1(scope: Construct, id: string, props?: KubeClusterRoleV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeClusterRoleV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolev1beta1props)</code>)  initialization props.
  * **aggregationRule** (<code>[k8s.AggregationRule](#opencdk8s-cdk8s-argocd-resources-k8s-aggregationrule)</code>)  AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **rules** (<code>Array<[k8s.PolicyRule](#opencdk8s-cdk8s-argocd-resources-k8s-policyrule)></code>)  Rules holds all the PolicyRules for this ClusterRole. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1beta1.ClusterRole".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolev1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1beta1.ClusterRole".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeClusterRoleV1Beta1Props): any
```

* **props** (<code>[k8s.KubeClusterRoleV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolev1beta1props)</code>)  initialization props.
  * **aggregationRule** (<code>[k8s.AggregationRule](#opencdk8s-cdk8s-argocd-resources-k8s-aggregationrule)</code>)  AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **rules** (<code>Array<[k8s.PolicyRule](#opencdk8s-cdk8s-argocd-resources-k8s-policyrule)></code>)  Rules holds all the PolicyRules for this ClusterRole. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeComponentStatus 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecomponentstatus"></a>

ComponentStatus (and ComponentStatusList) holds the cluster validation info.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.ComponentStatus" API object.

```ts
new k8s.KubeComponentStatus(scope: Construct, id: string, props?: KubeComponentStatusProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeComponentStatusProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubecomponentstatusprops)</code>)  initialization props.
  * **conditions** (<code>Array<[k8s.ComponentCondition](#opencdk8s-cdk8s-argocd-resources-k8s-componentcondition)></code>)  List of component conditions observed. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.ComponentStatus".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecomponentstatus-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.ComponentStatus".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeComponentStatusProps): any
```

* **props** (<code>[k8s.KubeComponentStatusProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubecomponentstatusprops)</code>)  initialization props.
  * **conditions** (<code>Array<[k8s.ComponentCondition](#opencdk8s-cdk8s-argocd-resources-k8s-componentcondition)></code>)  List of component conditions observed. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeComponentStatusList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecomponentstatuslist"></a>

Status of all the conditions for the component as a list of ComponentStatus objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.ComponentStatusList" API object.

```ts
new k8s.KubeComponentStatusList(scope: Construct, id: string, props: KubeComponentStatusListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeComponentStatusListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubecomponentstatuslistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeComponentStatusProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubecomponentstatusprops)></code>)  List of ComponentStatus objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.ComponentStatusList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecomponentstatuslist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.ComponentStatusList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeComponentStatusListProps): any
```

* **props** (<code>[k8s.KubeComponentStatusListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubecomponentstatuslistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeComponentStatusProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubecomponentstatusprops)></code>)  List of ComponentStatus objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeConfigMap 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeconfigmap"></a>

ConfigMap holds configuration data for pods to consume.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.ConfigMap" API object.

```ts
new k8s.KubeConfigMap(scope: Construct, id: string, props?: KubeConfigMapProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeConfigMapProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeconfigmapprops)</code>)  initialization props.
  * **binaryData** (<code>Map<string, string></code>)  BinaryData contains the binary data. __*Optional*__
  * **data** (<code>Map<string, string></code>)  Data contains the configuration data. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.ConfigMap".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeconfigmap-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.ConfigMap".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeConfigMapProps): any
```

* **props** (<code>[k8s.KubeConfigMapProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeconfigmapprops)</code>)  initialization props.
  * **binaryData** (<code>Map<string, string></code>)  BinaryData contains the binary data. __*Optional*__
  * **data** (<code>Map<string, string></code>)  Data contains the configuration data. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeConfigMapList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeconfigmaplist"></a>

ConfigMapList is a resource containing a list of ConfigMap objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.ConfigMapList" API object.

```ts
new k8s.KubeConfigMapList(scope: Construct, id: string, props: KubeConfigMapListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeConfigMapListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeconfigmaplistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeConfigMapProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeconfigmapprops)></code>)  Items is the list of ConfigMaps. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.ConfigMapList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeconfigmaplist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.ConfigMapList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeConfigMapListProps): any
```

* **props** (<code>[k8s.KubeConfigMapListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeconfigmaplistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeConfigMapProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeconfigmapprops)></code>)  Items is the list of ConfigMaps. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeControllerRevision 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevision"></a>

ControllerRevision implements an immutable snapshot of state data.

Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1.ControllerRevision" API object.

```ts
new k8s.KubeControllerRevision(scope: Construct, id: string, props: KubeControllerRevisionProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeControllerRevisionProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionprops)</code>)  initialization props.
  * **revision** (<code>number</code>)  Revision indicates the revision of the state represented by Data. 
  * **data** (<code>[k8s.RawExtension](#opencdk8s-cdk8s-argocd-resources-k8s-rawextension)</code>)  Data is the serialized representation of the state. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1.ControllerRevision".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevision-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1.ControllerRevision".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeControllerRevisionProps): any
```

* **props** (<code>[k8s.KubeControllerRevisionProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionprops)</code>)  initialization props.
  * **revision** (<code>number</code>)  Revision indicates the revision of the state represented by Data. 
  * **data** (<code>[k8s.RawExtension](#opencdk8s-cdk8s-argocd-resources-k8s-rawextension)</code>)  Data is the serialized representation of the state. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeControllerRevisionList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionlist"></a>

ControllerRevisionList is a resource containing a list of ControllerRevision objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1.ControllerRevisionList" API object.

```ts
new k8s.KubeControllerRevisionList(scope: Construct, id: string, props: KubeControllerRevisionListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeControllerRevisionListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeControllerRevisionProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionprops)></code>)  Items is the list of ControllerRevisions. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1.ControllerRevisionList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionlist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1.ControllerRevisionList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeControllerRevisionListProps): any
```

* **props** (<code>[k8s.KubeControllerRevisionListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeControllerRevisionProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionprops)></code>)  Items is the list of ControllerRevisions. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeControllerRevisionListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionlistv1beta1"></a>

ControllerRevisionList is a resource containing a list of ControllerRevision objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1beta1.ControllerRevisionList" API object.

```ts
new k8s.KubeControllerRevisionListV1Beta1(scope: Construct, id: string, props: KubeControllerRevisionListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeControllerRevisionListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeControllerRevisionV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionv1beta1props)></code>)  Items is the list of ControllerRevisions. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1beta1.ControllerRevisionList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionlistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta1.ControllerRevisionList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeControllerRevisionListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeControllerRevisionListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeControllerRevisionV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionv1beta1props)></code>)  Items is the list of ControllerRevisions. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeControllerRevisionListV1Beta2 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionlistv1beta2"></a>

ControllerRevisionList is a resource containing a list of ControllerRevision objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1beta2.ControllerRevisionList" API object.

```ts
new k8s.KubeControllerRevisionListV1Beta2(scope: Construct, id: string, props: KubeControllerRevisionListV1Beta2Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeControllerRevisionListV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionlistv1beta2props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeControllerRevisionV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionv1beta2props)></code>)  Items is the list of ControllerRevisions. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1beta2.ControllerRevisionList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionlistv1beta2-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta2.ControllerRevisionList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeControllerRevisionListV1Beta2Props): any
```

* **props** (<code>[k8s.KubeControllerRevisionListV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionlistv1beta2props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeControllerRevisionV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionv1beta2props)></code>)  Items is the list of ControllerRevisions. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeControllerRevisionV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionv1beta1"></a>

DEPRECATED - This group version of ControllerRevision is deprecated by apps/v1beta2/ControllerRevision.

See the release notes for more information. ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1beta1.ControllerRevision" API object.

```ts
new k8s.KubeControllerRevisionV1Beta1(scope: Construct, id: string, props: KubeControllerRevisionV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeControllerRevisionV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionv1beta1props)</code>)  initialization props.
  * **revision** (<code>number</code>)  Revision indicates the revision of the state represented by Data. 
  * **data** (<code>[k8s.RawExtension](#opencdk8s-cdk8s-argocd-resources-k8s-rawextension)</code>)  Data is the serialized representation of the state. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1beta1.ControllerRevision".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta1.ControllerRevision".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeControllerRevisionV1Beta1Props): any
```

* **props** (<code>[k8s.KubeControllerRevisionV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionv1beta1props)</code>)  initialization props.
  * **revision** (<code>number</code>)  Revision indicates the revision of the state represented by Data. 
  * **data** (<code>[k8s.RawExtension](#opencdk8s-cdk8s-argocd-resources-k8s-rawextension)</code>)  Data is the serialized representation of the state. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeControllerRevisionV1Beta2 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionv1beta2"></a>

DEPRECATED - This group version of ControllerRevision is deprecated by apps/v1/ControllerRevision.

See the release notes for more information. ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1beta2.ControllerRevision" API object.

```ts
new k8s.KubeControllerRevisionV1Beta2(scope: Construct, id: string, props: KubeControllerRevisionV1Beta2Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeControllerRevisionV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionv1beta2props)</code>)  initialization props.
  * **revision** (<code>number</code>)  Revision indicates the revision of the state represented by Data. 
  * **data** (<code>[k8s.RawExtension](#opencdk8s-cdk8s-argocd-resources-k8s-rawextension)</code>)  Data is the serialized representation of the state. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1beta2.ControllerRevision".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionv1beta2-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta2.ControllerRevision".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeControllerRevisionV1Beta2Props): any
```

* **props** (<code>[k8s.KubeControllerRevisionV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionv1beta2props)</code>)  initialization props.
  * **revision** (<code>number</code>)  Revision indicates the revision of the state represented by Data. 
  * **data** (<code>[k8s.RawExtension](#opencdk8s-cdk8s-argocd-resources-k8s-rawextension)</code>)  Data is the serialized representation of the state. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeCronJobListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecronjoblistv1beta1"></a>

CronJobList is a collection of cron jobs.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.batch.v1beta1.CronJobList" API object.

```ts
new k8s.KubeCronJobListV1Beta1(scope: Construct, id: string, props: KubeCronJobListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeCronJobListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjoblistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeCronJobV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjobv1beta1props)></code>)  items is the list of CronJobs. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.batch.v1beta1.CronJobList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecronjoblistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.batch.v1beta1.CronJobList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeCronJobListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeCronJobListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjoblistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeCronJobV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjobv1beta1props)></code>)  items is the list of CronJobs. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeCronJobListV2Alpha1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecronjoblistv2alpha1"></a>

CronJobList is a collection of cron jobs.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.batch.v2alpha1.CronJobList" API object.

```ts
new k8s.KubeCronJobListV2Alpha1(scope: Construct, id: string, props: KubeCronJobListV2Alpha1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeCronJobListV2Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjoblistv2alpha1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeCronJobV2Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjobv2alpha1props)></code>)  items is the list of CronJobs. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.batch.v2alpha1.CronJobList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecronjoblistv2alpha1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.batch.v2alpha1.CronJobList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeCronJobListV2Alpha1Props): any
```

* **props** (<code>[k8s.KubeCronJobListV2Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjoblistv2alpha1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeCronJobV2Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjobv2alpha1props)></code>)  items is the list of CronJobs. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeCronJobV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecronjobv1beta1"></a>

CronJob represents the configuration of a single cron job.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.batch.v1beta1.CronJob" API object.

```ts
new k8s.KubeCronJobV1Beta1(scope: Construct, id: string, props?: KubeCronJobV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeCronJobV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjobv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.CronJobSpec](#opencdk8s-cdk8s-argocd-resources-k8s-cronjobspec)</code>)  Specification of the desired behavior of a cron job, including the schedule. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.batch.v1beta1.CronJob".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecronjobv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.batch.v1beta1.CronJob".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeCronJobV1Beta1Props): any
```

* **props** (<code>[k8s.KubeCronJobV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjobv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.CronJobSpec](#opencdk8s-cdk8s-argocd-resources-k8s-cronjobspec)</code>)  Specification of the desired behavior of a cron job, including the schedule. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeCronJobV2Alpha1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecronjobv2alpha1"></a>

CronJob represents the configuration of a single cron job.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.batch.v2alpha1.CronJob" API object.

```ts
new k8s.KubeCronJobV2Alpha1(scope: Construct, id: string, props?: KubeCronJobV2Alpha1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeCronJobV2Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjobv2alpha1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.CronJobSpec](#opencdk8s-cdk8s-argocd-resources-k8s-cronjobspec)</code>)  Specification of the desired behavior of a cron job, including the schedule. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.batch.v2alpha1.CronJob".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecronjobv2alpha1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.batch.v2alpha1.CronJob".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeCronJobV2Alpha1Props): any
```

* **props** (<code>[k8s.KubeCronJobV2Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjobv2alpha1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.CronJobSpec](#opencdk8s-cdk8s-argocd-resources-k8s-cronjobspec)</code>)  Specification of the desired behavior of a cron job, including the schedule. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeCsiDriverListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecsidriverlistv1beta1"></a>

CSIDriverList is a collection of CSIDriver objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.storage.v1beta1.CSIDriverList" API object.

```ts
new k8s.KubeCsiDriverListV1Beta1(scope: Construct, id: string, props: KubeCsiDriverListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeCsiDriverListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsidriverlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeCsiDriverV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsidriverv1beta1props)></code>)  items is the list of CSIDriver. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.CSIDriverList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecsidriverlistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.CSIDriverList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeCsiDriverListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeCsiDriverListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsidriverlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeCsiDriverV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsidriverv1beta1props)></code>)  items is the list of CSIDriver. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeCsiDriverV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecsidriverv1beta1"></a>

CSIDriver captures information about a Container Storage Interface (CSI) volume driver deployed on the cluster.

CSI drivers do not need to create the CSIDriver object directly. Instead they may use the cluster-driver-registrar sidecar container. When deployed with a CSI driver it automatically creates a CSIDriver object representing the driver. Kubernetes attach detach controller uses this object to determine whether attach is required. Kubelet uses this object to determine whether pod information needs to be passed on mount. CSIDriver objects are non-namespaced.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.storage.v1beta1.CSIDriver" API object.

```ts
new k8s.KubeCsiDriverV1Beta1(scope: Construct, id: string, props: KubeCsiDriverV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeCsiDriverV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsidriverv1beta1props)</code>)  initialization props.
  * **spec** (<code>[k8s.CsiDriverSpec](#opencdk8s-cdk8s-argocd-resources-k8s-csidriverspec)</code>)  Specification of the CSI Driver. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.CSIDriver".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecsidriverv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.CSIDriver".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeCsiDriverV1Beta1Props): any
```

* **props** (<code>[k8s.KubeCsiDriverV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsidriverv1beta1props)</code>)  initialization props.
  * **spec** (<code>[k8s.CsiDriverSpec](#opencdk8s-cdk8s-argocd-resources-k8s-csidriverspec)</code>)  Specification of the CSI Driver. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeCsiNodeListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecsinodelistv1beta1"></a>

CSINodeList is a collection of CSINode objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.storage.v1beta1.CSINodeList" API object.

```ts
new k8s.KubeCsiNodeListV1Beta1(scope: Construct, id: string, props: KubeCsiNodeListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeCsiNodeListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsinodelistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeCsiNodeV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsinodev1beta1props)></code>)  items is the list of CSINode. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.CSINodeList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecsinodelistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.CSINodeList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeCsiNodeListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeCsiNodeListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsinodelistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeCsiNodeV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsinodev1beta1props)></code>)  items is the list of CSINode. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeCsiNodeV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecsinodev1beta1"></a>

CSINode holds information about all CSI drivers installed on a node.

CSI drivers do not need to create the CSINode object directly. As long as they use the node-driver-registrar sidecar container, the kubelet will automatically populate the CSINode object for the CSI driver as part of kubelet plugin registration. CSINode has the same name as a node. If the object is missing, it means either there are no CSI Drivers available on the node, or the Kubelet version is low enough that it doesn't create this object. CSINode has an OwnerReference that points to the corresponding node object.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.storage.v1beta1.CSINode" API object.

```ts
new k8s.KubeCsiNodeV1Beta1(scope: Construct, id: string, props: KubeCsiNodeV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeCsiNodeV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsinodev1beta1props)</code>)  initialization props.
  * **spec** (<code>[k8s.CsiNodeSpec](#opencdk8s-cdk8s-argocd-resources-k8s-csinodespec)</code>)  spec is the specification of CSINode. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  metadata.name must be the Kubernetes node name. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.CSINode".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecsinodev1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.CSINode".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeCsiNodeV1Beta1Props): any
```

* **props** (<code>[k8s.KubeCsiNodeV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsinodev1beta1props)</code>)  initialization props.
  * **spec** (<code>[k8s.CsiNodeSpec](#opencdk8s-cdk8s-argocd-resources-k8s-csinodespec)</code>)  spec is the specification of CSINode. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  metadata.name must be the Kubernetes node name. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeCustomResourceDefinitionListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecustomresourcedefinitionlistv1beta1"></a>

CustomResourceDefinitionList is a list of CustomResourceDefinition objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionList" API object.

```ts
new k8s.KubeCustomResourceDefinitionListV1Beta1(scope: Construct, id: string, props: KubeCustomResourceDefinitionListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeCustomResourceDefinitionListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecustomresourcedefinitionlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeCustomResourceDefinitionV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecustomresourcedefinitionv1beta1props)></code>)  Items individual CustomResourceDefinitions. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecustomresourcedefinitionlistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeCustomResourceDefinitionListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeCustomResourceDefinitionListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecustomresourcedefinitionlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeCustomResourceDefinitionV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecustomresourcedefinitionv1beta1props)></code>)  Items individual CustomResourceDefinitions. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class KubeCustomResourceDefinitionV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecustomresourcedefinitionv1beta1"></a>

CustomResourceDefinition represents a resource that should be exposed on the API server.

Its name MUST be in the format <.spec.name>.<.spec.group>.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinition" API object.

```ts
new k8s.KubeCustomResourceDefinitionV1Beta1(scope: Construct, id: string, props: KubeCustomResourceDefinitionV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeCustomResourceDefinitionV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecustomresourcedefinitionv1beta1props)</code>)  initialization props.
  * **spec** (<code>[k8s.CustomResourceDefinitionSpec](#opencdk8s-cdk8s-argocd-resources-k8s-customresourcedefinitionspec)</code>)  Spec describes how the user wants the resources to appear. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinition".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecustomresourcedefinitionv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinition".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeCustomResourceDefinitionV1Beta1Props): any
```

* **props** (<code>[k8s.KubeCustomResourceDefinitionV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecustomresourcedefinitionv1beta1props)</code>)  initialization props.
  * **spec** (<code>[k8s.CustomResourceDefinitionSpec](#opencdk8s-cdk8s-argocd-resources-k8s-customresourcedefinitionspec)</code>)  Spec describes how the user wants the resources to appear. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class KubeDaemonSet 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonset"></a>

DaemonSet represents the configuration of a daemon set.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1.DaemonSet" API object.

```ts
new k8s.KubeDaemonSet(scope: Construct, id: string, props?: KubeDaemonSetProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeDaemonSetProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.DaemonSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-daemonsetspec)</code>)  The desired behavior of this daemon set. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1.DaemonSet".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonset-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1.DaemonSet".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeDaemonSetProps): any
```

* **props** (<code>[k8s.KubeDaemonSetProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.DaemonSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-daemonsetspec)</code>)  The desired behavior of this daemon set. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeDaemonSetList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetlist"></a>

DaemonSetList is a collection of daemon sets.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1.DaemonSetList" API object.

```ts
new k8s.KubeDaemonSetList(scope: Construct, id: string, props: KubeDaemonSetListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeDaemonSetListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeDaemonSetProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetprops)></code>)  A list of daemon sets. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1.DaemonSetList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetlist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1.DaemonSetList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeDaemonSetListProps): any
```

* **props** (<code>[k8s.KubeDaemonSetListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeDaemonSetProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetprops)></code>)  A list of daemon sets. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeDaemonSetListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetlistv1beta1"></a>

DaemonSetList is a collection of daemon sets.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.extensions.v1beta1.DaemonSetList" API object.

```ts
new k8s.KubeDaemonSetListV1Beta1(scope: Construct, id: string, props: KubeDaemonSetListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeDaemonSetListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeDaemonSetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetv1beta1props)></code>)  A list of daemon sets. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.extensions.v1beta1.DaemonSetList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetlistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.extensions.v1beta1.DaemonSetList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeDaemonSetListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeDaemonSetListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeDaemonSetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetv1beta1props)></code>)  A list of daemon sets. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeDaemonSetListV1Beta2 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetlistv1beta2"></a>

DaemonSetList is a collection of daemon sets.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1beta2.DaemonSetList" API object.

```ts
new k8s.KubeDaemonSetListV1Beta2(scope: Construct, id: string, props: KubeDaemonSetListV1Beta2Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeDaemonSetListV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetlistv1beta2props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeDaemonSetV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetv1beta2props)></code>)  A list of daemon sets. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1beta2.DaemonSetList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetlistv1beta2-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta2.DaemonSetList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeDaemonSetListV1Beta2Props): any
```

* **props** (<code>[k8s.KubeDaemonSetListV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetlistv1beta2props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeDaemonSetV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetv1beta2props)></code>)  A list of daemon sets. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeDaemonSetV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetv1beta1"></a>

DEPRECATED - This group version of DaemonSet is deprecated by apps/v1beta2/DaemonSet.

See the release notes for more information. DaemonSet represents the configuration of a daemon set.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.extensions.v1beta1.DaemonSet" API object.

```ts
new k8s.KubeDaemonSetV1Beta1(scope: Construct, id: string, props?: KubeDaemonSetV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeDaemonSetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.DaemonSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-daemonsetspec)</code>)  The desired behavior of this daemon set. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.extensions.v1beta1.DaemonSet".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.extensions.v1beta1.DaemonSet".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeDaemonSetV1Beta1Props): any
```

* **props** (<code>[k8s.KubeDaemonSetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.DaemonSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-daemonsetspec)</code>)  The desired behavior of this daemon set. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeDaemonSetV1Beta2 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetv1beta2"></a>

DEPRECATED - This group version of DaemonSet is deprecated by apps/v1/DaemonSet.

See the release notes for more information. DaemonSet represents the configuration of a daemon set.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1beta2.DaemonSet" API object.

```ts
new k8s.KubeDaemonSetV1Beta2(scope: Construct, id: string, props?: KubeDaemonSetV1Beta2Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeDaemonSetV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetv1beta2props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.DaemonSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-daemonsetspec)</code>)  The desired behavior of this daemon set. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1beta2.DaemonSet".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetv1beta2-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta2.DaemonSet".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeDaemonSetV1Beta2Props): any
```

* **props** (<code>[k8s.KubeDaemonSetV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetv1beta2props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.DaemonSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-daemonsetspec)</code>)  The desired behavior of this daemon set. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeDeployment 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedeployment"></a>

Deployment enables declarative updates for Pods and ReplicaSets.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1.Deployment" API object.

```ts
new k8s.KubeDeployment(scope: Construct, id: string, props?: KubeDeploymentProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeDeploymentProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata. __*Optional*__
  * **spec** (<code>[k8s.DeploymentSpec](#opencdk8s-cdk8s-argocd-resources-k8s-deploymentspec)</code>)  Specification of the desired behavior of the Deployment. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1.Deployment".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedeployment-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1.Deployment".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeDeploymentProps): any
```

* **props** (<code>[k8s.KubeDeploymentProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata. __*Optional*__
  * **spec** (<code>[k8s.DeploymentSpec](#opencdk8s-cdk8s-argocd-resources-k8s-deploymentspec)</code>)  Specification of the desired behavior of the Deployment. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeDeploymentList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentlist"></a>

DeploymentList is a list of Deployments.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1.DeploymentList" API object.

```ts
new k8s.KubeDeploymentList(scope: Construct, id: string, props: KubeDeploymentListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeDeploymentListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeDeploymentProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentprops)></code>)  Items is the list of Deployments. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1.DeploymentList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentlist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1.DeploymentList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeDeploymentListProps): any
```

* **props** (<code>[k8s.KubeDeploymentListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeDeploymentProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentprops)></code>)  Items is the list of Deployments. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeDeploymentListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentlistv1beta1"></a>

DeploymentList is a list of Deployments.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.extensions.v1beta1.DeploymentList" API object.

```ts
new k8s.KubeDeploymentListV1Beta1(scope: Construct, id: string, props: KubeDeploymentListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeDeploymentListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeDeploymentV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentv1beta1props)></code>)  Items is the list of Deployments. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.extensions.v1beta1.DeploymentList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentlistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.extensions.v1beta1.DeploymentList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeDeploymentListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeDeploymentListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeDeploymentV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentv1beta1props)></code>)  Items is the list of Deployments. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeDeploymentListV1Beta2 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentlistv1beta2"></a>

DeploymentList is a list of Deployments.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1beta2.DeploymentList" API object.

```ts
new k8s.KubeDeploymentListV1Beta2(scope: Construct, id: string, props: KubeDeploymentListV1Beta2Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeDeploymentListV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentlistv1beta2props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeDeploymentV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentv1beta2props)></code>)  Items is the list of Deployments. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1beta2.DeploymentList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentlistv1beta2-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta2.DeploymentList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeDeploymentListV1Beta2Props): any
```

* **props** (<code>[k8s.KubeDeploymentListV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentlistv1beta2props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeDeploymentV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentv1beta2props)></code>)  Items is the list of Deployments. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeDeploymentV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentv1beta1"></a>

DEPRECATED - This group version of Deployment is deprecated by apps/v1beta2/Deployment.

See the release notes for more information. Deployment enables declarative updates for Pods and ReplicaSets.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.extensions.v1beta1.Deployment" API object.

```ts
new k8s.KubeDeploymentV1Beta1(scope: Construct, id: string, props?: KubeDeploymentV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeDeploymentV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata. __*Optional*__
  * **spec** (<code>[k8s.DeploymentSpec](#opencdk8s-cdk8s-argocd-resources-k8s-deploymentspec)</code>)  Specification of the desired behavior of the Deployment. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.extensions.v1beta1.Deployment".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.extensions.v1beta1.Deployment".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeDeploymentV1Beta1Props): any
```

* **props** (<code>[k8s.KubeDeploymentV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata. __*Optional*__
  * **spec** (<code>[k8s.DeploymentSpec](#opencdk8s-cdk8s-argocd-resources-k8s-deploymentspec)</code>)  Specification of the desired behavior of the Deployment. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeDeploymentV1Beta2 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentv1beta2"></a>

DEPRECATED - This group version of Deployment is deprecated by apps/v1/Deployment.

See the release notes for more information. Deployment enables declarative updates for Pods and ReplicaSets.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1beta2.Deployment" API object.

```ts
new k8s.KubeDeploymentV1Beta2(scope: Construct, id: string, props?: KubeDeploymentV1Beta2Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeDeploymentV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentv1beta2props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata. __*Optional*__
  * **spec** (<code>[k8s.DeploymentSpec](#opencdk8s-cdk8s-argocd-resources-k8s-deploymentspec)</code>)  Specification of the desired behavior of the Deployment. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1beta2.Deployment".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentv1beta2-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta2.Deployment".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeDeploymentV1Beta2Props): any
```

* **props** (<code>[k8s.KubeDeploymentV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentv1beta2props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata. __*Optional*__
  * **spec** (<code>[k8s.DeploymentSpec](#opencdk8s-cdk8s-argocd-resources-k8s-deploymentspec)</code>)  Specification of the desired behavior of the Deployment. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeEndpoints 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeendpoints"></a>

Endpoints is a collection of endpoints that implement the actual service.

Example:
Name: "mysvc",
Subsets: [
  {
    Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
    Ports: [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
  },
  {
    Addresses: [{"ip": "10.10.3.3"}],
    Ports: [{"name": "a", "port": 93}, {"name": "b", "port": 76}]
  },
]

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.Endpoints" API object.

```ts
new k8s.KubeEndpoints(scope: Construct, id: string, props?: KubeEndpointsProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeEndpointsProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeendpointsprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **subsets** (<code>Array<[k8s.EndpointSubset](#opencdk8s-cdk8s-argocd-resources-k8s-endpointsubset)></code>)  The set of all endpoints is the union of all subsets. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.Endpoints".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeendpoints-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.Endpoints".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeEndpointsProps): any
```

* **props** (<code>[k8s.KubeEndpointsProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeendpointsprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **subsets** (<code>Array<[k8s.EndpointSubset](#opencdk8s-cdk8s-argocd-resources-k8s-endpointsubset)></code>)  The set of all endpoints is the union of all subsets. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeEndpointsList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeendpointslist"></a>

EndpointsList is a list of endpoints.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.EndpointsList" API object.

```ts
new k8s.KubeEndpointsList(scope: Construct, id: string, props: KubeEndpointsListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeEndpointsListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeendpointslistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeEndpointsProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeendpointsprops)></code>)  List of endpoints. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.EndpointsList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeendpointslist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.EndpointsList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeEndpointsListProps): any
```

* **props** (<code>[k8s.KubeEndpointsListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeendpointslistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeEndpointsProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeendpointsprops)></code>)  List of endpoints. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeEvent 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeevent"></a>

Event is a report of an event somewhere in the cluster.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.Event" API object.

```ts
new k8s.KubeEvent(scope: Construct, id: string, props: KubeEventProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeEventProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeeventprops)</code>)  initialization props.
  * **involvedObject** (<code>[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)</code>)  The object that this event is about. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. 
  * **action** (<code>string</code>)  What action was taken/failed regarding to the Regarding object. __*Optional*__
  * **count** (<code>number</code>)  The number of times this event has occurred. __*Optional*__
  * **eventTime** (<code>date</code>)  Time when this Event was first observed. __*Optional*__
  * **firstTimestamp** (<code>date</code>)  The time at which the event was first recorded. __*Optional*__
  * **lastTimestamp** (<code>date</code>)  The time at which the most recent occurrence of this event was recorded. __*Optional*__
  * **message** (<code>string</code>)  A human-readable description of the status of this operation. __*Optional*__
  * **reason** (<code>string</code>)  This should be a short, machine understandable string that gives the reason for the transition into the object's current status. __*Optional*__
  * **related** (<code>[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)</code>)  Optional secondary object for more complex actions. __*Optional*__
  * **reportingComponent** (<code>string</code>)  Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`. __*Optional*__
  * **reportingInstance** (<code>string</code>)  ID of the controller instance, e.g. `kubelet-xyzf`. __*Optional*__
  * **series** (<code>[k8s.EventSeries](#opencdk8s-cdk8s-argocd-resources-k8s-eventseries)</code>)  Data about the Event series this event represents or nil if it's a singleton Event. __*Optional*__
  * **source** (<code>[k8s.EventSource](#opencdk8s-cdk8s-argocd-resources-k8s-eventsource)</code>)  The component reporting this event. __*Optional*__
  * **type** (<code>string</code>)  Type of this event (Normal, Warning), new types could be added in the future. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.Event".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeevent-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.Event".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeEventProps): any
```

* **props** (<code>[k8s.KubeEventProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeeventprops)</code>)  initialization props.
  * **involvedObject** (<code>[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)</code>)  The object that this event is about. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. 
  * **action** (<code>string</code>)  What action was taken/failed regarding to the Regarding object. __*Optional*__
  * **count** (<code>number</code>)  The number of times this event has occurred. __*Optional*__
  * **eventTime** (<code>date</code>)  Time when this Event was first observed. __*Optional*__
  * **firstTimestamp** (<code>date</code>)  The time at which the event was first recorded. __*Optional*__
  * **lastTimestamp** (<code>date</code>)  The time at which the most recent occurrence of this event was recorded. __*Optional*__
  * **message** (<code>string</code>)  A human-readable description of the status of this operation. __*Optional*__
  * **reason** (<code>string</code>)  This should be a short, machine understandable string that gives the reason for the transition into the object's current status. __*Optional*__
  * **related** (<code>[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)</code>)  Optional secondary object for more complex actions. __*Optional*__
  * **reportingComponent** (<code>string</code>)  Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`. __*Optional*__
  * **reportingInstance** (<code>string</code>)  ID of the controller instance, e.g. `kubelet-xyzf`. __*Optional*__
  * **series** (<code>[k8s.EventSeries](#opencdk8s-cdk8s-argocd-resources-k8s-eventseries)</code>)  Data about the Event series this event represents or nil if it's a singleton Event. __*Optional*__
  * **source** (<code>[k8s.EventSource](#opencdk8s-cdk8s-argocd-resources-k8s-eventsource)</code>)  The component reporting this event. __*Optional*__
  * **type** (<code>string</code>)  Type of this event (Normal, Warning), new types could be added in the future. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeEventList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeeventlist"></a>

EventList is a list of events.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.EventList" API object.

```ts
new k8s.KubeEventList(scope: Construct, id: string, props: KubeEventListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeEventListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeeventlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeEventProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeeventprops)></code>)  List of events. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.EventList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeeventlist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.EventList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeEventListProps): any
```

* **props** (<code>[k8s.KubeEventListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeeventlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeEventProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeeventprops)></code>)  List of events. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeEventListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeeventlistv1beta1"></a>

EventList is a list of Event objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.events.v1beta1.EventList" API object.

```ts
new k8s.KubeEventListV1Beta1(scope: Construct, id: string, props: KubeEventListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeEventListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeeventlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeEventV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeeventv1beta1props)></code>)  Items is a list of schema objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.events.v1beta1.EventList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeeventlistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.events.v1beta1.EventList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeEventListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeEventListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeeventlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeEventV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeeventv1beta1props)></code>)  Items is a list of schema objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeEventV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeeventv1beta1"></a>

Event is a report of an event somewhere in the cluster.

It generally denotes some state change in the system.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.events.v1beta1.Event" API object.

```ts
new k8s.KubeEventV1Beta1(scope: Construct, id: string, props: KubeEventV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeEventV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeeventv1beta1props)</code>)  initialization props.
  * **eventTime** (<code>date</code>)  Required. 
  * **action** (<code>string</code>)  What action was taken/failed regarding to the regarding object. __*Optional*__
  * **deprecatedCount** (<code>number</code>)  Deprecated field assuring backward compatibility with core.v1 Event type. __*Optional*__
  * **deprecatedFirstTimestamp** (<code>date</code>)  Deprecated field assuring backward compatibility with core.v1 Event type. __*Optional*__
  * **deprecatedLastTimestamp** (<code>date</code>)  Deprecated field assuring backward compatibility with core.v1 Event type. __*Optional*__
  * **deprecatedSource** (<code>[k8s.EventSource](#opencdk8s-cdk8s-argocd-resources-k8s-eventsource)</code>)  Deprecated field assuring backward compatibility with core.v1 Event type. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **note** (<code>string</code>)  Optional. __*Optional*__
  * **reason** (<code>string</code>)  Why the action was taken. __*Optional*__
  * **regarding** (<code>[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)</code>)  The object this Event is about. __*Optional*__
  * **related** (<code>[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)</code>)  Optional secondary object for more complex actions. __*Optional*__
  * **reportingController** (<code>string</code>)  Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`. __*Optional*__
  * **reportingInstance** (<code>string</code>)  ID of the controller instance, e.g. `kubelet-xyzf`. __*Optional*__
  * **series** (<code>[k8s.EventSeries](#opencdk8s-cdk8s-argocd-resources-k8s-eventseries)</code>)  Data about the Event series this event represents or nil if it's a singleton Event. __*Optional*__
  * **type** (<code>string</code>)  Type of this event (Normal, Warning), new types could be added in the future. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.events.v1beta1.Event".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeeventv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.events.v1beta1.Event".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeEventV1Beta1Props): any
```

* **props** (<code>[k8s.KubeEventV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeeventv1beta1props)</code>)  initialization props.
  * **eventTime** (<code>date</code>)  Required. 
  * **action** (<code>string</code>)  What action was taken/failed regarding to the regarding object. __*Optional*__
  * **deprecatedCount** (<code>number</code>)  Deprecated field assuring backward compatibility with core.v1 Event type. __*Optional*__
  * **deprecatedFirstTimestamp** (<code>date</code>)  Deprecated field assuring backward compatibility with core.v1 Event type. __*Optional*__
  * **deprecatedLastTimestamp** (<code>date</code>)  Deprecated field assuring backward compatibility with core.v1 Event type. __*Optional*__
  * **deprecatedSource** (<code>[k8s.EventSource](#opencdk8s-cdk8s-argocd-resources-k8s-eventsource)</code>)  Deprecated field assuring backward compatibility with core.v1 Event type. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **note** (<code>string</code>)  Optional. __*Optional*__
  * **reason** (<code>string</code>)  Why the action was taken. __*Optional*__
  * **regarding** (<code>[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)</code>)  The object this Event is about. __*Optional*__
  * **related** (<code>[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)</code>)  Optional secondary object for more complex actions. __*Optional*__
  * **reportingController** (<code>string</code>)  Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`. __*Optional*__
  * **reportingInstance** (<code>string</code>)  ID of the controller instance, e.g. `kubelet-xyzf`. __*Optional*__
  * **series** (<code>[k8s.EventSeries](#opencdk8s-cdk8s-argocd-resources-k8s-eventseries)</code>)  Data about the Event series this event represents or nil if it's a singleton Event. __*Optional*__
  * **type** (<code>string</code>)  Type of this event (Normal, Warning), new types could be added in the future. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeEvictionV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeevictionv1beta1"></a>

Eviction evicts a pod from its node subject to certain policies and safety constraints.

This is a subresource of Pod.  A request to cause such an eviction is created by POSTing to .../pods/<pod name>/evictions.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.policy.v1beta1.Eviction" API object.

```ts
new k8s.KubeEvictionV1Beta1(scope: Construct, id: string, props?: KubeEvictionV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeEvictionV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeevictionv1beta1props)</code>)  initialization props.
  * **deleteOptions** (<code>[k8s.DeleteOptions](#opencdk8s-cdk8s-argocd-resources-k8s-deleteoptions)</code>)  DeleteOptions may be provided. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  ObjectMeta describes the pod that is being evicted. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.Eviction".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeevictionv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.Eviction".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeEvictionV1Beta1Props): any
```

* **props** (<code>[k8s.KubeEvictionV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeevictionv1beta1props)</code>)  initialization props.
  * **deleteOptions** (<code>[k8s.DeleteOptions](#opencdk8s-cdk8s-argocd-resources-k8s-deleteoptions)</code>)  DeleteOptions may be provided. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  ObjectMeta describes the pod that is being evicted. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeHorizontalPodAutoscaler 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscaler"></a>

configuration of a horizontal pod autoscaler.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler" API object.

```ts
new k8s.KubeHorizontalPodAutoscaler(scope: Construct, id: string, props?: KubeHorizontalPodAutoscalerProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeHorizontalPodAutoscalerProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata. __*Optional*__
  * **spec** (<code>[k8s.HorizontalPodAutoscalerSpec](#opencdk8s-cdk8s-argocd-resources-k8s-horizontalpodautoscalerspec)</code>)  behaviour of autoscaler. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscaler-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeHorizontalPodAutoscalerProps): any
```

* **props** (<code>[k8s.KubeHorizontalPodAutoscalerProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata. __*Optional*__
  * **spec** (<code>[k8s.HorizontalPodAutoscalerSpec](#opencdk8s-cdk8s-argocd-resources-k8s-horizontalpodautoscalerspec)</code>)  behaviour of autoscaler. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeHorizontalPodAutoscalerList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerlist"></a>

list of horizontal pod autoscaler objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList" API object.

```ts
new k8s.KubeHorizontalPodAutoscalerList(scope: Construct, id: string, props: KubeHorizontalPodAutoscalerListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeHorizontalPodAutoscalerListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeHorizontalPodAutoscalerProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerprops)></code>)  list of horizontal pod autoscaler objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerlist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeHorizontalPodAutoscalerListProps): any
```

* **props** (<code>[k8s.KubeHorizontalPodAutoscalerListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeHorizontalPodAutoscalerProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerprops)></code>)  list of horizontal pod autoscaler objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeHorizontalPodAutoscalerListV2Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerlistv2beta1"></a>

HorizontalPodAutoscaler is a list of horizontal pod autoscaler objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerList" API object.

```ts
new k8s.KubeHorizontalPodAutoscalerListV2Beta1(scope: Construct, id: string, props: KubeHorizontalPodAutoscalerListV2Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeHorizontalPodAutoscalerListV2Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerlistv2beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeHorizontalPodAutoscalerV2Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerv2beta1props)></code>)  items is the list of horizontal pod autoscaler objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  metadata is the standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerlistv2beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeHorizontalPodAutoscalerListV2Beta1Props): any
```

* **props** (<code>[k8s.KubeHorizontalPodAutoscalerListV2Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerlistv2beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeHorizontalPodAutoscalerV2Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerv2beta1props)></code>)  items is the list of horizontal pod autoscaler objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  metadata is the standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeHorizontalPodAutoscalerListV2Beta2 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerlistv2beta2"></a>

HorizontalPodAutoscalerList is a list of horizontal pod autoscaler objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList" API object.

```ts
new k8s.KubeHorizontalPodAutoscalerListV2Beta2(scope: Construct, id: string, props: KubeHorizontalPodAutoscalerListV2Beta2Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeHorizontalPodAutoscalerListV2Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerlistv2beta2props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeHorizontalPodAutoscalerV2Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerv2beta2props)></code>)  items is the list of horizontal pod autoscaler objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  metadata is the standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerlistv2beta2-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeHorizontalPodAutoscalerListV2Beta2Props): any
```

* **props** (<code>[k8s.KubeHorizontalPodAutoscalerListV2Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerlistv2beta2props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeHorizontalPodAutoscalerV2Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerv2beta2props)></code>)  items is the list of horizontal pod autoscaler objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  metadata is the standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeHorizontalPodAutoscalerV2Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerv2beta1"></a>

HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscaler" API object.

```ts
new k8s.KubeHorizontalPodAutoscalerV2Beta1(scope: Construct, id: string, props?: KubeHorizontalPodAutoscalerV2Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeHorizontalPodAutoscalerV2Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerv2beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  metadata is the standard object metadata. __*Optional*__
  * **spec** (<code>[k8s.HorizontalPodAutoscalerSpec](#opencdk8s-cdk8s-argocd-resources-k8s-horizontalpodautoscalerspec)</code>)  spec is the specification for the behaviour of the autoscaler. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscaler".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerv2beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscaler".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeHorizontalPodAutoscalerV2Beta1Props): any
```

* **props** (<code>[k8s.KubeHorizontalPodAutoscalerV2Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerv2beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  metadata is the standard object metadata. __*Optional*__
  * **spec** (<code>[k8s.HorizontalPodAutoscalerSpec](#opencdk8s-cdk8s-argocd-resources-k8s-horizontalpodautoscalerspec)</code>)  spec is the specification for the behaviour of the autoscaler. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeHorizontalPodAutoscalerV2Beta2 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerv2beta2"></a>

HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler" API object.

```ts
new k8s.KubeHorizontalPodAutoscalerV2Beta2(scope: Construct, id: string, props?: KubeHorizontalPodAutoscalerV2Beta2Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeHorizontalPodAutoscalerV2Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerv2beta2props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  metadata is the standard object metadata. __*Optional*__
  * **spec** (<code>[k8s.HorizontalPodAutoscalerSpec](#opencdk8s-cdk8s-argocd-resources-k8s-horizontalpodautoscalerspec)</code>)  spec is the specification for the behaviour of the autoscaler. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerv2beta2-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeHorizontalPodAutoscalerV2Beta2Props): any
```

* **props** (<code>[k8s.KubeHorizontalPodAutoscalerV2Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerv2beta2props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  metadata is the standard object metadata. __*Optional*__
  * **spec** (<code>[k8s.HorizontalPodAutoscalerSpec](#opencdk8s-cdk8s-argocd-resources-k8s-horizontalpodautoscalerspec)</code>)  spec is the specification for the behaviour of the autoscaler. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeIngressListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeingresslistv1beta1"></a>

IngressList is a collection of Ingress.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.networking.v1beta1.IngressList" API object.

```ts
new k8s.KubeIngressListV1Beta1(scope: Construct, id: string, props: KubeIngressListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeIngressListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeingresslistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeIngressV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeingressv1beta1props)></code>)  Items is the list of Ingress. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.networking.v1beta1.IngressList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeingresslistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.networking.v1beta1.IngressList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeIngressListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeIngressListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeingresslistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeIngressV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeingressv1beta1props)></code>)  Items is the list of Ingress. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeIngressV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeingressv1beta1"></a>

Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend.

An Ingress can be configured to give services externally-reachable urls, load balance traffic, terminate SSL, offer name based virtual hosting etc.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.networking.v1beta1.Ingress" API object.

```ts
new k8s.KubeIngressV1Beta1(scope: Construct, id: string, props?: KubeIngressV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeIngressV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeingressv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.IngressSpec](#opencdk8s-cdk8s-argocd-resources-k8s-ingressspec)</code>)  Spec is the desired state of the Ingress. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.networking.v1beta1.Ingress".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeingressv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.networking.v1beta1.Ingress".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeIngressV1Beta1Props): any
```

* **props** (<code>[k8s.KubeIngressV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeingressv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.IngressSpec](#opencdk8s-cdk8s-argocd-resources-k8s-ingressspec)</code>)  Spec is the desired state of the Ingress. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeJob 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubejob"></a>

Job represents the configuration of a single job.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.batch.v1.Job" API object.

```ts
new k8s.KubeJob(scope: Construct, id: string, props?: KubeJobProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeJobProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubejobprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.JobSpec](#opencdk8s-cdk8s-argocd-resources-k8s-jobspec)</code>)  Specification of the desired behavior of a job. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.batch.v1.Job".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubejob-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.batch.v1.Job".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeJobProps): any
```

* **props** (<code>[k8s.KubeJobProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubejobprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.JobSpec](#opencdk8s-cdk8s-argocd-resources-k8s-jobspec)</code>)  Specification of the desired behavior of a job. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeJobList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubejoblist"></a>

JobList is a collection of jobs.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.batch.v1.JobList" API object.

```ts
new k8s.KubeJobList(scope: Construct, id: string, props: KubeJobListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeJobListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubejoblistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeJobProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubejobprops)></code>)  items is the list of Jobs. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.batch.v1.JobList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubejoblist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.batch.v1.JobList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeJobListProps): any
```

* **props** (<code>[k8s.KubeJobListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubejoblistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeJobProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubejobprops)></code>)  items is the list of Jobs. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeLease 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubelease"></a>

Lease defines a lease concept.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.coordination.v1.Lease" API object.

```ts
new k8s.KubeLease(scope: Construct, id: string, props?: KubeLeaseProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeLeaseProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeleaseprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__
  * **spec** (<code>[k8s.LeaseSpec](#opencdk8s-cdk8s-argocd-resources-k8s-leasespec)</code>)  Specification of the Lease. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.coordination.v1.Lease".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubelease-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.coordination.v1.Lease".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeLeaseProps): any
```

* **props** (<code>[k8s.KubeLeaseProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeleaseprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__
  * **spec** (<code>[k8s.LeaseSpec](#opencdk8s-cdk8s-argocd-resources-k8s-leasespec)</code>)  Specification of the Lease. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeLeaseList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeleaselist"></a>

LeaseList is a list of Lease objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.coordination.v1.LeaseList" API object.

```ts
new k8s.KubeLeaseList(scope: Construct, id: string, props: KubeLeaseListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeLeaseListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeleaselistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeLeaseProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeleaseprops)></code>)  Items is a list of schema objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.coordination.v1.LeaseList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeleaselist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.coordination.v1.LeaseList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeLeaseListProps): any
```

* **props** (<code>[k8s.KubeLeaseListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeleaselistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeLeaseProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeleaseprops)></code>)  Items is a list of schema objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeLeaseListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeleaselistv1beta1"></a>

LeaseList is a list of Lease objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.coordination.v1beta1.LeaseList" API object.

```ts
new k8s.KubeLeaseListV1Beta1(scope: Construct, id: string, props: KubeLeaseListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeLeaseListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeleaselistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeLeaseV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeleasev1beta1props)></code>)  Items is a list of schema objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.coordination.v1beta1.LeaseList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeleaselistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.coordination.v1beta1.LeaseList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeLeaseListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeLeaseListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeleaselistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeLeaseV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeleasev1beta1props)></code>)  Items is a list of schema objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeLeaseV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeleasev1beta1"></a>

Lease defines a lease concept.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.coordination.v1beta1.Lease" API object.

```ts
new k8s.KubeLeaseV1Beta1(scope: Construct, id: string, props?: KubeLeaseV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeLeaseV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeleasev1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__
  * **spec** (<code>[k8s.LeaseSpec](#opencdk8s-cdk8s-argocd-resources-k8s-leasespec)</code>)  Specification of the Lease. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.coordination.v1beta1.Lease".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeleasev1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.coordination.v1beta1.Lease".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeLeaseV1Beta1Props): any
```

* **props** (<code>[k8s.KubeLeaseV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeleasev1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__
  * **spec** (<code>[k8s.LeaseSpec](#opencdk8s-cdk8s-argocd-resources-k8s-leasespec)</code>)  Specification of the Lease. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeLimitRange 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubelimitrange"></a>

LimitRange sets resource usage limits for each kind of resource in a Namespace.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.LimitRange" API object.

```ts
new k8s.KubeLimitRange(scope: Construct, id: string, props?: KubeLimitRangeProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeLimitRangeProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubelimitrangeprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.LimitRangeSpec](#opencdk8s-cdk8s-argocd-resources-k8s-limitrangespec)</code>)  Spec defines the limits enforced. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.LimitRange".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubelimitrange-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.LimitRange".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeLimitRangeProps): any
```

* **props** (<code>[k8s.KubeLimitRangeProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubelimitrangeprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.LimitRangeSpec](#opencdk8s-cdk8s-argocd-resources-k8s-limitrangespec)</code>)  Spec defines the limits enforced. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeLimitRangeList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubelimitrangelist"></a>

LimitRangeList is a list of LimitRange items.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.LimitRangeList" API object.

```ts
new k8s.KubeLimitRangeList(scope: Construct, id: string, props: KubeLimitRangeListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeLimitRangeListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubelimitrangelistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeLimitRangeProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubelimitrangeprops)></code>)  Items is a list of LimitRange objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.LimitRangeList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubelimitrangelist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.LimitRangeList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeLimitRangeListProps): any
```

* **props** (<code>[k8s.KubeLimitRangeListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubelimitrangelistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeLimitRangeProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubelimitrangeprops)></code>)  Items is a list of LimitRange objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeLocalSubjectAccessReview 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubelocalsubjectaccessreview"></a>

LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace.

Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.authorization.v1.LocalSubjectAccessReview" API object.

```ts
new k8s.KubeLocalSubjectAccessReview(scope: Construct, id: string, props: KubeLocalSubjectAccessReviewProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeLocalSubjectAccessReviewProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubelocalsubjectaccessreviewprops)</code>)  initialization props.
  * **spec** (<code>[k8s.SubjectAccessReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-subjectaccessreviewspec)</code>)  Spec holds information about the request being evaluated. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.authorization.v1.LocalSubjectAccessReview".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubelocalsubjectaccessreview-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.authorization.v1.LocalSubjectAccessReview".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeLocalSubjectAccessReviewProps): any
```

* **props** (<code>[k8s.KubeLocalSubjectAccessReviewProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubelocalsubjectaccessreviewprops)</code>)  initialization props.
  * **spec** (<code>[k8s.SubjectAccessReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-subjectaccessreviewspec)</code>)  Spec holds information about the request being evaluated. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class KubeLocalSubjectAccessReviewV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubelocalsubjectaccessreviewv1beta1"></a>

LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace.

Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.authorization.v1beta1.LocalSubjectAccessReview" API object.

```ts
new k8s.KubeLocalSubjectAccessReviewV1Beta1(scope: Construct, id: string, props: KubeLocalSubjectAccessReviewV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeLocalSubjectAccessReviewV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubelocalsubjectaccessreviewv1beta1props)</code>)  initialization props.
  * **spec** (<code>[k8s.SubjectAccessReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-subjectaccessreviewspec)</code>)  Spec holds information about the request being evaluated. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.authorization.v1beta1.LocalSubjectAccessReview".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubelocalsubjectaccessreviewv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.authorization.v1beta1.LocalSubjectAccessReview".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeLocalSubjectAccessReviewV1Beta1Props): any
```

* **props** (<code>[k8s.KubeLocalSubjectAccessReviewV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubelocalsubjectaccessreviewv1beta1props)</code>)  initialization props.
  * **spec** (<code>[k8s.SubjectAccessReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-subjectaccessreviewspec)</code>)  Spec holds information about the request being evaluated. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class KubeMutatingWebhookConfigurationListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubemutatingwebhookconfigurationlistv1beta1"></a>

MutatingWebhookConfigurationList is a list of MutatingWebhookConfiguration.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfigurationList" API object.

```ts
new k8s.KubeMutatingWebhookConfigurationListV1Beta1(scope: Construct, id: string, props: KubeMutatingWebhookConfigurationListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeMutatingWebhookConfigurationListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubemutatingwebhookconfigurationlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeMutatingWebhookConfigurationV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubemutatingwebhookconfigurationv1beta1props)></code>)  List of MutatingWebhookConfiguration. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfigurationList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubemutatingwebhookconfigurationlistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfigurationList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeMutatingWebhookConfigurationListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeMutatingWebhookConfigurationListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubemutatingwebhookconfigurationlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeMutatingWebhookConfigurationV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubemutatingwebhookconfigurationv1beta1props)></code>)  List of MutatingWebhookConfiguration. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeMutatingWebhookConfigurationV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubemutatingwebhookconfigurationv1beta1"></a>

MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfiguration" API object.

```ts
new k8s.KubeMutatingWebhookConfigurationV1Beta1(scope: Construct, id: string, props?: KubeMutatingWebhookConfigurationV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeMutatingWebhookConfigurationV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubemutatingwebhookconfigurationv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata; __*Optional*__
  * **webhooks** (<code>Array<[k8s.MutatingWebhook](#opencdk8s-cdk8s-argocd-resources-k8s-mutatingwebhook)></code>)  Webhooks is a list of webhooks and the affected resources and operations. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfiguration".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubemutatingwebhookconfigurationv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfiguration".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeMutatingWebhookConfigurationV1Beta1Props): any
```

* **props** (<code>[k8s.KubeMutatingWebhookConfigurationV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubemutatingwebhookconfigurationv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata; __*Optional*__
  * **webhooks** (<code>Array<[k8s.MutatingWebhook](#opencdk8s-cdk8s-argocd-resources-k8s-mutatingwebhook)></code>)  Webhooks is a list of webhooks and the affected resources and operations. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeNamespace 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenamespace"></a>

Namespace provides a scope for Names.

Use of multiple namespaces is optional.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.Namespace" API object.

```ts
new k8s.KubeNamespace(scope: Construct, id: string, props?: KubeNamespaceProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeNamespaceProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenamespaceprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.NamespaceSpec](#opencdk8s-cdk8s-argocd-resources-k8s-namespacespec)</code>)  Spec defines the behavior of the Namespace. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.Namespace".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenamespace-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.Namespace".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeNamespaceProps): any
```

* **props** (<code>[k8s.KubeNamespaceProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenamespaceprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.NamespaceSpec](#opencdk8s-cdk8s-argocd-resources-k8s-namespacespec)</code>)  Spec defines the behavior of the Namespace. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeNamespaceList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenamespacelist"></a>

NamespaceList is a list of Namespaces.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.NamespaceList" API object.

```ts
new k8s.KubeNamespaceList(scope: Construct, id: string, props: KubeNamespaceListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeNamespaceListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenamespacelistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeNamespaceProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenamespaceprops)></code>)  Items is the list of Namespace objects in the list. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.NamespaceList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenamespacelist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.NamespaceList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeNamespaceListProps): any
```

* **props** (<code>[k8s.KubeNamespaceListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenamespacelistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeNamespaceProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenamespaceprops)></code>)  Items is the list of Namespace objects in the list. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeNetworkPolicy 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicy"></a>

NetworkPolicy describes what network traffic is allowed for a set of Pods.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.networking.v1.NetworkPolicy" API object.

```ts
new k8s.KubeNetworkPolicy(scope: Construct, id: string, props?: KubeNetworkPolicyProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeNetworkPolicyProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicyprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.NetworkPolicySpec](#opencdk8s-cdk8s-argocd-resources-k8s-networkpolicyspec)</code>)  Specification of the desired behavior for this NetworkPolicy. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.networking.v1.NetworkPolicy".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicy-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.networking.v1.NetworkPolicy".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeNetworkPolicyProps): any
```

* **props** (<code>[k8s.KubeNetworkPolicyProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicyprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.NetworkPolicySpec](#opencdk8s-cdk8s-argocd-resources-k8s-networkpolicyspec)</code>)  Specification of the desired behavior for this NetworkPolicy. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeNetworkPolicyList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicylist"></a>

NetworkPolicyList is a list of NetworkPolicy objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.networking.v1.NetworkPolicyList" API object.

```ts
new k8s.KubeNetworkPolicyList(scope: Construct, id: string, props: KubeNetworkPolicyListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeNetworkPolicyListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicylistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeNetworkPolicyProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicyprops)></code>)  Items is a list of schema objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.networking.v1.NetworkPolicyList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicylist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.networking.v1.NetworkPolicyList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeNetworkPolicyListProps): any
```

* **props** (<code>[k8s.KubeNetworkPolicyListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicylistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeNetworkPolicyProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicyprops)></code>)  Items is a list of schema objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeNetworkPolicyListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicylistv1beta1"></a>

DEPRECATED 1.9 - This group version of NetworkPolicyList is deprecated by networking/v1/NetworkPolicyList. Network Policy List is a list of NetworkPolicy objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.extensions.v1beta1.NetworkPolicyList" API object.

```ts
new k8s.KubeNetworkPolicyListV1Beta1(scope: Construct, id: string, props: KubeNetworkPolicyListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeNetworkPolicyListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicylistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeNetworkPolicyV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicyv1beta1props)></code>)  Items is a list of schema objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.extensions.v1beta1.NetworkPolicyList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicylistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.extensions.v1beta1.NetworkPolicyList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeNetworkPolicyListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeNetworkPolicyListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicylistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeNetworkPolicyV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicyv1beta1props)></code>)  Items is a list of schema objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeNetworkPolicyV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicyv1beta1"></a>

DEPRECATED 1.9 - This group version of NetworkPolicy is deprecated by networking/v1/NetworkPolicy. NetworkPolicy describes what network traffic is allowed for a set of Pods.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.extensions.v1beta1.NetworkPolicy" API object.

```ts
new k8s.KubeNetworkPolicyV1Beta1(scope: Construct, id: string, props?: KubeNetworkPolicyV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeNetworkPolicyV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicyv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.NetworkPolicySpec](#opencdk8s-cdk8s-argocd-resources-k8s-networkpolicyspec)</code>)  Specification of the desired behavior for this NetworkPolicy. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.extensions.v1beta1.NetworkPolicy".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicyv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.extensions.v1beta1.NetworkPolicy".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeNetworkPolicyV1Beta1Props): any
```

* **props** (<code>[k8s.KubeNetworkPolicyV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicyv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.NetworkPolicySpec](#opencdk8s-cdk8s-argocd-resources-k8s-networkpolicyspec)</code>)  Specification of the desired behavior for this NetworkPolicy. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeNode 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenode"></a>

Node is a worker node in Kubernetes.

Each node will have a unique identifier in the cache (i.e. in etcd).

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.Node" API object.

```ts
new k8s.KubeNode(scope: Construct, id: string, props?: KubeNodeProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeNodeProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenodeprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.NodeSpec](#opencdk8s-cdk8s-argocd-resources-k8s-nodespec)</code>)  Spec defines the behavior of a node. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.Node".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenode-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.Node".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeNodeProps): any
```

* **props** (<code>[k8s.KubeNodeProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenodeprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.NodeSpec](#opencdk8s-cdk8s-argocd-resources-k8s-nodespec)</code>)  Spec defines the behavior of a node. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeNodeList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenodelist"></a>

NodeList is the whole list of all Nodes which have been registered with master.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.NodeList" API object.

```ts
new k8s.KubeNodeList(scope: Construct, id: string, props: KubeNodeListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeNodeListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenodelistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeNodeProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenodeprops)></code>)  List of nodes. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.NodeList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenodelist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.NodeList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeNodeListProps): any
```

* **props** (<code>[k8s.KubeNodeListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenodelistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeNodeProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenodeprops)></code>)  List of nodes. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubePersistentVolume 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolume"></a>

PersistentVolume (PV) is a storage resource provisioned by an administrator.

It is analogous to a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.PersistentVolume" API object.

```ts
new k8s.KubePersistentVolume(scope: Construct, id: string, props?: KubePersistentVolumeProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubePersistentVolumeProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.PersistentVolumeSpec](#opencdk8s-cdk8s-argocd-resources-k8s-persistentvolumespec)</code>)  Spec defines a specification of a persistent volume owned by the cluster. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.PersistentVolume".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolume-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.PersistentVolume".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubePersistentVolumeProps): any
```

* **props** (<code>[k8s.KubePersistentVolumeProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.PersistentVolumeSpec](#opencdk8s-cdk8s-argocd-resources-k8s-persistentvolumespec)</code>)  Spec defines a specification of a persistent volume owned by the cluster. __*Optional*__

__Returns__:
* <code>any</code>



## class KubePersistentVolumeClaim 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeclaim"></a>

PersistentVolumeClaim is a user's request for and claim to a persistent volume.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.PersistentVolumeClaim" API object.

```ts
new k8s.KubePersistentVolumeClaim(scope: Construct, id: string, props?: KubePersistentVolumeClaimProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubePersistentVolumeClaimProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeclaimprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.PersistentVolumeClaimSpec](#opencdk8s-cdk8s-argocd-resources-k8s-persistentvolumeclaimspec)</code>)  Spec defines the desired characteristics of a volume requested by a pod author. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.PersistentVolumeClaim".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeclaim-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.PersistentVolumeClaim".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubePersistentVolumeClaimProps): any
```

* **props** (<code>[k8s.KubePersistentVolumeClaimProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeclaimprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.PersistentVolumeClaimSpec](#opencdk8s-cdk8s-argocd-resources-k8s-persistentvolumeclaimspec)</code>)  Spec defines the desired characteristics of a volume requested by a pod author. __*Optional*__

__Returns__:
* <code>any</code>



## class KubePersistentVolumeClaimList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeclaimlist"></a>

PersistentVolumeClaimList is a list of PersistentVolumeClaim items.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.PersistentVolumeClaimList" API object.

```ts
new k8s.KubePersistentVolumeClaimList(scope: Construct, id: string, props: KubePersistentVolumeClaimListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubePersistentVolumeClaimListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeclaimlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubePersistentVolumeClaimProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeclaimprops)></code>)  A list of persistent volume claims. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.PersistentVolumeClaimList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeclaimlist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.PersistentVolumeClaimList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubePersistentVolumeClaimListProps): any
```

* **props** (<code>[k8s.KubePersistentVolumeClaimListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeclaimlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubePersistentVolumeClaimProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeclaimprops)></code>)  A list of persistent volume claims. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubePersistentVolumeList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumelist"></a>

PersistentVolumeList is a list of PersistentVolume items.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.PersistentVolumeList" API object.

```ts
new k8s.KubePersistentVolumeList(scope: Construct, id: string, props: KubePersistentVolumeListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubePersistentVolumeListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumelistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubePersistentVolumeProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeprops)></code>)  List of persistent volumes. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.PersistentVolumeList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumelist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.PersistentVolumeList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubePersistentVolumeListProps): any
```

* **props** (<code>[k8s.KubePersistentVolumeListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumelistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubePersistentVolumeProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeprops)></code>)  List of persistent volumes. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubePod 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepod"></a>

Pod is a collection of containers that can run on a host.

This resource is created by clients and scheduled onto hosts.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.Pod" API object.

```ts
new k8s.KubePod(scope: Construct, id: string, props?: KubePodProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubePodProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.PodSpec](#opencdk8s-cdk8s-argocd-resources-k8s-podspec)</code>)  Specification of the desired behavior of the pod. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.Pod".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepod-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.Pod".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubePodProps): any
```

* **props** (<code>[k8s.KubePodProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.PodSpec](#opencdk8s-cdk8s-argocd-resources-k8s-podspec)</code>)  Specification of the desired behavior of the pod. __*Optional*__

__Returns__:
* <code>any</code>



## class KubePodDisruptionBudgetListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepoddisruptionbudgetlistv1beta1"></a>

PodDisruptionBudgetList is a collection of PodDisruptionBudgets.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.policy.v1beta1.PodDisruptionBudgetList" API object.

```ts
new k8s.KubePodDisruptionBudgetListV1Beta1(scope: Construct, id: string, props: KubePodDisruptionBudgetListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubePodDisruptionBudgetListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepoddisruptionbudgetlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubePodDisruptionBudgetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepoddisruptionbudgetv1beta1props)></code>)  *No description* 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.PodDisruptionBudgetList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepoddisruptionbudgetlistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.PodDisruptionBudgetList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubePodDisruptionBudgetListV1Beta1Props): any
```

* **props** (<code>[k8s.KubePodDisruptionBudgetListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepoddisruptionbudgetlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubePodDisruptionBudgetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepoddisruptionbudgetv1beta1props)></code>)  *No description* 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class KubePodDisruptionBudgetV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepoddisruptionbudgetv1beta1"></a>

PodDisruptionBudget is an object to define the max disruption that can be caused to a collection of pods.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.policy.v1beta1.PodDisruptionBudget" API object.

```ts
new k8s.KubePodDisruptionBudgetV1Beta1(scope: Construct, id: string, props?: KubePodDisruptionBudgetV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubePodDisruptionBudgetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepoddisruptionbudgetv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[k8s.PodDisruptionBudgetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-poddisruptionbudgetspec)</code>)  Specification of the desired behavior of the PodDisruptionBudget. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.PodDisruptionBudget".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepoddisruptionbudgetv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.PodDisruptionBudget".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubePodDisruptionBudgetV1Beta1Props): any
```

* **props** (<code>[k8s.KubePodDisruptionBudgetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepoddisruptionbudgetv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[k8s.PodDisruptionBudgetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-poddisruptionbudgetspec)</code>)  Specification of the desired behavior of the PodDisruptionBudget. __*Optional*__

__Returns__:
* <code>any</code>



## class KubePodList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodlist"></a>

PodList is a list of Pods.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.PodList" API object.

```ts
new k8s.KubePodList(scope: Construct, id: string, props: KubePodListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubePodListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubePodProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodprops)></code>)  List of pods. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.PodList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodlist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.PodList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubePodListProps): any
```

* **props** (<code>[k8s.KubePodListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubePodProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodprops)></code>)  List of pods. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubePodPresetListV1Alpha1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodpresetlistv1alpha1"></a>

PodPresetList is a list of PodPreset objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.settings.v1alpha1.PodPresetList" API object.

```ts
new k8s.KubePodPresetListV1Alpha1(scope: Construct, id: string, props: KubePodPresetListV1Alpha1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubePodPresetListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodpresetlistv1alpha1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubePodPresetV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodpresetv1alpha1props)></code>)  Items is a list of schema objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.settings.v1alpha1.PodPresetList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodpresetlistv1alpha1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.settings.v1alpha1.PodPresetList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubePodPresetListV1Alpha1Props): any
```

* **props** (<code>[k8s.KubePodPresetListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodpresetlistv1alpha1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubePodPresetV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodpresetv1alpha1props)></code>)  Items is a list of schema objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubePodPresetV1Alpha1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodpresetv1alpha1"></a>

PodPreset is a policy resource that defines additional runtime requirements for a Pod.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.settings.v1alpha1.PodPreset" API object.

```ts
new k8s.KubePodPresetV1Alpha1(scope: Construct, id: string, props?: KubePodPresetV1Alpha1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubePodPresetV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodpresetv1alpha1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[k8s.PodPresetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-podpresetspec)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.settings.v1alpha1.PodPreset".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodpresetv1alpha1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.settings.v1alpha1.PodPreset".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubePodPresetV1Alpha1Props): any
```

* **props** (<code>[k8s.KubePodPresetV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodpresetv1alpha1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[k8s.PodPresetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-podpresetspec)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class KubePodSecurityPolicyListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodsecuritypolicylistv1beta1"></a>

PodSecurityPolicyList is a list of PodSecurityPolicy objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.policy.v1beta1.PodSecurityPolicyList" API object.

```ts
new k8s.KubePodSecurityPolicyListV1Beta1(scope: Construct, id: string, props: KubePodSecurityPolicyListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubePodSecurityPolicyListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodsecuritypolicylistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubePodSecurityPolicyV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodsecuritypolicyv1beta1props)></code>)  items is a list of schema objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.PodSecurityPolicyList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodsecuritypolicylistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.PodSecurityPolicyList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubePodSecurityPolicyListV1Beta1Props): any
```

* **props** (<code>[k8s.KubePodSecurityPolicyListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodsecuritypolicylistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubePodSecurityPolicyV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodsecuritypolicyv1beta1props)></code>)  items is a list of schema objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubePodSecurityPolicyV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodsecuritypolicyv1beta1"></a>

PodSecurityPolicy governs the ability to make requests that affect the Security Context that will be applied to a pod and container.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.policy.v1beta1.PodSecurityPolicy" API object.

```ts
new k8s.KubePodSecurityPolicyV1Beta1(scope: Construct, id: string, props?: KubePodSecurityPolicyV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubePodSecurityPolicyV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodsecuritypolicyv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.PodSecurityPolicySpec](#opencdk8s-cdk8s-argocd-resources-k8s-podsecuritypolicyspec)</code>)  spec defines the policy enforced. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.PodSecurityPolicy".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodsecuritypolicyv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.PodSecurityPolicy".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubePodSecurityPolicyV1Beta1Props): any
```

* **props** (<code>[k8s.KubePodSecurityPolicyV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodsecuritypolicyv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.PodSecurityPolicySpec](#opencdk8s-cdk8s-argocd-resources-k8s-podsecuritypolicyspec)</code>)  spec defines the policy enforced. __*Optional*__

__Returns__:
* <code>any</code>



## class KubePodTemplate 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodtemplate"></a>

PodTemplate describes a template for creating copies of a predefined pod.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.PodTemplate" API object.

```ts
new k8s.KubePodTemplate(scope: Construct, id: string, props?: KubePodTemplateProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubePodTemplateProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodtemplateprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **template** (<code>[k8s.PodTemplateSpec](#opencdk8s-cdk8s-argocd-resources-k8s-podtemplatespec)</code>)  Template defines the pods that will be created from this pod template. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.PodTemplate".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodtemplate-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.PodTemplate".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubePodTemplateProps): any
```

* **props** (<code>[k8s.KubePodTemplateProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodtemplateprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **template** (<code>[k8s.PodTemplateSpec](#opencdk8s-cdk8s-argocd-resources-k8s-podtemplatespec)</code>)  Template defines the pods that will be created from this pod template. __*Optional*__

__Returns__:
* <code>any</code>



## class KubePodTemplateList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodtemplatelist"></a>

PodTemplateList is a list of PodTemplates.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.PodTemplateList" API object.

```ts
new k8s.KubePodTemplateList(scope: Construct, id: string, props: KubePodTemplateListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubePodTemplateListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodtemplatelistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubePodTemplateProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodtemplateprops)></code>)  List of pod templates. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.PodTemplateList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodtemplatelist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.PodTemplateList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubePodTemplateListProps): any
```

* **props** (<code>[k8s.KubePodTemplateListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodtemplatelistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubePodTemplateProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodtemplateprops)></code>)  List of pod templates. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubePriorityClass 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclass"></a>

PriorityClass defines mapping from a priority class name to the priority integer value.

The value can be any valid integer.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.scheduling.v1.PriorityClass" API object.

```ts
new k8s.KubePriorityClass(scope: Construct, id: string, props: KubePriorityClassProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubePriorityClassProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassprops)</code>)  initialization props.
  * **value** (<code>number</code>)  The value of this priority class. 
  * **description** (<code>string</code>)  description is an arbitrary string that usually provides guidelines on when this priority class should be used. __*Optional*__
  * **globalDefault** (<code>boolean</code>)  globalDefault specifies whether this PriorityClass should be considered as the default priority for pods that do not have any priority class. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **preemptionPolicy** (<code>string</code>)  PreemptionPolicy is the Policy for preempting pods with lower priority. __*Default*__: PreemptLowerPriority if unset. This field is alpha-level and is only honored by servers that enable the NonPreemptingPriority feature.



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.scheduling.v1.PriorityClass".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclass-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.scheduling.v1.PriorityClass".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubePriorityClassProps): any
```

* **props** (<code>[k8s.KubePriorityClassProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassprops)</code>)  initialization props.
  * **value** (<code>number</code>)  The value of this priority class. 
  * **description** (<code>string</code>)  description is an arbitrary string that usually provides guidelines on when this priority class should be used. __*Optional*__
  * **globalDefault** (<code>boolean</code>)  globalDefault specifies whether this PriorityClass should be considered as the default priority for pods that do not have any priority class. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **preemptionPolicy** (<code>string</code>)  PreemptionPolicy is the Policy for preempting pods with lower priority. __*Default*__: PreemptLowerPriority if unset. This field is alpha-level and is only honored by servers that enable the NonPreemptingPriority feature.

__Returns__:
* <code>any</code>



## class KubePriorityClassList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclasslist"></a>

PriorityClassList is a collection of priority classes.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.scheduling.v1.PriorityClassList" API object.

```ts
new k8s.KubePriorityClassList(scope: Construct, id: string, props: KubePriorityClassListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubePriorityClassListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclasslistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubePriorityClassProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassprops)></code>)  items is the list of PriorityClasses. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.scheduling.v1.PriorityClassList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclasslist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.scheduling.v1.PriorityClassList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubePriorityClassListProps): any
```

* **props** (<code>[k8s.KubePriorityClassListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclasslistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubePriorityClassProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassprops)></code>)  items is the list of PriorityClasses. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubePriorityClassListV1Alpha1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclasslistv1alpha1"></a>

PriorityClassList is a collection of priority classes.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.scheduling.v1alpha1.PriorityClassList" API object.

```ts
new k8s.KubePriorityClassListV1Alpha1(scope: Construct, id: string, props: KubePriorityClassListV1Alpha1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubePriorityClassListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclasslistv1alpha1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubePriorityClassV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassv1alpha1props)></code>)  items is the list of PriorityClasses. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.scheduling.v1alpha1.PriorityClassList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclasslistv1alpha1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.scheduling.v1alpha1.PriorityClassList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubePriorityClassListV1Alpha1Props): any
```

* **props** (<code>[k8s.KubePriorityClassListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclasslistv1alpha1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubePriorityClassV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassv1alpha1props)></code>)  items is the list of PriorityClasses. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubePriorityClassListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclasslistv1beta1"></a>

PriorityClassList is a collection of priority classes.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.scheduling.v1beta1.PriorityClassList" API object.

```ts
new k8s.KubePriorityClassListV1Beta1(scope: Construct, id: string, props: KubePriorityClassListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubePriorityClassListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclasslistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubePriorityClassV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassv1beta1props)></code>)  items is the list of PriorityClasses. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.scheduling.v1beta1.PriorityClassList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclasslistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.scheduling.v1beta1.PriorityClassList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubePriorityClassListV1Beta1Props): any
```

* **props** (<code>[k8s.KubePriorityClassListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclasslistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubePriorityClassV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassv1beta1props)></code>)  items is the list of PriorityClasses. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubePriorityClassV1Alpha1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassv1alpha1"></a>

DEPRECATED - This group version of PriorityClass is deprecated by scheduling.k8s.io/v1/PriorityClass. PriorityClass defines mapping from a priority class name to the priority integer value. The value can be any valid integer.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.scheduling.v1alpha1.PriorityClass" API object.

```ts
new k8s.KubePriorityClassV1Alpha1(scope: Construct, id: string, props: KubePriorityClassV1Alpha1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubePriorityClassV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassv1alpha1props)</code>)  initialization props.
  * **value** (<code>number</code>)  The value of this priority class. 
  * **description** (<code>string</code>)  description is an arbitrary string that usually provides guidelines on when this priority class should be used. __*Optional*__
  * **globalDefault** (<code>boolean</code>)  globalDefault specifies whether this PriorityClass should be considered as the default priority for pods that do not have any priority class. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **preemptionPolicy** (<code>string</code>)  PreemptionPolicy is the Policy for preempting pods with lower priority. __*Default*__: PreemptLowerPriority if unset. This field is alpha-level and is only honored by servers that enable the NonPreemptingPriority feature.



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.scheduling.v1alpha1.PriorityClass".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassv1alpha1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.scheduling.v1alpha1.PriorityClass".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubePriorityClassV1Alpha1Props): any
```

* **props** (<code>[k8s.KubePriorityClassV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassv1alpha1props)</code>)  initialization props.
  * **value** (<code>number</code>)  The value of this priority class. 
  * **description** (<code>string</code>)  description is an arbitrary string that usually provides guidelines on when this priority class should be used. __*Optional*__
  * **globalDefault** (<code>boolean</code>)  globalDefault specifies whether this PriorityClass should be considered as the default priority for pods that do not have any priority class. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **preemptionPolicy** (<code>string</code>)  PreemptionPolicy is the Policy for preempting pods with lower priority. __*Default*__: PreemptLowerPriority if unset. This field is alpha-level and is only honored by servers that enable the NonPreemptingPriority feature.

__Returns__:
* <code>any</code>



## class KubePriorityClassV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassv1beta1"></a>

DEPRECATED - This group version of PriorityClass is deprecated by scheduling.k8s.io/v1/PriorityClass. PriorityClass defines mapping from a priority class name to the priority integer value. The value can be any valid integer.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.scheduling.v1beta1.PriorityClass" API object.

```ts
new k8s.KubePriorityClassV1Beta1(scope: Construct, id: string, props: KubePriorityClassV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubePriorityClassV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassv1beta1props)</code>)  initialization props.
  * **value** (<code>number</code>)  The value of this priority class. 
  * **description** (<code>string</code>)  description is an arbitrary string that usually provides guidelines on when this priority class should be used. __*Optional*__
  * **globalDefault** (<code>boolean</code>)  globalDefault specifies whether this PriorityClass should be considered as the default priority for pods that do not have any priority class. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **preemptionPolicy** (<code>string</code>)  PreemptionPolicy is the Policy for preempting pods with lower priority. __*Default*__: PreemptLowerPriority if unset. This field is alpha-level and is only honored by servers that enable the NonPreemptingPriority feature.



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.scheduling.v1beta1.PriorityClass".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.scheduling.v1beta1.PriorityClass".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubePriorityClassV1Beta1Props): any
```

* **props** (<code>[k8s.KubePriorityClassV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassv1beta1props)</code>)  initialization props.
  * **value** (<code>number</code>)  The value of this priority class. 
  * **description** (<code>string</code>)  description is an arbitrary string that usually provides guidelines on when this priority class should be used. __*Optional*__
  * **globalDefault** (<code>boolean</code>)  globalDefault specifies whether this PriorityClass should be considered as the default priority for pods that do not have any priority class. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **preemptionPolicy** (<code>string</code>)  PreemptionPolicy is the Policy for preempting pods with lower priority. __*Default*__: PreemptLowerPriority if unset. This field is alpha-level and is only honored by servers that enable the NonPreemptingPriority feature.

__Returns__:
* <code>any</code>



## class KubeReplicaSet 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicaset"></a>

ReplicaSet ensures that a specified number of pod replicas are running at any given time.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1.ReplicaSet" API object.

```ts
new k8s.KubeReplicaSet(scope: Construct, id: string, props?: KubeReplicaSetProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeReplicaSetProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. __*Optional*__
  * **spec** (<code>[k8s.ReplicaSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-replicasetspec)</code>)  Spec defines the specification of the desired behavior of the ReplicaSet. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1.ReplicaSet".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicaset-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1.ReplicaSet".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeReplicaSetProps): any
```

* **props** (<code>[k8s.KubeReplicaSetProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. __*Optional*__
  * **spec** (<code>[k8s.ReplicaSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-replicasetspec)</code>)  Spec defines the specification of the desired behavior of the ReplicaSet. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeReplicaSetList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetlist"></a>

ReplicaSetList is a collection of ReplicaSets.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1.ReplicaSetList" API object.

```ts
new k8s.KubeReplicaSetList(scope: Construct, id: string, props: KubeReplicaSetListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeReplicaSetListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeReplicaSetProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetprops)></code>)  List of ReplicaSets. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1.ReplicaSetList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetlist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1.ReplicaSetList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeReplicaSetListProps): any
```

* **props** (<code>[k8s.KubeReplicaSetListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeReplicaSetProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetprops)></code>)  List of ReplicaSets. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeReplicaSetListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetlistv1beta1"></a>

ReplicaSetList is a collection of ReplicaSets.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.extensions.v1beta1.ReplicaSetList" API object.

```ts
new k8s.KubeReplicaSetListV1Beta1(scope: Construct, id: string, props: KubeReplicaSetListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeReplicaSetListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeReplicaSetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetv1beta1props)></code>)  List of ReplicaSets. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.extensions.v1beta1.ReplicaSetList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetlistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.extensions.v1beta1.ReplicaSetList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeReplicaSetListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeReplicaSetListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeReplicaSetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetv1beta1props)></code>)  List of ReplicaSets. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeReplicaSetListV1Beta2 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetlistv1beta2"></a>

ReplicaSetList is a collection of ReplicaSets.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1beta2.ReplicaSetList" API object.

```ts
new k8s.KubeReplicaSetListV1Beta2(scope: Construct, id: string, props: KubeReplicaSetListV1Beta2Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeReplicaSetListV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetlistv1beta2props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeReplicaSetV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetv1beta2props)></code>)  List of ReplicaSets. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1beta2.ReplicaSetList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetlistv1beta2-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta2.ReplicaSetList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeReplicaSetListV1Beta2Props): any
```

* **props** (<code>[k8s.KubeReplicaSetListV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetlistv1beta2props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeReplicaSetV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetv1beta2props)></code>)  List of ReplicaSets. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeReplicaSetV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetv1beta1"></a>

DEPRECATED - This group version of ReplicaSet is deprecated by apps/v1beta2/ReplicaSet.

See the release notes for more information. ReplicaSet ensures that a specified number of pod replicas are running at any given time.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.extensions.v1beta1.ReplicaSet" API object.

```ts
new k8s.KubeReplicaSetV1Beta1(scope: Construct, id: string, props?: KubeReplicaSetV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeReplicaSetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. __*Optional*__
  * **spec** (<code>[k8s.ReplicaSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-replicasetspec)</code>)  Spec defines the specification of the desired behavior of the ReplicaSet. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.extensions.v1beta1.ReplicaSet".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.extensions.v1beta1.ReplicaSet".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeReplicaSetV1Beta1Props): any
```

* **props** (<code>[k8s.KubeReplicaSetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. __*Optional*__
  * **spec** (<code>[k8s.ReplicaSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-replicasetspec)</code>)  Spec defines the specification of the desired behavior of the ReplicaSet. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeReplicaSetV1Beta2 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetv1beta2"></a>

DEPRECATED - This group version of ReplicaSet is deprecated by apps/v1/ReplicaSet.

See the release notes for more information. ReplicaSet ensures that a specified number of pod replicas are running at any given time.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1beta2.ReplicaSet" API object.

```ts
new k8s.KubeReplicaSetV1Beta2(scope: Construct, id: string, props?: KubeReplicaSetV1Beta2Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeReplicaSetV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetv1beta2props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. __*Optional*__
  * **spec** (<code>[k8s.ReplicaSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-replicasetspec)</code>)  Spec defines the specification of the desired behavior of the ReplicaSet. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1beta2.ReplicaSet".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetv1beta2-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta2.ReplicaSet".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeReplicaSetV1Beta2Props): any
```

* **props** (<code>[k8s.KubeReplicaSetV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetv1beta2props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. __*Optional*__
  * **spec** (<code>[k8s.ReplicaSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-replicasetspec)</code>)  Spec defines the specification of the desired behavior of the ReplicaSet. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeReplicationController 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicationcontroller"></a>

ReplicationController represents the configuration of a replication controller.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.ReplicationController" API object.

```ts
new k8s.KubeReplicationController(scope: Construct, id: string, props?: KubeReplicationControllerProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeReplicationControllerProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicationcontrollerprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  If the Labels of a ReplicationController are empty, they are defaulted to be the same as the Pod(s) that the replication controller manages. __*Optional*__
  * **spec** (<code>[k8s.ReplicationControllerSpec](#opencdk8s-cdk8s-argocd-resources-k8s-replicationcontrollerspec)</code>)  Spec defines the specification of the desired behavior of the replication controller. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.ReplicationController".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicationcontroller-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.ReplicationController".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeReplicationControllerProps): any
```

* **props** (<code>[k8s.KubeReplicationControllerProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicationcontrollerprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  If the Labels of a ReplicationController are empty, they are defaulted to be the same as the Pod(s) that the replication controller manages. __*Optional*__
  * **spec** (<code>[k8s.ReplicationControllerSpec](#opencdk8s-cdk8s-argocd-resources-k8s-replicationcontrollerspec)</code>)  Spec defines the specification of the desired behavior of the replication controller. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeReplicationControllerList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicationcontrollerlist"></a>

ReplicationControllerList is a collection of replication controllers.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.ReplicationControllerList" API object.

```ts
new k8s.KubeReplicationControllerList(scope: Construct, id: string, props: KubeReplicationControllerListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeReplicationControllerListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicationcontrollerlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeReplicationControllerProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicationcontrollerprops)></code>)  List of replication controllers. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.ReplicationControllerList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicationcontrollerlist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.ReplicationControllerList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeReplicationControllerListProps): any
```

* **props** (<code>[k8s.KubeReplicationControllerListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicationcontrollerlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeReplicationControllerProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicationcontrollerprops)></code>)  List of replication controllers. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeResourceQuota 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberesourcequota"></a>

ResourceQuota sets aggregate quota restrictions enforced per namespace.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.ResourceQuota" API object.

```ts
new k8s.KubeResourceQuota(scope: Construct, id: string, props?: KubeResourceQuotaProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeResourceQuotaProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberesourcequotaprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.ResourceQuotaSpec](#opencdk8s-cdk8s-argocd-resources-k8s-resourcequotaspec)</code>)  Spec defines the desired quota. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.ResourceQuota".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberesourcequota-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.ResourceQuota".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeResourceQuotaProps): any
```

* **props** (<code>[k8s.KubeResourceQuotaProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberesourcequotaprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.ResourceQuotaSpec](#opencdk8s-cdk8s-argocd-resources-k8s-resourcequotaspec)</code>)  Spec defines the desired quota. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeResourceQuotaList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberesourcequotalist"></a>

ResourceQuotaList is a list of ResourceQuota items.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.ResourceQuotaList" API object.

```ts
new k8s.KubeResourceQuotaList(scope: Construct, id: string, props: KubeResourceQuotaListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeResourceQuotaListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberesourcequotalistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeResourceQuotaProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberesourcequotaprops)></code>)  Items is a list of ResourceQuota objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.ResourceQuotaList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberesourcequotalist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.ResourceQuotaList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeResourceQuotaListProps): any
```

* **props** (<code>[k8s.KubeResourceQuotaListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberesourcequotalistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeResourceQuotaProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberesourcequotaprops)></code>)  Items is a list of ResourceQuota objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeRole 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberole"></a>

Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1.Role" API object.

```ts
new k8s.KubeRole(scope: Construct, id: string, props?: KubeRoleProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeRoleProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberoleprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **rules** (<code>Array<[k8s.PolicyRule](#opencdk8s-cdk8s-argocd-resources-k8s-policyrule)></code>)  Rules holds all the PolicyRules for this Role. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1.Role".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberole-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.Role".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeRoleProps): any
```

* **props** (<code>[k8s.KubeRoleProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberoleprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **rules** (<code>Array<[k8s.PolicyRule](#opencdk8s-cdk8s-argocd-resources-k8s-policyrule)></code>)  Rules holds all the PolicyRules for this Role. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeRoleBinding 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolebinding"></a>

RoleBinding references a role, but does not contain it.

It can reference a Role in the same namespace or a ClusterRole in the global namespace. It adds who information via Subjects and namespace information by which namespace it exists in.  RoleBindings in a given namespace only have effect in that namespace.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1.RoleBinding" API object.

```ts
new k8s.KubeRoleBinding(scope: Construct, id: string, props: KubeRoleBindingProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeRoleBindingProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingprops)</code>)  initialization props.
  * **roleRef** (<code>[k8s.RoleRef](#opencdk8s-cdk8s-argocd-resources-k8s-roleref)</code>)  RoleRef can reference a Role in the current namespace or a ClusterRole in the global namespace. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **subjects** (<code>Array<[k8s.Subject](#opencdk8s-cdk8s-argocd-resources-k8s-subject)></code>)  Subjects holds references to the objects the role applies to. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1.RoleBinding".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolebinding-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.RoleBinding".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeRoleBindingProps): any
```

* **props** (<code>[k8s.KubeRoleBindingProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingprops)</code>)  initialization props.
  * **roleRef** (<code>[k8s.RoleRef](#opencdk8s-cdk8s-argocd-resources-k8s-roleref)</code>)  RoleRef can reference a Role in the current namespace or a ClusterRole in the global namespace. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **subjects** (<code>Array<[k8s.Subject](#opencdk8s-cdk8s-argocd-resources-k8s-subject)></code>)  Subjects holds references to the objects the role applies to. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeRoleBindingList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindinglist"></a>

RoleBindingList is a collection of RoleBindings.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1.RoleBindingList" API object.

```ts
new k8s.KubeRoleBindingList(scope: Construct, id: string, props: KubeRoleBindingListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeRoleBindingListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindinglistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeRoleBindingProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingprops)></code>)  Items is a list of RoleBindings. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1.RoleBindingList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindinglist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.RoleBindingList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeRoleBindingListProps): any
```

* **props** (<code>[k8s.KubeRoleBindingListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindinglistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeRoleBindingProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingprops)></code>)  Items is a list of RoleBindings. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeRoleBindingListV1Alpha1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindinglistv1alpha1"></a>

RoleBindingList is a collection of RoleBindings.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1alpha1.RoleBindingList" API object.

```ts
new k8s.KubeRoleBindingListV1Alpha1(scope: Construct, id: string, props: KubeRoleBindingListV1Alpha1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeRoleBindingListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindinglistv1alpha1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeRoleBindingV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingv1alpha1props)></code>)  Items is a list of RoleBindings. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.RoleBindingList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindinglistv1alpha1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.RoleBindingList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeRoleBindingListV1Alpha1Props): any
```

* **props** (<code>[k8s.KubeRoleBindingListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindinglistv1alpha1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeRoleBindingV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingv1alpha1props)></code>)  Items is a list of RoleBindings. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeRoleBindingListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindinglistv1beta1"></a>

RoleBindingList is a collection of RoleBindings.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1beta1.RoleBindingList" API object.

```ts
new k8s.KubeRoleBindingListV1Beta1(scope: Construct, id: string, props: KubeRoleBindingListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeRoleBindingListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindinglistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeRoleBindingV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingv1beta1props)></code>)  Items is a list of RoleBindings. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1beta1.RoleBindingList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindinglistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1beta1.RoleBindingList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeRoleBindingListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeRoleBindingListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindinglistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeRoleBindingV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingv1beta1props)></code>)  Items is a list of RoleBindings. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeRoleBindingV1Alpha1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingv1alpha1"></a>

RoleBinding references a role, but does not contain it.

It can reference a Role in the same namespace or a ClusterRole in the global namespace. It adds who information via Subjects and namespace information by which namespace it exists in.  RoleBindings in a given namespace only have effect in that namespace.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1alpha1.RoleBinding" API object.

```ts
new k8s.KubeRoleBindingV1Alpha1(scope: Construct, id: string, props: KubeRoleBindingV1Alpha1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeRoleBindingV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingv1alpha1props)</code>)  initialization props.
  * **roleRef** (<code>[k8s.RoleRef](#opencdk8s-cdk8s-argocd-resources-k8s-roleref)</code>)  RoleRef can reference a Role in the current namespace or a ClusterRole in the global namespace. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **subjects** (<code>Array<[k8s.Subject](#opencdk8s-cdk8s-argocd-resources-k8s-subject)></code>)  Subjects holds references to the objects the role applies to. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.RoleBinding".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingv1alpha1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.RoleBinding".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeRoleBindingV1Alpha1Props): any
```

* **props** (<code>[k8s.KubeRoleBindingV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingv1alpha1props)</code>)  initialization props.
  * **roleRef** (<code>[k8s.RoleRef](#opencdk8s-cdk8s-argocd-resources-k8s-roleref)</code>)  RoleRef can reference a Role in the current namespace or a ClusterRole in the global namespace. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **subjects** (<code>Array<[k8s.Subject](#opencdk8s-cdk8s-argocd-resources-k8s-subject)></code>)  Subjects holds references to the objects the role applies to. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeRoleBindingV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingv1beta1"></a>

RoleBinding references a role, but does not contain it.

It can reference a Role in the same namespace or a ClusterRole in the global namespace. It adds who information via Subjects and namespace information by which namespace it exists in.  RoleBindings in a given namespace only have effect in that namespace.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1beta1.RoleBinding" API object.

```ts
new k8s.KubeRoleBindingV1Beta1(scope: Construct, id: string, props: KubeRoleBindingV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeRoleBindingV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingv1beta1props)</code>)  initialization props.
  * **roleRef** (<code>[k8s.RoleRef](#opencdk8s-cdk8s-argocd-resources-k8s-roleref)</code>)  RoleRef can reference a Role in the current namespace or a ClusterRole in the global namespace. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **subjects** (<code>Array<[k8s.Subject](#opencdk8s-cdk8s-argocd-resources-k8s-subject)></code>)  Subjects holds references to the objects the role applies to. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1beta1.RoleBinding".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1beta1.RoleBinding".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeRoleBindingV1Beta1Props): any
```

* **props** (<code>[k8s.KubeRoleBindingV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingv1beta1props)</code>)  initialization props.
  * **roleRef** (<code>[k8s.RoleRef](#opencdk8s-cdk8s-argocd-resources-k8s-roleref)</code>)  RoleRef can reference a Role in the current namespace or a ClusterRole in the global namespace. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **subjects** (<code>Array<[k8s.Subject](#opencdk8s-cdk8s-argocd-resources-k8s-subject)></code>)  Subjects holds references to the objects the role applies to. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeRoleList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolelist"></a>

RoleList is a collection of Roles.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1.RoleList" API object.

```ts
new k8s.KubeRoleList(scope: Construct, id: string, props: KubeRoleListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeRoleListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolelistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeRoleProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberoleprops)></code>)  Items is a list of Roles. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1.RoleList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolelist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.RoleList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeRoleListProps): any
```

* **props** (<code>[k8s.KubeRoleListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolelistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeRoleProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberoleprops)></code>)  Items is a list of Roles. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeRoleListV1Alpha1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolelistv1alpha1"></a>

RoleList is a collection of Roles.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1alpha1.RoleList" API object.

```ts
new k8s.KubeRoleListV1Alpha1(scope: Construct, id: string, props: KubeRoleListV1Alpha1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeRoleListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolelistv1alpha1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeRoleV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolev1alpha1props)></code>)  Items is a list of Roles. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.RoleList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolelistv1alpha1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.RoleList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeRoleListV1Alpha1Props): any
```

* **props** (<code>[k8s.KubeRoleListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolelistv1alpha1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeRoleV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolev1alpha1props)></code>)  Items is a list of Roles. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeRoleListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolelistv1beta1"></a>

RoleList is a collection of Roles.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1beta1.RoleList" API object.

```ts
new k8s.KubeRoleListV1Beta1(scope: Construct, id: string, props: KubeRoleListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeRoleListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolelistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeRoleV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolev1beta1props)></code>)  Items is a list of Roles. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1beta1.RoleList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolelistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1beta1.RoleList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeRoleListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeRoleListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolelistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeRoleV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolev1beta1props)></code>)  Items is a list of Roles. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard object's metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeRoleV1Alpha1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolev1alpha1"></a>

Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1alpha1.Role" API object.

```ts
new k8s.KubeRoleV1Alpha1(scope: Construct, id: string, props?: KubeRoleV1Alpha1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeRoleV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolev1alpha1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **rules** (<code>Array<[k8s.PolicyRule](#opencdk8s-cdk8s-argocd-resources-k8s-policyrule)></code>)  Rules holds all the PolicyRules for this Role. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.Role".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolev1alpha1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.Role".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeRoleV1Alpha1Props): any
```

* **props** (<code>[k8s.KubeRoleV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolev1alpha1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **rules** (<code>Array<[k8s.PolicyRule](#opencdk8s-cdk8s-argocd-resources-k8s-policyrule)></code>)  Rules holds all the PolicyRules for this Role. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeRoleV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolev1beta1"></a>

Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.rbac.v1beta1.Role" API object.

```ts
new k8s.KubeRoleV1Beta1(scope: Construct, id: string, props?: KubeRoleV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeRoleV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolev1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **rules** (<code>Array<[k8s.PolicyRule](#opencdk8s-cdk8s-argocd-resources-k8s-policyrule)></code>)  Rules holds all the PolicyRules for this Role. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1beta1.Role".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolev1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1beta1.Role".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeRoleV1Beta1Props): any
```

* **props** (<code>[k8s.KubeRoleV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolev1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **rules** (<code>Array<[k8s.PolicyRule](#opencdk8s-cdk8s-argocd-resources-k8s-policyrule)></code>)  Rules holds all the PolicyRules for this Role. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeRuntimeClassListV1Alpha1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclasslistv1alpha1"></a>

RuntimeClassList is a list of RuntimeClass objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.node.v1alpha1.RuntimeClassList" API object.

```ts
new k8s.KubeRuntimeClassListV1Alpha1(scope: Construct, id: string, props: KubeRuntimeClassListV1Alpha1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeRuntimeClassListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclasslistv1alpha1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeRuntimeClassV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclassv1alpha1props)></code>)  Items is a list of schema objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.node.v1alpha1.RuntimeClassList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclasslistv1alpha1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.node.v1alpha1.RuntimeClassList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeRuntimeClassListV1Alpha1Props): any
```

* **props** (<code>[k8s.KubeRuntimeClassListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclasslistv1alpha1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeRuntimeClassV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclassv1alpha1props)></code>)  Items is a list of schema objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeRuntimeClassListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclasslistv1beta1"></a>

RuntimeClassList is a list of RuntimeClass objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.node.v1beta1.RuntimeClassList" API object.

```ts
new k8s.KubeRuntimeClassListV1Beta1(scope: Construct, id: string, props: KubeRuntimeClassListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeRuntimeClassListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclasslistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeRuntimeClassV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclassv1beta1props)></code>)  Items is a list of schema objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.node.v1beta1.RuntimeClassList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclasslistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.node.v1beta1.RuntimeClassList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeRuntimeClassListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeRuntimeClassListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclasslistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeRuntimeClassV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclassv1beta1props)></code>)  Items is a list of schema objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeRuntimeClassV1Alpha1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclassv1alpha1"></a>

RuntimeClass defines a class of container runtime supported in the cluster.

The RuntimeClass is used to determine which container runtime is used to run all containers in a pod. RuntimeClasses are (currently) manually defined by a user or cluster provisioner, and referenced in the PodSpec. The Kubelet is responsible for resolving the RuntimeClassName reference before running the pod.  For more details, see https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.node.v1alpha1.RuntimeClass" API object.

```ts
new k8s.KubeRuntimeClassV1Alpha1(scope: Construct, id: string, props: KubeRuntimeClassV1Alpha1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeRuntimeClassV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclassv1alpha1props)</code>)  initialization props.
  * **spec** (<code>[k8s.RuntimeClassSpec](#opencdk8s-cdk8s-argocd-resources-k8s-runtimeclassspec)</code>)  Specification of the RuntimeClass More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.node.v1alpha1.RuntimeClass".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclassv1alpha1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.node.v1alpha1.RuntimeClass".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeRuntimeClassV1Alpha1Props): any
```

* **props** (<code>[k8s.KubeRuntimeClassV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclassv1alpha1props)</code>)  initialization props.
  * **spec** (<code>[k8s.RuntimeClassSpec](#opencdk8s-cdk8s-argocd-resources-k8s-runtimeclassspec)</code>)  Specification of the RuntimeClass More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeRuntimeClassV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclassv1beta1"></a>

RuntimeClass defines a class of container runtime supported in the cluster.

The RuntimeClass is used to determine which container runtime is used to run all containers in a pod. RuntimeClasses are (currently) manually defined by a user or cluster provisioner, and referenced in the PodSpec. The Kubelet is responsible for resolving the RuntimeClassName reference before running the pod.  For more details, see https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.node.v1beta1.RuntimeClass" API object.

```ts
new k8s.KubeRuntimeClassV1Beta1(scope: Construct, id: string, props: KubeRuntimeClassV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeRuntimeClassV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclassv1beta1props)</code>)  initialization props.
  * **handler** (<code>string</code>)  Handler specifies the underlying runtime and configuration that the CRI implementation will use to handle pods of this class. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.node.v1beta1.RuntimeClass".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclassv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.node.v1beta1.RuntimeClass".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeRuntimeClassV1Beta1Props): any
```

* **props** (<code>[k8s.KubeRuntimeClassV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclassv1beta1props)</code>)  initialization props.
  * **handler** (<code>string</code>)  Handler specifies the underlying runtime and configuration that the CRI implementation will use to handle pods of this class. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeScale 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubescale"></a>

Scale represents a scaling request for a resource.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.autoscaling.v1.Scale" API object.

```ts
new k8s.KubeScale(scope: Construct, id: string, props?: KubeScaleProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeScaleProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubescaleprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata; __*Optional*__
  * **spec** (<code>[k8s.ScaleSpec](#opencdk8s-cdk8s-argocd-resources-k8s-scalespec)</code>)  defines the behavior of the scale. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.autoscaling.v1.Scale".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubescale-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v1.Scale".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeScaleProps): any
```

* **props** (<code>[k8s.KubeScaleProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubescaleprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata; __*Optional*__
  * **spec** (<code>[k8s.ScaleSpec](#opencdk8s-cdk8s-argocd-resources-k8s-scalespec)</code>)  defines the behavior of the scale. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeScaleV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubescalev1beta1"></a>

represents a scaling request for a resource.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.extensions.v1beta1.Scale" API object.

```ts
new k8s.KubeScaleV1Beta1(scope: Construct, id: string, props?: KubeScaleV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeScaleV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubescalev1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata; __*Optional*__
  * **spec** (<code>[k8s.ScaleSpec](#opencdk8s-cdk8s-argocd-resources-k8s-scalespec)</code>)  defines the behavior of the scale. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.extensions.v1beta1.Scale".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubescalev1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.extensions.v1beta1.Scale".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeScaleV1Beta1Props): any
```

* **props** (<code>[k8s.KubeScaleV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubescalev1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata; __*Optional*__
  * **spec** (<code>[k8s.ScaleSpec](#opencdk8s-cdk8s-argocd-resources-k8s-scalespec)</code>)  defines the behavior of the scale. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeScaleV1Beta2 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubescalev1beta2"></a>

Scale represents a scaling request for a resource.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1beta2.Scale" API object.

```ts
new k8s.KubeScaleV1Beta2(scope: Construct, id: string, props?: KubeScaleV1Beta2Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeScaleV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubescalev1beta2props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata; __*Optional*__
  * **spec** (<code>[k8s.ScaleSpec](#opencdk8s-cdk8s-argocd-resources-k8s-scalespec)</code>)  defines the behavior of the scale. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1beta2.Scale".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubescalev1beta2-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta2.Scale".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeScaleV1Beta2Props): any
```

* **props** (<code>[k8s.KubeScaleV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubescalev1beta2props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata; __*Optional*__
  * **spec** (<code>[k8s.ScaleSpec](#opencdk8s-cdk8s-argocd-resources-k8s-scalespec)</code>)  defines the behavior of the scale. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeSecret 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubesecret"></a>

Secret holds secret data of a certain type.

The total bytes of the values in the Data field must be less than MaxSecretSize bytes.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.Secret" API object.

```ts
new k8s.KubeSecret(scope: Construct, id: string, props?: KubeSecretProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeSecretProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubesecretprops)</code>)  initialization props.
  * **data** (<code>Map<string, string></code>)  Data contains the secret data. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **stringData** (<code>Map<string, string></code>)  stringData allows specifying non-binary secret data in string form. __*Optional*__
  * **type** (<code>string</code>)  Used to facilitate programmatic handling of secret data. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.Secret".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubesecret-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.Secret".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeSecretProps): any
```

* **props** (<code>[k8s.KubeSecretProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubesecretprops)</code>)  initialization props.
  * **data** (<code>Map<string, string></code>)  Data contains the secret data. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **stringData** (<code>Map<string, string></code>)  stringData allows specifying non-binary secret data in string form. __*Optional*__
  * **type** (<code>string</code>)  Used to facilitate programmatic handling of secret data. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeSecretList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubesecretlist"></a>

SecretList is a list of Secret.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.SecretList" API object.

```ts
new k8s.KubeSecretList(scope: Construct, id: string, props: KubeSecretListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeSecretListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubesecretlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeSecretProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubesecretprops)></code>)  Items is a list of secret objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.SecretList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubesecretlist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.SecretList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeSecretListProps): any
```

* **props** (<code>[k8s.KubeSecretListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubesecretlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeSecretProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubesecretprops)></code>)  Items is a list of secret objects. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeSelfSubjectAccessReview 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectaccessreview"></a>

SelfSubjectAccessReview checks whether or the current user can perform an action.

Not filling in a spec.namespace means "in all namespaces".  Self is a special case, because users should always be able to check whether they can perform an action

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.authorization.v1.SelfSubjectAccessReview" API object.

```ts
new k8s.KubeSelfSubjectAccessReview(scope: Construct, id: string, props: KubeSelfSubjectAccessReviewProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeSelfSubjectAccessReviewProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectaccessreviewprops)</code>)  initialization props.
  * **spec** (<code>[k8s.SelfSubjectAccessReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-selfsubjectaccessreviewspec)</code>)  Spec holds information about the request being evaluated. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.authorization.v1.SelfSubjectAccessReview".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectaccessreview-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.authorization.v1.SelfSubjectAccessReview".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeSelfSubjectAccessReviewProps): any
```

* **props** (<code>[k8s.KubeSelfSubjectAccessReviewProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectaccessreviewprops)</code>)  initialization props.
  * **spec** (<code>[k8s.SelfSubjectAccessReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-selfsubjectaccessreviewspec)</code>)  Spec holds information about the request being evaluated. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class KubeSelfSubjectAccessReviewV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectaccessreviewv1beta1"></a>

SelfSubjectAccessReview checks whether or the current user can perform an action.

Not filling in a spec.namespace means "in all namespaces".  Self is a special case, because users should always be able to check whether they can perform an action

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.authorization.v1beta1.SelfSubjectAccessReview" API object.

```ts
new k8s.KubeSelfSubjectAccessReviewV1Beta1(scope: Construct, id: string, props: KubeSelfSubjectAccessReviewV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeSelfSubjectAccessReviewV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectaccessreviewv1beta1props)</code>)  initialization props.
  * **spec** (<code>[k8s.SelfSubjectAccessReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-selfsubjectaccessreviewspec)</code>)  Spec holds information about the request being evaluated. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.authorization.v1beta1.SelfSubjectAccessReview".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectaccessreviewv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.authorization.v1beta1.SelfSubjectAccessReview".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeSelfSubjectAccessReviewV1Beta1Props): any
```

* **props** (<code>[k8s.KubeSelfSubjectAccessReviewV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectaccessreviewv1beta1props)</code>)  initialization props.
  * **spec** (<code>[k8s.SelfSubjectAccessReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-selfsubjectaccessreviewspec)</code>)  Spec holds information about the request being evaluated. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class KubeSelfSubjectRulesReview 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectrulesreview"></a>

SelfSubjectRulesReview enumerates the set of actions the current user can perform within a namespace.

The returned list of actions may be incomplete depending on the server's authorization mode, and any errors experienced during the evaluation. SelfSubjectRulesReview should be used by UIs to show/hide actions, or to quickly let an end user reason about their permissions. It should NOT Be used by external systems to drive authorization decisions as this raises confused deputy, cache lifetime/revocation, and correctness concerns. SubjectAccessReview, and LocalAccessReview are the correct way to defer authorization decisions to the API server.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.authorization.v1.SelfSubjectRulesReview" API object.

```ts
new k8s.KubeSelfSubjectRulesReview(scope: Construct, id: string, props: KubeSelfSubjectRulesReviewProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeSelfSubjectRulesReviewProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectrulesreviewprops)</code>)  initialization props.
  * **spec** (<code>[k8s.SelfSubjectRulesReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-selfsubjectrulesreviewspec)</code>)  Spec holds information about the request being evaluated. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.authorization.v1.SelfSubjectRulesReview".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectrulesreview-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.authorization.v1.SelfSubjectRulesReview".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeSelfSubjectRulesReviewProps): any
```

* **props** (<code>[k8s.KubeSelfSubjectRulesReviewProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectrulesreviewprops)</code>)  initialization props.
  * **spec** (<code>[k8s.SelfSubjectRulesReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-selfsubjectrulesreviewspec)</code>)  Spec holds information about the request being evaluated. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class KubeSelfSubjectRulesReviewV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectrulesreviewv1beta1"></a>

SelfSubjectRulesReview enumerates the set of actions the current user can perform within a namespace.

The returned list of actions may be incomplete depending on the server's authorization mode, and any errors experienced during the evaluation. SelfSubjectRulesReview should be used by UIs to show/hide actions, or to quickly let an end user reason about their permissions. It should NOT Be used by external systems to drive authorization decisions as this raises confused deputy, cache lifetime/revocation, and correctness concerns. SubjectAccessReview, and LocalAccessReview are the correct way to defer authorization decisions to the API server.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.authorization.v1beta1.SelfSubjectRulesReview" API object.

```ts
new k8s.KubeSelfSubjectRulesReviewV1Beta1(scope: Construct, id: string, props: KubeSelfSubjectRulesReviewV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeSelfSubjectRulesReviewV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectrulesreviewv1beta1props)</code>)  initialization props.
  * **spec** (<code>[k8s.SelfSubjectRulesReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-selfsubjectrulesreviewspec)</code>)  Spec holds information about the request being evaluated. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.authorization.v1beta1.SelfSubjectRulesReview".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectrulesreviewv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.authorization.v1beta1.SelfSubjectRulesReview".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeSelfSubjectRulesReviewV1Beta1Props): any
```

* **props** (<code>[k8s.KubeSelfSubjectRulesReviewV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectrulesreviewv1beta1props)</code>)  initialization props.
  * **spec** (<code>[k8s.SelfSubjectRulesReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-selfsubjectrulesreviewspec)</code>)  Spec holds information about the request being evaluated. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class KubeService 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeservice"></a>

Service is a named abstraction of software service (for example, mysql) consisting of local port (for example 3306) that the proxy listens on, and the selector that determines which pods will answer requests sent through the proxy.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.Service" API object.

```ts
new k8s.KubeService(scope: Construct, id: string, props?: KubeServiceProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeServiceProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.ServiceSpec](#opencdk8s-cdk8s-argocd-resources-k8s-servicespec)</code>)  Spec defines the behavior of a service. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.Service".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeservice-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.Service".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeServiceProps): any
```

* **props** (<code>[k8s.KubeServiceProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **spec** (<code>[k8s.ServiceSpec](#opencdk8s-cdk8s-argocd-resources-k8s-servicespec)</code>)  Spec defines the behavior of a service. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeServiceAccount 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceaccount"></a>

ServiceAccount binds together: * a name, understood by users, and perhaps by peripheral systems, for an identity * a principal that can be authenticated and authorized * a set of secrets.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.ServiceAccount" API object.

```ts
new k8s.KubeServiceAccount(scope: Construct, id: string, props?: KubeServiceAccountProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeServiceAccountProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceaccountprops)</code>)  initialization props.
  * **automountServiceAccountToken** (<code>boolean</code>)  AutomountServiceAccountToken indicates whether pods running as this service account should have an API token automatically mounted. __*Optional*__
  * **imagePullSecrets** (<code>Array<[k8s.LocalObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-localobjectreference)></code>)  ImagePullSecrets is a list of references to secrets in the same namespace to use for pulling any images in pods that reference this ServiceAccount. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **secrets** (<code>Array<[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)></code>)  Secrets is the list of secrets allowed to be used by pods running using this ServiceAccount. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.ServiceAccount".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceaccount-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.ServiceAccount".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeServiceAccountProps): any
```

* **props** (<code>[k8s.KubeServiceAccountProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceaccountprops)</code>)  initialization props.
  * **automountServiceAccountToken** (<code>boolean</code>)  AutomountServiceAccountToken indicates whether pods running as this service account should have an API token automatically mounted. __*Optional*__
  * **imagePullSecrets** (<code>Array<[k8s.LocalObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-localobjectreference)></code>)  ImagePullSecrets is a list of references to secrets in the same namespace to use for pulling any images in pods that reference this ServiceAccount. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **secrets** (<code>Array<[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)></code>)  Secrets is the list of secrets allowed to be used by pods running using this ServiceAccount. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeServiceAccountList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceaccountlist"></a>

ServiceAccountList is a list of ServiceAccount objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.ServiceAccountList" API object.

```ts
new k8s.KubeServiceAccountList(scope: Construct, id: string, props: KubeServiceAccountListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeServiceAccountListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceaccountlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeServiceAccountProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceaccountprops)></code>)  List of ServiceAccounts. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.ServiceAccountList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceaccountlist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.ServiceAccountList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeServiceAccountListProps): any
```

* **props** (<code>[k8s.KubeServiceAccountListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceaccountlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeServiceAccountProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceaccountprops)></code>)  List of ServiceAccounts. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeServiceList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeservicelist"></a>

ServiceList holds a list of services.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.core.v1.ServiceList" API object.

```ts
new k8s.KubeServiceList(scope: Construct, id: string, props: KubeServiceListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeServiceListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeservicelistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeServiceProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceprops)></code>)  List of services. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.ServiceList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeservicelist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.core.v1.ServiceList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeServiceListProps): any
```

* **props** (<code>[k8s.KubeServiceListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeservicelistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeServiceProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceprops)></code>)  List of services. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeStatefulSet 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulset"></a>

StatefulSet represents a set of pods with consistent identities.

Identities are defined as:
- Network: A single stable DNS and hostname.
- Storage: As many VolumeClaims as requested.
The StatefulSet guarantees that a given network identity will always map to the same storage identity.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1.StatefulSet" API object.

```ts
new k8s.KubeStatefulSet(scope: Construct, id: string, props?: KubeStatefulSetProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeStatefulSetProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[k8s.StatefulSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-statefulsetspec)</code>)  Spec defines the desired identities of pods in this set. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1.StatefulSet".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulset-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1.StatefulSet".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeStatefulSetProps): any
```

* **props** (<code>[k8s.KubeStatefulSetProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetprops)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[k8s.StatefulSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-statefulsetspec)</code>)  Spec defines the desired identities of pods in this set. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeStatefulSetList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetlist"></a>

StatefulSetList is a collection of StatefulSets.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1.StatefulSetList" API object.

```ts
new k8s.KubeStatefulSetList(scope: Construct, id: string, props: KubeStatefulSetListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeStatefulSetListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeStatefulSetProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetprops)></code>)  *No description* 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1.StatefulSetList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetlist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1.StatefulSetList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeStatefulSetListProps): any
```

* **props** (<code>[k8s.KubeStatefulSetListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeStatefulSetProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetprops)></code>)  *No description* 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class KubeStatefulSetListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetlistv1beta1"></a>

StatefulSetList is a collection of StatefulSets.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1beta1.StatefulSetList" API object.

```ts
new k8s.KubeStatefulSetListV1Beta1(scope: Construct, id: string, props: KubeStatefulSetListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeStatefulSetListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeStatefulSetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetv1beta1props)></code>)  *No description* 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1beta1.StatefulSetList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetlistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta1.StatefulSetList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeStatefulSetListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeStatefulSetListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeStatefulSetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetv1beta1props)></code>)  *No description* 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class KubeStatefulSetListV1Beta2 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetlistv1beta2"></a>

StatefulSetList is a collection of StatefulSets.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1beta2.StatefulSetList" API object.

```ts
new k8s.KubeStatefulSetListV1Beta2(scope: Construct, id: string, props: KubeStatefulSetListV1Beta2Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeStatefulSetListV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetlistv1beta2props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeStatefulSetV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetv1beta2props)></code>)  *No description* 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1beta2.StatefulSetList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetlistv1beta2-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta2.StatefulSetList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeStatefulSetListV1Beta2Props): any
```

* **props** (<code>[k8s.KubeStatefulSetListV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetlistv1beta2props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeStatefulSetV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetv1beta2props)></code>)  *No description* 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class KubeStatefulSetV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetv1beta1"></a>

DEPRECATED - This group version of StatefulSet is deprecated by apps/v1beta2/StatefulSet.

See the release notes for more information. StatefulSet represents a set of pods with consistent identities. Identities are defined as:
- Network: A single stable DNS and hostname.
- Storage: As many VolumeClaims as requested.
The StatefulSet guarantees that a given network identity will always map to the same storage identity.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1beta1.StatefulSet" API object.

```ts
new k8s.KubeStatefulSetV1Beta1(scope: Construct, id: string, props?: KubeStatefulSetV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeStatefulSetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[k8s.StatefulSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-statefulsetspec)</code>)  Spec defines the desired identities of pods in this set. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1beta1.StatefulSet".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta1.StatefulSet".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeStatefulSetV1Beta1Props): any
```

* **props** (<code>[k8s.KubeStatefulSetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[k8s.StatefulSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-statefulsetspec)</code>)  Spec defines the desired identities of pods in this set. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeStatefulSetV1Beta2 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetv1beta2"></a>

DEPRECATED - This group version of StatefulSet is deprecated by apps/v1/StatefulSet.

See the release notes for more information. StatefulSet represents a set of pods with consistent identities. Identities are defined as:
- Network: A single stable DNS and hostname.
- Storage: As many VolumeClaims as requested.
The StatefulSet guarantees that a given network identity will always map to the same storage identity.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.apps.v1beta2.StatefulSet" API object.

```ts
new k8s.KubeStatefulSetV1Beta2(scope: Construct, id: string, props?: KubeStatefulSetV1Beta2Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeStatefulSetV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetv1beta2props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[k8s.StatefulSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-statefulsetspec)</code>)  Spec defines the desired identities of pods in this set. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1beta2.StatefulSet".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetv1beta2-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta2.StatefulSet".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeStatefulSetV1Beta2Props): any
```

* **props** (<code>[k8s.KubeStatefulSetV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetv1beta2props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__
  * **spec** (<code>[k8s.StatefulSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-statefulsetspec)</code>)  Spec defines the desired identities of pods in this set. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeStatus 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestatus"></a>

Status is a return value for calls that don't return other objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.apimachinery.pkg.apis.meta.v1.Status" API object.

```ts
new k8s.KubeStatus(scope: Construct, id: string, props?: KubeStatusProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeStatusProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatusprops)</code>)  initialization props.
  * **code** (<code>number</code>)  Suggested HTTP return code for this status, 0 if not set. __*Optional*__
  * **details** (<code>[k8s.StatusDetails](#opencdk8s-cdk8s-argocd-resources-k8s-statusdetails)</code>)  Extended data associated with the reason. __*Optional*__
  * **message** (<code>string</code>)  A human-readable description of the status of this operation. __*Optional*__
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__
  * **reason** (<code>string</code>)  A machine-readable description of why this operation is in the "Failure" status. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.apimachinery.pkg.apis.meta.v1.Status".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestatus-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.apimachinery.pkg.apis.meta.v1.Status".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeStatusProps): any
```

* **props** (<code>[k8s.KubeStatusProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatusprops)</code>)  initialization props.
  * **code** (<code>number</code>)  Suggested HTTP return code for this status, 0 if not set. __*Optional*__
  * **details** (<code>[k8s.StatusDetails](#opencdk8s-cdk8s-argocd-resources-k8s-statusdetails)</code>)  Extended data associated with the reason. __*Optional*__
  * **message** (<code>string</code>)  A human-readable description of the status of this operation. __*Optional*__
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__
  * **reason** (<code>string</code>)  A machine-readable description of why this operation is in the "Failure" status. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeStorageClass 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclass"></a>

StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.

StorageClasses are non-namespaced; the name of the storage class according to etcd is in ObjectMeta.Name.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.storage.v1.StorageClass" API object.

```ts
new k8s.KubeStorageClass(scope: Construct, id: string, props: KubeStorageClassProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeStorageClassProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclassprops)</code>)  initialization props.
  * **provisioner** (<code>string</code>)  Provisioner indicates the type of the provisioner. 
  * **allowedTopologies** (<code>Array<[k8s.TopologySelectorTerm](#opencdk8s-cdk8s-argocd-resources-k8s-topologyselectorterm)></code>)  Restrict the node topologies where volumes can be dynamically provisioned. __*Optional*__
  * **allowVolumeExpansion** (<code>boolean</code>)  AllowVolumeExpansion shows whether the storage class allow volume expand. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **mountOptions** (<code>Array<string></code>)  Dynamically provisioned PersistentVolumes of this storage class are created with these mountOptions, e.g. ["ro", "soft"]. Not validated - mount of the PVs will simply fail if one is invalid. __*Optional*__
  * **parameters** (<code>Map<string, string></code>)  Parameters holds the parameters for the provisioner that should create volumes of this storage class. __*Optional*__
  * **reclaimPolicy** (<code>string</code>)  Dynamically provisioned PersistentVolumes of this storage class are created with this reclaimPolicy. __*Default*__: Delete.
  * **volumeBindingMode** (<code>string</code>)  VolumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1.StorageClass".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclass-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.storage.v1.StorageClass".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeStorageClassProps): any
```

* **props** (<code>[k8s.KubeStorageClassProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclassprops)</code>)  initialization props.
  * **provisioner** (<code>string</code>)  Provisioner indicates the type of the provisioner. 
  * **allowedTopologies** (<code>Array<[k8s.TopologySelectorTerm](#opencdk8s-cdk8s-argocd-resources-k8s-topologyselectorterm)></code>)  Restrict the node topologies where volumes can be dynamically provisioned. __*Optional*__
  * **allowVolumeExpansion** (<code>boolean</code>)  AllowVolumeExpansion shows whether the storage class allow volume expand. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **mountOptions** (<code>Array<string></code>)  Dynamically provisioned PersistentVolumes of this storage class are created with these mountOptions, e.g. ["ro", "soft"]. Not validated - mount of the PVs will simply fail if one is invalid. __*Optional*__
  * **parameters** (<code>Map<string, string></code>)  Parameters holds the parameters for the provisioner that should create volumes of this storage class. __*Optional*__
  * **reclaimPolicy** (<code>string</code>)  Dynamically provisioned PersistentVolumes of this storage class are created with this reclaimPolicy. __*Default*__: Delete.
  * **volumeBindingMode** (<code>string</code>)  VolumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeStorageClassList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclasslist"></a>

StorageClassList is a collection of storage classes.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.storage.v1.StorageClassList" API object.

```ts
new k8s.KubeStorageClassList(scope: Construct, id: string, props: KubeStorageClassListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeStorageClassListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclasslistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeStorageClassProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclassprops)></code>)  Items is the list of StorageClasses. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1.StorageClassList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclasslist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.storage.v1.StorageClassList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeStorageClassListProps): any
```

* **props** (<code>[k8s.KubeStorageClassListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclasslistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeStorageClassProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclassprops)></code>)  Items is the list of StorageClasses. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeStorageClassListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclasslistv1beta1"></a>

StorageClassList is a collection of storage classes.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.storage.v1beta1.StorageClassList" API object.

```ts
new k8s.KubeStorageClassListV1Beta1(scope: Construct, id: string, props: KubeStorageClassListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeStorageClassListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclasslistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeStorageClassV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclassv1beta1props)></code>)  Items is the list of StorageClasses. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.StorageClassList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclasslistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.StorageClassList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeStorageClassListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeStorageClassListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclasslistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeStorageClassV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclassv1beta1props)></code>)  Items is the list of StorageClasses. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeStorageClassV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclassv1beta1"></a>

StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.

StorageClasses are non-namespaced; the name of the storage class according to etcd is in ObjectMeta.Name.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.storage.v1beta1.StorageClass" API object.

```ts
new k8s.KubeStorageClassV1Beta1(scope: Construct, id: string, props: KubeStorageClassV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeStorageClassV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclassv1beta1props)</code>)  initialization props.
  * **provisioner** (<code>string</code>)  Provisioner indicates the type of the provisioner. 
  * **allowedTopologies** (<code>Array<[k8s.TopologySelectorTerm](#opencdk8s-cdk8s-argocd-resources-k8s-topologyselectorterm)></code>)  Restrict the node topologies where volumes can be dynamically provisioned. __*Optional*__
  * **allowVolumeExpansion** (<code>boolean</code>)  AllowVolumeExpansion shows whether the storage class allow volume expand. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **mountOptions** (<code>Array<string></code>)  Dynamically provisioned PersistentVolumes of this storage class are created with these mountOptions, e.g. ["ro", "soft"]. Not validated - mount of the PVs will simply fail if one is invalid. __*Optional*__
  * **parameters** (<code>Map<string, string></code>)  Parameters holds the parameters for the provisioner that should create volumes of this storage class. __*Optional*__
  * **reclaimPolicy** (<code>string</code>)  Dynamically provisioned PersistentVolumes of this storage class are created with this reclaimPolicy. __*Default*__: Delete.
  * **volumeBindingMode** (<code>string</code>)  VolumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.StorageClass".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclassv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.StorageClass".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeStorageClassV1Beta1Props): any
```

* **props** (<code>[k8s.KubeStorageClassV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclassv1beta1props)</code>)  initialization props.
  * **provisioner** (<code>string</code>)  Provisioner indicates the type of the provisioner. 
  * **allowedTopologies** (<code>Array<[k8s.TopologySelectorTerm](#opencdk8s-cdk8s-argocd-resources-k8s-topologyselectorterm)></code>)  Restrict the node topologies where volumes can be dynamically provisioned. __*Optional*__
  * **allowVolumeExpansion** (<code>boolean</code>)  AllowVolumeExpansion shows whether the storage class allow volume expand. __*Optional*__
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object's metadata. __*Optional*__
  * **mountOptions** (<code>Array<string></code>)  Dynamically provisioned PersistentVolumes of this storage class are created with these mountOptions, e.g. ["ro", "soft"]. Not validated - mount of the PVs will simply fail if one is invalid. __*Optional*__
  * **parameters** (<code>Map<string, string></code>)  Parameters holds the parameters for the provisioner that should create volumes of this storage class. __*Optional*__
  * **reclaimPolicy** (<code>string</code>)  Dynamically provisioned PersistentVolumes of this storage class are created with this reclaimPolicy. __*Default*__: Delete.
  * **volumeBindingMode** (<code>string</code>)  VolumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeSubjectAccessReview 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubesubjectaccessreview"></a>

SubjectAccessReview checks whether or not a user or group can perform an action.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.authorization.v1.SubjectAccessReview" API object.

```ts
new k8s.KubeSubjectAccessReview(scope: Construct, id: string, props: KubeSubjectAccessReviewProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeSubjectAccessReviewProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubesubjectaccessreviewprops)</code>)  initialization props.
  * **spec** (<code>[k8s.SubjectAccessReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-subjectaccessreviewspec)</code>)  Spec holds information about the request being evaluated. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.authorization.v1.SubjectAccessReview".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubesubjectaccessreview-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.authorization.v1.SubjectAccessReview".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeSubjectAccessReviewProps): any
```

* **props** (<code>[k8s.KubeSubjectAccessReviewProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubesubjectaccessreviewprops)</code>)  initialization props.
  * **spec** (<code>[k8s.SubjectAccessReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-subjectaccessreviewspec)</code>)  Spec holds information about the request being evaluated. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class KubeSubjectAccessReviewV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubesubjectaccessreviewv1beta1"></a>

SubjectAccessReview checks whether or not a user or group can perform an action.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.authorization.v1beta1.SubjectAccessReview" API object.

```ts
new k8s.KubeSubjectAccessReviewV1Beta1(scope: Construct, id: string, props: KubeSubjectAccessReviewV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeSubjectAccessReviewV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubesubjectaccessreviewv1beta1props)</code>)  initialization props.
  * **spec** (<code>[k8s.SubjectAccessReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-subjectaccessreviewspec)</code>)  Spec holds information about the request being evaluated. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.authorization.v1beta1.SubjectAccessReview".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubesubjectaccessreviewv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.authorization.v1beta1.SubjectAccessReview".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeSubjectAccessReviewV1Beta1Props): any
```

* **props** (<code>[k8s.KubeSubjectAccessReviewV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubesubjectaccessreviewv1beta1props)</code>)  initialization props.
  * **spec** (<code>[k8s.SubjectAccessReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-subjectaccessreviewspec)</code>)  Spec holds information about the request being evaluated. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class KubeTokenReview 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubetokenreview"></a>

TokenReview attempts to authenticate a token to a known user.

Note: TokenReview requests may be cached by the webhook token authenticator plugin in the kube-apiserver.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.authentication.v1.TokenReview" API object.

```ts
new k8s.KubeTokenReview(scope: Construct, id: string, props: KubeTokenReviewProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeTokenReviewProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubetokenreviewprops)</code>)  initialization props.
  * **spec** (<code>[k8s.TokenReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-tokenreviewspec)</code>)  Spec holds information about the request being evaluated. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.authentication.v1.TokenReview".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubetokenreview-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.authentication.v1.TokenReview".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeTokenReviewProps): any
```

* **props** (<code>[k8s.KubeTokenReviewProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubetokenreviewprops)</code>)  initialization props.
  * **spec** (<code>[k8s.TokenReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-tokenreviewspec)</code>)  Spec holds information about the request being evaluated. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class KubeTokenReviewV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubetokenreviewv1beta1"></a>

TokenReview attempts to authenticate a token to a known user.

Note: TokenReview requests may be cached by the webhook token authenticator plugin in the kube-apiserver.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.authentication.v1beta1.TokenReview" API object.

```ts
new k8s.KubeTokenReviewV1Beta1(scope: Construct, id: string, props: KubeTokenReviewV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeTokenReviewV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubetokenreviewv1beta1props)</code>)  initialization props.
  * **spec** (<code>[k8s.TokenReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-tokenreviewspec)</code>)  Spec holds information about the request being evaluated. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.authentication.v1beta1.TokenReview".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubetokenreviewv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.authentication.v1beta1.TokenReview".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeTokenReviewV1Beta1Props): any
```

* **props** (<code>[k8s.KubeTokenReviewV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubetokenreviewv1beta1props)</code>)  initialization props.
  * **spec** (<code>[k8s.TokenReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-tokenreviewspec)</code>)  Spec holds information about the request being evaluated. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  *No description* __*Optional*__

__Returns__:
* <code>any</code>



## class KubeValidatingWebhookConfigurationListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevalidatingwebhookconfigurationlistv1beta1"></a>

ValidatingWebhookConfigurationList is a list of ValidatingWebhookConfiguration.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.admissionregistration.v1beta1.ValidatingWebhookConfigurationList" API object.

```ts
new k8s.KubeValidatingWebhookConfigurationListV1Beta1(scope: Construct, id: string, props: KubeValidatingWebhookConfigurationListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeValidatingWebhookConfigurationListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevalidatingwebhookconfigurationlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeValidatingWebhookConfigurationV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevalidatingwebhookconfigurationv1beta1props)></code>)  List of ValidatingWebhookConfiguration. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.admissionregistration.v1beta1.ValidatingWebhookConfigurationList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevalidatingwebhookconfigurationlistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.admissionregistration.v1beta1.ValidatingWebhookConfigurationList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeValidatingWebhookConfigurationListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeValidatingWebhookConfigurationListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevalidatingwebhookconfigurationlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeValidatingWebhookConfigurationV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevalidatingwebhookconfigurationv1beta1props)></code>)  List of ValidatingWebhookConfiguration. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeValidatingWebhookConfigurationV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevalidatingwebhookconfigurationv1beta1"></a>

ValidatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and object without changing it.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.admissionregistration.v1beta1.ValidatingWebhookConfiguration" API object.

```ts
new k8s.KubeValidatingWebhookConfigurationV1Beta1(scope: Construct, id: string, props?: KubeValidatingWebhookConfigurationV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeValidatingWebhookConfigurationV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevalidatingwebhookconfigurationv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata; __*Optional*__
  * **webhooks** (<code>Array<[k8s.ValidatingWebhook](#opencdk8s-cdk8s-argocd-resources-k8s-validatingwebhook)></code>)  Webhooks is a list of webhooks and the affected resources and operations. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.admissionregistration.v1beta1.ValidatingWebhookConfiguration".

### Methods


#### *static* manifest(props?)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevalidatingwebhookconfigurationv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.admissionregistration.v1beta1.ValidatingWebhookConfiguration".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props?: KubeValidatingWebhookConfigurationV1Beta1Props): any
```

* **props** (<code>[k8s.KubeValidatingWebhookConfigurationV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevalidatingwebhookconfigurationv1beta1props)</code>)  initialization props.
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata; __*Optional*__
  * **webhooks** (<code>Array<[k8s.ValidatingWebhook](#opencdk8s-cdk8s-argocd-resources-k8s-validatingwebhook)></code>)  Webhooks is a list of webhooks and the affected resources and operations. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeVolumeAttachment 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachment"></a>

VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.

VolumeAttachment objects are non-namespaced.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.storage.v1.VolumeAttachment" API object.

```ts
new k8s.KubeVolumeAttachment(scope: Construct, id: string, props: KubeVolumeAttachmentProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeVolumeAttachmentProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentprops)</code>)  initialization props.
  * **spec** (<code>[k8s.VolumeAttachmentSpec](#opencdk8s-cdk8s-argocd-resources-k8s-volumeattachmentspec)</code>)  Specification of the desired attach/detach volume behavior. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1.VolumeAttachment".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachment-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.storage.v1.VolumeAttachment".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeVolumeAttachmentProps): any
```

* **props** (<code>[k8s.KubeVolumeAttachmentProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentprops)</code>)  initialization props.
  * **spec** (<code>[k8s.VolumeAttachmentSpec](#opencdk8s-cdk8s-argocd-resources-k8s-volumeattachmentspec)</code>)  Specification of the desired attach/detach volume behavior. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeVolumeAttachmentList 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentlist"></a>

VolumeAttachmentList is a collection of VolumeAttachment objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.storage.v1.VolumeAttachmentList" API object.

```ts
new k8s.KubeVolumeAttachmentList(scope: Construct, id: string, props: KubeVolumeAttachmentListProps)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeVolumeAttachmentListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeVolumeAttachmentProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentprops)></code>)  Items is the list of VolumeAttachments. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1.VolumeAttachmentList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentlist-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.storage.v1.VolumeAttachmentList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeVolumeAttachmentListProps): any
```

* **props** (<code>[k8s.KubeVolumeAttachmentListProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentlistprops)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeVolumeAttachmentProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentprops)></code>)  Items is the list of VolumeAttachments. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeVolumeAttachmentListV1Alpha1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentlistv1alpha1"></a>

VolumeAttachmentList is a collection of VolumeAttachment objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.storage.v1alpha1.VolumeAttachmentList" API object.

```ts
new k8s.KubeVolumeAttachmentListV1Alpha1(scope: Construct, id: string, props: KubeVolumeAttachmentListV1Alpha1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeVolumeAttachmentListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentlistv1alpha1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeVolumeAttachmentV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentv1alpha1props)></code>)  Items is the list of VolumeAttachments. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1alpha1.VolumeAttachmentList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentlistv1alpha1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.storage.v1alpha1.VolumeAttachmentList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeVolumeAttachmentListV1Alpha1Props): any
```

* **props** (<code>[k8s.KubeVolumeAttachmentListV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentlistv1alpha1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeVolumeAttachmentV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentv1alpha1props)></code>)  Items is the list of VolumeAttachments. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeVolumeAttachmentListV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentlistv1beta1"></a>

VolumeAttachmentList is a collection of VolumeAttachment objects.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.storage.v1beta1.VolumeAttachmentList" API object.

```ts
new k8s.KubeVolumeAttachmentListV1Beta1(scope: Construct, id: string, props: KubeVolumeAttachmentListV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeVolumeAttachmentListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeVolumeAttachmentV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentv1beta1props)></code>)  Items is the list of VolumeAttachments. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.VolumeAttachmentList".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentlistv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.VolumeAttachmentList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeVolumeAttachmentListV1Beta1Props): any
```

* **props** (<code>[k8s.KubeVolumeAttachmentListV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentlistv1beta1props)</code>)  initialization props.
  * **items** (<code>Array<[k8s.KubeVolumeAttachmentV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentv1beta1props)></code>)  Items is the list of VolumeAttachments. 
  * **metadata** (<code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code>)  Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeVolumeAttachmentV1Alpha1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentv1alpha1"></a>

VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.

VolumeAttachment objects are non-namespaced.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.storage.v1alpha1.VolumeAttachment" API object.

```ts
new k8s.KubeVolumeAttachmentV1Alpha1(scope: Construct, id: string, props: KubeVolumeAttachmentV1Alpha1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeVolumeAttachmentV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentv1alpha1props)</code>)  initialization props.
  * **spec** (<code>[k8s.VolumeAttachmentSpec](#opencdk8s-cdk8s-argocd-resources-k8s-volumeattachmentspec)</code>)  Specification of the desired attach/detach volume behavior. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1alpha1.VolumeAttachment".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentv1alpha1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.storage.v1alpha1.VolumeAttachment".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeVolumeAttachmentV1Alpha1Props): any
```

* **props** (<code>[k8s.KubeVolumeAttachmentV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentv1alpha1props)</code>)  initialization props.
  * **spec** (<code>[k8s.VolumeAttachmentSpec](#opencdk8s-cdk8s-argocd-resources-k8s-volumeattachmentspec)</code>)  Specification of the desired attach/detach volume behavior. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class KubeVolumeAttachmentV1Beta1 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentv1beta1"></a>

VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.

VolumeAttachment objects are non-namespaced.

__Implements__: [IConstruct](#constructs-iconstruct), [IDependable](#constructs-idependable)
__Submodule__: k8s

__Extends__: [ApiObject](#cdk8s-apiobject)

### Initializer


Defines a "io.k8s.api.storage.v1beta1.VolumeAttachment" API object.

```ts
new k8s.KubeVolumeAttachmentV1Beta1(scope: Construct, id: string, props: KubeVolumeAttachmentV1Beta1Props)
```

* **scope** (<code>[Construct](#constructs-construct)</code>)  the scope in which to define this object.
* **id** (<code>string</code>)  a scope-local name for the object.
* **props** (<code>[k8s.KubeVolumeAttachmentV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentv1beta1props)</code>)  initialization props.
  * **spec** (<code>[k8s.VolumeAttachmentSpec](#opencdk8s-cdk8s-argocd-resources-k8s-volumeattachmentspec)</code>)  Specification of the desired attach/detach volume behavior. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
*static* **GVK**🔹 | <code>[GroupVersionKind](#cdk8s-groupversionkind)</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.VolumeAttachment".

### Methods


#### *static* manifest(props)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentv1beta1-manifest"></a>

Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.VolumeAttachment".

This can be used to inline resource manifests inside other objects (e.g. as templates).

```ts
static manifest(props: KubeVolumeAttachmentV1Beta1Props): any
```

* **props** (<code>[k8s.KubeVolumeAttachmentV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentv1beta1props)</code>)  initialization props.
  * **spec** (<code>[k8s.VolumeAttachmentSpec](#opencdk8s-cdk8s-argocd-resources-k8s-volumeattachmentspec)</code>)  Specification of the desired attach/detach volume behavior. 
  * **metadata** (<code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code>)  Standard object metadata. __*Optional*__

__Returns__:
* <code>any</code>



## class Quantity 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-quantity"></a>



__Submodule__: k8s


### Methods


#### *static* fromNumber(value)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-quantity-fromnumber"></a>



```ts
static fromNumber(value: number): Quantity
```

* **value** (<code>number</code>)  *No description*

__Returns__:
* <code>[k8s.Quantity](#opencdk8s-cdk8s-argocd-resources-k8s-quantity)</code>

#### *static* fromString(value)🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-quantity-fromstring"></a>



```ts
static fromString(value: string): Quantity
```

* **value** (<code>string</code>)  *No description*

__Returns__:
* <code>[k8s.Quantity](#opencdk8s-cdk8s-argocd-resources-k8s-quantity)</code>



## struct ApplicationDestination 🔹 <a id="opencdk8s-cdk8s-argocd-resources-applicationdestination"></a>






Name | Type | Description 
-----|------|-------------
**name**?🔹 | <code>string</code> | __*Optional*__
**namespace**?🔹 | <code>string</code> | __*Optional*__
**server**?🔹 | <code>string</code> | __*Optional*__



## struct ApplicationDirectory 🔹 <a id="opencdk8s-cdk8s-argocd-resources-applicationdirectory"></a>






Name | Type | Description 
-----|------|-------------
**recurse**?🔹 | <code>boolean</code> | __*Optional*__



## struct ApplicationPlugin 🔹 <a id="opencdk8s-cdk8s-argocd-resources-applicationplugin"></a>






Name | Type | Description 
-----|------|-------------
**env**?🔹 | <code>Array<[k8s.EnvVar](#opencdk8s-cdk8s-argocd-resources-k8s-envvar)></code> | __*Optional*__
**name**?🔹 | <code>string</code> | __*Optional*__



## struct ApplicationSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-applicationsource"></a>






Name | Type | Description 
-----|------|-------------
**directory**?🔹 | <code>[ApplicationDirectory](#opencdk8s-cdk8s-argocd-resources-applicationdirectory)</code> | __*Optional*__
**path**?🔹 | <code>string</code> | __*Optional*__
**plugin**?🔹 | <code>[ApplicationPlugin](#opencdk8s-cdk8s-argocd-resources-applicationplugin)</code> | __*Optional*__
**repoURL**?🔹 | <code>string</code> | __*Optional*__
**targetRevision**?🔹 | <code>string</code> | __*Optional*__



## struct ApplicationSyncPolicy 🔹 <a id="opencdk8s-cdk8s-argocd-resources-applicationsyncpolicy"></a>






Name | Type | Description 
-----|------|-------------
**automated**?🔹 | <code>[SyncPolicyAutomated](#opencdk8s-cdk8s-argocd-resources-syncpolicyautomated)</code> | __*Optional*__
**retry**?🔹 | <code>[SyncRetry](#opencdk8s-cdk8s-argocd-resources-syncretry)</code> | __*Optional*__
**syncOptions**?🔹 | <code>Array<string></code> | __*Optional*__



## struct ArgoCdApplicationProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-argocdapplicationprops"></a>






Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__
**spec**?🔹 | <code>[ArgoCdApplicationSpec](#opencdk8s-cdk8s-argocd-resources-argocdapplicationspec)</code> | __*Optional*__



## struct ArgoCdApplicationSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-argocdapplicationspec"></a>






Name | Type | Description 
-----|------|-------------
**destination**?🔹 | <code>[ApplicationDestination](#opencdk8s-cdk8s-argocd-resources-applicationdestination)</code> | __*Optional*__
**project**?🔹 | <code>string</code> | __*Optional*__
**source**?🔹 | <code>[ApplicationSource](#opencdk8s-cdk8s-argocd-resources-applicationsource)</code> | __*Optional*__
**syncPolicy**?🔹 | <code>[ApplicationSyncPolicy](#opencdk8s-cdk8s-argocd-resources-applicationsyncpolicy)</code> | __*Optional*__



## struct ArgoCdProjectProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-argocdprojectprops"></a>






Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__
**spec**?🔹 | <code>[ArgoCdProjectSpec](#opencdk8s-cdk8s-argocd-resources-argocdprojectspec)</code> | __*Optional*__



## struct ArgoCdProjectSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-argocdprojectspec"></a>






Name | Type | Description 
-----|------|-------------
**clusterResourceWhiteList**?🔹 | <code>Array<[ResourceRef](#opencdk8s-cdk8s-argocd-resources-resourceref)></code> | __*Optional*__
**description**?🔹 | <code>string</code> | __*Optional*__
**destination**?🔹 | <code>Array<[ApplicationDestination](#opencdk8s-cdk8s-argocd-resources-applicationdestination)></code> | __*Optional*__
**namespaceResourceBlacklist**?🔹 | <code>Array<[ResourceRef](#opencdk8s-cdk8s-argocd-resources-resourceref)></code> | __*Optional*__
**namespaceResourceWhitelist**?🔹 | <code>Array<[ResourceRef](#opencdk8s-cdk8s-argocd-resources-resourceref)></code> | __*Optional*__
**roles**?🔹 | <code>Array<[ProjectRoles](#opencdk8s-cdk8s-argocd-resources-projectroles)></code> | __*Optional*__
**sourceRepos**?🔹 | <code>Array<string></code> | __*Optional*__



## struct ProjectRoles 🔹 <a id="opencdk8s-cdk8s-argocd-resources-projectroles"></a>






Name | Type | Description 
-----|------|-------------
**description**?🔹 | <code>string</code> | __*Optional*__
**groups**?🔹 | <code>Array<string></code> | __*Optional*__
**name**?🔹 | <code>string</code> | __*Optional*__
**policies**?🔹 | <code>Array<string></code> | __*Optional*__



## struct ResourceRef 🔹 <a id="opencdk8s-cdk8s-argocd-resources-resourceref"></a>






Name | Type | Description 
-----|------|-------------
**group**?🔹 | <code>string</code> | __*Optional*__
**kind**?🔹 | <code>string</code> | __*Optional*__



## struct RetryBackoff 🔹 <a id="opencdk8s-cdk8s-argocd-resources-retrybackoff"></a>






Name | Type | Description 
-----|------|-------------
**duration**?🔹 | <code>string</code> | __*Optional*__
**factor**?🔹 | <code>number</code> | __*Optional*__
**maxDuration**?🔹 | <code>string</code> | __*Optional*__



## struct SyncPolicyAutomated 🔹 <a id="opencdk8s-cdk8s-argocd-resources-syncpolicyautomated"></a>






Name | Type | Description 
-----|------|-------------
**allowEmpty**?🔹 | <code>boolean</code> | __*Optional*__
**prune**?🔹 | <code>boolean</code> | __*Optional*__
**selfHeal**?🔹 | <code>boolean</code> | __*Optional*__



## struct SyncRetry 🔹 <a id="opencdk8s-cdk8s-argocd-resources-syncretry"></a>






Name | Type | Description 
-----|------|-------------
**backoff**?🔹 | <code>[RetryBackoff](#opencdk8s-cdk8s-argocd-resources-retrybackoff)</code> | __*Optional*__
**limit**?🔹 | <code>number</code> | __*Optional*__



## struct Affinity 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-affinity"></a>


Affinity is a group of affinity scheduling rules.



Name | Type | Description 
-----|------|-------------
**nodeAffinity**?🔹 | <code>[k8s.NodeAffinity](#opencdk8s-cdk8s-argocd-resources-k8s-nodeaffinity)</code> | Describes node affinity scheduling rules for the pod.<br/>__*Optional*__
**podAffinity**?🔹 | <code>[k8s.PodAffinity](#opencdk8s-cdk8s-argocd-resources-k8s-podaffinity)</code> | Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).<br/>__*Optional*__
**podAntiAffinity**?🔹 | <code>[k8s.PodAntiAffinity](#opencdk8s-cdk8s-argocd-resources-k8s-podantiaffinity)</code> | Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).<br/>__*Optional*__



## struct AggregationRule 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-aggregationrule"></a>


AggregationRule describes how to locate ClusterRoles to aggregate into the ClusterRole.



Name | Type | Description 
-----|------|-------------
**clusterRoleSelectors**?🔹 | <code>Array<[k8s.LabelSelector](#opencdk8s-cdk8s-argocd-resources-k8s-labelselector)></code> | ClusterRoleSelectors holds a list of selectors which will be used to find ClusterRoles and create the rules.<br/>__*Optional*__



## struct AllowedCsiDriver 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-allowedcsidriver"></a>


AllowedCSIDriver represents a single inline CSI Driver that is allowed to be used.



Name | Type | Description 
-----|------|-------------
**name**🔹 | <code>string</code> | Name is the registered name of the CSI driver.



## struct AllowedFlexVolume 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-allowedflexvolume"></a>


AllowedFlexVolume represents a single Flexvolume that is allowed to be used.



Name | Type | Description 
-----|------|-------------
**driver**🔹 | <code>string</code> | driver is the name of the Flexvolume driver.



## struct AllowedHostPath 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-allowedhostpath"></a>


AllowedHostPath defines the host volume conditions that will be enabled by a policy for pods to use.

It requires the path prefix to be defined.



Name | Type | Description 
-----|------|-------------
**pathPrefix**?🔹 | <code>string</code> | pathPrefix is the path prefix that the host volume must match.<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | when set to true, will allow host volumes matching the pathPrefix only if all volume mounts are readOnly.<br/>__*Optional*__



## struct ApiServiceSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-apiservicespec"></a>


APIServiceSpec contains information for locating and communicating with a server.

Only https is supported, though you are able to disable certificate verification.



Name | Type | Description 
-----|------|-------------
**groupPriorityMinimum**🔹 | <code>number</code> | GroupPriorityMininum is the priority this group should have at least.
**service**🔹 | <code>[k8s.ServiceReference](#opencdk8s-cdk8s-argocd-resources-k8s-servicereference)</code> | Service is a reference to the service for this API server.
**versionPriority**🔹 | <code>number</code> | VersionPriority controls the ordering of this API version inside of its group.
**caBundle**?🔹 | <code>string</code> | CABundle is a PEM encoded CA bundle which will be used to validate an API server's serving certificate.<br/>__*Optional*__
**group**?🔹 | <code>string</code> | Group is the API group name this server hosts.<br/>__*Optional*__
**insecureSkipTLSVerify**?🔹 | <code>boolean</code> | InsecureSkipTLSVerify disables TLS certificate verification when communicating with this server.<br/>__*Optional*__
**version**?🔹 | <code>string</code> | Version is the API version this server hosts.<br/>__*Optional*__



## struct AuditSinkSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-auditsinkspec"></a>


AuditSinkSpec holds the spec for the audit sink.



Name | Type | Description 
-----|------|-------------
**policy**🔹 | <code>[k8s.Policy](#opencdk8s-cdk8s-argocd-resources-k8s-policy)</code> | Policy defines the policy for selecting which events should be sent to the webhook required.
**webhook**🔹 | <code>[k8s.Webhook](#opencdk8s-cdk8s-argocd-resources-k8s-webhook)</code> | Webhook to send events required.



## struct AwsElasticBlockStoreVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-awselasticblockstorevolumesource"></a>


Represents a Persistent Disk resource in AWS.

An AWS EBS disk must exist before mounting to a container. The disk must also be in the same AWS zone as the kubelet. An AWS EBS disk can only be mounted as read/write once. AWS EBS volumes support ownership management and SELinux relabeling.



Name | Type | Description 
-----|------|-------------
**volumeID**🔹 | <code>string</code> | Unique ID of the persistent disk resource in AWS (Amazon EBS volume).
**fsType**?🔹 | <code>string</code> | Filesystem type of the volume that you want to mount.<br/>__*Optional*__
**partition**?🔹 | <code>number</code> | The partition in the volume that you want to mount.<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | Specify "true" to force and set the ReadOnly property in VolumeMounts to "true".<br/>__*Optional*__



## struct AzureDiskVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-azurediskvolumesource"></a>


AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.



Name | Type | Description 
-----|------|-------------
**diskName**🔹 | <code>string</code> | The Name of the data disk in the blob storage.
**diskURI**🔹 | <code>string</code> | The URI the data disk in the blob storage.
**cachingMode**?🔹 | <code>string</code> | Host Caching mode: None, Read Only, Read Write.<br/>__*Optional*__
**fsType**?🔹 | <code>string</code> | Filesystem type to mount.<br/>__*Optional*__
**kind**?🔹 | <code>string</code> | Expected values Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set).<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | Defaults to false (read/write).<br/>__*Default*__: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.



## struct AzureFilePersistentVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-azurefilepersistentvolumesource"></a>


AzureFile represents an Azure File Service mount on the host and bind mount to the pod.



Name | Type | Description 
-----|------|-------------
**secretName**🔹 | <code>string</code> | the name of secret that contains Azure Storage Account Name and Key.
**shareName**🔹 | <code>string</code> | Share Name.
**readOnly**?🔹 | <code>boolean</code> | Defaults to false (read/write).<br/>__*Default*__: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
**secretNamespace**?🔹 | <code>string</code> | the namespace of the secret that contains Azure Storage Account Name and Key default is the same as the Pod.<br/>__*Optional*__



## struct AzureFileVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-azurefilevolumesource"></a>


AzureFile represents an Azure File Service mount on the host and bind mount to the pod.



Name | Type | Description 
-----|------|-------------
**secretName**🔹 | <code>string</code> | the name of secret that contains Azure Storage Account Name and Key.
**shareName**🔹 | <code>string</code> | Share Name.
**readOnly**?🔹 | <code>boolean</code> | Defaults to false (read/write).<br/>__*Default*__: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.



## struct Capabilities 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-capabilities"></a>


Adds and removes POSIX capabilities from running containers.



Name | Type | Description 
-----|------|-------------
**add**?🔹 | <code>Array<string></code> | Added capabilities.<br/>__*Optional*__
**drop**?🔹 | <code>Array<string></code> | Removed capabilities.<br/>__*Optional*__



## struct CephFsPersistentVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-cephfspersistentvolumesource"></a>


Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.



Name | Type | Description 
-----|------|-------------
**monitors**🔹 | <code>Array<string></code> | Required: Monitors is a collection of Ceph monitors More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it.
**path**?🔹 | <code>string</code> | Optional: Used as the mounted root, rather than the full Ceph tree, default is /.<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | Optional: Defaults to false (read/write).<br/>__*Default*__: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
**secretFile**?🔹 | <code>string</code> | Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it.<br/>__*Optional*__
**secretRef**?🔹 | <code>[k8s.SecretReference](#opencdk8s-cdk8s-argocd-resources-k8s-secretreference)</code> | Optional: SecretRef is reference to the authentication secret for User, default is empty.<br/>__*Optional*__
**user**?🔹 | <code>string</code> | Optional: User is the rados user name, default is admin More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it.<br/>__*Optional*__



## struct CephFsVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-cephfsvolumesource"></a>


Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.



Name | Type | Description 
-----|------|-------------
**monitors**🔹 | <code>Array<string></code> | Required: Monitors is a collection of Ceph monitors More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it.
**path**?🔹 | <code>string</code> | Optional: Used as the mounted root, rather than the full Ceph tree, default is /.<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | Optional: Defaults to false (read/write).<br/>__*Default*__: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
**secretFile**?🔹 | <code>string</code> | Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it.<br/>__*Optional*__
**secretRef**?🔹 | <code>[k8s.LocalObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-localobjectreference)</code> | Optional: SecretRef is reference to the authentication secret for User, default is empty.<br/>__*Optional*__
**user**?🔹 | <code>string</code> | Optional: User is the rados user name, default is admin More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it.<br/>__*Optional*__



## struct CertificateSigningRequestSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-certificatesigningrequestspec"></a>


This information is immutable after the request is created.

Only the Request and Usages fields can be set on creation, other fields are derived by Kubernetes and cannot be modified by users.



Name | Type | Description 
-----|------|-------------
**request**🔹 | <code>string</code> | Base64-encoded PKCS#10 CSR data.
**extra**?🔹 | <code>Map<string, Array<string>></code> | Extra information about the requesting user.<br/>__*Optional*__
**groups**?🔹 | <code>Array<string></code> | Group information about the requesting user.<br/>__*Optional*__
**uid**?🔹 | <code>string</code> | UID information about the requesting user.<br/>__*Optional*__
**usages**?🔹 | <code>Array<string></code> | allowedUsages specifies a set of usage contexts the key will be valid for.<br/>__*Optional*__
**username**?🔹 | <code>string</code> | Information about the requesting user.<br/>__*Optional*__



## struct CinderPersistentVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-cinderpersistentvolumesource"></a>


Represents a cinder volume resource in Openstack.

A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.



Name | Type | Description 
-----|------|-------------
**volumeID**🔹 | <code>string</code> | volume id used to identify the volume in cinder More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md.
**fsType**?🔹 | <code>string</code> | Filesystem type to mount.<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | Optional: Defaults to false (read/write).<br/>__*Default*__: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
**secretRef**?🔹 | <code>[k8s.SecretReference](#opencdk8s-cdk8s-argocd-resources-k8s-secretreference)</code> | Optional: points to a secret object containing parameters used to connect to OpenStack.<br/>__*Optional*__



## struct CinderVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-cindervolumesource"></a>


Represents a cinder volume resource in Openstack.

A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.



Name | Type | Description 
-----|------|-------------
**volumeID**🔹 | <code>string</code> | volume id used to identify the volume in cinder More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md.
**fsType**?🔹 | <code>string</code> | Filesystem type to mount.<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | Optional: Defaults to false (read/write).<br/>__*Default*__: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
**secretRef**?🔹 | <code>[k8s.LocalObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-localobjectreference)</code> | Optional: points to a secret object containing parameters used to connect to OpenStack.<br/>__*Optional*__



## struct ClientIpConfig 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-clientipconfig"></a>


ClientIPConfig represents the configurations of Client IP based session affinity.



Name | Type | Description 
-----|------|-------------
**timeoutSeconds**?🔹 | <code>number</code> | timeoutSeconds specifies the seconds of ClientIP type session sticky time.<br/>__*Optional*__



## struct ComponentCondition 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-componentcondition"></a>


Information about the condition of a component.



Name | Type | Description 
-----|------|-------------
**status**🔹 | <code>string</code> | Status of the condition for a component.
**type**🔹 | <code>string</code> | Type of condition for a component.
**error**?🔹 | <code>string</code> | Condition error code for a component.<br/>__*Optional*__
**message**?🔹 | <code>string</code> | Message about the condition for a component.<br/>__*Optional*__



## struct ConfigMapEnvSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-configmapenvsource"></a>


ConfigMapEnvSource selects a ConfigMap to populate the environment variables with.

The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.



Name | Type | Description 
-----|------|-------------
**name**?🔹 | <code>string</code> | Name of the referent.<br/>__*Optional*__
**optional**?🔹 | <code>boolean</code> | Specify whether the ConfigMap must be defined.<br/>__*Optional*__



## struct ConfigMapKeySelector 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-configmapkeyselector"></a>


Selects a key from a ConfigMap.



Name | Type | Description 
-----|------|-------------
**key**🔹 | <code>string</code> | The key to select.
**name**?🔹 | <code>string</code> | Name of the referent.<br/>__*Optional*__
**optional**?🔹 | <code>boolean</code> | Specify whether the ConfigMap or its key must be defined.<br/>__*Optional*__



## struct ConfigMapNodeConfigSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-configmapnodeconfigsource"></a>


ConfigMapNodeConfigSource contains the information to reference a ConfigMap as a config source for the Node.



Name | Type | Description 
-----|------|-------------
**kubeletConfigKey**🔹 | <code>string</code> | KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration structure This field is required in all cases.
**name**🔹 | <code>string</code> | Name is the metadata.name of the referenced ConfigMap. This field is required in all cases.
**namespace**🔹 | <code>string</code> | Namespace is the metadata.namespace of the referenced ConfigMap. This field is required in all cases.
**resourceVersion**?🔹 | <code>string</code> | ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.<br/>__*Optional*__
**uid**?🔹 | <code>string</code> | UID is the metadata.UID of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.<br/>__*Optional*__



## struct ConfigMapProjection 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-configmapprojection"></a>


Adapts a ConfigMap into a projected volume.

The contents of the target ConfigMap's Data field will be presented in a projected volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. Note that this is identical to a configmap volume source without the default mode.



Name | Type | Description 
-----|------|-------------
**items**?🔹 | <code>Array<[k8s.KeyToPath](#opencdk8s-cdk8s-argocd-resources-k8s-keytopath)></code> | If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value.<br/>__*Optional*__
**name**?🔹 | <code>string</code> | Name of the referent.<br/>__*Optional*__
**optional**?🔹 | <code>boolean</code> | Specify whether the ConfigMap or its keys must be defined.<br/>__*Optional*__



## struct ConfigMapVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-configmapvolumesource"></a>


Adapts a ConfigMap into a volume.

The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. ConfigMap volumes support ownership management and SELinux relabeling.



Name | Type | Description 
-----|------|-------------
**defaultMode**?🔹 | <code>number</code> | Optional: mode bits to use on created files by default.<br/>__*Default*__: 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
**items**?🔹 | <code>Array<[k8s.KeyToPath](#opencdk8s-cdk8s-argocd-resources-k8s-keytopath)></code> | If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value.<br/>__*Optional*__
**name**?🔹 | <code>string</code> | Name of the referent.<br/>__*Optional*__
**optional**?🔹 | <code>boolean</code> | Specify whether the ConfigMap or its keys must be defined.<br/>__*Optional*__



## struct Container 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-container"></a>


A single application container that you want to run within a pod.



Name | Type | Description 
-----|------|-------------
**name**🔹 | <code>string</code> | Name of the container specified as a DNS_LABEL.
**args**?🔹 | <code>Array<string></code> | Arguments to the entrypoint.<br/>__*Optional*__
**command**?🔹 | <code>Array<string></code> | Entrypoint array.<br/>__*Optional*__
**env**?🔹 | <code>Array<[k8s.EnvVar](#opencdk8s-cdk8s-argocd-resources-k8s-envvar)></code> | List of environment variables to set in the container.<br/>__*Optional*__
**envFrom**?🔹 | <code>Array<[k8s.EnvFromSource](#opencdk8s-cdk8s-argocd-resources-k8s-envfromsource)></code> | List of sources to populate environment variables in the container.<br/>__*Optional*__
**image**?🔹 | <code>string</code> | Docker image name.<br/>__*Optional*__
**imagePullPolicy**?🔹 | <code>string</code> | Image pull policy.<br/>__*Default*__: Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
**lifecycle**?🔹 | <code>[k8s.Lifecycle](#opencdk8s-cdk8s-argocd-resources-k8s-lifecycle)</code> | Actions that the management system should take in response to container lifecycle events.<br/>__*Optional*__
**livenessProbe**?🔹 | <code>[k8s.Probe](#opencdk8s-cdk8s-argocd-resources-k8s-probe)</code> | Periodic probe of container liveness.<br/>__*Optional*__
**ports**?🔹 | <code>Array<[k8s.ContainerPort](#opencdk8s-cdk8s-argocd-resources-k8s-containerport)></code> | List of ports to expose from the container.<br/>__*Optional*__
**readinessProbe**?🔹 | <code>[k8s.Probe](#opencdk8s-cdk8s-argocd-resources-k8s-probe)</code> | Periodic probe of container service readiness.<br/>__*Optional*__
**resources**?🔹 | <code>[k8s.ResourceRequirements](#opencdk8s-cdk8s-argocd-resources-k8s-resourcerequirements)</code> | Compute Resources required by this container.<br/>__*Optional*__
**securityContext**?🔹 | <code>[k8s.SecurityContext](#opencdk8s-cdk8s-argocd-resources-k8s-securitycontext)</code> | Security options the pod should run with.<br/>__*Optional*__
**stdin**?🔹 | <code>boolean</code> | Whether this container should allocate a buffer for stdin in the container runtime.<br/>__*Default*__: false.
**stdinOnce**?🔹 | <code>boolean</code> | Whether the container runtime should close the stdin channel after it has been opened by a single attach.<br/>__*Default*__: false
**terminationMessagePath**?🔹 | <code>string</code> | Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem.<br/>__*Default*__: dev/termination-log. Cannot be updated.
**terminationMessagePolicy**?🔹 | <code>string</code> | Indicate how the termination message should be populated.<br/>__*Default*__: File. Cannot be updated.
**tty**?🔹 | <code>boolean</code> | Whether this container should allocate a TTY for itself, also requires 'stdin' to be true.<br/>__*Default*__: false.
**volumeDevices**?🔹 | <code>Array<[k8s.VolumeDevice](#opencdk8s-cdk8s-argocd-resources-k8s-volumedevice)></code> | volumeDevices is the list of block devices to be used by the container.<br/>__*Optional*__
**volumeMounts**?🔹 | <code>Array<[k8s.VolumeMount](#opencdk8s-cdk8s-argocd-resources-k8s-volumemount)></code> | Pod volumes to mount into the container's filesystem.<br/>__*Optional*__
**workingDir**?🔹 | <code>string</code> | Container's working directory.<br/>__*Optional*__



## struct ContainerPort 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-containerport"></a>


ContainerPort represents a network port in a single container.



Name | Type | Description 
-----|------|-------------
**containerPort**🔹 | <code>number</code> | Number of port to expose on the pod's IP address.
**hostIP**?🔹 | <code>string</code> | What host IP to bind the external port to.<br/>__*Optional*__
**hostPort**?🔹 | <code>number</code> | Number of port to expose on the host.<br/>__*Optional*__
**name**?🔹 | <code>string</code> | If specified, this must be an IANA_SVC_NAME and unique within the pod.<br/>__*Optional*__
**protocol**?🔹 | <code>string</code> | Protocol for port.<br/>__*Default*__: TCP".



## struct CronJobSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-cronjobspec"></a>


CronJobSpec describes how the job execution will look like and when it will actually run.



Name | Type | Description 
-----|------|-------------
**jobTemplate**🔹 | <code>[k8s.JobTemplateSpec](#opencdk8s-cdk8s-argocd-resources-k8s-jobtemplatespec)</code> | Specifies the job that will be created when executing a CronJob.
**schedule**🔹 | <code>string</code> | The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
**concurrencyPolicy**?🔹 | <code>string</code> | Specifies how to treat concurrent executions of a Job.<br/>__*Optional*__
**failedJobsHistoryLimit**?🔹 | <code>number</code> | The number of failed finished jobs to retain.<br/>__*Optional*__
**startingDeadlineSeconds**?🔹 | <code>number</code> | Optional deadline in seconds for starting the job if it misses scheduled time for any reason.<br/>__*Optional*__
**successfulJobsHistoryLimit**?🔹 | <code>number</code> | The number of successful finished jobs to retain.<br/>__*Optional*__
**suspend**?🔹 | <code>boolean</code> | This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.<br/>__*Default*__: false.



## struct CrossVersionObjectReference 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-crossversionobjectreference"></a>


CrossVersionObjectReference contains enough information to let you identify the referred resource.



Name | Type | Description 
-----|------|-------------
**kind**🔹 | <code>string</code> | Kind of the referent;
**name**🔹 | <code>string</code> | Name of the referent;
**apiVersion**?🔹 | <code>string</code> | API version of the referent.<br/>__*Optional*__



## struct CsiDriverSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-csidriverspec"></a>


CSIDriverSpec is the specification of a CSIDriver.



Name | Type | Description 
-----|------|-------------
**attachRequired**?🔹 | <code>boolean</code> | attachRequired indicates this CSI volume driver requires an attach operation (because it implements the CSI ControllerPublishVolume() method), and that the Kubernetes attach detach controller should call the attach volume interface which checks the volumeattachment status and waits until the volume is attached before proceeding to mounting.<br/>__*Optional*__
**podInfoOnMount**?🔹 | <code>boolean</code> | If set to true, podInfoOnMount indicates this CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations. If set to false, pod information will not be passed on mount. Default is false. The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext. The following VolumeConext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID).<br/>__*Default*__: false. The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext. The following VolumeConext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID)



## struct CsiNodeDriver 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-csinodedriver"></a>


CSINodeDriver holds information about the specification of one CSI driver installed on a node.



Name | Type | Description 
-----|------|-------------
**name**🔹 | <code>string</code> | This is the name of the CSI driver that this object refers to.
**nodeID**🔹 | <code>string</code> | nodeID of the node from the driver point of view.
**topologyKeys**?🔹 | <code>Array<string></code> | topologyKeys is the list of keys supported by the driver.<br/>__*Optional*__



## struct CsiNodeSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-csinodespec"></a>


CSINodeSpec holds information about the specification of all CSI drivers installed on a node.



Name | Type | Description 
-----|------|-------------
**drivers**🔹 | <code>Array<[k8s.CsiNodeDriver](#opencdk8s-cdk8s-argocd-resources-k8s-csinodedriver)></code> | drivers is a list of information of all CSI Drivers existing on a node.



## struct CsiPersistentVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-csipersistentvolumesource"></a>


Represents storage that is managed by an external CSI volume driver (Beta feature).



Name | Type | Description 
-----|------|-------------
**driver**🔹 | <code>string</code> | Driver is the name of the driver to use for this volume.
**volumeHandle**🔹 | <code>string</code> | VolumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume to refer to the volume on all subsequent calls.
**controllerExpandSecretRef**?🔹 | <code>[k8s.SecretReference](#opencdk8s-cdk8s-argocd-resources-k8s-secretreference)</code> | ControllerExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerExpandVolume call.<br/>__*Optional*__
**controllerPublishSecretRef**?🔹 | <code>[k8s.SecretReference](#opencdk8s-cdk8s-argocd-resources-k8s-secretreference)</code> | ControllerPublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerPublishVolume and ControllerUnpublishVolume calls.<br/>__*Optional*__
**fsType**?🔹 | <code>string</code> | Filesystem type to mount.<br/>__*Optional*__
**nodePublishSecretRef**?🔹 | <code>[k8s.SecretReference](#opencdk8s-cdk8s-argocd-resources-k8s-secretreference)</code> | NodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls.<br/>__*Optional*__
**nodeStageSecretRef**?🔹 | <code>[k8s.SecretReference](#opencdk8s-cdk8s-argocd-resources-k8s-secretreference)</code> | NodeStageSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeStageVolume and NodeStageVolume and NodeUnstageVolume calls.<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | Optional: The value to pass to ControllerPublishVolumeRequest.<br/>__*Default*__: false (read/write).
**volumeAttributes**?🔹 | <code>Map<string, string></code> | Attributes of the volume to publish.<br/>__*Optional*__



## struct CsiVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-csivolumesource"></a>


Represents a source location of a volume to mount, managed by an external CSI driver.



Name | Type | Description 
-----|------|-------------
**driver**🔹 | <code>string</code> | Driver is the name of the CSI driver that handles this volume.
**fsType**?🔹 | <code>string</code> | Filesystem type to mount.<br/>__*Optional*__
**nodePublishSecretRef**?🔹 | <code>[k8s.LocalObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-localobjectreference)</code> | NodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls.<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | Specifies a read-only configuration for the volume.<br/>__*Default*__: false (read/write).
**volumeAttributes**?🔹 | <code>Map<string, string></code> | VolumeAttributes stores driver-specific properties that are passed to the CSI driver.<br/>__*Optional*__



## struct CustomResourceColumnDefinition 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-customresourcecolumndefinition"></a>


CustomResourceColumnDefinition specifies a column for server side printing.



Name | Type | Description 
-----|------|-------------
**name**🔹 | <code>string</code> | name is a human readable name for the column.
**type**🔹 | <code>string</code> | type is an OpenAPI type definition for this column.
**description**?🔹 | <code>string</code> | description is a human readable description of this column.<br/>__*Optional*__
**format**?🔹 | <code>string</code> | format is an optional OpenAPI type definition for this column.<br/>__*Optional*__
**jsonPath**?🔹 | <code>string</code> | JSONPath is a simple JSON path, i.e. with array notation.<br/>__*Optional*__
**priority**?🔹 | <code>number</code> | priority is an integer defining the relative importance of this column compared to others.<br/>__*Optional*__



## struct CustomResourceConversion 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-customresourceconversion"></a>


CustomResourceConversion describes how to convert different versions of a CR.



Name | Type | Description 
-----|------|-------------
**strategy**🔹 | <code>string</code> | `strategy` specifies the conversion strategy.
**conversionReviewVersions**?🔹 | <code>Array<string></code> | ConversionReviewVersions is an ordered list of preferred `ConversionReview` versions the Webhook expects.<br/>__*Default*__: v1beta1']`.
**webhookClientConfig**?🔹 | <code>[k8s.WebhookClientConfig](#opencdk8s-cdk8s-argocd-resources-k8s-webhookclientconfig)</code> | `webhookClientConfig` is the instructions for how to call the webhook if strategy is `Webhook`.<br/>__*Optional*__



## struct CustomResourceDefinitionNames 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-customresourcedefinitionnames"></a>


CustomResourceDefinitionNames indicates the names to serve this CustomResourceDefinition.



Name | Type | Description 
-----|------|-------------
**kind**🔹 | <code>string</code> | Kind is the serialized kind of the resource.
**plural**🔹 | <code>string</code> | Plural is the plural name of the resource to serve.
**categories**?🔹 | <code>Array<string></code> | Categories is a list of grouped resources custom resources belong to (e.g. 'all').<br/>__*Optional*__
**listKind**?🔹 | <code>string</code> | ListKind is the serialized kind of the list for this resource.<br/>__*Default*__: kind>List.
**shortNames**?🔹 | <code>Array<string></code> | ShortNames are short names for the resource.<br/>__*Optional*__
**singular**?🔹 | <code>string</code> | Singular is the singular name of the resource.<br/>__*Default*__: lowercased <kind>



## struct CustomResourceDefinitionSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-customresourcedefinitionspec"></a>


CustomResourceDefinitionSpec describes how a user wants their resource to appear.



Name | Type | Description 
-----|------|-------------
**group**🔹 | <code>string</code> | Group is the group this resource belongs in.
**names**🔹 | <code>[k8s.CustomResourceDefinitionNames](#opencdk8s-cdk8s-argocd-resources-k8s-customresourcedefinitionnames)</code> | Names are the names used to describe this custom resource.
**scope**🔹 | <code>string</code> | Scope indicates whether this resource is cluster or namespace scoped.
**additionalPrinterColumns**?🔹 | <code>Array<[k8s.CustomResourceColumnDefinition](#opencdk8s-cdk8s-argocd-resources-k8s-customresourcecolumndefinition)></code> | AdditionalPrinterColumns are additional columns shown e.g. in kubectl next to the name. Defaults to a created-at column. Optional, the global columns for all versions. Top-level and per-version columns are mutually exclusive.<br/>__*Default*__: a created-at column. Optional, the global columns for all versions. Top-level and per-version columns are mutually exclusive.
**conversion**?🔹 | <code>[k8s.CustomResourceConversion](#opencdk8s-cdk8s-argocd-resources-k8s-customresourceconversion)</code> | `conversion` defines conversion settings for the CRD.<br/>__*Optional*__
**preserveUnknownFields**?🔹 | <code>boolean</code> | preserveUnknownFields disables pruning of object fields which are not specified in the OpenAPI schema.<br/>__*Default*__: true in v1beta and will default to false in v1.
**subresources**?🔹 | <code>[k8s.CustomResourceSubresources](#opencdk8s-cdk8s-argocd-resources-k8s-customresourcesubresources)</code> | Subresources describes the subresources for CustomResource Optional, the global subresources for all versions.<br/>__*Optional*__
**validation**?🔹 | <code>[k8s.CustomResourceValidation](#opencdk8s-cdk8s-argocd-resources-k8s-customresourcevalidation)</code> | Validation describes the validation methods for CustomResources Optional, the global validation schema for all versions.<br/>__*Optional*__
**version**?🔹 | <code>string</code> | Version is the version this resource belongs in Should be always first item in Versions field if provided.<br/>__*Optional*__
**versions**?🔹 | <code>Array<[k8s.CustomResourceDefinitionVersion](#opencdk8s-cdk8s-argocd-resources-k8s-customresourcedefinitionversion)></code> | Versions is the list of all supported versions for this resource.<br/>__*Optional*__



## struct CustomResourceDefinitionVersion 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-customresourcedefinitionversion"></a>


CustomResourceDefinitionVersion describes a version for CRD.



Name | Type | Description 
-----|------|-------------
**name**🔹 | <code>string</code> | Name is the version name, e.g. “v1”, “v2beta1”, etc.
**served**🔹 | <code>boolean</code> | Served is a flag enabling/disabling this version from being served via REST APIs.
**storage**🔹 | <code>boolean</code> | Storage flags the version as storage version.
**additionalPrinterColumns**?🔹 | <code>Array<[k8s.CustomResourceColumnDefinition](#opencdk8s-cdk8s-argocd-resources-k8s-customresourcecolumndefinition)></code> | AdditionalPrinterColumns are additional columns shown e.g. in kubectl next to the name. Defaults to a created-at column. Top-level and per-version columns are mutually exclusive. Per-version columns must not all be set to identical values (top-level columns should be used instead) This field is alpha-level and is only honored by servers that enable the CustomResourceWebhookConversion feature. NOTE: CRDs created prior to 1.13 populated the top-level additionalPrinterColumns field by default. To apply an update that changes to per-version additionalPrinterColumns, the top-level additionalPrinterColumns field must be explicitly set to null.<br/>__*Default*__: a created-at column. Top-level and per-version columns are mutually exclusive. Per-version columns must not all be set to identical values (top-level columns should be used instead) This field is alpha-level and is only honored by servers that enable the CustomResourceWebhookConversion feature. NOTE: CRDs created prior to 1.13 populated the top-level additionalPrinterColumns field by default. To apply an update that changes to per-version additionalPrinterColumns, the top-level additionalPrinterColumns field must be explicitly set to null
**schema**?🔹 | <code>[k8s.CustomResourceValidation](#opencdk8s-cdk8s-argocd-resources-k8s-customresourcevalidation)</code> | Schema describes the schema for CustomResource used in validation, pruning, and defaulting.<br/>__*Optional*__
**subresources**?🔹 | <code>[k8s.CustomResourceSubresources](#opencdk8s-cdk8s-argocd-resources-k8s-customresourcesubresources)</code> | Subresources describes the subresources for CustomResource Top-level and per-version subresources are mutually exclusive.<br/>__*Optional*__



## struct CustomResourceSubresourceScale 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-customresourcesubresourcescale"></a>


CustomResourceSubresourceScale defines how to serve the scale subresource for CustomResources.



Name | Type | Description 
-----|------|-------------
**specReplicasPath**🔹 | <code>string</code> | SpecReplicasPath defines the JSON path inside of a CustomResource that corresponds to Scale.Spec.Replicas. Only JSON paths without the array notation are allowed. Must be a JSON Path under .spec. If there is no value under the given path in the CustomResource, the /scale subresource will return an error on GET.
**statusReplicasPath**🔹 | <code>string</code> | StatusReplicasPath defines the JSON path inside of a CustomResource that corresponds to Scale.Status.Replicas. Only JSON paths without the array notation are allowed. Must be a JSON Path under .status. If there is no value under the given path in the CustomResource, the status replica value in the /scale subresource will default to 0.
**labelSelectorPath**?🔹 | <code>string</code> | LabelSelectorPath defines the JSON path inside of a CustomResource that corresponds to Scale.Status.Selector. Only JSON paths without the array notation are allowed. Must be a JSON Path under .status or .spec. Must be set to work with HPA. The field pointed by this JSON path must be a string field (not a complex selector struct) which contains a serialized label selector in string form. More info: https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions#scale-subresource If there is no value under the given path in the CustomResource, the status label selector value in the /scale subresource will default to the empty string.<br/>__*Optional*__



## struct CustomResourceSubresources 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-customresourcesubresources"></a>


CustomResourceSubresources defines the status and scale subresources for CustomResources.



Name | Type | Description 
-----|------|-------------
**scale**?🔹 | <code>[k8s.CustomResourceSubresourceScale](#opencdk8s-cdk8s-argocd-resources-k8s-customresourcesubresourcescale)</code> | Scale denotes the scale subresource for CustomResources.<br/>__*Optional*__
**status**?🔹 | <code>any</code> | Status denotes the status subresource for CustomResources.<br/>__*Optional*__



## struct CustomResourceValidation 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-customresourcevalidation"></a>


CustomResourceValidation is a list of validation methods for CustomResources.



Name | Type | Description 
-----|------|-------------
**openAPIV3Schema**?🔹 | <code>[k8s.JsonSchemaProps](#opencdk8s-cdk8s-argocd-resources-k8s-jsonschemaprops)</code> | OpenAPIV3Schema is the OpenAPI v3 schema to be validated against.<br/>__*Optional*__



## struct DaemonSetSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-daemonsetspec"></a>


DaemonSetSpec is the specification of a daemon set.



Name | Type | Description 
-----|------|-------------
**template**🔹 | <code>[k8s.PodTemplateSpec](#opencdk8s-cdk8s-argocd-resources-k8s-podtemplatespec)</code> | An object that describes the pod that will be created.
**minReadySeconds**?🔹 | <code>number</code> | The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available.<br/>__*Default*__: 0 (pod will be considered available as soon as it is ready).
**revisionHistoryLimit**?🔹 | <code>number</code> | The number of old history to retain to allow rollback.<br/>__*Default*__: 10.
**selector**?🔹 | <code>[k8s.LabelSelector](#opencdk8s-cdk8s-argocd-resources-k8s-labelselector)</code> | A label query over pods that are managed by the daemon set.<br/>__*Optional*__
**templateGeneration**?🔹 | <code>number</code> | DEPRECATED.<br/>__*Optional*__
**updateStrategy**?🔹 | <code>[k8s.DaemonSetUpdateStrategy](#opencdk8s-cdk8s-argocd-resources-k8s-daemonsetupdatestrategy)</code> | An update strategy to replace existing DaemonSet pods with new pods.<br/>__*Optional*__



## struct DaemonSetUpdateStrategy 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-daemonsetupdatestrategy"></a>






Name | Type | Description 
-----|------|-------------
**rollingUpdate**?🔹 | <code>[k8s.RollingUpdateDaemonSet](#opencdk8s-cdk8s-argocd-resources-k8s-rollingupdatedaemonset)</code> | Rolling update config params.<br/>__*Optional*__
**type**?🔹 | <code>string</code> | Type of daemon set update.<br/>__*Default*__: OnDelete.



## struct DeleteOptions 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-deleteoptions"></a>


DeleteOptions may be provided when deleting an API object.



Name | Type | Description 
-----|------|-------------
**apiVersion**?🔹 | <code>string</code> | APIVersion defines the versioned schema of this representation of an object.<br/>__*Optional*__
**dryRun**?🔹 | <code>Array<string></code> | When present, indicates that modifications should not be persisted.<br/>__*Optional*__
**gracePeriodSeconds**?🔹 | <code>number</code> | The duration in seconds before the object should be deleted.<br/>__*Default*__: a per object value if not specified. zero means delete immediately.
**kind**?🔹 | <code>[k8s.IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind](#opencdk8s-cdk8s-argocd-resources-k8s-iok8sapimachinerypkgapismetav1deleteoptionskind)</code> | Kind is a string value representing the REST resource this object represents.<br/>__*Optional*__
**orphanDependents**?🔹 | <code>boolean</code> | Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.<br/>__*Optional*__
**preconditions**?🔹 | <code>[k8s.Preconditions](#opencdk8s-cdk8s-argocd-resources-k8s-preconditions)</code> | Must be fulfilled before a deletion is carried out.<br/>__*Optional*__
**propagationPolicy**?🔹 | <code>string</code> | Whether and how garbage collection will be performed.<br/>__*Optional*__



## struct DeploymentSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-deploymentspec"></a>


DeploymentSpec is the specification of the desired behavior of the Deployment.



Name | Type | Description 
-----|------|-------------
**selector**🔹 | <code>[k8s.LabelSelector](#opencdk8s-cdk8s-argocd-resources-k8s-labelselector)</code> | Label selector for pods.
**template**🔹 | <code>[k8s.PodTemplateSpec](#opencdk8s-cdk8s-argocd-resources-k8s-podtemplatespec)</code> | Template describes the pods that will be created.
**minReadySeconds**?🔹 | <code>number</code> | Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available.<br/>__*Default*__: 0 (pod will be considered available as soon as it is ready)
**paused**?🔹 | <code>boolean</code> | Indicates that the deployment is paused.<br/>__*Optional*__
**progressDeadlineSeconds**?🔹 | <code>number</code> | The maximum time in seconds for a deployment to make progress before it is considered to be failed.<br/>__*Default*__: 600s.
**replicas**?🔹 | <code>number</code> | Number of desired pods.<br/>__*Default*__: 1.
**revisionHistoryLimit**?🔹 | <code>number</code> | The number of old ReplicaSets to retain to allow rollback.<br/>__*Default*__: 10.
**strategy**?🔹 | <code>[k8s.DeploymentStrategy](#opencdk8s-cdk8s-argocd-resources-k8s-deploymentstrategy)</code> | The deployment strategy to use to replace existing pods with new ones.<br/>__*Optional*__



## struct DeploymentStrategy 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-deploymentstrategy"></a>


DeploymentStrategy describes how to replace existing pods with new ones.



Name | Type | Description 
-----|------|-------------
**rollingUpdate**?🔹 | <code>[k8s.RollingUpdateDeployment](#opencdk8s-cdk8s-argocd-resources-k8s-rollingupdatedeployment)</code> | Rolling update config params.<br/>__*Optional*__
**type**?🔹 | <code>string</code> | Type of deployment.<br/>__*Default*__: RollingUpdate.



## struct DownwardApiProjection 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-downwardapiprojection"></a>


Represents downward API info for projecting into a projected volume.

Note that this is identical to a downwardAPI volume source without the default mode.



Name | Type | Description 
-----|------|-------------
**items**?🔹 | <code>Array<[k8s.DownwardApiVolumeFile](#opencdk8s-cdk8s-argocd-resources-k8s-downwardapivolumefile)></code> | Items is a list of DownwardAPIVolume file.<br/>__*Optional*__



## struct DownwardApiVolumeFile 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-downwardapivolumefile"></a>


DownwardAPIVolumeFile represents information to create the file containing the pod field.



Name | Type | Description 
-----|------|-------------
**path**🔹 | <code>string</code> | Required: Path is  the relative path name of the file to be created.
**fieldRef**?🔹 | <code>[k8s.ObjectFieldSelector](#opencdk8s-cdk8s-argocd-resources-k8s-objectfieldselector)</code> | Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.<br/>__*Optional*__
**mode**?🔹 | <code>number</code> | Optional: mode bits to use on this file, must be a value between 0 and 0777.<br/>__*Optional*__
**resourceFieldRef**?🔹 | <code>[k8s.ResourceFieldSelector](#opencdk8s-cdk8s-argocd-resources-k8s-resourcefieldselector)</code> | Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.<br/>__*Optional*__



## struct DownwardApiVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-downwardapivolumesource"></a>


DownwardAPIVolumeSource represents a volume containing downward API info.

Downward API volumes support ownership management and SELinux relabeling.



Name | Type | Description 
-----|------|-------------
**defaultMode**?🔹 | <code>number</code> | Optional: mode bits to use on created files by default.<br/>__*Default*__: 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
**items**?🔹 | <code>Array<[k8s.DownwardApiVolumeFile](#opencdk8s-cdk8s-argocd-resources-k8s-downwardapivolumefile)></code> | Items is a list of downward API volume file.<br/>__*Optional*__



## struct EmptyDirVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-emptydirvolumesource"></a>


Represents an empty directory for a pod.

Empty directory volumes support ownership management and SELinux relabeling.



Name | Type | Description 
-----|------|-------------
**medium**?🔹 | <code>string</code> | What type of storage medium should back this directory.<br/>__*Optional*__
**sizeLimit**?🔹 | <code>[k8s.Quantity](#opencdk8s-cdk8s-argocd-resources-k8s-quantity)</code> | Total amount of local storage required for this EmptyDir volume.<br/>__*Optional*__



## struct EndpointAddress 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-endpointaddress"></a>


EndpointAddress is a tuple that describes single IP address.



Name | Type | Description 
-----|------|-------------
**ip**🔹 | <code>string</code> | The IP of this endpoint.
**hostname**?🔹 | <code>string</code> | The Hostname of this endpoint.<br/>__*Optional*__
**nodeName**?🔹 | <code>string</code> | Optional: Node hosting this endpoint.<br/>__*Optional*__
**targetRef**?🔹 | <code>[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)</code> | Reference to object providing the endpoint.<br/>__*Optional*__



## struct EndpointPort 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-endpointport"></a>


EndpointPort is a tuple that describes a single port.



Name | Type | Description 
-----|------|-------------
**port**🔹 | <code>number</code> | The port number of the endpoint.
**name**?🔹 | <code>string</code> | The name of this port (corresponds to ServicePort.Name). Must be a DNS_LABEL. Optional only if one port is defined.<br/>__*Optional*__
**protocol**?🔹 | <code>string</code> | The IP protocol for this port.<br/>__*Default*__: TCP.



## struct EndpointSubset 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-endpointsubset"></a>


EndpointSubset is a group of addresses with a common set of ports.

The expanded set of endpoints is the Cartesian product of Addresses x Ports. For example, given:
{
  Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
  Ports:     [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
}
The resulting set of endpoints can be viewed as:
  a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],
  b: [ 10.10.1.1:309, 10.10.2.2:309 ]



Name | Type | Description 
-----|------|-------------
**addresses**?🔹 | <code>Array<[k8s.EndpointAddress](#opencdk8s-cdk8s-argocd-resources-k8s-endpointaddress)></code> | IP addresses which offer the related ports that are marked as ready.<br/>__*Optional*__
**notReadyAddresses**?🔹 | <code>Array<[k8s.EndpointAddress](#opencdk8s-cdk8s-argocd-resources-k8s-endpointaddress)></code> | IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.<br/>__*Optional*__
**ports**?🔹 | <code>Array<[k8s.EndpointPort](#opencdk8s-cdk8s-argocd-resources-k8s-endpointport)></code> | Port numbers available on the related IP addresses.<br/>__*Optional*__



## struct EnvFromSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-envfromsource"></a>


EnvFromSource represents the source of a set of ConfigMaps.



Name | Type | Description 
-----|------|-------------
**configMapRef**?🔹 | <code>[k8s.ConfigMapEnvSource](#opencdk8s-cdk8s-argocd-resources-k8s-configmapenvsource)</code> | The ConfigMap to select from.<br/>__*Optional*__
**prefix**?🔹 | <code>string</code> | An optional identifier to prepend to each key in the ConfigMap.<br/>__*Optional*__
**secretRef**?🔹 | <code>[k8s.SecretEnvSource](#opencdk8s-cdk8s-argocd-resources-k8s-secretenvsource)</code> | The Secret to select from.<br/>__*Optional*__



## struct EnvVar 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-envvar"></a>


EnvVar represents an environment variable present in a Container.



Name | Type | Description 
-----|------|-------------
**name**🔹 | <code>string</code> | Name of the environment variable.
**value**?🔹 | <code>string</code> | Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables.<br/>__*Default*__: .
**valueFrom**?🔹 | <code>[k8s.EnvVarSource](#opencdk8s-cdk8s-argocd-resources-k8s-envvarsource)</code> | Source for the environment variable's value.<br/>__*Optional*__



## struct EnvVarSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-envvarsource"></a>


EnvVarSource represents a source for the value of an EnvVar.



Name | Type | Description 
-----|------|-------------
**configMapKeyRef**?🔹 | <code>[k8s.ConfigMapKeySelector](#opencdk8s-cdk8s-argocd-resources-k8s-configmapkeyselector)</code> | Selects a key of a ConfigMap.<br/>__*Optional*__
**fieldRef**?🔹 | <code>[k8s.ObjectFieldSelector](#opencdk8s-cdk8s-argocd-resources-k8s-objectfieldselector)</code> | Selects a field of the pod: supports metadata.name, metadata.namespace, metadata.labels, metadata.annotations, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP.<br/>__*Optional*__
**resourceFieldRef**?🔹 | <code>[k8s.ResourceFieldSelector](#opencdk8s-cdk8s-argocd-resources-k8s-resourcefieldselector)</code> | Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.<br/>__*Optional*__
**secretKeyRef**?🔹 | <code>[k8s.SecretKeySelector](#opencdk8s-cdk8s-argocd-resources-k8s-secretkeyselector)</code> | Selects a key of a secret in the pod's namespace.<br/>__*Optional*__



## struct EventSeries 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-eventseries"></a>


EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time.



Name | Type | Description 
-----|------|-------------
**count**🔹 | <code>number</code> | Number of occurrences in this series up to the last heartbeat time.
**lastObservedTime**🔹 | <code>date</code> | Time when last Event from the series was seen before last heartbeat.
**state**🔹 | <code>string</code> | Information whether this series is ongoing or finished.



## struct EventSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-eventsource"></a>


EventSource contains information for an event.



Name | Type | Description 
-----|------|-------------
**component**?🔹 | <code>string</code> | Component from which the event is generated.<br/>__*Optional*__
**host**?🔹 | <code>string</code> | Node name on which the event is generated.<br/>__*Optional*__



## struct ExecAction 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-execaction"></a>


ExecAction describes a "run in container" action.



Name | Type | Description 
-----|------|-------------
**command**?🔹 | <code>Array<string></code> | Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem.<br/>__*Optional*__



## struct ExternalDocumentation 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-externaldocumentation"></a>


ExternalDocumentation allows referencing an external resource for extended documentation.



Name | Type | Description 
-----|------|-------------
**description**?🔹 | <code>string</code> | __*Optional*__
**url**?🔹 | <code>string</code> | __*Optional*__



## struct ExternalMetricSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-externalmetricsource"></a>


ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).



Name | Type | Description 
-----|------|-------------
**metric**🔹 | <code>[k8s.MetricIdentifier](#opencdk8s-cdk8s-argocd-resources-k8s-metricidentifier)</code> | metric identifies the target metric by name and selector.
**target**🔹 | <code>[k8s.MetricTarget](#opencdk8s-cdk8s-argocd-resources-k8s-metrictarget)</code> | target specifies the target value for the given metric.



## struct FcVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-fcvolumesource"></a>


Represents a Fibre Channel volume.

Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling.



Name | Type | Description 
-----|------|-------------
**fsType**?🔹 | <code>string</code> | Filesystem type to mount.<br/>__*Optional*__
**lun**?🔹 | <code>number</code> | Optional: FC target lun number.<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | Optional: Defaults to false (read/write).<br/>__*Default*__: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
**targetWWNs**?🔹 | <code>Array<string></code> | Optional: FC target worldwide names (WWNs).<br/>__*Optional*__
**wwids**?🔹 | <code>Array<string></code> | Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.<br/>__*Optional*__



## struct FlexPersistentVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-flexpersistentvolumesource"></a>


FlexPersistentVolumeSource represents a generic persistent volume resource that is provisioned/attached using an exec based plugin.



Name | Type | Description 
-----|------|-------------
**driver**🔹 | <code>string</code> | Driver is the name of the driver to use for this volume.
**fsType**?🔹 | <code>string</code> | Filesystem type to mount.<br/>__*Optional*__
**options**?🔹 | <code>Map<string, string></code> | Optional: Extra command options if any.<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | Optional: Defaults to false (read/write).<br/>__*Default*__: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
**secretRef**?🔹 | <code>[k8s.SecretReference](#opencdk8s-cdk8s-argocd-resources-k8s-secretreference)</code> | Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts.<br/>__*Optional*__



## struct FlexVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-flexvolumesource"></a>


FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.



Name | Type | Description 
-----|------|-------------
**driver**🔹 | <code>string</code> | Driver is the name of the driver to use for this volume.
**fsType**?🔹 | <code>string</code> | Filesystem type to mount.<br/>__*Optional*__
**options**?🔹 | <code>Map<string, string></code> | Optional: Extra command options if any.<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | Optional: Defaults to false (read/write).<br/>__*Default*__: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
**secretRef**?🔹 | <code>[k8s.LocalObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-localobjectreference)</code> | Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts.<br/>__*Optional*__



## struct FlockerVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-flockervolumesource"></a>


Represents a Flocker volume mounted by the Flocker agent.

One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling.



Name | Type | Description 
-----|------|-------------
**datasetName**?🔹 | <code>string</code> | Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated.<br/>__*Optional*__
**datasetUUID**?🔹 | <code>string</code> | UUID of the dataset.<br/>__*Optional*__



## struct FsGroupStrategyOptions 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-fsgroupstrategyoptions"></a>


FSGroupStrategyOptions defines the strategy type and options used to create the strategy.



Name | Type | Description 
-----|------|-------------
**ranges**?🔹 | <code>Array<[k8s.IdRange](#opencdk8s-cdk8s-argocd-resources-k8s-idrange)></code> | ranges are the allowed ranges of fs groups.<br/>__*Optional*__
**rule**?🔹 | <code>string</code> | rule is the strategy that will dictate what FSGroup is used in the SecurityContext.<br/>__*Optional*__



## struct GcePersistentDiskVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-gcepersistentdiskvolumesource"></a>


Represents a Persistent Disk resource in Google Compute Engine.

A GCE PD must exist before mounting to a container. The disk must also be in the same GCE project and zone as the kubelet. A GCE PD can only be mounted as read/write once or read-only many times. GCE PDs support ownership management and SELinux relabeling.



Name | Type | Description 
-----|------|-------------
**pdName**🔹 | <code>string</code> | Unique name of the PD resource in GCE.
**fsType**?🔹 | <code>string</code> | Filesystem type of the volume that you want to mount.<br/>__*Optional*__
**partition**?🔹 | <code>number</code> | The partition in the volume that you want to mount.<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | ReadOnly here will force the ReadOnly setting in VolumeMounts.<br/>__*Default*__: false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk



## struct GitRepoVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-gitrepovolumesource"></a>


Represents a volume that is populated with the contents of a git repository.

Git repo volumes do not support ownership management. Git repo volumes support SELinux relabeling.

DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.



Name | Type | Description 
-----|------|-------------
**repository**🔹 | <code>string</code> | Repository URL.
**directory**?🔹 | <code>string</code> | Target directory name.<br/>__*Optional*__
**revision**?🔹 | <code>string</code> | Commit hash for the specified revision.<br/>__*Optional*__



## struct GlusterfsPersistentVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-glusterfspersistentvolumesource"></a>


Represents a Glusterfs mount that lasts the lifetime of a pod.

Glusterfs volumes do not support ownership management or SELinux relabeling.



Name | Type | Description 
-----|------|-------------
**endpoints**🔹 | <code>string</code> | EndpointsName is the endpoint name that details Glusterfs topology.
**path**🔹 | <code>string</code> | Path is the Glusterfs volume path.
**endpointsNamespace**?🔹 | <code>string</code> | EndpointsNamespace is the namespace that contains Glusterfs endpoint.<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions.<br/>__*Default*__: false. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod



## struct GlusterfsVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-glusterfsvolumesource"></a>


Represents a Glusterfs mount that lasts the lifetime of a pod.

Glusterfs volumes do not support ownership management or SELinux relabeling.



Name | Type | Description 
-----|------|-------------
**endpoints**🔹 | <code>string</code> | EndpointsName is the endpoint name that details Glusterfs topology.
**path**🔹 | <code>string</code> | Path is the Glusterfs volume path.
**readOnly**?🔹 | <code>boolean</code> | ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions.<br/>__*Default*__: false. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod



## struct Handler 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-handler"></a>


Handler defines a specific action that should be taken.



Name | Type | Description 
-----|------|-------------
**exec**?🔹 | <code>[k8s.ExecAction](#opencdk8s-cdk8s-argocd-resources-k8s-execaction)</code> | One and only one of the following should be specified.<br/>__*Optional*__
**httpGet**?🔹 | <code>[k8s.HttpGetAction](#opencdk8s-cdk8s-argocd-resources-k8s-httpgetaction)</code> | HTTPGet specifies the http request to perform.<br/>__*Optional*__
**tcpSocket**?🔹 | <code>[k8s.TcpSocketAction](#opencdk8s-cdk8s-argocd-resources-k8s-tcpsocketaction)</code> | TCPSocket specifies an action involving a TCP port.<br/>__*Optional*__



## struct HorizontalPodAutoscalerSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-horizontalpodautoscalerspec"></a>


HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.



Name | Type | Description 
-----|------|-------------
**maxReplicas**🔹 | <code>number</code> | maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up.
**scaleTargetRef**🔹 | <code>[k8s.CrossVersionObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-crossversionobjectreference)</code> | scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
**metrics**?🔹 | <code>Array<[k8s.MetricSpec](#opencdk8s-cdk8s-argocd-resources-k8s-metricspec)></code> | metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).<br/>__*Optional*__
**minReplicas**?🔹 | <code>number</code> | minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.<br/>__*Optional*__



## struct HostAlias 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-hostalias"></a>


HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.



Name | Type | Description 
-----|------|-------------
**hostnames**?🔹 | <code>Array<string></code> | Hostnames for the above IP address.<br/>__*Optional*__
**ip**?🔹 | <code>string</code> | IP address of the host file entry.<br/>__*Optional*__



## struct HostPathVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-hostpathvolumesource"></a>


Represents a host path mapped into a pod.

Host path volumes do not support ownership management or SELinux relabeling.



Name | Type | Description 
-----|------|-------------
**path**🔹 | <code>string</code> | Path of the directory on the host.
**type**?🔹 | <code>string</code> | Type for HostPath Volume Defaults to "" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath.<br/>__*Default*__: More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath



## struct HostPortRange 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-hostportrange"></a>


HostPortRange defines a range of host ports that will be enabled by a policy for pods to use.

It requires both the start and end to be defined.



Name | Type | Description 
-----|------|-------------
**max**🔹 | <code>number</code> | max is the end of the range, inclusive.
**min**🔹 | <code>number</code> | min is the start of the range, inclusive.



## struct HttpGetAction 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-httpgetaction"></a>


HTTPGetAction describes an action based on HTTP Get requests.



Name | Type | Description 
-----|------|-------------
**port**🔹 | <code>[k8s.IntOrString](#opencdk8s-cdk8s-argocd-resources-k8s-intorstring)</code> | Name or number of the port to access on the container.
**host**?🔹 | <code>string</code> | Host name to connect to, defaults to the pod IP.<br/>__*Optional*__
**httpHeaders**?🔹 | <code>Array<[k8s.HttpHeader](#opencdk8s-cdk8s-argocd-resources-k8s-httpheader)></code> | Custom headers to set in the request.<br/>__*Optional*__
**path**?🔹 | <code>string</code> | Path to access on the HTTP server.<br/>__*Optional*__
**scheme**?🔹 | <code>string</code> | Scheme to use for connecting to the host.<br/>__*Default*__: HTTP.



## struct HttpHeader 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-httpheader"></a>


HTTPHeader describes a custom header to be used in HTTP probes.



Name | Type | Description 
-----|------|-------------
**name**🔹 | <code>string</code> | The header field name.
**value**🔹 | <code>string</code> | The header field value.



## struct HttpIngressPath 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-httpingresspath"></a>


HTTPIngressPath associates a path regex with a backend.

Incoming urls matching the path are forwarded to the backend.



Name | Type | Description 
-----|------|-------------
**backend**🔹 | <code>[k8s.IngressBackend](#opencdk8s-cdk8s-argocd-resources-k8s-ingressbackend)</code> | Backend defines the referenced service endpoint to which the traffic will be forwarded to.
**path**?🔹 | <code>string</code> | Path is an extended POSIX regex as defined by IEEE Std 1003.1, (i.e this follows the egrep/unix syntax, not the perl syntax) matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/'. If unspecified, the path defaults to a catch all sending traffic to the backend.<br/>__*Optional*__



## struct HttpIngressRuleValue 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-httpingressrulevalue"></a>


HTTPIngressRuleValue is a list of http selectors pointing to backends.

In the example: http://<host>/<path>?<searchpart> -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'.



Name | Type | Description 
-----|------|-------------
**paths**🔹 | <code>Array<[k8s.HttpIngressPath](#opencdk8s-cdk8s-argocd-resources-k8s-httpingresspath)></code> | A collection of paths that map requests to backends.



## struct IdRange 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-idrange"></a>


IDRange provides a min/max of an allowed range of IDs.



Name | Type | Description 
-----|------|-------------
**max**🔹 | <code>number</code> | max is the end of the range, inclusive.
**min**🔹 | <code>number</code> | min is the start of the range, inclusive.



## struct IngressBackend 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-ingressbackend"></a>


IngressBackend describes all endpoints for a given service and port.



Name | Type | Description 
-----|------|-------------
**serviceName**🔹 | <code>string</code> | Specifies the name of the referenced service.
**servicePort**🔹 | <code>[k8s.IntOrString](#opencdk8s-cdk8s-argocd-resources-k8s-intorstring)</code> | Specifies the port of the referenced service.



## struct IngressRule 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-ingressrule"></a>


IngressRule represents the rules mapping the paths under a specified host to the related backend services.

Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.



Name | Type | Description 
-----|------|-------------
**host**?🔹 | <code>string</code> | Host is the fully qualified domain name of a network host, as defined by RFC 3986.<br/>__*Optional*__
**http**?🔹 | <code>[k8s.HttpIngressRuleValue](#opencdk8s-cdk8s-argocd-resources-k8s-httpingressrulevalue)</code> | __*Optional*__



## struct IngressSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-ingressspec"></a>


IngressSpec describes the Ingress the user wishes to exist.



Name | Type | Description 
-----|------|-------------
**backend**?🔹 | <code>[k8s.IngressBackend](#opencdk8s-cdk8s-argocd-resources-k8s-ingressbackend)</code> | A default backend capable of servicing requests that don't match any rule.<br/>__*Optional*__
**rules**?🔹 | <code>Array<[k8s.IngressRule](#opencdk8s-cdk8s-argocd-resources-k8s-ingressrule)></code> | A list of host rules used to configure the Ingress.<br/>__*Optional*__
**tls**?🔹 | <code>Array<[k8s.IngressTls](#opencdk8s-cdk8s-argocd-resources-k8s-ingresstls)></code> | TLS configuration.<br/>__*Optional*__



## struct IngressTls 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-ingresstls"></a>


IngressTLS describes the transport layer security associated with an Ingress.



Name | Type | Description 
-----|------|-------------
**hosts**?🔹 | <code>Array<string></code> | Hosts are a list of hosts included in the TLS certificate.<br/>__*Default*__: the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
**secretName**?🔹 | <code>string</code> | SecretName is the name of the secret used to terminate SSL traffic on 443.<br/>__*Optional*__



## struct Initializer 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-initializer"></a>


Initializer is information about an initializer that has not yet completed.



Name | Type | Description 
-----|------|-------------
**name**🔹 | <code>string</code> | name of the process that is responsible for initializing this object.



## struct Initializers 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-initializers"></a>


Initializers tracks the progress of initialization.



Name | Type | Description 
-----|------|-------------
**pending**🔹 | <code>Array<[k8s.Initializer](#opencdk8s-cdk8s-argocd-resources-k8s-initializer)></code> | Pending is a list of initializers that must execute in order before this object is visible.
**result**?🔹 | <code>[k8s.KubeStatusProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatusprops)</code> | If result is set with the Failure field, the object will be persisted to storage and then deleted, ensuring that other clients can observe the deletion.<br/>__*Optional*__



## struct IpBlock 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-ipblock"></a>


IPBlock describes a particular CIDR (Ex.

"192.168.1.1/24") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule.



Name | Type | Description 
-----|------|-------------
**cidr**🔹 | <code>string</code> | CIDR is a string representing the IP Block Valid examples are "192.168.1.1/24".
**except**?🔹 | <code>Array<string></code> | Except is a slice of CIDRs that should not be included within an IP Block Valid examples are "192.168.1.1/24" Except values will be rejected if they are outside the CIDR range.<br/>__*Optional*__



## struct IscsiPersistentVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-iscsipersistentvolumesource"></a>


ISCSIPersistentVolumeSource represents an ISCSI disk.

ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.



Name | Type | Description 
-----|------|-------------
**iqn**🔹 | <code>string</code> | Target iSCSI Qualified Name.
**lun**🔹 | <code>number</code> | iSCSI Target Lun number.
**targetPortal**🔹 | <code>string</code> | iSCSI Target Portal.
**chapAuthDiscovery**?🔹 | <code>boolean</code> | whether support iSCSI Discovery CHAP authentication.<br/>__*Optional*__
**chapAuthSession**?🔹 | <code>boolean</code> | whether support iSCSI Session CHAP authentication.<br/>__*Optional*__
**fsType**?🔹 | <code>string</code> | Filesystem type of the volume that you want to mount.<br/>__*Optional*__
**initiatorName**?🔹 | <code>string</code> | Custom iSCSI Initiator Name.<br/>__*Optional*__
**iscsiInterface**?🔹 | <code>string</code> | iSCSI Interface Name that uses an iSCSI transport.<br/>__*Default*__: default' (tcp).
**portals**?🔹 | <code>Array<string></code> | iSCSI Target Portal List.<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | ReadOnly here will force the ReadOnly setting in VolumeMounts.<br/>__*Default*__: false.
**secretRef**?🔹 | <code>[k8s.SecretReference](#opencdk8s-cdk8s-argocd-resources-k8s-secretreference)</code> | CHAP Secret for iSCSI target and initiator authentication.<br/>__*Optional*__



## struct IscsiVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-iscsivolumesource"></a>


Represents an ISCSI disk.

ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.



Name | Type | Description 
-----|------|-------------
**iqn**🔹 | <code>string</code> | Target iSCSI Qualified Name.
**lun**🔹 | <code>number</code> | iSCSI Target Lun number.
**targetPortal**🔹 | <code>string</code> | iSCSI Target Portal.
**chapAuthDiscovery**?🔹 | <code>boolean</code> | whether support iSCSI Discovery CHAP authentication.<br/>__*Optional*__
**chapAuthSession**?🔹 | <code>boolean</code> | whether support iSCSI Session CHAP authentication.<br/>__*Optional*__
**fsType**?🔹 | <code>string</code> | Filesystem type of the volume that you want to mount.<br/>__*Optional*__
**initiatorName**?🔹 | <code>string</code> | Custom iSCSI Initiator Name.<br/>__*Optional*__
**iscsiInterface**?🔹 | <code>string</code> | iSCSI Interface Name that uses an iSCSI transport.<br/>__*Default*__: default' (tcp).
**portals**?🔹 | <code>Array<string></code> | iSCSI Target Portal List.<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | ReadOnly here will force the ReadOnly setting in VolumeMounts.<br/>__*Default*__: false.
**secretRef**?🔹 | <code>[k8s.LocalObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-localobjectreference)</code> | CHAP Secret for iSCSI target and initiator authentication.<br/>__*Optional*__



## struct JobSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-jobspec"></a>


JobSpec describes how the job execution will look like.



Name | Type | Description 
-----|------|-------------
**template**🔹 | <code>[k8s.PodTemplateSpec](#opencdk8s-cdk8s-argocd-resources-k8s-podtemplatespec)</code> | Describes the pod that will be created when executing a job.
**activeDeadlineSeconds**?🔹 | <code>number</code> | Specifies the duration in seconds relative to the startTime that the job may be active before the system tries to terminate it;<br/>__*Optional*__
**backoffLimit**?🔹 | <code>number</code> | Specifies the number of retries before marking this job failed.<br/>__*Default*__: 6
**completions**?🔹 | <code>number</code> | Specifies the desired number of successfully finished pods the job should be run with.<br/>__*Optional*__
**manualSelector**?🔹 | <code>boolean</code> | manualSelector controls generation of pod labels and pod selectors.<br/>__*Optional*__
**parallelism**?🔹 | <code>number</code> | Specifies the maximum desired number of pods the job should run at any given time.<br/>__*Optional*__
**selector**?🔹 | <code>[k8s.LabelSelector](#opencdk8s-cdk8s-argocd-resources-k8s-labelselector)</code> | A label query over pods that should match the pod count.<br/>__*Optional*__
**ttlSecondsAfterFinished**?🔹 | <code>number</code> | ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed).<br/>__*Optional*__



## struct JobTemplateSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-jobtemplatespec"></a>


JobTemplateSpec describes the data a Job should have when created from a template.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata of the jobs created from this template.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.JobSpec](#opencdk8s-cdk8s-argocd-resources-k8s-jobspec)</code> | Specification of the desired behavior of the job.<br/>__*Optional*__



## struct JsonSchemaProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-jsonschemaprops"></a>


JSONSchemaProps is a JSON-Schema following Specification Draft 4 (http://json-schema.org/).



Name | Type | Description 
-----|------|-------------
**additionalItems**?🔹 | <code>any</code> | __*Optional*__
**additionalProperties**?🔹 | <code>any</code> | __*Optional*__
**allOf**?🔹 | <code>Array<[k8s.JsonSchemaProps](#opencdk8s-cdk8s-argocd-resources-k8s-jsonschemaprops)></code> | __*Optional*__
**anyOf**?🔹 | <code>Array<[k8s.JsonSchemaProps](#opencdk8s-cdk8s-argocd-resources-k8s-jsonschemaprops)></code> | __*Optional*__
**default**?🔹 | <code>any</code> | default is a default value for undefined object fields.<br/>__*Optional*__
**definitions**?🔹 | <code>Map<string, [k8s.JsonSchemaProps](#opencdk8s-cdk8s-argocd-resources-k8s-jsonschemaprops)></code> | __*Optional*__
**dependencies**?🔹 | <code>Map<string, any></code> | __*Optional*__
**description**?🔹 | <code>string</code> | __*Optional*__
**enum**?🔹 | <code>Array<any></code> | __*Optional*__
**example**?🔹 | <code>any</code> | __*Optional*__
**exclusiveMaximum**?🔹 | <code>boolean</code> | __*Optional*__
**exclusiveMinimum**?🔹 | <code>boolean</code> | __*Optional*__
**externalDocs**?🔹 | <code>[k8s.ExternalDocumentation](#opencdk8s-cdk8s-argocd-resources-k8s-externaldocumentation)</code> | __*Optional*__
**format**?🔹 | <code>string</code> | __*Optional*__
**id**?🔹 | <code>string</code> | __*Optional*__
**items**?🔹 | <code>any</code> | __*Optional*__
**maxItems**?🔹 | <code>number</code> | __*Optional*__
**maxLength**?🔹 | <code>number</code> | __*Optional*__
**maxProperties**?🔹 | <code>number</code> | __*Optional*__
**maximum**?🔹 | <code>number</code> | __*Optional*__
**minItems**?🔹 | <code>number</code> | __*Optional*__
**minLength**?🔹 | <code>number</code> | __*Optional*__
**minProperties**?🔹 | <code>number</code> | __*Optional*__
**minimum**?🔹 | <code>number</code> | __*Optional*__
**multipleOf**?🔹 | <code>number</code> | __*Optional*__
**not**?🔹 | <code>[k8s.JsonSchemaProps](#opencdk8s-cdk8s-argocd-resources-k8s-jsonschemaprops)</code> | __*Optional*__
**nullable**?🔹 | <code>boolean</code> | __*Optional*__
**oneOf**?🔹 | <code>Array<[k8s.JsonSchemaProps](#opencdk8s-cdk8s-argocd-resources-k8s-jsonschemaprops)></code> | __*Optional*__
**pattern**?🔹 | <code>string</code> | __*Optional*__
**patternProperties**?🔹 | <code>Map<string, [k8s.JsonSchemaProps](#opencdk8s-cdk8s-argocd-resources-k8s-jsonschemaprops)></code> | __*Optional*__
**properties**?🔹 | <code>Map<string, [k8s.JsonSchemaProps](#opencdk8s-cdk8s-argocd-resources-k8s-jsonschemaprops)></code> | __*Optional*__
**ref**?🔹 | <code>string</code> | __*Optional*__
**required**?🔹 | <code>Array<string></code> | __*Optional*__
**schema**?🔹 | <code>string</code> | __*Optional*__
**title**?🔹 | <code>string</code> | __*Optional*__
**type**?🔹 | <code>string</code> | __*Optional*__
**uniqueItems**?🔹 | <code>boolean</code> | __*Optional*__



## struct KeyToPath 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-keytopath"></a>


Maps a string key to a path within a volume.



Name | Type | Description 
-----|------|-------------
**key**🔹 | <code>string</code> | The key to project.
**path**🔹 | <code>string</code> | The relative path of the file to map the key to.
**mode**?🔹 | <code>number</code> | Optional: mode bits to use on this file, must be a value between 0 and 0777.<br/>__*Optional*__



## struct KubeApiServiceListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicelistprops"></a>


APIServiceList is a list of APIService objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeApiServiceProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiserviceprops)></code> | <span></span>
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | __*Optional*__



## struct KubeApiServiceListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicelistv1beta1props"></a>


APIServiceList is a list of APIService objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeApiServiceV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicev1beta1props)></code> | <span></span>
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | __*Optional*__



## struct KubeApiServiceProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeapiserviceprops"></a>


APIService represents a server for a particular GroupVersion.

Name must be "version.group".



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__
**spec**?🔹 | <code>[k8s.ApiServiceSpec](#opencdk8s-cdk8s-argocd-resources-k8s-apiservicespec)</code> | Spec contains information for locating and communicating with a server.<br/>__*Optional*__



## struct KubeApiServiceV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeapiservicev1beta1props"></a>


APIService represents a server for a particular GroupVersion.

Name must be "version.group".



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__
**spec**?🔹 | <code>[k8s.ApiServiceSpec](#opencdk8s-cdk8s-argocd-resources-k8s-apiservicespec)</code> | Spec contains information for locating and communicating with a server.<br/>__*Optional*__



## struct KubeAuditSinkListV1Alpha1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeauditsinklistv1alpha1props"></a>


AuditSinkList is a list of AuditSink items.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeAuditSinkV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeauditsinkv1alpha1props)></code> | List of audit configurations.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | __*Optional*__



## struct KubeAuditSinkV1Alpha1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeauditsinkv1alpha1props"></a>


AuditSink represents a cluster level audit sink.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__
**spec**?🔹 | <code>[k8s.AuditSinkSpec](#opencdk8s-cdk8s-argocd-resources-k8s-auditsinkspec)</code> | Spec defines the audit configuration spec.<br/>__*Optional*__



## struct KubeBindingProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubebindingprops"></a>


Binding ties one object to another;

for example, a pod is bound to a node by a scheduler. Deprecated in 1.7, please use the bindings subresource of pods instead.



Name | Type | Description 
-----|------|-------------
**target**🔹 | <code>[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)</code> | The target object that you want to bind to the standard object.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__



## struct KubeCertificateSigningRequestListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecertificatesigningrequestlistv1beta1props"></a>






Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeCertificateSigningRequestV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecertificatesigningrequestv1beta1props)></code> | <span></span>
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | __*Optional*__



## struct KubeCertificateSigningRequestV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecertificatesigningrequestv1beta1props"></a>


Describes a certificate signing request.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__
**spec**?🔹 | <code>[k8s.CertificateSigningRequestSpec](#opencdk8s-cdk8s-argocd-resources-k8s-certificatesigningrequestspec)</code> | The certificate request itself and any additional information.<br/>__*Optional*__



## struct KubeClusterRoleBindingListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindinglistprops"></a>


ClusterRoleBindingList is a collection of ClusterRoleBindings.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeClusterRoleBindingProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingprops)></code> | Items is a list of ClusterRoleBindings.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard object's metadata.<br/>__*Optional*__



## struct KubeClusterRoleBindingListV1Alpha1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindinglistv1alpha1props"></a>


ClusterRoleBindingList is a collection of ClusterRoleBindings.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeClusterRoleBindingV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingv1alpha1props)></code> | Items is a list of ClusterRoleBindings.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard object's metadata.<br/>__*Optional*__



## struct KubeClusterRoleBindingListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindinglistv1beta1props"></a>


ClusterRoleBindingList is a collection of ClusterRoleBindings.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeClusterRoleBindingV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingv1beta1props)></code> | Items is a list of ClusterRoleBindings.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard object's metadata.<br/>__*Optional*__



## struct KubeClusterRoleBindingProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingprops"></a>


ClusterRoleBinding references a ClusterRole, but not contain it.

It can reference a ClusterRole in the global namespace, and adds who information via Subject.



Name | Type | Description 
-----|------|-------------
**roleRef**🔹 | <code>[k8s.RoleRef](#opencdk8s-cdk8s-argocd-resources-k8s-roleref)</code> | RoleRef can only reference a ClusterRole in the global namespace.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**subjects**?🔹 | <code>Array<[k8s.Subject](#opencdk8s-cdk8s-argocd-resources-k8s-subject)></code> | Subjects holds references to the objects the role applies to.<br/>__*Optional*__



## struct KubeClusterRoleBindingV1Alpha1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingv1alpha1props"></a>


ClusterRoleBinding references a ClusterRole, but not contain it.

It can reference a ClusterRole in the global namespace, and adds who information via Subject.



Name | Type | Description 
-----|------|-------------
**roleRef**🔹 | <code>[k8s.RoleRef](#opencdk8s-cdk8s-argocd-resources-k8s-roleref)</code> | RoleRef can only reference a ClusterRole in the global namespace.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**subjects**?🔹 | <code>Array<[k8s.Subject](#opencdk8s-cdk8s-argocd-resources-k8s-subject)></code> | Subjects holds references to the objects the role applies to.<br/>__*Optional*__



## struct KubeClusterRoleBindingV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolebindingv1beta1props"></a>


ClusterRoleBinding references a ClusterRole, but not contain it.

It can reference a ClusterRole in the global namespace, and adds who information via Subject.



Name | Type | Description 
-----|------|-------------
**roleRef**🔹 | <code>[k8s.RoleRef](#opencdk8s-cdk8s-argocd-resources-k8s-roleref)</code> | RoleRef can only reference a ClusterRole in the global namespace.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**subjects**?🔹 | <code>Array<[k8s.Subject](#opencdk8s-cdk8s-argocd-resources-k8s-subject)></code> | Subjects holds references to the objects the role applies to.<br/>__*Optional*__



## struct KubeClusterRoleListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolelistprops"></a>


ClusterRoleList is a collection of ClusterRoles.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeClusterRoleProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterroleprops)></code> | Items is a list of ClusterRoles.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard object's metadata.<br/>__*Optional*__



## struct KubeClusterRoleListV1Alpha1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolelistv1alpha1props"></a>


ClusterRoleList is a collection of ClusterRoles.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeClusterRoleV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolev1alpha1props)></code> | Items is a list of ClusterRoles.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard object's metadata.<br/>__*Optional*__



## struct KubeClusterRoleListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolelistv1beta1props"></a>


ClusterRoleList is a collection of ClusterRoles.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeClusterRoleV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolev1beta1props)></code> | Items is a list of ClusterRoles.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard object's metadata.<br/>__*Optional*__



## struct KubeClusterRoleProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterroleprops"></a>


ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.



Name | Type | Description 
-----|------|-------------
**aggregationRule**?🔹 | <code>[k8s.AggregationRule](#opencdk8s-cdk8s-argocd-resources-k8s-aggregationrule)</code> | AggregationRule is an optional field that describes how to build the Rules for this ClusterRole.<br/>__*Optional*__
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**rules**?🔹 | <code>Array<[k8s.PolicyRule](#opencdk8s-cdk8s-argocd-resources-k8s-policyrule)></code> | Rules holds all the PolicyRules for this ClusterRole.<br/>__*Optional*__



## struct KubeClusterRoleV1Alpha1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolev1alpha1props"></a>


ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.



Name | Type | Description 
-----|------|-------------
**aggregationRule**?🔹 | <code>[k8s.AggregationRule](#opencdk8s-cdk8s-argocd-resources-k8s-aggregationrule)</code> | AggregationRule is an optional field that describes how to build the Rules for this ClusterRole.<br/>__*Optional*__
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**rules**?🔹 | <code>Array<[k8s.PolicyRule](#opencdk8s-cdk8s-argocd-resources-k8s-policyrule)></code> | Rules holds all the PolicyRules for this ClusterRole.<br/>__*Optional*__



## struct KubeClusterRoleV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeclusterrolev1beta1props"></a>


ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.



Name | Type | Description 
-----|------|-------------
**aggregationRule**?🔹 | <code>[k8s.AggregationRule](#opencdk8s-cdk8s-argocd-resources-k8s-aggregationrule)</code> | AggregationRule is an optional field that describes how to build the Rules for this ClusterRole.<br/>__*Optional*__
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**rules**?🔹 | <code>Array<[k8s.PolicyRule](#opencdk8s-cdk8s-argocd-resources-k8s-policyrule)></code> | Rules holds all the PolicyRules for this ClusterRole.<br/>__*Optional*__



## struct KubeComponentStatusListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecomponentstatuslistprops"></a>


Status of all the conditions for the component as a list of ComponentStatus objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeComponentStatusProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubecomponentstatusprops)></code> | List of ComponentStatus objects.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeComponentStatusProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecomponentstatusprops"></a>


ComponentStatus (and ComponentStatusList) holds the cluster validation info.



Name | Type | Description 
-----|------|-------------
**conditions**?🔹 | <code>Array<[k8s.ComponentCondition](#opencdk8s-cdk8s-argocd-resources-k8s-componentcondition)></code> | List of component conditions observed.<br/>__*Optional*__
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__



## struct KubeConfigMapListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeconfigmaplistprops"></a>


ConfigMapList is a resource containing a list of ConfigMap objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeConfigMapProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeconfigmapprops)></code> | Items is the list of ConfigMaps.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.<br/>__*Optional*__



## struct KubeConfigMapProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeconfigmapprops"></a>


ConfigMap holds configuration data for pods to consume.



Name | Type | Description 
-----|------|-------------
**binaryData**?🔹 | <code>Map<string, string></code> | BinaryData contains the binary data.<br/>__*Optional*__
**data**?🔹 | <code>Map<string, string></code> | Data contains the configuration data.<br/>__*Optional*__
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__



## struct KubeControllerRevisionListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionlistprops"></a>


ControllerRevisionList is a resource containing a list of ControllerRevision objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeControllerRevisionProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionprops)></code> | Items is the list of ControllerRevisions.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.<br/>__*Optional*__



## struct KubeControllerRevisionListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionlistv1beta1props"></a>


ControllerRevisionList is a resource containing a list of ControllerRevision objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeControllerRevisionV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionv1beta1props)></code> | Items is the list of ControllerRevisions.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.<br/>__*Optional*__



## struct KubeControllerRevisionListV1Beta2Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionlistv1beta2props"></a>


ControllerRevisionList is a resource containing a list of ControllerRevision objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeControllerRevisionV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionv1beta2props)></code> | Items is the list of ControllerRevisions.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.<br/>__*Optional*__



## struct KubeControllerRevisionProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionprops"></a>


ControllerRevision implements an immutable snapshot of state data.

Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.



Name | Type | Description 
-----|------|-------------
**revision**🔹 | <code>number</code> | Revision indicates the revision of the state represented by Data.
**data**?🔹 | <code>[k8s.RawExtension](#opencdk8s-cdk8s-argocd-resources-k8s-rawextension)</code> | Data is the serialized representation of the state.<br/>__*Optional*__
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__



## struct KubeControllerRevisionV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionv1beta1props"></a>


DEPRECATED - This group version of ControllerRevision is deprecated by apps/v1beta2/ControllerRevision.

See the release notes for more information. ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.



Name | Type | Description 
-----|------|-------------
**revision**🔹 | <code>number</code> | Revision indicates the revision of the state represented by Data.
**data**?🔹 | <code>[k8s.RawExtension](#opencdk8s-cdk8s-argocd-resources-k8s-rawextension)</code> | Data is the serialized representation of the state.<br/>__*Optional*__
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__



## struct KubeControllerRevisionV1Beta2Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecontrollerrevisionv1beta2props"></a>


DEPRECATED - This group version of ControllerRevision is deprecated by apps/v1/ControllerRevision.

See the release notes for more information. ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.



Name | Type | Description 
-----|------|-------------
**revision**🔹 | <code>number</code> | Revision indicates the revision of the state represented by Data.
**data**?🔹 | <code>[k8s.RawExtension](#opencdk8s-cdk8s-argocd-resources-k8s-rawextension)</code> | Data is the serialized representation of the state.<br/>__*Optional*__
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__



## struct KubeCronJobListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecronjoblistv1beta1props"></a>


CronJobList is a collection of cron jobs.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeCronJobV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjobv1beta1props)></code> | items is the list of CronJobs.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeCronJobListV2Alpha1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecronjoblistv2alpha1props"></a>


CronJobList is a collection of cron jobs.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeCronJobV2Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecronjobv2alpha1props)></code> | items is the list of CronJobs.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeCronJobV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecronjobv1beta1props"></a>


CronJob represents the configuration of a single cron job.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.CronJobSpec](#opencdk8s-cdk8s-argocd-resources-k8s-cronjobspec)</code> | Specification of the desired behavior of a cron job, including the schedule.<br/>__*Optional*__



## struct KubeCronJobV2Alpha1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecronjobv2alpha1props"></a>


CronJob represents the configuration of a single cron job.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.CronJobSpec](#opencdk8s-cdk8s-argocd-resources-k8s-cronjobspec)</code> | Specification of the desired behavior of a cron job, including the schedule.<br/>__*Optional*__



## struct KubeCsiDriverListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecsidriverlistv1beta1props"></a>


CSIDriverList is a collection of CSIDriver objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeCsiDriverV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsidriverv1beta1props)></code> | items is the list of CSIDriver.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.<br/>__*Optional*__



## struct KubeCsiDriverV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecsidriverv1beta1props"></a>


CSIDriver captures information about a Container Storage Interface (CSI) volume driver deployed on the cluster.

CSI drivers do not need to create the CSIDriver object directly. Instead they may use the cluster-driver-registrar sidecar container. When deployed with a CSI driver it automatically creates a CSIDriver object representing the driver. Kubernetes attach detach controller uses this object to determine whether attach is required. Kubelet uses this object to determine whether pod information needs to be passed on mount. CSIDriver objects are non-namespaced.



Name | Type | Description 
-----|------|-------------
**spec**🔹 | <code>[k8s.CsiDriverSpec](#opencdk8s-cdk8s-argocd-resources-k8s-csidriverspec)</code> | Specification of the CSI Driver.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object metadata.<br/>__*Optional*__



## struct KubeCsiNodeListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecsinodelistv1beta1props"></a>


CSINodeList is a collection of CSINode objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeCsiNodeV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecsinodev1beta1props)></code> | items is the list of CSINode.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.<br/>__*Optional*__



## struct KubeCsiNodeV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecsinodev1beta1props"></a>


CSINode holds information about all CSI drivers installed on a node.

CSI drivers do not need to create the CSINode object directly. As long as they use the node-driver-registrar sidecar container, the kubelet will automatically populate the CSINode object for the CSI driver as part of kubelet plugin registration. CSINode has the same name as a node. If the object is missing, it means either there are no CSI Drivers available on the node, or the Kubelet version is low enough that it doesn't create this object. CSINode has an OwnerReference that points to the corresponding node object.



Name | Type | Description 
-----|------|-------------
**spec**🔹 | <code>[k8s.CsiNodeSpec](#opencdk8s-cdk8s-argocd-resources-k8s-csinodespec)</code> | spec is the specification of CSINode.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | metadata.name must be the Kubernetes node name.<br/>__*Optional*__



## struct KubeCustomResourceDefinitionListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecustomresourcedefinitionlistv1beta1props"></a>


CustomResourceDefinitionList is a list of CustomResourceDefinition objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeCustomResourceDefinitionV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubecustomresourcedefinitionv1beta1props)></code> | Items individual CustomResourceDefinitions.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | __*Optional*__



## struct KubeCustomResourceDefinitionV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubecustomresourcedefinitionv1beta1props"></a>


CustomResourceDefinition represents a resource that should be exposed on the API server.

Its name MUST be in the format <.spec.name>.<.spec.group>.



Name | Type | Description 
-----|------|-------------
**spec**🔹 | <code>[k8s.CustomResourceDefinitionSpec](#opencdk8s-cdk8s-argocd-resources-k8s-customresourcedefinitionspec)</code> | Spec describes how the user wants the resources to appear.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__



## struct KubeDaemonSetListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetlistprops"></a>


DaemonSetList is a collection of daemon sets.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeDaemonSetProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetprops)></code> | A list of daemon sets.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeDaemonSetListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetlistv1beta1props"></a>


DaemonSetList is a collection of daemon sets.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeDaemonSetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetv1beta1props)></code> | A list of daemon sets.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeDaemonSetListV1Beta2Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetlistv1beta2props"></a>


DaemonSetList is a collection of daemon sets.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeDaemonSetV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetv1beta2props)></code> | A list of daemon sets.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeDaemonSetProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetprops"></a>


DaemonSet represents the configuration of a daemon set.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.DaemonSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-daemonsetspec)</code> | The desired behavior of this daemon set.<br/>__*Optional*__



## struct KubeDaemonSetV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetv1beta1props"></a>


DEPRECATED - This group version of DaemonSet is deprecated by apps/v1beta2/DaemonSet.

See the release notes for more information. DaemonSet represents the configuration of a daemon set.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.DaemonSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-daemonsetspec)</code> | The desired behavior of this daemon set.<br/>__*Optional*__



## struct KubeDaemonSetV1Beta2Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedaemonsetv1beta2props"></a>


DEPRECATED - This group version of DaemonSet is deprecated by apps/v1/DaemonSet.

See the release notes for more information. DaemonSet represents the configuration of a daemon set.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.DaemonSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-daemonsetspec)</code> | The desired behavior of this daemon set.<br/>__*Optional*__



## struct KubeDeploymentListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentlistprops"></a>


DeploymentList is a list of Deployments.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeDeploymentProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentprops)></code> | Items is the list of Deployments.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeDeploymentListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentlistv1beta1props"></a>


DeploymentList is a list of Deployments.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeDeploymentV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentv1beta1props)></code> | Items is the list of Deployments.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeDeploymentListV1Beta2Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentlistv1beta2props"></a>


DeploymentList is a list of Deployments.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeDeploymentV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentv1beta2props)></code> | Items is the list of Deployments.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeDeploymentProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentprops"></a>


Deployment enables declarative updates for Pods and ReplicaSets.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.DeploymentSpec](#opencdk8s-cdk8s-argocd-resources-k8s-deploymentspec)</code> | Specification of the desired behavior of the Deployment.<br/>__*Optional*__



## struct KubeDeploymentV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentv1beta1props"></a>


DEPRECATED - This group version of Deployment is deprecated by apps/v1beta2/Deployment.

See the release notes for more information. Deployment enables declarative updates for Pods and ReplicaSets.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.DeploymentSpec](#opencdk8s-cdk8s-argocd-resources-k8s-deploymentspec)</code> | Specification of the desired behavior of the Deployment.<br/>__*Optional*__



## struct KubeDeploymentV1Beta2Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubedeploymentv1beta2props"></a>


DEPRECATED - This group version of Deployment is deprecated by apps/v1/Deployment.

See the release notes for more information. Deployment enables declarative updates for Pods and ReplicaSets.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.DeploymentSpec](#opencdk8s-cdk8s-argocd-resources-k8s-deploymentspec)</code> | Specification of the desired behavior of the Deployment.<br/>__*Optional*__



## struct KubeEndpointsListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeendpointslistprops"></a>


EndpointsList is a list of endpoints.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeEndpointsProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeendpointsprops)></code> | List of endpoints.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeEndpointsProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeendpointsprops"></a>


Endpoints is a collection of endpoints that implement the actual service.

Example:
Name: "mysvc",
Subsets: [
  {
    Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
    Ports: [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
  },
  {
    Addresses: [{"ip": "10.10.3.3"}],
    Ports: [{"name": "a", "port": 93}, {"name": "b", "port": 76}]
  },
]



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**subsets**?🔹 | <code>Array<[k8s.EndpointSubset](#opencdk8s-cdk8s-argocd-resources-k8s-endpointsubset)></code> | The set of all endpoints is the union of all subsets.<br/>__*Optional*__



## struct KubeEventListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeeventlistprops"></a>


EventList is a list of events.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeEventProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeeventprops)></code> | List of events.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeEventListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeeventlistv1beta1props"></a>


EventList is a list of Event objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeEventV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeeventv1beta1props)></code> | Items is a list of schema objects.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeEventProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeeventprops"></a>


Event is a report of an event somewhere in the cluster.



Name | Type | Description 
-----|------|-------------
**involvedObject**🔹 | <code>[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)</code> | The object that this event is about.
**metadata**🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.
**action**?🔹 | <code>string</code> | What action was taken/failed regarding to the Regarding object.<br/>__*Optional*__
**count**?🔹 | <code>number</code> | The number of times this event has occurred.<br/>__*Optional*__
**eventTime**?🔹 | <code>date</code> | Time when this Event was first observed.<br/>__*Optional*__
**firstTimestamp**?🔹 | <code>date</code> | The time at which the event was first recorded.<br/>__*Optional*__
**lastTimestamp**?🔹 | <code>date</code> | The time at which the most recent occurrence of this event was recorded.<br/>__*Optional*__
**message**?🔹 | <code>string</code> | A human-readable description of the status of this operation.<br/>__*Optional*__
**reason**?🔹 | <code>string</code> | This should be a short, machine understandable string that gives the reason for the transition into the object's current status.<br/>__*Optional*__
**related**?🔹 | <code>[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)</code> | Optional secondary object for more complex actions.<br/>__*Optional*__
**reportingComponent**?🔹 | <code>string</code> | Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.<br/>__*Optional*__
**reportingInstance**?🔹 | <code>string</code> | ID of the controller instance, e.g. `kubelet-xyzf`.<br/>__*Optional*__
**series**?🔹 | <code>[k8s.EventSeries](#opencdk8s-cdk8s-argocd-resources-k8s-eventseries)</code> | Data about the Event series this event represents or nil if it's a singleton Event.<br/>__*Optional*__
**source**?🔹 | <code>[k8s.EventSource](#opencdk8s-cdk8s-argocd-resources-k8s-eventsource)</code> | The component reporting this event.<br/>__*Optional*__
**type**?🔹 | <code>string</code> | Type of this event (Normal, Warning), new types could be added in the future.<br/>__*Optional*__



## struct KubeEventV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeeventv1beta1props"></a>


Event is a report of an event somewhere in the cluster.

It generally denotes some state change in the system.



Name | Type | Description 
-----|------|-------------
**eventTime**🔹 | <code>date</code> | Required.
**action**?🔹 | <code>string</code> | What action was taken/failed regarding to the regarding object.<br/>__*Optional*__
**deprecatedCount**?🔹 | <code>number</code> | Deprecated field assuring backward compatibility with core.v1 Event type.<br/>__*Optional*__
**deprecatedFirstTimestamp**?🔹 | <code>date</code> | Deprecated field assuring backward compatibility with core.v1 Event type.<br/>__*Optional*__
**deprecatedLastTimestamp**?🔹 | <code>date</code> | Deprecated field assuring backward compatibility with core.v1 Event type.<br/>__*Optional*__
**deprecatedSource**?🔹 | <code>[k8s.EventSource](#opencdk8s-cdk8s-argocd-resources-k8s-eventsource)</code> | Deprecated field assuring backward compatibility with core.v1 Event type.<br/>__*Optional*__
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__
**note**?🔹 | <code>string</code> | Optional.<br/>__*Optional*__
**reason**?🔹 | <code>string</code> | Why the action was taken.<br/>__*Optional*__
**regarding**?🔹 | <code>[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)</code> | The object this Event is about.<br/>__*Optional*__
**related**?🔹 | <code>[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)</code> | Optional secondary object for more complex actions.<br/>__*Optional*__
**reportingController**?🔹 | <code>string</code> | Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.<br/>__*Optional*__
**reportingInstance**?🔹 | <code>string</code> | ID of the controller instance, e.g. `kubelet-xyzf`.<br/>__*Optional*__
**series**?🔹 | <code>[k8s.EventSeries](#opencdk8s-cdk8s-argocd-resources-k8s-eventseries)</code> | Data about the Event series this event represents or nil if it's a singleton Event.<br/>__*Optional*__
**type**?🔹 | <code>string</code> | Type of this event (Normal, Warning), new types could be added in the future.<br/>__*Optional*__



## struct KubeEvictionV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeevictionv1beta1props"></a>


Eviction evicts a pod from its node subject to certain policies and safety constraints.

This is a subresource of Pod.  A request to cause such an eviction is created by POSTing to .../pods/<pod name>/evictions.



Name | Type | Description 
-----|------|-------------
**deleteOptions**?🔹 | <code>[k8s.DeleteOptions](#opencdk8s-cdk8s-argocd-resources-k8s-deleteoptions)</code> | DeleteOptions may be provided.<br/>__*Optional*__
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | ObjectMeta describes the pod that is being evicted.<br/>__*Optional*__



## struct KubeHorizontalPodAutoscalerListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerlistprops"></a>


list of horizontal pod autoscaler objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeHorizontalPodAutoscalerProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerprops)></code> | list of horizontal pod autoscaler objects.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeHorizontalPodAutoscalerListV2Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerlistv2beta1props"></a>


HorizontalPodAutoscaler is a list of horizontal pod autoscaler objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeHorizontalPodAutoscalerV2Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerv2beta1props)></code> | items is the list of horizontal pod autoscaler objects.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | metadata is the standard list metadata.<br/>__*Optional*__



## struct KubeHorizontalPodAutoscalerListV2Beta2Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerlistv2beta2props"></a>


HorizontalPodAutoscalerList is a list of horizontal pod autoscaler objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeHorizontalPodAutoscalerV2Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerv2beta2props)></code> | items is the list of horizontal pod autoscaler objects.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | metadata is the standard list metadata.<br/>__*Optional*__



## struct KubeHorizontalPodAutoscalerProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerprops"></a>


configuration of a horizontal pod autoscaler.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.HorizontalPodAutoscalerSpec](#opencdk8s-cdk8s-argocd-resources-k8s-horizontalpodautoscalerspec)</code> | behaviour of autoscaler.<br/>__*Optional*__



## struct KubeHorizontalPodAutoscalerV2Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerv2beta1props"></a>


HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | metadata is the standard object metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.HorizontalPodAutoscalerSpec](#opencdk8s-cdk8s-argocd-resources-k8s-horizontalpodautoscalerspec)</code> | spec is the specification for the behaviour of the autoscaler.<br/>__*Optional*__



## struct KubeHorizontalPodAutoscalerV2Beta2Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubehorizontalpodautoscalerv2beta2props"></a>


HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | metadata is the standard object metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.HorizontalPodAutoscalerSpec](#opencdk8s-cdk8s-argocd-resources-k8s-horizontalpodautoscalerspec)</code> | spec is the specification for the behaviour of the autoscaler.<br/>__*Optional*__



## struct KubeIngressListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeingresslistv1beta1props"></a>


IngressList is a collection of Ingress.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeIngressV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeingressv1beta1props)></code> | Items is the list of Ingress.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard object's metadata.<br/>__*Optional*__



## struct KubeIngressV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeingressv1beta1props"></a>


Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend.

An Ingress can be configured to give services externally-reachable urls, load balance traffic, terminate SSL, offer name based virtual hosting etc.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.IngressSpec](#opencdk8s-cdk8s-argocd-resources-k8s-ingressspec)</code> | Spec is the desired state of the Ingress.<br/>__*Optional*__



## struct KubeJobListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubejoblistprops"></a>


JobList is a collection of jobs.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeJobProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubejobprops)></code> | items is the list of Jobs.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeJobProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubejobprops"></a>


Job represents the configuration of a single job.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.JobSpec](#opencdk8s-cdk8s-argocd-resources-k8s-jobspec)</code> | Specification of the desired behavior of a job.<br/>__*Optional*__



## struct KubeLeaseListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeleaselistprops"></a>


LeaseList is a list of Lease objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeLeaseProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeleaseprops)></code> | Items is a list of schema objects.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeLeaseListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeleaselistv1beta1props"></a>


LeaseList is a list of Lease objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeLeaseV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubeleasev1beta1props)></code> | Items is a list of schema objects.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeLeaseProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeleaseprops"></a>


Lease defines a lease concept.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.LeaseSpec](#opencdk8s-cdk8s-argocd-resources-k8s-leasespec)</code> | Specification of the Lease.<br/>__*Optional*__



## struct KubeLeaseV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeleasev1beta1props"></a>


Lease defines a lease concept.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.LeaseSpec](#opencdk8s-cdk8s-argocd-resources-k8s-leasespec)</code> | Specification of the Lease.<br/>__*Optional*__



## struct KubeLimitRangeListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubelimitrangelistprops"></a>


LimitRangeList is a list of LimitRange items.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeLimitRangeProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubelimitrangeprops)></code> | Items is a list of LimitRange objects.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeLimitRangeProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubelimitrangeprops"></a>


LimitRange sets resource usage limits for each kind of resource in a Namespace.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.LimitRangeSpec](#opencdk8s-cdk8s-argocd-resources-k8s-limitrangespec)</code> | Spec defines the limits enforced.<br/>__*Optional*__



## struct KubeLocalSubjectAccessReviewProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubelocalsubjectaccessreviewprops"></a>


LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace.

Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking.



Name | Type | Description 
-----|------|-------------
**spec**🔹 | <code>[k8s.SubjectAccessReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-subjectaccessreviewspec)</code> | Spec holds information about the request being evaluated.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__



## struct KubeLocalSubjectAccessReviewV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubelocalsubjectaccessreviewv1beta1props"></a>


LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace.

Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking.



Name | Type | Description 
-----|------|-------------
**spec**🔹 | <code>[k8s.SubjectAccessReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-subjectaccessreviewspec)</code> | Spec holds information about the request being evaluated.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__



## struct KubeMutatingWebhookConfigurationListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubemutatingwebhookconfigurationlistv1beta1props"></a>


MutatingWebhookConfigurationList is a list of MutatingWebhookConfiguration.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeMutatingWebhookConfigurationV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubemutatingwebhookconfigurationv1beta1props)></code> | List of MutatingWebhookConfiguration.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeMutatingWebhookConfigurationV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubemutatingwebhookconfigurationv1beta1props"></a>


MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object metadata;<br/>__*Optional*__
**webhooks**?🔹 | <code>Array<[k8s.MutatingWebhook](#opencdk8s-cdk8s-argocd-resources-k8s-mutatingwebhook)></code> | Webhooks is a list of webhooks and the affected resources and operations.<br/>__*Optional*__



## struct KubeNamespaceListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenamespacelistprops"></a>


NamespaceList is a list of Namespaces.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeNamespaceProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenamespaceprops)></code> | Items is the list of Namespace objects in the list.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeNamespaceProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenamespaceprops"></a>


Namespace provides a scope for Names.

Use of multiple namespaces is optional.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.NamespaceSpec](#opencdk8s-cdk8s-argocd-resources-k8s-namespacespec)</code> | Spec defines the behavior of the Namespace.<br/>__*Optional*__



## struct KubeNetworkPolicyListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicylistprops"></a>


NetworkPolicyList is a list of NetworkPolicy objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeNetworkPolicyProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicyprops)></code> | Items is a list of schema objects.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeNetworkPolicyListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicylistv1beta1props"></a>


DEPRECATED 1.9 - This group version of NetworkPolicyList is deprecated by networking/v1/NetworkPolicyList. Network Policy List is a list of NetworkPolicy objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeNetworkPolicyV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicyv1beta1props)></code> | Items is a list of schema objects.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeNetworkPolicyProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicyprops"></a>


NetworkPolicy describes what network traffic is allowed for a set of Pods.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.NetworkPolicySpec](#opencdk8s-cdk8s-argocd-resources-k8s-networkpolicyspec)</code> | Specification of the desired behavior for this NetworkPolicy.<br/>__*Optional*__



## struct KubeNetworkPolicyV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenetworkpolicyv1beta1props"></a>


DEPRECATED 1.9 - This group version of NetworkPolicy is deprecated by networking/v1/NetworkPolicy. NetworkPolicy describes what network traffic is allowed for a set of Pods.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.NetworkPolicySpec](#opencdk8s-cdk8s-argocd-resources-k8s-networkpolicyspec)</code> | Specification of the desired behavior for this NetworkPolicy.<br/>__*Optional*__



## struct KubeNodeListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenodelistprops"></a>


NodeList is the whole list of all Nodes which have been registered with master.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeNodeProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubenodeprops)></code> | List of nodes.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeNodeProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubenodeprops"></a>


Node is a worker node in Kubernetes.

Each node will have a unique identifier in the cache (i.e. in etcd).



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.NodeSpec](#opencdk8s-cdk8s-argocd-resources-k8s-nodespec)</code> | Spec defines the behavior of a node.<br/>__*Optional*__



## struct KubePersistentVolumeClaimListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeclaimlistprops"></a>


PersistentVolumeClaimList is a list of PersistentVolumeClaim items.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubePersistentVolumeClaimProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeclaimprops)></code> | A list of persistent volume claims.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubePersistentVolumeClaimProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeclaimprops"></a>


PersistentVolumeClaim is a user's request for and claim to a persistent volume.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.PersistentVolumeClaimSpec](#opencdk8s-cdk8s-argocd-resources-k8s-persistentvolumeclaimspec)</code> | Spec defines the desired characteristics of a volume requested by a pod author.<br/>__*Optional*__



## struct KubePersistentVolumeListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumelistprops"></a>


PersistentVolumeList is a list of PersistentVolume items.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubePersistentVolumeProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeprops)></code> | List of persistent volumes.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubePersistentVolumeProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeprops"></a>


PersistentVolume (PV) is a storage resource provisioned by an administrator.

It is analogous to a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.PersistentVolumeSpec](#opencdk8s-cdk8s-argocd-resources-k8s-persistentvolumespec)</code> | Spec defines a specification of a persistent volume owned by the cluster.<br/>__*Optional*__



## struct KubePodDisruptionBudgetListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepoddisruptionbudgetlistv1beta1props"></a>


PodDisruptionBudgetList is a collection of PodDisruptionBudgets.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubePodDisruptionBudgetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepoddisruptionbudgetv1beta1props)></code> | <span></span>
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | __*Optional*__



## struct KubePodDisruptionBudgetV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepoddisruptionbudgetv1beta1props"></a>


PodDisruptionBudget is an object to define the max disruption that can be caused to a collection of pods.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__
**spec**?🔹 | <code>[k8s.PodDisruptionBudgetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-poddisruptionbudgetspec)</code> | Specification of the desired behavior of the PodDisruptionBudget.<br/>__*Optional*__



## struct KubePodListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodlistprops"></a>


PodList is a list of Pods.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubePodProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodprops)></code> | List of pods.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubePodPresetListV1Alpha1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodpresetlistv1alpha1props"></a>


PodPresetList is a list of PodPreset objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubePodPresetV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodpresetv1alpha1props)></code> | Items is a list of schema objects.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubePodPresetV1Alpha1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodpresetv1alpha1props"></a>


PodPreset is a policy resource that defines additional runtime requirements for a Pod.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__
**spec**?🔹 | <code>[k8s.PodPresetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-podpresetspec)</code> | __*Optional*__



## struct KubePodProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodprops"></a>


Pod is a collection of containers that can run on a host.

This resource is created by clients and scheduled onto hosts.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.PodSpec](#opencdk8s-cdk8s-argocd-resources-k8s-podspec)</code> | Specification of the desired behavior of the pod.<br/>__*Optional*__



## struct KubePodSecurityPolicyListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodsecuritypolicylistv1beta1props"></a>


PodSecurityPolicyList is a list of PodSecurityPolicy objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubePodSecurityPolicyV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodsecuritypolicyv1beta1props)></code> | items is a list of schema objects.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubePodSecurityPolicyV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodsecuritypolicyv1beta1props"></a>


PodSecurityPolicy governs the ability to make requests that affect the Security Context that will be applied to a pod and container.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.PodSecurityPolicySpec](#opencdk8s-cdk8s-argocd-resources-k8s-podsecuritypolicyspec)</code> | spec defines the policy enforced.<br/>__*Optional*__



## struct KubePodTemplateListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodtemplatelistprops"></a>


PodTemplateList is a list of PodTemplates.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubePodTemplateProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepodtemplateprops)></code> | List of pod templates.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubePodTemplateProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepodtemplateprops"></a>


PodTemplate describes a template for creating copies of a predefined pod.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**template**?🔹 | <code>[k8s.PodTemplateSpec](#opencdk8s-cdk8s-argocd-resources-k8s-podtemplatespec)</code> | Template defines the pods that will be created from this pod template.<br/>__*Optional*__



## struct KubePriorityClassListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclasslistprops"></a>


PriorityClassList is a collection of priority classes.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubePriorityClassProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassprops)></code> | items is the list of PriorityClasses.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.<br/>__*Optional*__



## struct KubePriorityClassListV1Alpha1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclasslistv1alpha1props"></a>


PriorityClassList is a collection of priority classes.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubePriorityClassV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassv1alpha1props)></code> | items is the list of PriorityClasses.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.<br/>__*Optional*__



## struct KubePriorityClassListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclasslistv1beta1props"></a>


PriorityClassList is a collection of priority classes.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubePriorityClassV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassv1beta1props)></code> | items is the list of PriorityClasses.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.<br/>__*Optional*__



## struct KubePriorityClassProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassprops"></a>


PriorityClass defines mapping from a priority class name to the priority integer value.

The value can be any valid integer.



Name | Type | Description 
-----|------|-------------
**value**🔹 | <code>number</code> | The value of this priority class.
**description**?🔹 | <code>string</code> | description is an arbitrary string that usually provides guidelines on when this priority class should be used.<br/>__*Optional*__
**globalDefault**?🔹 | <code>boolean</code> | globalDefault specifies whether this PriorityClass should be considered as the default priority for pods that do not have any priority class.<br/>__*Optional*__
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**preemptionPolicy**?🔹 | <code>string</code> | PreemptionPolicy is the Policy for preempting pods with lower priority.<br/>__*Default*__: PreemptLowerPriority if unset. This field is alpha-level and is only honored by servers that enable the NonPreemptingPriority feature.



## struct KubePriorityClassV1Alpha1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassv1alpha1props"></a>


DEPRECATED - This group version of PriorityClass is deprecated by scheduling.k8s.io/v1/PriorityClass. PriorityClass defines mapping from a priority class name to the priority integer value. The value can be any valid integer.



Name | Type | Description 
-----|------|-------------
**value**🔹 | <code>number</code> | The value of this priority class.
**description**?🔹 | <code>string</code> | description is an arbitrary string that usually provides guidelines on when this priority class should be used.<br/>__*Optional*__
**globalDefault**?🔹 | <code>boolean</code> | globalDefault specifies whether this PriorityClass should be considered as the default priority for pods that do not have any priority class.<br/>__*Optional*__
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**preemptionPolicy**?🔹 | <code>string</code> | PreemptionPolicy is the Policy for preempting pods with lower priority.<br/>__*Default*__: PreemptLowerPriority if unset. This field is alpha-level and is only honored by servers that enable the NonPreemptingPriority feature.



## struct KubePriorityClassV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubepriorityclassv1beta1props"></a>


DEPRECATED - This group version of PriorityClass is deprecated by scheduling.k8s.io/v1/PriorityClass. PriorityClass defines mapping from a priority class name to the priority integer value. The value can be any valid integer.



Name | Type | Description 
-----|------|-------------
**value**🔹 | <code>number</code> | The value of this priority class.
**description**?🔹 | <code>string</code> | description is an arbitrary string that usually provides guidelines on when this priority class should be used.<br/>__*Optional*__
**globalDefault**?🔹 | <code>boolean</code> | globalDefault specifies whether this PriorityClass should be considered as the default priority for pods that do not have any priority class.<br/>__*Optional*__
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**preemptionPolicy**?🔹 | <code>string</code> | PreemptionPolicy is the Policy for preempting pods with lower priority.<br/>__*Default*__: PreemptLowerPriority if unset. This field is alpha-level and is only honored by servers that enable the NonPreemptingPriority feature.



## struct KubeReplicaSetListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetlistprops"></a>


ReplicaSetList is a collection of ReplicaSets.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeReplicaSetProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetprops)></code> | List of ReplicaSets.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeReplicaSetListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetlistv1beta1props"></a>


ReplicaSetList is a collection of ReplicaSets.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeReplicaSetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetv1beta1props)></code> | List of ReplicaSets.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeReplicaSetListV1Beta2Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetlistv1beta2props"></a>


ReplicaSetList is a collection of ReplicaSets.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeReplicaSetV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetv1beta2props)></code> | List of ReplicaSets.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeReplicaSetProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetprops"></a>


ReplicaSet ensures that a specified number of pod replicas are running at any given time.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.ReplicaSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-replicasetspec)</code> | Spec defines the specification of the desired behavior of the ReplicaSet.<br/>__*Optional*__



## struct KubeReplicaSetV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetv1beta1props"></a>


DEPRECATED - This group version of ReplicaSet is deprecated by apps/v1beta2/ReplicaSet.

See the release notes for more information. ReplicaSet ensures that a specified number of pod replicas are running at any given time.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.ReplicaSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-replicasetspec)</code> | Spec defines the specification of the desired behavior of the ReplicaSet.<br/>__*Optional*__



## struct KubeReplicaSetV1Beta2Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicasetv1beta2props"></a>


DEPRECATED - This group version of ReplicaSet is deprecated by apps/v1/ReplicaSet.

See the release notes for more information. ReplicaSet ensures that a specified number of pod replicas are running at any given time.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.ReplicaSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-replicasetspec)</code> | Spec defines the specification of the desired behavior of the ReplicaSet.<br/>__*Optional*__



## struct KubeReplicationControllerListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicationcontrollerlistprops"></a>


ReplicationControllerList is a collection of replication controllers.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeReplicationControllerProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubereplicationcontrollerprops)></code> | List of replication controllers.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeReplicationControllerProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubereplicationcontrollerprops"></a>


ReplicationController represents the configuration of a replication controller.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | If the Labels of a ReplicationController are empty, they are defaulted to be the same as the Pod(s) that the replication controller manages.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.ReplicationControllerSpec](#opencdk8s-cdk8s-argocd-resources-k8s-replicationcontrollerspec)</code> | Spec defines the specification of the desired behavior of the replication controller.<br/>__*Optional*__



## struct KubeResourceQuotaListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberesourcequotalistprops"></a>


ResourceQuotaList is a list of ResourceQuota items.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeResourceQuotaProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberesourcequotaprops)></code> | Items is a list of ResourceQuota objects.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeResourceQuotaProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberesourcequotaprops"></a>


ResourceQuota sets aggregate quota restrictions enforced per namespace.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.ResourceQuotaSpec](#opencdk8s-cdk8s-argocd-resources-k8s-resourcequotaspec)</code> | Spec defines the desired quota.<br/>__*Optional*__



## struct KubeRoleBindingListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindinglistprops"></a>


RoleBindingList is a collection of RoleBindings.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeRoleBindingProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingprops)></code> | Items is a list of RoleBindings.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard object's metadata.<br/>__*Optional*__



## struct KubeRoleBindingListV1Alpha1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindinglistv1alpha1props"></a>


RoleBindingList is a collection of RoleBindings.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeRoleBindingV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingv1alpha1props)></code> | Items is a list of RoleBindings.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard object's metadata.<br/>__*Optional*__



## struct KubeRoleBindingListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindinglistv1beta1props"></a>


RoleBindingList is a collection of RoleBindings.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeRoleBindingV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingv1beta1props)></code> | Items is a list of RoleBindings.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard object's metadata.<br/>__*Optional*__



## struct KubeRoleBindingProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingprops"></a>


RoleBinding references a role, but does not contain it.

It can reference a Role in the same namespace or a ClusterRole in the global namespace. It adds who information via Subjects and namespace information by which namespace it exists in.  RoleBindings in a given namespace only have effect in that namespace.



Name | Type | Description 
-----|------|-------------
**roleRef**🔹 | <code>[k8s.RoleRef](#opencdk8s-cdk8s-argocd-resources-k8s-roleref)</code> | RoleRef can reference a Role in the current namespace or a ClusterRole in the global namespace.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**subjects**?🔹 | <code>Array<[k8s.Subject](#opencdk8s-cdk8s-argocd-resources-k8s-subject)></code> | Subjects holds references to the objects the role applies to.<br/>__*Optional*__



## struct KubeRoleBindingV1Alpha1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingv1alpha1props"></a>


RoleBinding references a role, but does not contain it.

It can reference a Role in the same namespace or a ClusterRole in the global namespace. It adds who information via Subjects and namespace information by which namespace it exists in.  RoleBindings in a given namespace only have effect in that namespace.



Name | Type | Description 
-----|------|-------------
**roleRef**🔹 | <code>[k8s.RoleRef](#opencdk8s-cdk8s-argocd-resources-k8s-roleref)</code> | RoleRef can reference a Role in the current namespace or a ClusterRole in the global namespace.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**subjects**?🔹 | <code>Array<[k8s.Subject](#opencdk8s-cdk8s-argocd-resources-k8s-subject)></code> | Subjects holds references to the objects the role applies to.<br/>__*Optional*__



## struct KubeRoleBindingV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolebindingv1beta1props"></a>


RoleBinding references a role, but does not contain it.

It can reference a Role in the same namespace or a ClusterRole in the global namespace. It adds who information via Subjects and namespace information by which namespace it exists in.  RoleBindings in a given namespace only have effect in that namespace.



Name | Type | Description 
-----|------|-------------
**roleRef**🔹 | <code>[k8s.RoleRef](#opencdk8s-cdk8s-argocd-resources-k8s-roleref)</code> | RoleRef can reference a Role in the current namespace or a ClusterRole in the global namespace.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**subjects**?🔹 | <code>Array<[k8s.Subject](#opencdk8s-cdk8s-argocd-resources-k8s-subject)></code> | Subjects holds references to the objects the role applies to.<br/>__*Optional*__



## struct KubeRoleListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolelistprops"></a>


RoleList is a collection of Roles.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeRoleProps](#opencdk8s-cdk8s-argocd-resources-k8s-kuberoleprops)></code> | Items is a list of Roles.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard object's metadata.<br/>__*Optional*__



## struct KubeRoleListV1Alpha1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolelistv1alpha1props"></a>


RoleList is a collection of Roles.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeRoleV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolev1alpha1props)></code> | Items is a list of Roles.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard object's metadata.<br/>__*Optional*__



## struct KubeRoleListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolelistv1beta1props"></a>


RoleList is a collection of Roles.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeRoleV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberolev1beta1props)></code> | Items is a list of Roles.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard object's metadata.<br/>__*Optional*__



## struct KubeRoleProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberoleprops"></a>


Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**rules**?🔹 | <code>Array<[k8s.PolicyRule](#opencdk8s-cdk8s-argocd-resources-k8s-policyrule)></code> | Rules holds all the PolicyRules for this Role.<br/>__*Optional*__



## struct KubeRoleV1Alpha1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolev1alpha1props"></a>


Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**rules**?🔹 | <code>Array<[k8s.PolicyRule](#opencdk8s-cdk8s-argocd-resources-k8s-policyrule)></code> | Rules holds all the PolicyRules for this Role.<br/>__*Optional*__



## struct KubeRoleV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberolev1beta1props"></a>


Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**rules**?🔹 | <code>Array<[k8s.PolicyRule](#opencdk8s-cdk8s-argocd-resources-k8s-policyrule)></code> | Rules holds all the PolicyRules for this Role.<br/>__*Optional*__



## struct KubeRuntimeClassListV1Alpha1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclasslistv1alpha1props"></a>


RuntimeClassList is a list of RuntimeClass objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeRuntimeClassV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclassv1alpha1props)></code> | Items is a list of schema objects.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeRuntimeClassListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclasslistv1beta1props"></a>


RuntimeClassList is a list of RuntimeClass objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeRuntimeClassV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclassv1beta1props)></code> | Items is a list of schema objects.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeRuntimeClassV1Alpha1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclassv1alpha1props"></a>


RuntimeClass defines a class of container runtime supported in the cluster.

The RuntimeClass is used to determine which container runtime is used to run all containers in a pod. RuntimeClasses are (currently) manually defined by a user or cluster provisioner, and referenced in the PodSpec. The Kubelet is responsible for resolving the RuntimeClassName reference before running the pod.  For more details, see https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md



Name | Type | Description 
-----|------|-------------
**spec**🔹 | <code>[k8s.RuntimeClassSpec](#opencdk8s-cdk8s-argocd-resources-k8s-runtimeclassspec)</code> | Specification of the RuntimeClass More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.<br/>__*Optional*__



## struct KubeRuntimeClassV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kuberuntimeclassv1beta1props"></a>


RuntimeClass defines a class of container runtime supported in the cluster.

The RuntimeClass is used to determine which container runtime is used to run all containers in a pod. RuntimeClasses are (currently) manually defined by a user or cluster provisioner, and referenced in the PodSpec. The Kubelet is responsible for resolving the RuntimeClassName reference before running the pod.  For more details, see https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md



Name | Type | Description 
-----|------|-------------
**handler**🔹 | <code>string</code> | Handler specifies the underlying runtime and configuration that the CRI implementation will use to handle pods of this class.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.<br/>__*Optional*__



## struct KubeScaleProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubescaleprops"></a>


Scale represents a scaling request for a resource.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object metadata;<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.ScaleSpec](#opencdk8s-cdk8s-argocd-resources-k8s-scalespec)</code> | defines the behavior of the scale.<br/>__*Optional*__



## struct KubeScaleV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubescalev1beta1props"></a>


represents a scaling request for a resource.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object metadata;<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.ScaleSpec](#opencdk8s-cdk8s-argocd-resources-k8s-scalespec)</code> | defines the behavior of the scale.<br/>__*Optional*__



## struct KubeScaleV1Beta2Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubescalev1beta2props"></a>


Scale represents a scaling request for a resource.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object metadata;<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.ScaleSpec](#opencdk8s-cdk8s-argocd-resources-k8s-scalespec)</code> | defines the behavior of the scale.<br/>__*Optional*__



## struct KubeSecretListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubesecretlistprops"></a>


SecretList is a list of Secret.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeSecretProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubesecretprops)></code> | Items is a list of secret objects.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeSecretProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubesecretprops"></a>


Secret holds secret data of a certain type.

The total bytes of the values in the Data field must be less than MaxSecretSize bytes.



Name | Type | Description 
-----|------|-------------
**data**?🔹 | <code>Map<string, string></code> | Data contains the secret data.<br/>__*Optional*__
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**stringData**?🔹 | <code>Map<string, string></code> | stringData allows specifying non-binary secret data in string form.<br/>__*Optional*__
**type**?🔹 | <code>string</code> | Used to facilitate programmatic handling of secret data.<br/>__*Optional*__



## struct KubeSelfSubjectAccessReviewProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectaccessreviewprops"></a>


SelfSubjectAccessReview checks whether or the current user can perform an action.

Not filling in a spec.namespace means "in all namespaces".  Self is a special case, because users should always be able to check whether they can perform an action



Name | Type | Description 
-----|------|-------------
**spec**🔹 | <code>[k8s.SelfSubjectAccessReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-selfsubjectaccessreviewspec)</code> | Spec holds information about the request being evaluated.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__



## struct KubeSelfSubjectAccessReviewV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectaccessreviewv1beta1props"></a>


SelfSubjectAccessReview checks whether or the current user can perform an action.

Not filling in a spec.namespace means "in all namespaces".  Self is a special case, because users should always be able to check whether they can perform an action



Name | Type | Description 
-----|------|-------------
**spec**🔹 | <code>[k8s.SelfSubjectAccessReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-selfsubjectaccessreviewspec)</code> | Spec holds information about the request being evaluated.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__



## struct KubeSelfSubjectRulesReviewProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectrulesreviewprops"></a>


SelfSubjectRulesReview enumerates the set of actions the current user can perform within a namespace.

The returned list of actions may be incomplete depending on the server's authorization mode, and any errors experienced during the evaluation. SelfSubjectRulesReview should be used by UIs to show/hide actions, or to quickly let an end user reason about their permissions. It should NOT Be used by external systems to drive authorization decisions as this raises confused deputy, cache lifetime/revocation, and correctness concerns. SubjectAccessReview, and LocalAccessReview are the correct way to defer authorization decisions to the API server.



Name | Type | Description 
-----|------|-------------
**spec**🔹 | <code>[k8s.SelfSubjectRulesReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-selfsubjectrulesreviewspec)</code> | Spec holds information about the request being evaluated.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__



## struct KubeSelfSubjectRulesReviewV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeselfsubjectrulesreviewv1beta1props"></a>


SelfSubjectRulesReview enumerates the set of actions the current user can perform within a namespace.

The returned list of actions may be incomplete depending on the server's authorization mode, and any errors experienced during the evaluation. SelfSubjectRulesReview should be used by UIs to show/hide actions, or to quickly let an end user reason about their permissions. It should NOT Be used by external systems to drive authorization decisions as this raises confused deputy, cache lifetime/revocation, and correctness concerns. SubjectAccessReview, and LocalAccessReview are the correct way to defer authorization decisions to the API server.



Name | Type | Description 
-----|------|-------------
**spec**🔹 | <code>[k8s.SelfSubjectRulesReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-selfsubjectrulesreviewspec)</code> | Spec holds information about the request being evaluated.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__



## struct KubeServiceAccountListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceaccountlistprops"></a>


ServiceAccountList is a list of ServiceAccount objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeServiceAccountProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceaccountprops)></code> | List of ServiceAccounts.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeServiceAccountProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceaccountprops"></a>


ServiceAccount binds together: * a name, understood by users, and perhaps by peripheral systems, for an identity * a principal that can be authenticated and authorized * a set of secrets.



Name | Type | Description 
-----|------|-------------
**automountServiceAccountToken**?🔹 | <code>boolean</code> | AutomountServiceAccountToken indicates whether pods running as this service account should have an API token automatically mounted.<br/>__*Optional*__
**imagePullSecrets**?🔹 | <code>Array<[k8s.LocalObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-localobjectreference)></code> | ImagePullSecrets is a list of references to secrets in the same namespace to use for pulling any images in pods that reference this ServiceAccount.<br/>__*Optional*__
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**secrets**?🔹 | <code>Array<[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)></code> | Secrets is the list of secrets allowed to be used by pods running using this ServiceAccount.<br/>__*Optional*__



## struct KubeServiceListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeservicelistprops"></a>


ServiceList holds a list of services.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeServiceProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceprops)></code> | List of services.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeServiceProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubeserviceprops"></a>


Service is a named abstraction of software service (for example, mysql) consisting of local port (for example 3306) that the proxy listens on, and the selector that determines which pods will answer requests sent through the proxy.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.ServiceSpec](#opencdk8s-cdk8s-argocd-resources-k8s-servicespec)</code> | Spec defines the behavior of a service.<br/>__*Optional*__



## struct KubeStatefulSetListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetlistprops"></a>


StatefulSetList is a collection of StatefulSets.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeStatefulSetProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetprops)></code> | <span></span>
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | __*Optional*__



## struct KubeStatefulSetListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetlistv1beta1props"></a>


StatefulSetList is a collection of StatefulSets.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeStatefulSetV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetv1beta1props)></code> | <span></span>
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | __*Optional*__



## struct KubeStatefulSetListV1Beta2Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetlistv1beta2props"></a>


StatefulSetList is a collection of StatefulSets.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeStatefulSetV1Beta2Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetv1beta2props)></code> | <span></span>
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | __*Optional*__



## struct KubeStatefulSetProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetprops"></a>


StatefulSet represents a set of pods with consistent identities.

Identities are defined as:
- Network: A single stable DNS and hostname.
- Storage: As many VolumeClaims as requested.
The StatefulSet guarantees that a given network identity will always map to the same storage identity.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__
**spec**?🔹 | <code>[k8s.StatefulSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-statefulsetspec)</code> | Spec defines the desired identities of pods in this set.<br/>__*Optional*__



## struct KubeStatefulSetV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetv1beta1props"></a>


DEPRECATED - This group version of StatefulSet is deprecated by apps/v1beta2/StatefulSet.

See the release notes for more information. StatefulSet represents a set of pods with consistent identities. Identities are defined as:
- Network: A single stable DNS and hostname.
- Storage: As many VolumeClaims as requested.
The StatefulSet guarantees that a given network identity will always map to the same storage identity.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__
**spec**?🔹 | <code>[k8s.StatefulSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-statefulsetspec)</code> | Spec defines the desired identities of pods in this set.<br/>__*Optional*__



## struct KubeStatefulSetV1Beta2Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestatefulsetv1beta2props"></a>


DEPRECATED - This group version of StatefulSet is deprecated by apps/v1/StatefulSet.

See the release notes for more information. StatefulSet represents a set of pods with consistent identities. Identities are defined as:
- Network: A single stable DNS and hostname.
- Storage: As many VolumeClaims as requested.
The StatefulSet guarantees that a given network identity will always map to the same storage identity.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__
**spec**?🔹 | <code>[k8s.StatefulSetSpec](#opencdk8s-cdk8s-argocd-resources-k8s-statefulsetspec)</code> | Spec defines the desired identities of pods in this set.<br/>__*Optional*__



## struct KubeStatusProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestatusprops"></a>


Status is a return value for calls that don't return other objects.



Name | Type | Description 
-----|------|-------------
**code**?🔹 | <code>number</code> | Suggested HTTP return code for this status, 0 if not set.<br/>__*Optional*__
**details**?🔹 | <code>[k8s.StatusDetails](#opencdk8s-cdk8s-argocd-resources-k8s-statusdetails)</code> | Extended data associated with the reason.<br/>__*Optional*__
**message**?🔹 | <code>string</code> | A human-readable description of the status of this operation.<br/>__*Optional*__
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__
**reason**?🔹 | <code>string</code> | A machine-readable description of why this operation is in the "Failure" status.<br/>__*Optional*__



## struct KubeStorageClassListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclasslistprops"></a>


StorageClassList is a collection of storage classes.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeStorageClassProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclassprops)></code> | Items is the list of StorageClasses.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.<br/>__*Optional*__



## struct KubeStorageClassListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclasslistv1beta1props"></a>


StorageClassList is a collection of storage classes.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeStorageClassV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclassv1beta1props)></code> | Items is the list of StorageClasses.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.<br/>__*Optional*__



## struct KubeStorageClassProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclassprops"></a>


StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.

StorageClasses are non-namespaced; the name of the storage class according to etcd is in ObjectMeta.Name.



Name | Type | Description 
-----|------|-------------
**provisioner**🔹 | <code>string</code> | Provisioner indicates the type of the provisioner.
**allowVolumeExpansion**?🔹 | <code>boolean</code> | AllowVolumeExpansion shows whether the storage class allow volume expand.<br/>__*Optional*__
**allowedTopologies**?🔹 | <code>Array<[k8s.TopologySelectorTerm](#opencdk8s-cdk8s-argocd-resources-k8s-topologyselectorterm)></code> | Restrict the node topologies where volumes can be dynamically provisioned.<br/>__*Optional*__
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**mountOptions**?🔹 | <code>Array<string></code> | Dynamically provisioned PersistentVolumes of this storage class are created with these mountOptions, e.g. ["ro", "soft"]. Not validated - mount of the PVs will simply fail if one is invalid.<br/>__*Optional*__
**parameters**?🔹 | <code>Map<string, string></code> | Parameters holds the parameters for the provisioner that should create volumes of this storage class.<br/>__*Optional*__
**reclaimPolicy**?🔹 | <code>string</code> | Dynamically provisioned PersistentVolumes of this storage class are created with this reclaimPolicy.<br/>__*Default*__: Delete.
**volumeBindingMode**?🔹 | <code>string</code> | VolumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound.<br/>__*Optional*__



## struct KubeStorageClassV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubestorageclassv1beta1props"></a>


StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.

StorageClasses are non-namespaced; the name of the storage class according to etcd is in ObjectMeta.Name.



Name | Type | Description 
-----|------|-------------
**provisioner**🔹 | <code>string</code> | Provisioner indicates the type of the provisioner.
**allowVolumeExpansion**?🔹 | <code>boolean</code> | AllowVolumeExpansion shows whether the storage class allow volume expand.<br/>__*Optional*__
**allowedTopologies**?🔹 | <code>Array<[k8s.TopologySelectorTerm](#opencdk8s-cdk8s-argocd-resources-k8s-topologyselectorterm)></code> | Restrict the node topologies where volumes can be dynamically provisioned.<br/>__*Optional*__
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**mountOptions**?🔹 | <code>Array<string></code> | Dynamically provisioned PersistentVolumes of this storage class are created with these mountOptions, e.g. ["ro", "soft"]. Not validated - mount of the PVs will simply fail if one is invalid.<br/>__*Optional*__
**parameters**?🔹 | <code>Map<string, string></code> | Parameters holds the parameters for the provisioner that should create volumes of this storage class.<br/>__*Optional*__
**reclaimPolicy**?🔹 | <code>string</code> | Dynamically provisioned PersistentVolumes of this storage class are created with this reclaimPolicy.<br/>__*Default*__: Delete.
**volumeBindingMode**?🔹 | <code>string</code> | VolumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound.<br/>__*Optional*__



## struct KubeSubjectAccessReviewProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubesubjectaccessreviewprops"></a>


SubjectAccessReview checks whether or not a user or group can perform an action.



Name | Type | Description 
-----|------|-------------
**spec**🔹 | <code>[k8s.SubjectAccessReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-subjectaccessreviewspec)</code> | Spec holds information about the request being evaluated.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__



## struct KubeSubjectAccessReviewV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubesubjectaccessreviewv1beta1props"></a>


SubjectAccessReview checks whether or not a user or group can perform an action.



Name | Type | Description 
-----|------|-------------
**spec**🔹 | <code>[k8s.SubjectAccessReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-subjectaccessreviewspec)</code> | Spec holds information about the request being evaluated.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__



## struct KubeTokenReviewProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubetokenreviewprops"></a>


TokenReview attempts to authenticate a token to a known user.

Note: TokenReview requests may be cached by the webhook token authenticator plugin in the kube-apiserver.



Name | Type | Description 
-----|------|-------------
**spec**🔹 | <code>[k8s.TokenReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-tokenreviewspec)</code> | Spec holds information about the request being evaluated.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__



## struct KubeTokenReviewV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubetokenreviewv1beta1props"></a>


TokenReview attempts to authenticate a token to a known user.

Note: TokenReview requests may be cached by the webhook token authenticator plugin in the kube-apiserver.



Name | Type | Description 
-----|------|-------------
**spec**🔹 | <code>[k8s.TokenReviewSpec](#opencdk8s-cdk8s-argocd-resources-k8s-tokenreviewspec)</code> | Spec holds information about the request being evaluated.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | __*Optional*__



## struct KubeValidatingWebhookConfigurationListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevalidatingwebhookconfigurationlistv1beta1props"></a>


ValidatingWebhookConfigurationList is a list of ValidatingWebhookConfiguration.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeValidatingWebhookConfigurationV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevalidatingwebhookconfigurationv1beta1props)></code> | List of ValidatingWebhookConfiguration.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata.<br/>__*Optional*__



## struct KubeValidatingWebhookConfigurationV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevalidatingwebhookconfigurationv1beta1props"></a>


ValidatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and object without changing it.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object metadata;<br/>__*Optional*__
**webhooks**?🔹 | <code>Array<[k8s.ValidatingWebhook](#opencdk8s-cdk8s-argocd-resources-k8s-validatingwebhook)></code> | Webhooks is a list of webhooks and the affected resources and operations.<br/>__*Optional*__



## struct KubeVolumeAttachmentListProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentlistprops"></a>


VolumeAttachmentList is a collection of VolumeAttachment objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeVolumeAttachmentProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentprops)></code> | Items is the list of VolumeAttachments.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.<br/>__*Optional*__



## struct KubeVolumeAttachmentListV1Alpha1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentlistv1alpha1props"></a>


VolumeAttachmentList is a collection of VolumeAttachment objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeVolumeAttachmentV1Alpha1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentv1alpha1props)></code> | Items is the list of VolumeAttachments.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.<br/>__*Optional*__



## struct KubeVolumeAttachmentListV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentlistv1beta1props"></a>


VolumeAttachmentList is a collection of VolumeAttachment objects.



Name | Type | Description 
-----|------|-------------
**items**🔹 | <code>Array<[k8s.KubeVolumeAttachmentV1Beta1Props](#opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentv1beta1props)></code> | Items is the list of VolumeAttachments.
**metadata**?🔹 | <code>[k8s.ListMeta](#opencdk8s-cdk8s-argocd-resources-k8s-listmeta)</code> | Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.<br/>__*Optional*__



## struct KubeVolumeAttachmentProps 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentprops"></a>


VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.

VolumeAttachment objects are non-namespaced.



Name | Type | Description 
-----|------|-------------
**spec**🔹 | <code>[k8s.VolumeAttachmentSpec](#opencdk8s-cdk8s-argocd-resources-k8s-volumeattachmentspec)</code> | Specification of the desired attach/detach volume behavior.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object metadata.<br/>__*Optional*__



## struct KubeVolumeAttachmentV1Alpha1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentv1alpha1props"></a>


VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.

VolumeAttachment objects are non-namespaced.



Name | Type | Description 
-----|------|-------------
**spec**🔹 | <code>[k8s.VolumeAttachmentSpec](#opencdk8s-cdk8s-argocd-resources-k8s-volumeattachmentspec)</code> | Specification of the desired attach/detach volume behavior.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object metadata.<br/>__*Optional*__



## struct KubeVolumeAttachmentV1Beta1Props 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-kubevolumeattachmentv1beta1props"></a>


VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.

VolumeAttachment objects are non-namespaced.



Name | Type | Description 
-----|------|-------------
**spec**🔹 | <code>[k8s.VolumeAttachmentSpec](#opencdk8s-cdk8s-argocd-resources-k8s-volumeattachmentspec)</code> | Specification of the desired attach/detach volume behavior.
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object metadata.<br/>__*Optional*__



## struct LabelSelector 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-labelselector"></a>


A label selector is a label query over a set of resources.

The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects.



Name | Type | Description 
-----|------|-------------
**matchExpressions**?🔹 | <code>Array<[k8s.LabelSelectorRequirement](#opencdk8s-cdk8s-argocd-resources-k8s-labelselectorrequirement)></code> | matchExpressions is a list of label selector requirements.<br/>__*Optional*__
**matchLabels**?🔹 | <code>Map<string, string></code> | matchLabels is a map of {key,value} pairs.<br/>__*Optional*__



## struct LabelSelectorRequirement 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-labelselectorrequirement"></a>


A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.



Name | Type | Description 
-----|------|-------------
**key**🔹 | <code>string</code> | key is the label key that the selector applies to.
**operator**🔹 | <code>string</code> | operator represents a key's relationship to a set of values.
**values**?🔹 | <code>Array<string></code> | values is an array of string values.<br/>__*Optional*__



## struct LeaseSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-leasespec"></a>


LeaseSpec is a specification of a Lease.



Name | Type | Description 
-----|------|-------------
**acquireTime**?🔹 | <code>date</code> | acquireTime is a time when the current lease was acquired.<br/>__*Optional*__
**holderIdentity**?🔹 | <code>string</code> | holderIdentity contains the identity of the holder of a current lease.<br/>__*Optional*__
**leaseDurationSeconds**?🔹 | <code>number</code> | leaseDurationSeconds is a duration that candidates for a lease need to wait to force acquire it.<br/>__*Optional*__
**leaseTransitions**?🔹 | <code>number</code> | leaseTransitions is the number of transitions of a lease between holders.<br/>__*Optional*__
**renewTime**?🔹 | <code>date</code> | renewTime is a time when the current holder of a lease has last updated the lease.<br/>__*Optional*__



## struct Lifecycle 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-lifecycle"></a>


Lifecycle describes actions that the management system should take in response to container lifecycle events.

For the PostStart and PreStop lifecycle handlers, management of the container blocks until the action is complete, unless the container process fails, in which case the handler is aborted.



Name | Type | Description 
-----|------|-------------
**postStart**?🔹 | <code>[k8s.Handler](#opencdk8s-cdk8s-argocd-resources-k8s-handler)</code> | PostStart is called immediately after a container is created.<br/>__*Optional*__
**preStop**?🔹 | <code>[k8s.Handler](#opencdk8s-cdk8s-argocd-resources-k8s-handler)</code> | PreStop is called immediately before a container is terminated due to an API request or management event such as liveness probe failure, preemption, resource contention, etc.<br/>__*Optional*__



## struct LimitRangeItem 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-limitrangeitem"></a>


LimitRangeItem defines a min/max usage limit for any resource that matches on kind.



Name | Type | Description 
-----|------|-------------
**default**?🔹 | <code>Map<string, [k8s.Quantity](#opencdk8s-cdk8s-argocd-resources-k8s-quantity)></code> | Default resource requirement limit value by resource name if resource limit is omitted.<br/>__*Optional*__
**defaultRequest**?🔹 | <code>Map<string, [k8s.Quantity](#opencdk8s-cdk8s-argocd-resources-k8s-quantity)></code> | DefaultRequest is the default resource requirement request value by resource name if resource request is omitted.<br/>__*Optional*__
**max**?🔹 | <code>Map<string, [k8s.Quantity](#opencdk8s-cdk8s-argocd-resources-k8s-quantity)></code> | Max usage constraints on this kind by resource name.<br/>__*Optional*__
**maxLimitRequestRatio**?🔹 | <code>Map<string, [k8s.Quantity](#opencdk8s-cdk8s-argocd-resources-k8s-quantity)></code> | MaxLimitRequestRatio if specified, the named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value;<br/>__*Optional*__
**min**?🔹 | <code>Map<string, [k8s.Quantity](#opencdk8s-cdk8s-argocd-resources-k8s-quantity)></code> | Min usage constraints on this kind by resource name.<br/>__*Optional*__
**type**?🔹 | <code>string</code> | Type of resource that this limit applies to.<br/>__*Optional*__



## struct LimitRangeSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-limitrangespec"></a>


LimitRangeSpec defines a min/max usage limit for resources that match on kind.



Name | Type | Description 
-----|------|-------------
**limits**🔹 | <code>Array<[k8s.LimitRangeItem](#opencdk8s-cdk8s-argocd-resources-k8s-limitrangeitem)></code> | Limits is the list of LimitRangeItem objects that are enforced.



## struct ListMeta 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-listmeta"></a>


ListMeta describes metadata that synthetic resources must have, including lists and various status objects.

A resource may have only one of {ObjectMeta, ListMeta}.



Name | Type | Description 
-----|------|-------------
**continue**?🔹 | <code>string</code> | continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available.<br/>__*Optional*__
**remainingItemCount**?🔹 | <code>number</code> | remainingItemCount is the number of subsequent items in the list which are not included in this list response.<br/>__*Optional*__
**resourceVersion**?🔹 | <code>string</code> | String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed.<br/>__*Optional*__
**selfLink**?🔹 | <code>string</code> | selfLink is a URL representing this object.<br/>__*Optional*__



## struct LocalObjectReference 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-localobjectreference"></a>


LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.



Name | Type | Description 
-----|------|-------------
**name**?🔹 | <code>string</code> | Name of the referent.<br/>__*Optional*__



## struct LocalVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-localvolumesource"></a>


Local represents directly-attached storage with node affinity (Beta feature).



Name | Type | Description 
-----|------|-------------
**path**🔹 | <code>string</code> | The full path to the volume on the node.
**fsType**?🔹 | <code>string</code> | Filesystem type to mount.<br/>__*Optional*__



## struct ManagedFieldsEntry 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-managedfieldsentry"></a>


ManagedFieldsEntry is a workflow-id, a FieldSet and the group version of the resource that the fieldset applies to.



Name | Type | Description 
-----|------|-------------
**apiVersion**?🔹 | <code>string</code> | APIVersion defines the version of this resource that this field set applies to.<br/>__*Optional*__
**fields**?🔹 | <code>any</code> | Fields identifies a set of fields.<br/>__*Optional*__
**manager**?🔹 | <code>string</code> | Manager is an identifier of the workflow managing these fields.<br/>__*Optional*__
**operation**?🔹 | <code>string</code> | Operation is the type of operation which lead to this ManagedFieldsEntry being created.<br/>__*Optional*__
**time**?🔹 | <code>date</code> | Time is timestamp of when these fields were set.<br/>__*Optional*__



## struct MetricIdentifier 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-metricidentifier"></a>


MetricIdentifier defines the name and optionally selector for a metric.



Name | Type | Description 
-----|------|-------------
**name**🔹 | <code>string</code> | name is the name of the given metric.
**selector**?🔹 | <code>[k8s.LabelSelector](#opencdk8s-cdk8s-argocd-resources-k8s-labelselector)</code> | selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping.<br/>__*Optional*__



## struct MetricSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-metricspec"></a>


MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).



Name | Type | Description 
-----|------|-------------
**type**🔹 | <code>string</code> | type is the type of metric source.
**external**?🔹 | <code>[k8s.ExternalMetricSource](#opencdk8s-cdk8s-argocd-resources-k8s-externalmetricsource)</code> | external refers to a global metric that is not associated with any Kubernetes object.<br/>__*Optional*__
**object**?🔹 | <code>[k8s.ObjectMetricSource](#opencdk8s-cdk8s-argocd-resources-k8s-objectmetricsource)</code> | object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).<br/>__*Optional*__
**pods**?🔹 | <code>[k8s.PodsMetricSource](#opencdk8s-cdk8s-argocd-resources-k8s-podsmetricsource)</code> | pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).<br/>__*Optional*__
**resource**?🔹 | <code>[k8s.ResourceMetricSource](#opencdk8s-cdk8s-argocd-resources-k8s-resourcemetricsource)</code> | resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.<br/>__*Optional*__



## struct MetricTarget 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-metrictarget"></a>


MetricTarget defines the target value, average value, or average utilization of a specific metric.



Name | Type | Description 
-----|------|-------------
**type**🔹 | <code>string</code> | type represents whether the metric type is Utilization, Value, or AverageValue.
**averageUtilization**?🔹 | <code>number</code> | averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.<br/>__*Optional*__
**averageValue**?🔹 | <code>[k8s.Quantity](#opencdk8s-cdk8s-argocd-resources-k8s-quantity)</code> | averageValue is the target value of the average of the metric across all relevant pods (as a quantity).<br/>__*Optional*__
**value**?🔹 | <code>[k8s.Quantity](#opencdk8s-cdk8s-argocd-resources-k8s-quantity)</code> | value is the target value of the metric (as a quantity).<br/>__*Optional*__



## struct MutatingWebhook 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-mutatingwebhook"></a>


MutatingWebhook describes an admission webhook and the resources and operations it applies to.



Name | Type | Description 
-----|------|-------------
**clientConfig**🔹 | <code>[k8s.WebhookClientConfig](#opencdk8s-cdk8s-argocd-resources-k8s-webhookclientconfig)</code> | ClientConfig defines how to communicate with the hook.
**name**🔹 | <code>string</code> | The name of the admission webhook.
**admissionReviewVersions**?🔹 | <code>Array<string></code> | AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects.<br/>__*Default*__: v1beta1']`.
**failurePolicy**?🔹 | <code>string</code> | FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail.<br/>__*Default*__: Ignore.
**matchPolicy**?🔹 | <code>string</code> | matchPolicy defines how the "rules" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".<br/>__*Default*__: Exact"
**namespaceSelector**?🔹 | <code>[k8s.LabelSelector](#opencdk8s-cdk8s-argocd-resources-k8s-labelselector)</code> | NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector.<br/>__*Default*__: the empty LabelSelector, which matches everything.
**objectSelector**?🔹 | <code>[k8s.LabelSelector](#opencdk8s-cdk8s-argocd-resources-k8s-labelselector)</code> | ObjectSelector decides whether to run the webhook based on if the object has matching labels.<br/>__*Default*__: the empty LabelSelector, which matches everything.
**reinvocationPolicy**?🔹 | <code>string</code> | reinvocationPolicy indicates whether this webhook should be called multiple times as part of a single admission evaluation.<br/>__*Default*__: Never".
**rules**?🔹 | <code>Array<[k8s.RuleWithOperations](#opencdk8s-cdk8s-argocd-resources-k8s-rulewithoperations)></code> | Rules describes what operations on what resources/subresources the webhook cares about.<br/>__*Optional*__
**sideEffects**?🔹 | <code>string</code> | SideEffects states whether this webhookk has side effects.<br/>__*Default*__: Unknown.
**timeoutSeconds**?🔹 | <code>number</code> | TimeoutSeconds specifies the timeout for this webhook.<br/>__*Default*__: 30 seconds.



## struct NamespaceSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-namespacespec"></a>


NamespaceSpec describes the attributes on a Namespace.



Name | Type | Description 
-----|------|-------------
**finalizers**?🔹 | <code>Array<string></code> | Finalizers is an opaque list of values that must be empty to permanently remove object from storage.<br/>__*Optional*__



## struct NetworkPolicyEgressRule 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-networkpolicyegressrule"></a>


NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods matched by a NetworkPolicySpec's podSelector.

The traffic must match both ports and to. This type is beta-level in 1.8



Name | Type | Description 
-----|------|-------------
**ports**?🔹 | <code>Array<[k8s.NetworkPolicyPort](#opencdk8s-cdk8s-argocd-resources-k8s-networkpolicyport)></code> | List of destination ports for outgoing traffic.<br/>__*Optional*__
**to**?🔹 | <code>Array<[k8s.NetworkPolicyPeer](#opencdk8s-cdk8s-argocd-resources-k8s-networkpolicypeer)></code> | List of destinations for outgoing traffic of pods selected for this rule.<br/>__*Optional*__



## struct NetworkPolicyIngressRule 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-networkpolicyingressrule"></a>


NetworkPolicyIngressRule describes a particular set of traffic that is allowed to the pods matched by a NetworkPolicySpec's podSelector.

The traffic must match both ports and from.



Name | Type | Description 
-----|------|-------------
**from**?🔹 | <code>Array<[k8s.NetworkPolicyPeer](#opencdk8s-cdk8s-argocd-resources-k8s-networkpolicypeer)></code> | List of sources which should be able to access the pods selected for this rule.<br/>__*Optional*__
**ports**?🔹 | <code>Array<[k8s.NetworkPolicyPort](#opencdk8s-cdk8s-argocd-resources-k8s-networkpolicyport)></code> | List of ports which should be made accessible on the pods selected for this rule.<br/>__*Optional*__



## struct NetworkPolicyPeer 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-networkpolicypeer"></a>


NetworkPolicyPeer describes a peer to allow traffic from.

Only certain combinations of fields are allowed



Name | Type | Description 
-----|------|-------------
**ipBlock**?🔹 | <code>[k8s.IpBlock](#opencdk8s-cdk8s-argocd-resources-k8s-ipblock)</code> | IPBlock defines policy on a particular IPBlock.<br/>__*Optional*__
**namespaceSelector**?🔹 | <code>[k8s.LabelSelector](#opencdk8s-cdk8s-argocd-resources-k8s-labelselector)</code> | Selects Namespaces using cluster-scoped labels.<br/>__*Optional*__
**podSelector**?🔹 | <code>[k8s.LabelSelector](#opencdk8s-cdk8s-argocd-resources-k8s-labelselector)</code> | This is a label selector which selects Pods.<br/>__*Optional*__



## struct NetworkPolicyPort 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-networkpolicyport"></a>


NetworkPolicyPort describes a port to allow traffic on.



Name | Type | Description 
-----|------|-------------
**port**?🔹 | <code>[k8s.IntOrString](#opencdk8s-cdk8s-argocd-resources-k8s-intorstring)</code> | The port on the given protocol.<br/>__*Optional*__
**protocol**?🔹 | <code>string</code> | The protocol (TCP, UDP, or SCTP) which traffic must match.<br/>__*Optional*__



## struct NetworkPolicySpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-networkpolicyspec"></a>


NetworkPolicySpec provides the specification of a NetworkPolicy.



Name | Type | Description 
-----|------|-------------
**podSelector**🔹 | <code>[k8s.LabelSelector](#opencdk8s-cdk8s-argocd-resources-k8s-labelselector)</code> | Selects the pods to which this NetworkPolicy object applies.
**egress**?🔹 | <code>Array<[k8s.NetworkPolicyEgressRule](#opencdk8s-cdk8s-argocd-resources-k8s-networkpolicyegressrule)></code> | List of egress rules to be applied to the selected pods.<br/>__*Optional*__
**ingress**?🔹 | <code>Array<[k8s.NetworkPolicyIngressRule](#opencdk8s-cdk8s-argocd-resources-k8s-networkpolicyingressrule)></code> | List of ingress rules to be applied to the selected pods.<br/>__*Optional*__
**policyTypes**?🔹 | <code>Array<string></code> | List of rule types that the NetworkPolicy relates to.<br/>__*Optional*__



## struct NfsVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-nfsvolumesource"></a>


Represents an NFS mount that lasts the lifetime of a pod.

NFS volumes do not support ownership management or SELinux relabeling.



Name | Type | Description 
-----|------|-------------
**path**🔹 | <code>string</code> | Path that is exported by the NFS server.
**server**🔹 | <code>string</code> | Server is the hostname or IP address of the NFS server.
**readOnly**?🔹 | <code>boolean</code> | ReadOnly here will force the NFS export to be mounted with read-only permissions.<br/>__*Default*__: false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs



## struct NodeAffinity 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-nodeaffinity"></a>


Node affinity is a group of node affinity scheduling rules.



Name | Type | Description 
-----|------|-------------
**preferredDuringSchedulingIgnoredDuringExecution**?🔹 | <code>Array<[k8s.PreferredSchedulingTerm](#opencdk8s-cdk8s-argocd-resources-k8s-preferredschedulingterm)></code> | The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions.<br/>__*Optional*__
**requiredDuringSchedulingIgnoredDuringExecution**?🔹 | <code>[k8s.NodeSelector](#opencdk8s-cdk8s-argocd-resources-k8s-nodeselector)</code> | If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node.<br/>__*Optional*__



## struct NodeConfigSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-nodeconfigsource"></a>


NodeConfigSource specifies a source of node configuration.

Exactly one subfield (excluding metadata) must be non-nil.



Name | Type | Description 
-----|------|-------------
**configMap**?🔹 | <code>[k8s.ConfigMapNodeConfigSource](#opencdk8s-cdk8s-argocd-resources-k8s-configmapnodeconfigsource)</code> | ConfigMap is a reference to a Node's ConfigMap.<br/>__*Optional*__



## struct NodeSelector 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-nodeselector"></a>


A node selector represents the union of the results of one or more label queries over a set of nodes;

that is, it represents the OR of the selectors represented by the node selector terms.



Name | Type | Description 
-----|------|-------------
**nodeSelectorTerms**🔹 | <code>Array<[k8s.NodeSelectorTerm](#opencdk8s-cdk8s-argocd-resources-k8s-nodeselectorterm)></code> | Required.



## struct NodeSelectorRequirement 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-nodeselectorrequirement"></a>


A node selector requirement is a selector that contains values, a key, and an operator that relates the key and values.



Name | Type | Description 
-----|------|-------------
**key**🔹 | <code>string</code> | The label key that the selector applies to.
**operator**🔹 | <code>string</code> | Represents a key's relationship to a set of values.
**values**?🔹 | <code>Array<string></code> | An array of string values.<br/>__*Optional*__



## struct NodeSelectorTerm 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-nodeselectorterm"></a>


A null or empty node selector term matches no objects.

The requirements of them are ANDed. The TopologySelectorTerm type implements a subset of the NodeSelectorTerm.



Name | Type | Description 
-----|------|-------------
**matchExpressions**?🔹 | <code>Array<[k8s.NodeSelectorRequirement](#opencdk8s-cdk8s-argocd-resources-k8s-nodeselectorrequirement)></code> | A list of node selector requirements by node's labels.<br/>__*Optional*__
**matchFields**?🔹 | <code>Array<[k8s.NodeSelectorRequirement](#opencdk8s-cdk8s-argocd-resources-k8s-nodeselectorrequirement)></code> | A list of node selector requirements by node's fields.<br/>__*Optional*__



## struct NodeSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-nodespec"></a>


NodeSpec describes the attributes that a node is created with.



Name | Type | Description 
-----|------|-------------
**configSource**?🔹 | <code>[k8s.NodeConfigSource](#opencdk8s-cdk8s-argocd-resources-k8s-nodeconfigsource)</code> | If specified, the source to get node configuration from The DynamicKubeletConfig feature gate must be enabled for the Kubelet to use this field.<br/>__*Optional*__
**externalID**?🔹 | <code>string</code> | Deprecated.<br/>__*Optional*__
**podCIDR**?🔹 | <code>string</code> | PodCIDR represents the pod IP range assigned to the node.<br/>__*Optional*__
**providerID**?🔹 | <code>string</code> | ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>.<br/>__*Optional*__
**taints**?🔹 | <code>Array<[k8s.Taint](#opencdk8s-cdk8s-argocd-resources-k8s-taint)></code> | If specified, the node's taints.<br/>__*Optional*__
**unschedulable**?🔹 | <code>boolean</code> | Unschedulable controls node schedulability of new pods.<br/>__*Optional*__



## struct NonResourceAttributes 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-nonresourceattributes"></a>


NonResourceAttributes includes the authorization attributes available for non-resource requests to the Authorizer interface.



Name | Type | Description 
-----|------|-------------
**path**?🔹 | <code>string</code> | Path is the URL path of the request.<br/>__*Optional*__
**verb**?🔹 | <code>string</code> | Verb is the standard HTTP verb.<br/>__*Optional*__



## struct ObjectFieldSelector 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-objectfieldselector"></a>


ObjectFieldSelector selects an APIVersioned field of an object.



Name | Type | Description 
-----|------|-------------
**fieldPath**🔹 | <code>string</code> | Path of the field to select in the specified API version.
**apiVersion**?🔹 | <code>string</code> | Version of the schema the FieldPath is written in terms of, defaults to "v1".<br/>__*Optional*__



## struct ObjectMeta 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-objectmeta"></a>


ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.



Name | Type | Description 
-----|------|-------------
**annotations**?🔹 | <code>Map<string, string></code> | Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata.<br/>__*Optional*__
**clusterName**?🔹 | <code>string</code> | The name of the cluster which the object belongs to.<br/>__*Optional*__
**creationTimestamp**?🔹 | <code>date</code> | CreationTimestamp is a timestamp representing the server time when this object was created.<br/>__*Optional*__
**deletionGracePeriodSeconds**?🔹 | <code>number</code> | Number of seconds allowed for this object to gracefully terminate before it will be removed from the system.<br/>__*Optional*__
**deletionTimestamp**?🔹 | <code>date</code> | DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted.<br/>__*Optional*__
**finalizers**?🔹 | <code>Array<string></code> | Must be empty before the object is deleted from the registry.<br/>__*Optional*__
**generateName**?🔹 | <code>string</code> | GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided.<br/>__*Optional*__
**generation**?🔹 | <code>number</code> | A sequence number representing a specific generation of the desired state.<br/>__*Optional*__
**initializers**?🔹 | <code>[k8s.Initializers](#opencdk8s-cdk8s-argocd-resources-k8s-initializers)</code> | An initializer is a controller which enforces some system invariant at object creation time.<br/>__*Optional*__
**labels**?🔹 | <code>Map<string, string></code> | Map of string keys and values that can be used to organize and categorize (scope and select) objects.<br/>__*Optional*__
**managedFields**?🔹 | <code>Array<[k8s.ManagedFieldsEntry](#opencdk8s-cdk8s-argocd-resources-k8s-managedfieldsentry)></code> | ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow.<br/>__*Optional*__
**name**?🔹 | <code>string</code> | Name must be unique within a namespace.<br/>__*Optional*__
**namespace**?🔹 | <code>string</code> | Namespace defines the space within each name must be unique.<br/>__*Optional*__
**ownerReferences**?🔹 | <code>Array<[k8s.OwnerReference](#opencdk8s-cdk8s-argocd-resources-k8s-ownerreference)></code> | List of objects depended by this object.<br/>__*Optional*__
**resourceVersion**?🔹 | <code>string</code> | An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed.<br/>__*Optional*__
**selfLink**?🔹 | <code>string</code> | SelfLink is a URL representing this object.<br/>__*Optional*__
**uid**?🔹 | <code>string</code> | UID is the unique in time and space value for this object.<br/>__*Optional*__



## struct ObjectMetricSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-objectmetricsource"></a>


ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).



Name | Type | Description 
-----|------|-------------
**describedObject**🔹 | <code>[k8s.CrossVersionObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-crossversionobjectreference)</code> | <span></span>
**metric**🔹 | <code>[k8s.MetricIdentifier](#opencdk8s-cdk8s-argocd-resources-k8s-metricidentifier)</code> | metric identifies the target metric by name and selector.
**target**🔹 | <code>[k8s.MetricTarget](#opencdk8s-cdk8s-argocd-resources-k8s-metrictarget)</code> | target specifies the target value for the given metric.



## struct ObjectReference 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-objectreference"></a>


ObjectReference contains enough information to let you inspect or modify the referred object.



Name | Type | Description 
-----|------|-------------
**apiVersion**?🔹 | <code>string</code> | API version of the referent.<br/>__*Optional*__
**fieldPath**?🔹 | <code>string</code> | If referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]. For example, if the object reference is to a container within a pod, this would take on a value like: "spec.containers{name}" (where "name" refers to the name of the container that triggered the event) or if no container name is specified "spec.containers[2]" (container with index 2 in this pod). This syntax is chosen only to have some well-defined way of referencing a part of an object.<br/>__*Optional*__
**kind**?🔹 | <code>string</code> | Kind of the referent.<br/>__*Optional*__
**name**?🔹 | <code>string</code> | Name of the referent.<br/>__*Optional*__
**namespace**?🔹 | <code>string</code> | Namespace of the referent.<br/>__*Optional*__
**resourceVersion**?🔹 | <code>string</code> | Specific resourceVersion to which this reference is made, if any.<br/>__*Optional*__
**uid**?🔹 | <code>string</code> | UID of the referent.<br/>__*Optional*__



## struct OwnerReference 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-ownerreference"></a>


OwnerReference contains enough information to let you identify an owning object.

An owning object must be in the same namespace as the dependent, or be cluster-scoped, so there is no namespace field.



Name | Type | Description 
-----|------|-------------
**apiVersion**🔹 | <code>string</code> | API version of the referent.
**kind**🔹 | <code>string</code> | Kind of the referent.
**name**🔹 | <code>string</code> | Name of the referent.
**uid**🔹 | <code>string</code> | UID of the referent.
**blockOwnerDeletion**?🔹 | <code>boolean</code> | If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed.<br/>__*Default*__: false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.
**controller**?🔹 | <code>boolean</code> | If true, this reference points to the managing controller.<br/>__*Optional*__



## struct PersistentVolumeClaimSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-persistentvolumeclaimspec"></a>


PersistentVolumeClaimSpec describes the common attributes of storage devices and allows a Source for provider-specific attributes.



Name | Type | Description 
-----|------|-------------
**accessModes**?🔹 | <code>Array<string></code> | AccessModes contains the desired access modes the volume should have.<br/>__*Optional*__
**dataSource**?🔹 | <code>[k8s.TypedLocalObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-typedlocalobjectreference)</code> | This field requires the VolumeSnapshotDataSource alpha feature gate to be enabled and currently VolumeSnapshot is the only supported data source.<br/>__*Optional*__
**resources**?🔹 | <code>[k8s.ResourceRequirements](#opencdk8s-cdk8s-argocd-resources-k8s-resourcerequirements)</code> | Resources represents the minimum resources the volume should have.<br/>__*Optional*__
**selector**?🔹 | <code>[k8s.LabelSelector](#opencdk8s-cdk8s-argocd-resources-k8s-labelselector)</code> | A label query over volumes to consider for binding.<br/>__*Optional*__
**storageClassName**?🔹 | <code>string</code> | Name of the StorageClass required by the claim.<br/>__*Optional*__
**volumeMode**?🔹 | <code>string</code> | volumeMode defines what type of volume is required by the claim.<br/>__*Optional*__
**volumeName**?🔹 | <code>string</code> | VolumeName is the binding reference to the PersistentVolume backing this claim.<br/>__*Optional*__



## struct PersistentVolumeClaimVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-persistentvolumeclaimvolumesource"></a>


PersistentVolumeClaimVolumeSource references the user's PVC in the same namespace.

This volume finds the bound PV and mounts that volume for the pod. A PersistentVolumeClaimVolumeSource is, essentially, a wrapper around another type of volume that is owned by someone else (the system).



Name | Type | Description 
-----|------|-------------
**claimName**🔹 | <code>string</code> | ClaimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume.
**readOnly**?🔹 | <code>boolean</code> | Will force the ReadOnly setting in VolumeMounts.<br/>__*Optional*__



## struct PersistentVolumeSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-persistentvolumespec"></a>


PersistentVolumeSpec is the specification of a persistent volume.



Name | Type | Description 
-----|------|-------------
**accessModes**?🔹 | <code>Array<string></code> | AccessModes contains all ways the volume can be mounted.<br/>__*Optional*__
**awsElasticBlockStore**?🔹 | <code>[k8s.AwsElasticBlockStoreVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-awselasticblockstorevolumesource)</code> | AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod.<br/>__*Optional*__
**azureDisk**?🔹 | <code>[k8s.AzureDiskVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-azurediskvolumesource)</code> | AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.<br/>__*Optional*__
**azureFile**?🔹 | <code>[k8s.AzureFilePersistentVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-azurefilepersistentvolumesource)</code> | AzureFile represents an Azure File Service mount on the host and bind mount to the pod.<br/>__*Optional*__
**capacity**?🔹 | <code>Map<string, [k8s.Quantity](#opencdk8s-cdk8s-argocd-resources-k8s-quantity)></code> | A description of the persistent volume's resources and capacity.<br/>__*Optional*__
**cephfs**?🔹 | <code>[k8s.CephFsPersistentVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-cephfspersistentvolumesource)</code> | CephFS represents a Ceph FS mount on the host that shares a pod's lifetime.<br/>__*Optional*__
**cinder**?🔹 | <code>[k8s.CinderPersistentVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-cinderpersistentvolumesource)</code> | Cinder represents a cinder volume attached and mounted on kubelets host machine More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md.<br/>__*Optional*__
**claimRef**?🔹 | <code>[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)</code> | ClaimRef is part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.<br/>__*Optional*__
**csi**?🔹 | <code>[k8s.CsiPersistentVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-csipersistentvolumesource)</code> | CSI represents storage that is handled by an external CSI driver (Beta feature).<br/>__*Optional*__
**fc**?🔹 | <code>[k8s.FcVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-fcvolumesource)</code> | FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.<br/>__*Optional*__
**flexVolume**?🔹 | <code>[k8s.FlexPersistentVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-flexpersistentvolumesource)</code> | FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.<br/>__*Optional*__
**flocker**?🔹 | <code>[k8s.FlockerVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-flockervolumesource)</code> | Flocker represents a Flocker volume attached to a kubelet's host machine and exposed to the pod for its usage.<br/>__*Optional*__
**gcePersistentDisk**?🔹 | <code>[k8s.GcePersistentDiskVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-gcepersistentdiskvolumesource)</code> | GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod.<br/>__*Optional*__
**glusterfs**?🔹 | <code>[k8s.GlusterfsPersistentVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-glusterfspersistentvolumesource)</code> | Glusterfs represents a Glusterfs volume that is attached to a host and exposed to the pod.<br/>__*Optional*__
**hostPath**?🔹 | <code>[k8s.HostPathVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-hostpathvolumesource)</code> | HostPath represents a directory on the host.<br/>__*Optional*__
**iscsi**?🔹 | <code>[k8s.IscsiPersistentVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-iscsipersistentvolumesource)</code> | ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod.<br/>__*Optional*__
**local**?🔹 | <code>[k8s.LocalVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-localvolumesource)</code> | Local represents directly-attached storage with node affinity.<br/>__*Optional*__
**mountOptions**?🔹 | <code>Array<string></code> | A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options.<br/>__*Optional*__
**nfs**?🔹 | <code>[k8s.NfsVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-nfsvolumesource)</code> | NFS represents an NFS mount on the host.<br/>__*Optional*__
**nodeAffinity**?🔹 | <code>[k8s.VolumeNodeAffinity](#opencdk8s-cdk8s-argocd-resources-k8s-volumenodeaffinity)</code> | NodeAffinity defines constraints that limit what nodes this volume can be accessed from.<br/>__*Optional*__
**persistentVolumeReclaimPolicy**?🔹 | <code>string</code> | What happens to a persistent volume when released from its claim.<br/>__*Optional*__
**photonPersistentDisk**?🔹 | <code>[k8s.PhotonPersistentDiskVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-photonpersistentdiskvolumesource)</code> | PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine.<br/>__*Optional*__
**portworxVolume**?🔹 | <code>[k8s.PortworxVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-portworxvolumesource)</code> | PortworxVolume represents a portworx volume attached and mounted on kubelets host machine.<br/>__*Optional*__
**quobyte**?🔹 | <code>[k8s.QuobyteVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-quobytevolumesource)</code> | Quobyte represents a Quobyte mount on the host that shares a pod's lifetime.<br/>__*Optional*__
**rbd**?🔹 | <code>[k8s.RbdPersistentVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-rbdpersistentvolumesource)</code> | RBD represents a Rados Block Device mount on the host that shares a pod's lifetime.<br/>__*Optional*__
**scaleIO**?🔹 | <code>[k8s.ScaleIoPersistentVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-scaleiopersistentvolumesource)</code> | ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.<br/>__*Optional*__
**storageClassName**?🔹 | <code>string</code> | Name of StorageClass to which this persistent volume belongs.<br/>__*Optional*__
**storageos**?🔹 | <code>[k8s.StorageOsPersistentVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-storageospersistentvolumesource)</code> | StorageOS represents a StorageOS volume that is attached to the kubelet's host machine and mounted into the pod More info: https://releases.k8s.io/HEAD/examples/volumes/storageos/README.md.<br/>__*Optional*__
**volumeMode**?🔹 | <code>string</code> | volumeMode defines if a volume is intended to be used with a formatted filesystem or to remain in raw block state.<br/>__*Optional*__
**vsphereVolume**?🔹 | <code>[k8s.VsphereVirtualDiskVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-vspherevirtualdiskvolumesource)</code> | VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine.<br/>__*Optional*__



## struct PhotonPersistentDiskVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-photonpersistentdiskvolumesource"></a>


Represents a Photon Controller persistent disk resource.



Name | Type | Description 
-----|------|-------------
**pdID**🔹 | <code>string</code> | ID that identifies Photon Controller persistent disk.
**fsType**?🔹 | <code>string</code> | Filesystem type to mount.<br/>__*Optional*__



## struct PodAffinity 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-podaffinity"></a>


Pod affinity is a group of inter pod affinity scheduling rules.



Name | Type | Description 
-----|------|-------------
**preferredDuringSchedulingIgnoredDuringExecution**?🔹 | <code>Array<[k8s.WeightedPodAffinityTerm](#opencdk8s-cdk8s-argocd-resources-k8s-weightedpodaffinityterm)></code> | The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions.<br/>__*Optional*__
**requiredDuringSchedulingIgnoredDuringExecution**?🔹 | <code>Array<[k8s.PodAffinityTerm](#opencdk8s-cdk8s-argocd-resources-k8s-podaffinityterm)></code> | If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node.<br/>__*Optional*__



## struct PodAffinityTerm 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-podaffinityterm"></a>


Defines a set of pods (namely those matching the labelSelector relative to the given namespace(s)) that this pod should be co-located (affinity) or not co-located (anti-affinity) with, where co-located is defined as running on a node whose value of the label with key <topologyKey> matches that of any node on which a pod of the set of pods is running.



Name | Type | Description 
-----|------|-------------
**topologyKey**🔹 | <code>string</code> | This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching the labelSelector in the specified namespaces, where co-located is defined as running on a node whose value of the label with key topologyKey matches that of any node on which any of the selected pods is running.
**labelSelector**?🔹 | <code>[k8s.LabelSelector](#opencdk8s-cdk8s-argocd-resources-k8s-labelselector)</code> | A label query over a set of resources, in this case pods.<br/>__*Optional*__
**namespaces**?🔹 | <code>Array<string></code> | namespaces specifies which namespaces the labelSelector applies to (matches against);<br/>__*Optional*__



## struct PodAntiAffinity 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-podantiaffinity"></a>


Pod anti affinity is a group of inter pod anti affinity scheduling rules.



Name | Type | Description 
-----|------|-------------
**preferredDuringSchedulingIgnoredDuringExecution**?🔹 | <code>Array<[k8s.WeightedPodAffinityTerm](#opencdk8s-cdk8s-argocd-resources-k8s-weightedpodaffinityterm)></code> | The scheduler will prefer to schedule pods to nodes that satisfy the anti-affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions.<br/>__*Optional*__
**requiredDuringSchedulingIgnoredDuringExecution**?🔹 | <code>Array<[k8s.PodAffinityTerm](#opencdk8s-cdk8s-argocd-resources-k8s-podaffinityterm)></code> | If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node.<br/>__*Optional*__



## struct PodDisruptionBudgetSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-poddisruptionbudgetspec"></a>


PodDisruptionBudgetSpec is a description of a PodDisruptionBudget.



Name | Type | Description 
-----|------|-------------
**maxUnavailable**?🔹 | <code>[k8s.IntOrString](#opencdk8s-cdk8s-argocd-resources-k8s-intorstring)</code> | An eviction is allowed if at most "maxUnavailable" pods selected by "selector" are unavailable after the eviction, i.e. even in absence of the evicted pod. For example, one can prevent all voluntary evictions by specifying 0. This is a mutually exclusive setting with "minAvailable".<br/>__*Optional*__
**minAvailable**?🔹 | <code>[k8s.IntOrString](#opencdk8s-cdk8s-argocd-resources-k8s-intorstring)</code> | An eviction is allowed if at least "minAvailable" pods selected by "selector" will still be available after the eviction, i.e. even in the absence of the evicted pod.  So for example you can prevent all voluntary evictions by specifying "100%".<br/>__*Optional*__
**selector**?🔹 | <code>[k8s.LabelSelector](#opencdk8s-cdk8s-argocd-resources-k8s-labelselector)</code> | Label query over pods whose evictions are managed by the disruption budget.<br/>__*Optional*__



## struct PodDnsConfig 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-poddnsconfig"></a>


PodDNSConfig defines the DNS parameters of a pod in addition to those generated from DNSPolicy.



Name | Type | Description 
-----|------|-------------
**nameservers**?🔹 | <code>Array<string></code> | A list of DNS name server IP addresses.<br/>__*Optional*__
**options**?🔹 | <code>Array<[k8s.PodDnsConfigOption](#opencdk8s-cdk8s-argocd-resources-k8s-poddnsconfigoption)></code> | A list of DNS resolver options.<br/>__*Optional*__
**searches**?🔹 | <code>Array<string></code> | A list of DNS search domains for host-name lookup.<br/>__*Optional*__



## struct PodDnsConfigOption 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-poddnsconfigoption"></a>


PodDNSConfigOption defines DNS resolver options of a pod.



Name | Type | Description 
-----|------|-------------
**name**?🔹 | <code>string</code> | Required.<br/>__*Optional*__
**value**?🔹 | <code>string</code> | __*Optional*__



## struct PodPresetSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-podpresetspec"></a>


PodPresetSpec is a description of a pod preset.



Name | Type | Description 
-----|------|-------------
**env**?🔹 | <code>Array<[k8s.EnvVar](#opencdk8s-cdk8s-argocd-resources-k8s-envvar)></code> | Env defines the collection of EnvVar to inject into containers.<br/>__*Optional*__
**envFrom**?🔹 | <code>Array<[k8s.EnvFromSource](#opencdk8s-cdk8s-argocd-resources-k8s-envfromsource)></code> | EnvFrom defines the collection of EnvFromSource to inject into containers.<br/>__*Optional*__
**selector**?🔹 | <code>[k8s.LabelSelector](#opencdk8s-cdk8s-argocd-resources-k8s-labelselector)</code> | Selector is a label query over a set of resources, in this case pods.<br/>__*Optional*__
**volumeMounts**?🔹 | <code>Array<[k8s.VolumeMount](#opencdk8s-cdk8s-argocd-resources-k8s-volumemount)></code> | VolumeMounts defines the collection of VolumeMount to inject into containers.<br/>__*Optional*__
**volumes**?🔹 | <code>Array<[k8s.Volume](#opencdk8s-cdk8s-argocd-resources-k8s-volume)></code> | Volumes defines the collection of Volume to inject into the pod.<br/>__*Optional*__



## struct PodReadinessGate 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-podreadinessgate"></a>


PodReadinessGate contains the reference to a pod condition.



Name | Type | Description 
-----|------|-------------
**conditionType**🔹 | <code>string</code> | ConditionType refers to a condition in the pod's condition list with matching type.



## struct PodSecurityContext 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-podsecuritycontext"></a>


PodSecurityContext holds pod-level security attributes and common container settings.

Some fields are also present in container.securityContext.  Field values of container.securityContext take precedence over field values of PodSecurityContext.



Name | Type | Description 
-----|------|-------------
**fsGroup**?🔹 | <code>number</code> | A special supplemental group that applies to all containers in a pod.<br/>__*Optional*__
**runAsGroup**?🔹 | <code>number</code> | The GID to run the entrypoint of the container process.<br/>__*Optional*__
**runAsNonRoot**?🔹 | <code>boolean</code> | Indicates that the container must run as a non-root user.<br/>__*Optional*__
**runAsUser**?🔹 | <code>number</code> | The UID to run the entrypoint of the container process.<br/>__*Default*__: user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
**seLinuxOptions**?🔹 | <code>[k8s.SeLinuxOptions](#opencdk8s-cdk8s-argocd-resources-k8s-selinuxoptions)</code> | The SELinux context to be applied to all containers.<br/>__*Optional*__
**supplementalGroups**?🔹 | <code>Array<number></code> | A list of groups applied to the first process run in each container, in addition to the container's primary GID.<br/>__*Optional*__
**sysctls**?🔹 | <code>Array<[k8s.Sysctl](#opencdk8s-cdk8s-argocd-resources-k8s-sysctl)></code> | Sysctls hold a list of namespaced sysctls used for the pod.<br/>__*Optional*__
**windowsOptions**?🔹 | <code>[k8s.WindowsSecurityContextOptions](#opencdk8s-cdk8s-argocd-resources-k8s-windowssecuritycontextoptions)</code> | Windows security options.<br/>__*Optional*__



## struct PodSecurityPolicySpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-podsecuritypolicyspec"></a>


PodSecurityPolicySpec defines the policy enforced.



Name | Type | Description 
-----|------|-------------
**fsGroup**🔹 | <code>[k8s.FsGroupStrategyOptions](#opencdk8s-cdk8s-argocd-resources-k8s-fsgroupstrategyoptions)</code> | fsGroup is the strategy that will dictate what fs group is used by the SecurityContext.
**runAsUser**🔹 | <code>[k8s.RunAsUserStrategyOptions](#opencdk8s-cdk8s-argocd-resources-k8s-runasuserstrategyoptions)</code> | runAsUser is the strategy that will dictate the allowable RunAsUser values that may be set.
**seLinux**🔹 | <code>[k8s.SeLinuxStrategyOptions](#opencdk8s-cdk8s-argocd-resources-k8s-selinuxstrategyoptions)</code> | seLinux is the strategy that will dictate the allowable labels that may be set.
**supplementalGroups**🔹 | <code>[k8s.SupplementalGroupsStrategyOptions](#opencdk8s-cdk8s-argocd-resources-k8s-supplementalgroupsstrategyoptions)</code> | supplementalGroups is the strategy that will dictate what supplemental groups are used by the SecurityContext.
**allowPrivilegeEscalation**?🔹 | <code>boolean</code> | allowPrivilegeEscalation determines if a pod can request to allow privilege escalation.<br/>__*Optional*__
**allowedCSIDrivers**?🔹 | <code>Array<[k8s.AllowedCsiDriver](#opencdk8s-cdk8s-argocd-resources-k8s-allowedcsidriver)></code> | AllowedCSIDrivers is a whitelist of inline CSI drivers that must be explicitly set to be embedded within a pod spec.<br/>__*Optional*__
**allowedCapabilities**?🔹 | <code>Array<string></code> | allowedCapabilities is a list of capabilities that can be requested to add to the container.<br/>__*Optional*__
**allowedFlexVolumes**?🔹 | <code>Array<[k8s.AllowedFlexVolume](#opencdk8s-cdk8s-argocd-resources-k8s-allowedflexvolume)></code> | allowedFlexVolumes is a whitelist of allowed Flexvolumes.<br/>__*Optional*__
**allowedHostPaths**?🔹 | <code>Array<[k8s.AllowedHostPath](#opencdk8s-cdk8s-argocd-resources-k8s-allowedhostpath)></code> | allowedHostPaths is a white list of allowed host paths.<br/>__*Optional*__
**allowedProcMountTypes**?🔹 | <code>Array<string></code> | AllowedProcMountTypes is a whitelist of allowed ProcMountTypes.<br/>__*Optional*__
**allowedUnsafeSysctls**?🔹 | <code>Array<string></code> | allowedUnsafeSysctls is a list of explicitly allowed unsafe sysctls, defaults to none.<br/>__*Optional*__
**defaultAddCapabilities**?🔹 | <code>Array<string></code> | defaultAddCapabilities is the default set of capabilities that will be added to the container unless the pod spec specifically drops the capability.<br/>__*Optional*__
**defaultAllowPrivilegeEscalation**?🔹 | <code>boolean</code> | defaultAllowPrivilegeEscalation controls the default setting for whether a process can gain more privileges than its parent process.<br/>__*Optional*__
**forbiddenSysctls**?🔹 | <code>Array<string></code> | forbiddenSysctls is a list of explicitly forbidden sysctls, defaults to none.<br/>__*Optional*__
**hostIPC**?🔹 | <code>boolean</code> | hostIPC determines if the policy allows the use of HostIPC in the pod spec.<br/>__*Optional*__
**hostNetwork**?🔹 | <code>boolean</code> | hostNetwork determines if the policy allows the use of HostNetwork in the pod spec.<br/>__*Optional*__
**hostPID**?🔹 | <code>boolean</code> | hostPID determines if the policy allows the use of HostPID in the pod spec.<br/>__*Optional*__
**hostPorts**?🔹 | <code>Array<[k8s.HostPortRange](#opencdk8s-cdk8s-argocd-resources-k8s-hostportrange)></code> | hostPorts determines which host port ranges are allowed to be exposed.<br/>__*Optional*__
**privileged**?🔹 | <code>boolean</code> | privileged determines if a pod can request to be run as privileged.<br/>__*Optional*__
**readOnlyRootFilesystem**?🔹 | <code>boolean</code> | readOnlyRootFilesystem when set to true will force containers to run with a read only root file system.<br/>__*Optional*__
**requiredDropCapabilities**?🔹 | <code>Array<string></code> | requiredDropCapabilities are the capabilities that will be dropped from the container.<br/>__*Optional*__
**runAsGroup**?🔹 | <code>[k8s.RunAsGroupStrategyOptions](#opencdk8s-cdk8s-argocd-resources-k8s-runasgroupstrategyoptions)</code> | RunAsGroup is the strategy that will dictate the allowable RunAsGroup values that may be set.<br/>__*Optional*__
**runtimeClass**?🔹 | <code>[k8s.RuntimeClassStrategyOptions](#opencdk8s-cdk8s-argocd-resources-k8s-runtimeclassstrategyoptions)</code> | runtimeClass is the strategy that will dictate the allowable RuntimeClasses for a pod.<br/>__*Optional*__
**volumes**?🔹 | <code>Array<string></code> | volumes is a white list of allowed volume plugins.<br/>__*Optional*__



## struct PodSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-podspec"></a>


PodSpec is a description of a pod.



Name | Type | Description 
-----|------|-------------
**containers**🔹 | <code>Array<[k8s.Container](#opencdk8s-cdk8s-argocd-resources-k8s-container)></code> | List of containers belonging to the pod.
**activeDeadlineSeconds**?🔹 | <code>number</code> | Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers.<br/>__*Optional*__
**affinity**?🔹 | <code>[k8s.Affinity](#opencdk8s-cdk8s-argocd-resources-k8s-affinity)</code> | If specified, the pod's scheduling constraints.<br/>__*Optional*__
**automountServiceAccountToken**?🔹 | <code>boolean</code> | AutomountServiceAccountToken indicates whether a service account token should be automatically mounted.<br/>__*Optional*__
**dnsConfig**?🔹 | <code>[k8s.PodDnsConfig](#opencdk8s-cdk8s-argocd-resources-k8s-poddnsconfig)</code> | Specifies the DNS parameters of a pod.<br/>__*Optional*__
**dnsPolicy**?🔹 | <code>string</code> | Set DNS policy for the pod.<br/>__*Default*__: ClusterFirst". Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to 'ClusterFirstWithHostNet'.
**enableServiceLinks**?🔹 | <code>boolean</code> | EnableServiceLinks indicates whether information about services should be injected into pod's environment variables, matching the syntax of Docker links.<br/>__*Default*__: true.
**hostAliases**?🔹 | <code>Array<[k8s.HostAlias](#opencdk8s-cdk8s-argocd-resources-k8s-hostalias)></code> | HostAliases is an optional list of hosts and IPs that will be injected into the pod's hosts file if specified.<br/>__*Optional*__
**hostIPC**?🔹 | <code>boolean</code> | Use the host's ipc namespace.<br/>__*Default*__: false.
**hostNetwork**?🔹 | <code>boolean</code> | Host networking requested for this pod.<br/>__*Default*__: false.
**hostPID**?🔹 | <code>boolean</code> | Use the host's pid namespace.<br/>__*Default*__: false.
**hostname**?🔹 | <code>string</code> | Specifies the hostname of the Pod If not specified, the pod's hostname will be set to a system-defined value.<br/>__*Optional*__
**imagePullSecrets**?🔹 | <code>Array<[k8s.LocalObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-localobjectreference)></code> | ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec.<br/>__*Optional*__
**initContainers**?🔹 | <code>Array<[k8s.Container](#opencdk8s-cdk8s-argocd-resources-k8s-container)></code> | List of initialization containers belonging to the pod.<br/>__*Optional*__
**nodeName**?🔹 | <code>string</code> | NodeName is a request to schedule this pod onto a specific node.<br/>__*Optional*__
**nodeSelector**?🔹 | <code>Map<string, string></code> | NodeSelector is a selector which must be true for the pod to fit on a node.<br/>__*Optional*__
**preemptionPolicy**?🔹 | <code>string</code> | PreemptionPolicy is the Policy for preempting pods with lower priority.<br/>__*Default*__: PreemptLowerPriority if unset. This field is alpha-level and is only honored by servers that enable the NonPreemptingPriority feature.
**priority**?🔹 | <code>number</code> | The priority value.<br/>__*Optional*__
**priorityClassName**?🔹 | <code>string</code> | If specified, indicates the pod's priority.<br/>__*Optional*__
**readinessGates**?🔹 | <code>Array<[k8s.PodReadinessGate](#opencdk8s-cdk8s-argocd-resources-k8s-podreadinessgate)></code> | If specified, all readiness gates will be evaluated for pod readiness.<br/>__*Optional*__
**restartPolicy**?🔹 | <code>string</code> | Restart policy for all containers within the pod.<br/>__*Default*__: Always. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
**runtimeClassName**?🔹 | <code>string</code> | RuntimeClassName refers to a RuntimeClass object in the node.k8s.io group, which should be used to run this pod.  If no RuntimeClass resource matches the named class, the pod will not be run. If unset or empty, the "legacy" RuntimeClass will be used, which is an implicit class with an empty definition that uses the default runtime handler. More info: https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md This is a beta feature as of Kubernetes v1.14.<br/>__*Optional*__
**schedulerName**?🔹 | <code>string</code> | If specified, the pod will be dispatched by specified scheduler.<br/>__*Optional*__
**securityContext**?🔹 | <code>[k8s.PodSecurityContext](#opencdk8s-cdk8s-argocd-resources-k8s-podsecuritycontext)</code> | SecurityContext holds pod-level security attributes and common container settings.<br/>__*Default*__: empty.  See type description for default values of each field.
**serviceAccount**?🔹 | <code>string</code> | DeprecatedServiceAccount is a depreciated alias for ServiceAccountName.<br/>__*Optional*__
**serviceAccountName**?🔹 | <code>string</code> | ServiceAccountName is the name of the ServiceAccount to use to run this pod.<br/>__*Optional*__
**shareProcessNamespace**?🔹 | <code>boolean</code> | Share a single process namespace between all of the containers in a pod.<br/>__*Default*__: false. This field is beta-level and may be disabled with the PodShareProcessNamespace feature.
**subdomain**?🔹 | <code>string</code> | If specified, the fully qualified Pod hostname will be "<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>". If not specified, the pod will not have a domainname at all.<br/>__*Optional*__
**terminationGracePeriodSeconds**?🔹 | <code>number</code> | Optional duration in seconds the pod needs to terminate gracefully.<br/>__*Default*__: 30 seconds.
**tolerations**?🔹 | <code>Array<[k8s.Toleration](#opencdk8s-cdk8s-argocd-resources-k8s-toleration)></code> | If specified, the pod's tolerations.<br/>__*Optional*__
**volumes**?🔹 | <code>Array<[k8s.Volume](#opencdk8s-cdk8s-argocd-resources-k8s-volume)></code> | List of volumes that can be mounted by containers belonging to the pod.<br/>__*Optional*__



## struct PodTemplateSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-podtemplatespec"></a>


PodTemplateSpec describes the data a pod should have when created from a template.



Name | Type | Description 
-----|------|-------------
**metadata**?🔹 | <code>[k8s.ObjectMeta](#opencdk8s-cdk8s-argocd-resources-k8s-objectmeta)</code> | Standard object's metadata.<br/>__*Optional*__
**spec**?🔹 | <code>[k8s.PodSpec](#opencdk8s-cdk8s-argocd-resources-k8s-podspec)</code> | Specification of the desired behavior of the pod.<br/>__*Optional*__



## struct PodsMetricSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-podsmetricsource"></a>


PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second).

The values will be averaged together before being compared to the target value.



Name | Type | Description 
-----|------|-------------
**metric**🔹 | <code>[k8s.MetricIdentifier](#opencdk8s-cdk8s-argocd-resources-k8s-metricidentifier)</code> | metric identifies the target metric by name and selector.
**target**🔹 | <code>[k8s.MetricTarget](#opencdk8s-cdk8s-argocd-resources-k8s-metrictarget)</code> | target specifies the target value for the given metric.



## struct Policy 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-policy"></a>


Policy defines the configuration of how audit events are logged.



Name | Type | Description 
-----|------|-------------
**level**🔹 | <code>string</code> | The Level that all requests are recorded at.
**stages**?🔹 | <code>Array<string></code> | Stages is a list of stages for which events are created.<br/>__*Optional*__



## struct PolicyRule 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-policyrule"></a>


PolicyRule holds information that describes a policy rule, but does not contain information about who the rule applies to or which namespace the rule applies to.



Name | Type | Description 
-----|------|-------------
**verbs**🔹 | <code>Array<string></code> | Verbs is a list of Verbs that apply to ALL the ResourceKinds and AttributeRestrictions contained in this rule.
**apiGroups**?🔹 | <code>Array<string></code> | APIGroups is the name of the APIGroup that contains the resources.<br/>__*Optional*__
**nonResourceURLs**?🔹 | <code>Array<string></code> | NonResourceURLs is a set of partial urls that a user should have access to.<br/>__*Optional*__
**resourceNames**?🔹 | <code>Array<string></code> | ResourceNames is an optional white list of names that the rule applies to.<br/>__*Optional*__
**resources**?🔹 | <code>Array<string></code> | Resources is a list of resources this rule applies to.<br/>__*Optional*__



## struct PortworxVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-portworxvolumesource"></a>


PortworxVolumeSource represents a Portworx volume resource.



Name | Type | Description 
-----|------|-------------
**volumeID**🔹 | <code>string</code> | VolumeID uniquely identifies a Portworx volume.
**fsType**?🔹 | <code>string</code> | FSType represents the filesystem type to mount Must be a filesystem type supported by the host operating system.<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | Defaults to false (read/write).<br/>__*Default*__: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.



## struct Preconditions 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-preconditions"></a>


Preconditions must be fulfilled before an operation (update, delete, etc.) is carried out.



Name | Type | Description 
-----|------|-------------
**resourceVersion**?🔹 | <code>string</code> | Specifies the target ResourceVersion.<br/>__*Optional*__
**uid**?🔹 | <code>string</code> | Specifies the target UID.<br/>__*Optional*__



## struct PreferredSchedulingTerm 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-preferredschedulingterm"></a>


An empty preferred scheduling term matches all objects with implicit weight 0 (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op).



Name | Type | Description 
-----|------|-------------
**preference**🔹 | <code>[k8s.NodeSelectorTerm](#opencdk8s-cdk8s-argocd-resources-k8s-nodeselectorterm)</code> | A node selector term, associated with the corresponding weight.
**weight**🔹 | <code>number</code> | Weight associated with matching the corresponding nodeSelectorTerm, in the range 1-100.



## struct Probe 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-probe"></a>


Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.



Name | Type | Description 
-----|------|-------------
**exec**?🔹 | <code>[k8s.ExecAction](#opencdk8s-cdk8s-argocd-resources-k8s-execaction)</code> | One and only one of the following should be specified.<br/>__*Optional*__
**failureThreshold**?🔹 | <code>number</code> | Minimum consecutive failures for the probe to be considered failed after having succeeded.<br/>__*Default*__: 3. Minimum value is 1.
**httpGet**?🔹 | <code>[k8s.HttpGetAction](#opencdk8s-cdk8s-argocd-resources-k8s-httpgetaction)</code> | HTTPGet specifies the http request to perform.<br/>__*Optional*__
**initialDelaySeconds**?🔹 | <code>number</code> | Number of seconds after the container has started before liveness probes are initiated.<br/>__*Optional*__
**periodSeconds**?🔹 | <code>number</code> | How often (in seconds) to perform the probe.<br/>__*Default*__: 10 seconds. Minimum value is 1.
**successThreshold**?🔹 | <code>number</code> | Minimum consecutive successes for the probe to be considered successful after having failed.<br/>__*Default*__: 1. Must be 1 for liveness. Minimum value is 1.
**tcpSocket**?🔹 | <code>[k8s.TcpSocketAction](#opencdk8s-cdk8s-argocd-resources-k8s-tcpsocketaction)</code> | TCPSocket specifies an action involving a TCP port.<br/>__*Optional*__
**timeoutSeconds**?🔹 | <code>number</code> | Number of seconds after which the probe times out.<br/>__*Default*__: 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes



## struct ProjectedVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-projectedvolumesource"></a>


Represents a projected volume source.



Name | Type | Description 
-----|------|-------------
**sources**🔹 | <code>Array<[k8s.VolumeProjection](#opencdk8s-cdk8s-argocd-resources-k8s-volumeprojection)></code> | list of volume projections.
**defaultMode**?🔹 | <code>number</code> | Mode bits to use on created files by default.<br/>__*Optional*__



## struct QuobyteVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-quobytevolumesource"></a>


Represents a Quobyte mount that lasts the lifetime of a pod.

Quobyte volumes do not support ownership management or SELinux relabeling.



Name | Type | Description 
-----|------|-------------
**registry**🔹 | <code>string</code> | Registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes.
**volume**🔹 | <code>string</code> | Volume is a string that references an already created Quobyte volume by name.
**group**?🔹 | <code>string</code> | Group to map volume access to Default is no group.<br/>__*Default*__: no group
**readOnly**?🔹 | <code>boolean</code> | ReadOnly here will force the Quobyte volume to be mounted with read-only permissions.<br/>__*Default*__: false.
**tenant**?🔹 | <code>string</code> | Tenant owning the given Quobyte volume in the Backend Used with dynamically provisioned Quobyte volumes, value is set by the plugin.<br/>__*Optional*__
**user**?🔹 | <code>string</code> | User to map volume access to Defaults to serivceaccount user.<br/>__*Default*__: serivceaccount user



## struct RawExtension 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-rawextension"></a>


RawExtension is used to hold extensions in external versions.

To use this, make a field which has RawExtension as its type in your external, versioned struct, and Object in your internal struct. You also need to register your various plugin types.

// Internal package: type MyAPIObject struct {
runtime.TypeMeta `json:",inline"`
MyPlugin runtime.Object `json:"myPlugin"`
} type PluginA struct {
AOption string `json:"aOption"`
}

// External package: type MyAPIObject struct {
runtime.TypeMeta `json:",inline"`
MyPlugin runtime.RawExtension `json:"myPlugin"`
} type PluginA struct {
AOption string `json:"aOption"`
}

// On the wire, the JSON will look something like this: {
"kind":"MyAPIObject",
"apiVersion":"v1",
"myPlugin": {
"kind":"PluginA",
"aOption":"foo",
},
}

So what happens? Decode first uses json or yaml to unmarshal the serialized data into your external MyAPIObject. That causes the raw JSON to be stored, but not unpacked. The next step is to copy (using pkg/conversion) into the internal struct. The runtime package's DefaultScheme has conversion functions installed which will unpack the JSON stored in RawExtension, turning it into the correct object type, and storing it in the Object. (TODO: In the case where the object is of an unknown type, a runtime.Unknown object will be created and stored.)



Name | Type | Description 
-----|------|-------------
**raw**?🔹 | <code>string</code> | Raw is the underlying serialization of this object.<br/>__*Optional*__



## struct RbdPersistentVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-rbdpersistentvolumesource"></a>


Represents a Rados Block Device mount that lasts the lifetime of a pod.

RBD volumes support ownership management and SELinux relabeling.



Name | Type | Description 
-----|------|-------------
**image**🔹 | <code>string</code> | The rados image name.
**monitors**🔹 | <code>Array<string></code> | A collection of Ceph monitors.
**fsType**?🔹 | <code>string</code> | Filesystem type of the volume that you want to mount.<br/>__*Optional*__
**keyring**?🔹 | <code>string</code> | Keyring is the path to key ring for RBDUser.<br/>__*Default*__: etc/ceph/keyring. More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
**pool**?🔹 | <code>string</code> | The rados pool name.<br/>__*Default*__: rbd. More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
**readOnly**?🔹 | <code>boolean</code> | ReadOnly here will force the ReadOnly setting in VolumeMounts.<br/>__*Default*__: false. More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
**secretRef**?🔹 | <code>[k8s.SecretReference](#opencdk8s-cdk8s-argocd-resources-k8s-secretreference)</code> | SecretRef is name of the authentication secret for RBDUser.<br/>__*Default*__: nil. More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
**user**?🔹 | <code>string</code> | The rados user name.<br/>__*Default*__: admin. More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it



## struct RbdVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-rbdvolumesource"></a>


Represents a Rados Block Device mount that lasts the lifetime of a pod.

RBD volumes support ownership management and SELinux relabeling.



Name | Type | Description 
-----|------|-------------
**image**🔹 | <code>string</code> | The rados image name.
**monitors**🔹 | <code>Array<string></code> | A collection of Ceph monitors.
**fsType**?🔹 | <code>string</code> | Filesystem type of the volume that you want to mount.<br/>__*Optional*__
**keyring**?🔹 | <code>string</code> | Keyring is the path to key ring for RBDUser.<br/>__*Default*__: etc/ceph/keyring. More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
**pool**?🔹 | <code>string</code> | The rados pool name.<br/>__*Default*__: rbd. More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
**readOnly**?🔹 | <code>boolean</code> | ReadOnly here will force the ReadOnly setting in VolumeMounts.<br/>__*Default*__: false. More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
**secretRef**?🔹 | <code>[k8s.LocalObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-localobjectreference)</code> | SecretRef is name of the authentication secret for RBDUser.<br/>__*Default*__: nil. More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
**user**?🔹 | <code>string</code> | The rados user name.<br/>__*Default*__: admin. More info: https://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it



## struct ReplicaSetSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-replicasetspec"></a>


ReplicaSetSpec is the specification of a ReplicaSet.



Name | Type | Description 
-----|------|-------------
**minReadySeconds**?🔹 | <code>number</code> | Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available.<br/>__*Default*__: 0 (pod will be considered available as soon as it is ready)
**replicas**?🔹 | <code>number</code> | Replicas is the number of desired replicas.<br/>__*Default*__: 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
**selector**?🔹 | <code>[k8s.LabelSelector](#opencdk8s-cdk8s-argocd-resources-k8s-labelselector)</code> | Selector is a label query over pods that should match the replica count.<br/>__*Optional*__
**template**?🔹 | <code>[k8s.PodTemplateSpec](#opencdk8s-cdk8s-argocd-resources-k8s-podtemplatespec)</code> | Template is the object that describes the pod that will be created if insufficient replicas are detected.<br/>__*Optional*__



## struct ReplicationControllerSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-replicationcontrollerspec"></a>


ReplicationControllerSpec is the specification of a replication controller.



Name | Type | Description 
-----|------|-------------
**minReadySeconds**?🔹 | <code>number</code> | Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available.<br/>__*Default*__: 0 (pod will be considered available as soon as it is ready)
**replicas**?🔹 | <code>number</code> | Replicas is the number of desired replicas.<br/>__*Default*__: 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
**selector**?🔹 | <code>Map<string, string></code> | Selector is a label query over pods that should match the Replicas count.<br/>__*Optional*__
**template**?🔹 | <code>[k8s.PodTemplateSpec](#opencdk8s-cdk8s-argocd-resources-k8s-podtemplatespec)</code> | Template is the object that describes the pod that will be created if insufficient replicas are detected.<br/>__*Optional*__



## struct ResourceAttributes 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-resourceattributes"></a>


ResourceAttributes includes the authorization attributes available for resource requests to the Authorizer interface.



Name | Type | Description 
-----|------|-------------
**group**?🔹 | <code>string</code> | Group is the API Group of the Resource.<br/>__*Optional*__
**name**?🔹 | <code>string</code> | Name is the name of the resource being requested for a "get" or deleted for a "delete".<br/>__*Optional*__
**namespace**?🔹 | <code>string</code> | Namespace is the namespace of the action being requested.<br/>__*Optional*__
**resource**?🔹 | <code>string</code> | Resource is one of the existing resource types.<br/>__*Optional*__
**subresource**?🔹 | <code>string</code> | Subresource is one of the existing resource types.<br/>__*Optional*__
**verb**?🔹 | <code>string</code> | Verb is a kubernetes resource API verb, like: get, list, watch, create, update, delete, proxy.<br/>__*Optional*__
**version**?🔹 | <code>string</code> | Version is the API Version of the Resource.<br/>__*Optional*__



## struct ResourceFieldSelector 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-resourcefieldselector"></a>


ResourceFieldSelector represents container resources (cpu, memory) and their output format.



Name | Type | Description 
-----|------|-------------
**resource**🔹 | <code>string</code> | Required: resource to select.
**containerName**?🔹 | <code>string</code> | Container name: required for volumes, optional for env vars.<br/>__*Optional*__
**divisor**?🔹 | <code>[k8s.Quantity](#opencdk8s-cdk8s-argocd-resources-k8s-quantity)</code> | Specifies the output format of the exposed resources, defaults to "1".<br/>__*Optional*__



## struct ResourceMetricSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-resourcemetricsource"></a>


ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.



Name | Type | Description 
-----|------|-------------
**name**🔹 | <code>string</code> | name is the name of the resource in question.
**target**🔹 | <code>[k8s.MetricTarget](#opencdk8s-cdk8s-argocd-resources-k8s-metrictarget)</code> | target specifies the target value for the given metric.



## struct ResourceQuotaSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-resourcequotaspec"></a>


ResourceQuotaSpec defines the desired hard limits to enforce for Quota.



Name | Type | Description 
-----|------|-------------
**hard**?🔹 | <code>Map<string, [k8s.Quantity](#opencdk8s-cdk8s-argocd-resources-k8s-quantity)></code> | hard is the set of desired hard limits for each named resource.<br/>__*Optional*__
**scopeSelector**?🔹 | <code>[k8s.ScopeSelector](#opencdk8s-cdk8s-argocd-resources-k8s-scopeselector)</code> | scopeSelector is also a collection of filters like scopes that must match each object tracked by a quota but expressed using ScopeSelectorOperator in combination with possible values.<br/>__*Optional*__
**scopes**?🔹 | <code>Array<string></code> | A collection of filters that must match each object tracked by a quota.<br/>__*Optional*__



## struct ResourceRequirements 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-resourcerequirements"></a>


ResourceRequirements describes the compute resource requirements.



Name | Type | Description 
-----|------|-------------
**limits**?🔹 | <code>Map<string, [k8s.Quantity](#opencdk8s-cdk8s-argocd-resources-k8s-quantity)></code> | Limits describes the maximum amount of compute resources allowed.<br/>__*Optional*__
**requests**?🔹 | <code>Map<string, [k8s.Quantity](#opencdk8s-cdk8s-argocd-resources-k8s-quantity)></code> | Requests describes the minimum amount of compute resources required.<br/>__*Optional*__



## struct RoleRef 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-roleref"></a>


RoleRef contains information that points to the role being used.



Name | Type | Description 
-----|------|-------------
**apiGroup**🔹 | <code>string</code> | APIGroup is the group for the resource being referenced.
**kind**🔹 | <code>string</code> | Kind is the type of resource being referenced.
**name**🔹 | <code>string</code> | Name is the name of resource being referenced.



## struct RollingUpdateDaemonSet 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-rollingupdatedaemonset"></a>


Spec to control the desired behavior of daemon set rolling update.



Name | Type | Description 
-----|------|-------------
**maxUnavailable**?🔹 | <code>[k8s.IntOrString](#opencdk8s-cdk8s-argocd-resources-k8s-intorstring)</code> | The maximum number of DaemonSet pods that can be unavailable during the update.<br/>__*Optional*__



## struct RollingUpdateDeployment 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-rollingupdatedeployment"></a>


Spec to control the desired behavior of rolling update.



Name | Type | Description 
-----|------|-------------
**maxSurge**?🔹 | <code>[k8s.IntOrString](#opencdk8s-cdk8s-argocd-resources-k8s-intorstring)</code> | The maximum number of pods that can be scheduled above the desired number of pods.<br/>__*Default*__: 25%. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.
**maxUnavailable**?🔹 | <code>[k8s.IntOrString](#opencdk8s-cdk8s-argocd-resources-k8s-intorstring)</code> | The maximum number of pods that can be unavailable during the update.<br/>__*Default*__: 25%. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.



## struct RollingUpdateStatefulSetStrategy 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-rollingupdatestatefulsetstrategy"></a>


RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.



Name | Type | Description 
-----|------|-------------
**partition**?🔹 | <code>number</code> | Partition indicates the ordinal at which the StatefulSet should be partitioned.<br/>__*Optional*__



## struct RuleWithOperations 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-rulewithoperations"></a>


RuleWithOperations is a tuple of Operations and Resources.

It is recommended to make sure that all the tuple expansions are valid.



Name | Type | Description 
-----|------|-------------
**apiGroups**?🔹 | <code>Array<string></code> | APIGroups is the API groups the resources belong to.<br/>__*Optional*__
**apiVersions**?🔹 | <code>Array<string></code> | APIVersions is the API versions the resources belong to.<br/>__*Optional*__
**operations**?🔹 | <code>Array<string></code> | Operations is the operations the admission hook cares about - CREATE, UPDATE, or * for all operations.<br/>__*Optional*__
**resources**?🔹 | <code>Array<string></code> | Resources is a list of resources this rule applies to.<br/>__*Optional*__
**scope**?🔹 | <code>string</code> | scope specifies the scope of this rule.<br/>__*Default*__: .



## struct RunAsGroupStrategyOptions 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-runasgroupstrategyoptions"></a>


RunAsGroupStrategyOptions defines the strategy type and any options used to create the strategy.



Name | Type | Description 
-----|------|-------------
**rule**🔹 | <code>string</code> | rule is the strategy that will dictate the allowable RunAsGroup values that may be set.
**ranges**?🔹 | <code>Array<[k8s.IdRange](#opencdk8s-cdk8s-argocd-resources-k8s-idrange)></code> | ranges are the allowed ranges of gids that may be used.<br/>__*Optional*__



## struct RunAsUserStrategyOptions 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-runasuserstrategyoptions"></a>


RunAsUserStrategyOptions defines the strategy type and any options used to create the strategy.



Name | Type | Description 
-----|------|-------------
**rule**🔹 | <code>string</code> | rule is the strategy that will dictate the allowable RunAsUser values that may be set.
**ranges**?🔹 | <code>Array<[k8s.IdRange](#opencdk8s-cdk8s-argocd-resources-k8s-idrange)></code> | ranges are the allowed ranges of uids that may be used.<br/>__*Optional*__



## struct RuntimeClassSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-runtimeclassspec"></a>


RuntimeClassSpec is a specification of a RuntimeClass.

It contains parameters that are required to describe the RuntimeClass to the Container Runtime Interface (CRI) implementation, as well as any other components that need to understand how the pod will be run. The RuntimeClassSpec is immutable.



Name | Type | Description 
-----|------|-------------
**runtimeHandler**🔹 | <code>string</code> | RuntimeHandler specifies the underlying runtime and configuration that the CRI implementation will use to handle pods of this class.



## struct RuntimeClassStrategyOptions 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-runtimeclassstrategyoptions"></a>


RuntimeClassStrategyOptions define the strategy that will dictate the allowable RuntimeClasses for a pod.



Name | Type | Description 
-----|------|-------------
**allowedRuntimeClassNames**🔹 | <code>Array<string></code> | allowedRuntimeClassNames is a whitelist of RuntimeClass names that may be specified on a pod.
**defaultRuntimeClassName**?🔹 | <code>string</code> | defaultRuntimeClassName is the default RuntimeClassName to set on the pod.<br/>__*Optional*__



## struct ScaleIoPersistentVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-scaleiopersistentvolumesource"></a>


ScaleIOPersistentVolumeSource represents a persistent ScaleIO volume.



Name | Type | Description 
-----|------|-------------
**gateway**🔹 | <code>string</code> | The host address of the ScaleIO API Gateway.
**secretRef**🔹 | <code>[k8s.SecretReference](#opencdk8s-cdk8s-argocd-resources-k8s-secretreference)</code> | SecretRef references to the secret for ScaleIO user and other sensitive information.
**system**🔹 | <code>string</code> | The name of the storage system as configured in ScaleIO.
**fsType**?🔹 | <code>string</code> | Filesystem type to mount.<br/>__*Default*__: xfs"
**protectionDomain**?🔹 | <code>string</code> | The name of the ScaleIO Protection Domain for the configured storage.<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | Defaults to false (read/write).<br/>__*Default*__: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
**sslEnabled**?🔹 | <code>boolean</code> | Flag to enable/disable SSL communication with Gateway, default false.<br/>__*Optional*__
**storageMode**?🔹 | <code>string</code> | Indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned.<br/>__*Default*__: ThinProvisioned.
**storagePool**?🔹 | <code>string</code> | The ScaleIO Storage Pool associated with the protection domain.<br/>__*Optional*__
**volumeName**?🔹 | <code>string</code> | The name of a volume already created in the ScaleIO system that is associated with this volume source.<br/>__*Optional*__



## struct ScaleIoVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-scaleiovolumesource"></a>


ScaleIOVolumeSource represents a persistent ScaleIO volume.



Name | Type | Description 
-----|------|-------------
**gateway**🔹 | <code>string</code> | The host address of the ScaleIO API Gateway.
**secretRef**🔹 | <code>[k8s.LocalObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-localobjectreference)</code> | SecretRef references to the secret for ScaleIO user and other sensitive information.
**system**🔹 | <code>string</code> | The name of the storage system as configured in ScaleIO.
**fsType**?🔹 | <code>string</code> | Filesystem type to mount.<br/>__*Default*__: xfs".
**protectionDomain**?🔹 | <code>string</code> | The name of the ScaleIO Protection Domain for the configured storage.<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | Defaults to false (read/write).<br/>__*Default*__: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
**sslEnabled**?🔹 | <code>boolean</code> | Flag to enable/disable SSL communication with Gateway, default false.<br/>__*Optional*__
**storageMode**?🔹 | <code>string</code> | Indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned.<br/>__*Default*__: ThinProvisioned.
**storagePool**?🔹 | <code>string</code> | The ScaleIO Storage Pool associated with the protection domain.<br/>__*Optional*__
**volumeName**?🔹 | <code>string</code> | The name of a volume already created in the ScaleIO system that is associated with this volume source.<br/>__*Optional*__



## struct ScaleSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-scalespec"></a>


ScaleSpec describes the attributes of a scale subresource.



Name | Type | Description 
-----|------|-------------
**replicas**?🔹 | <code>number</code> | desired number of instances for the scaled object.<br/>__*Optional*__



## struct ScopeSelector 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-scopeselector"></a>


A scope selector represents the AND of the selectors represented by the scoped-resource selector requirements.



Name | Type | Description 
-----|------|-------------
**matchExpressions**?🔹 | <code>Array<[k8s.ScopedResourceSelectorRequirement](#opencdk8s-cdk8s-argocd-resources-k8s-scopedresourceselectorrequirement)></code> | A list of scope selector requirements by scope of the resources.<br/>__*Optional*__



## struct ScopedResourceSelectorRequirement 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-scopedresourceselectorrequirement"></a>


A scoped-resource selector requirement is a selector that contains values, a scope name, and an operator that relates the scope name and values.



Name | Type | Description 
-----|------|-------------
**operator**🔹 | <code>string</code> | Represents a scope's relationship to a set of values.
**scopeName**🔹 | <code>string</code> | The name of the scope that the selector applies to.
**values**?🔹 | <code>Array<string></code> | An array of string values.<br/>__*Optional*__



## struct SeLinuxOptions 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-selinuxoptions"></a>


SELinuxOptions are the labels to be applied to the container.



Name | Type | Description 
-----|------|-------------
**level**?🔹 | <code>string</code> | Level is SELinux level label that applies to the container.<br/>__*Optional*__
**role**?🔹 | <code>string</code> | Role is a SELinux role label that applies to the container.<br/>__*Optional*__
**type**?🔹 | <code>string</code> | Type is a SELinux type label that applies to the container.<br/>__*Optional*__
**user**?🔹 | <code>string</code> | User is a SELinux user label that applies to the container.<br/>__*Optional*__



## struct SeLinuxStrategyOptions 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-selinuxstrategyoptions"></a>


SELinuxStrategyOptions defines the strategy type and any options used to create the strategy.



Name | Type | Description 
-----|------|-------------
**rule**🔹 | <code>string</code> | rule is the strategy that will dictate the allowable labels that may be set.
**seLinuxOptions**?🔹 | <code>[k8s.SeLinuxOptions](#opencdk8s-cdk8s-argocd-resources-k8s-selinuxoptions)</code> | seLinuxOptions required to run as;<br/>__*Optional*__



## struct SecretEnvSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-secretenvsource"></a>


SecretEnvSource selects a Secret to populate the environment variables with.

The contents of the target Secret's Data field will represent the key-value pairs as environment variables.



Name | Type | Description 
-----|------|-------------
**name**?🔹 | <code>string</code> | Name of the referent.<br/>__*Optional*__
**optional**?🔹 | <code>boolean</code> | Specify whether the Secret must be defined.<br/>__*Optional*__



## struct SecretKeySelector 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-secretkeyselector"></a>


SecretKeySelector selects a key of a Secret.



Name | Type | Description 
-----|------|-------------
**key**🔹 | <code>string</code> | The key of the secret to select from.
**name**?🔹 | <code>string</code> | Name of the referent.<br/>__*Optional*__
**optional**?🔹 | <code>boolean</code> | Specify whether the Secret or its key must be defined.<br/>__*Optional*__



## struct SecretProjection 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-secretprojection"></a>


Adapts a secret into a projected volume.

The contents of the target Secret's Data field will be presented in a projected volume as files using the keys in the Data field as the file names. Note that this is identical to a secret volume source without the default mode.



Name | Type | Description 
-----|------|-------------
**items**?🔹 | <code>Array<[k8s.KeyToPath](#opencdk8s-cdk8s-argocd-resources-k8s-keytopath)></code> | If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value.<br/>__*Optional*__
**name**?🔹 | <code>string</code> | Name of the referent.<br/>__*Optional*__
**optional**?🔹 | <code>boolean</code> | Specify whether the Secret or its key must be defined.<br/>__*Optional*__



## struct SecretReference 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-secretreference"></a>


SecretReference represents a Secret Reference.

It has enough information to retrieve secret in any namespace



Name | Type | Description 
-----|------|-------------
**name**?🔹 | <code>string</code> | Name is unique within a namespace to reference a secret resource.<br/>__*Optional*__
**namespace**?🔹 | <code>string</code> | Namespace defines the space within which the secret name must be unique.<br/>__*Optional*__



## struct SecretVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-secretvolumesource"></a>


Adapts a Secret into a volume.

The contents of the target Secret's Data field will be presented in a volume as files using the keys in the Data field as the file names. Secret volumes support ownership management and SELinux relabeling.



Name | Type | Description 
-----|------|-------------
**defaultMode**?🔹 | <code>number</code> | Optional: mode bits to use on created files by default.<br/>__*Default*__: 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
**items**?🔹 | <code>Array<[k8s.KeyToPath](#opencdk8s-cdk8s-argocd-resources-k8s-keytopath)></code> | If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value.<br/>__*Optional*__
**optional**?🔹 | <code>boolean</code> | Specify whether the Secret or its keys must be defined.<br/>__*Optional*__
**secretName**?🔹 | <code>string</code> | Name of the secret in the pod's namespace to use.<br/>__*Optional*__



## struct SecurityContext 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-securitycontext"></a>


SecurityContext holds security configuration that will be applied to a container.

Some fields are present in both SecurityContext and PodSecurityContext.  When both are set, the values in SecurityContext take precedence.



Name | Type | Description 
-----|------|-------------
**allowPrivilegeEscalation**?🔹 | <code>boolean</code> | AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process.<br/>__*Optional*__
**capabilities**?🔹 | <code>[k8s.Capabilities](#opencdk8s-cdk8s-argocd-resources-k8s-capabilities)</code> | The capabilities to add/drop when running containers.<br/>__*Default*__: the default set of capabilities granted by the container runtime.
**privileged**?🔹 | <code>boolean</code> | Run container in privileged mode.<br/>__*Default*__: false.
**procMount**?🔹 | <code>string</code> | procMount denotes the type of proc mount to use for the containers.<br/>__*Optional*__
**readOnlyRootFilesystem**?🔹 | <code>boolean</code> | Whether this container has a read-only root filesystem.<br/>__*Default*__: false.
**runAsGroup**?🔹 | <code>number</code> | The GID to run the entrypoint of the container process.<br/>__*Optional*__
**runAsNonRoot**?🔹 | <code>boolean</code> | Indicates that the container must run as a non-root user.<br/>__*Optional*__
**runAsUser**?🔹 | <code>number</code> | The UID to run the entrypoint of the container process.<br/>__*Default*__: user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
**seLinuxOptions**?🔹 | <code>[k8s.SeLinuxOptions](#opencdk8s-cdk8s-argocd-resources-k8s-selinuxoptions)</code> | The SELinux context to be applied to the container.<br/>__*Optional*__
**windowsOptions**?🔹 | <code>[k8s.WindowsSecurityContextOptions](#opencdk8s-cdk8s-argocd-resources-k8s-windowssecuritycontextoptions)</code> | Windows security options.<br/>__*Optional*__



## struct SelfSubjectAccessReviewSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-selfsubjectaccessreviewspec"></a>


SelfSubjectAccessReviewSpec is a description of the access request.

Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set



Name | Type | Description 
-----|------|-------------
**nonResourceAttributes**?🔹 | <code>[k8s.NonResourceAttributes](#opencdk8s-cdk8s-argocd-resources-k8s-nonresourceattributes)</code> | NonResourceAttributes describes information for a non-resource access request.<br/>__*Optional*__
**resourceAttributes**?🔹 | <code>[k8s.ResourceAttributes](#opencdk8s-cdk8s-argocd-resources-k8s-resourceattributes)</code> | ResourceAuthorizationAttributes describes information for a resource access request.<br/>__*Optional*__



## struct SelfSubjectRulesReviewSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-selfsubjectrulesreviewspec"></a>






Name | Type | Description 
-----|------|-------------
**namespace**?🔹 | <code>string</code> | Namespace to evaluate rules for.<br/>__*Optional*__



## struct ServiceAccountTokenProjection 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-serviceaccounttokenprojection"></a>


ServiceAccountTokenProjection represents a projected service account token volume.

This projection can be used to insert a service account token into the pods runtime filesystem for use against APIs (Kubernetes API Server or otherwise).



Name | Type | Description 
-----|------|-------------
**path**🔹 | <code>string</code> | Path is the path relative to the mount point of the file to project the token into.
**audience**?🔹 | <code>string</code> | Audience is the intended audience of the token.<br/>__*Optional*__
**expirationSeconds**?🔹 | <code>number</code> | ExpirationSeconds is the requested duration of validity of the service account token.<br/>__*Default*__: 1 hour and must be at least 10 minutes.



## struct ServicePort 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-serviceport"></a>


ServicePort contains information on service's port.



Name | Type | Description 
-----|------|-------------
**port**🔹 | <code>number</code> | The port that will be exposed by this service.
**name**?🔹 | <code>string</code> | The name of this port within the service.<br/>__*Optional*__
**nodePort**?🔹 | <code>number</code> | The port on each node on which this service is exposed when type=NodePort or LoadBalancer.<br/>__*Default*__: to auto-allocate a port if the ServiceType of this Service requires one. More info: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
**protocol**?🔹 | <code>string</code> | The IP protocol for this port.<br/>__*Default*__: TCP.
**targetPort**?🔹 | <code>[k8s.IntOrString](#opencdk8s-cdk8s-argocd-resources-k8s-intorstring)</code> | Number or name of the port to access on the pods targeted by the service.<br/>__*Optional*__



## struct ServiceReference 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-servicereference"></a>


ServiceReference holds a reference to Service.legacy.k8s.io.



Name | Type | Description 
-----|------|-------------
**name**🔹 | <code>string</code> | `name` is the name of the service.
**namespace**🔹 | <code>string</code> | `namespace` is the namespace of the service.
**path**?🔹 | <code>string</code> | `path` is an optional URL path which will be sent in any request to this service.<br/>__*Optional*__
**port**?🔹 | <code>number</code> | If specified, the port on the service that hosting webhook.<br/>__*Default*__: 443 for backward compatibility. `port` should be a valid port number (1-65535, inclusive).



## struct ServiceSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-servicespec"></a>


ServiceSpec describes the attributes that a user creates on a service.



Name | Type | Description 
-----|------|-------------
**clusterIP**?🔹 | <code>string</code> | clusterIP is the IP address of the service and is usually assigned randomly by the master.<br/>__*Optional*__
**externalIPs**?🔹 | <code>Array<string></code> | externalIPs is a list of IP addresses for which nodes in the cluster will also accept traffic for this service.<br/>__*Optional*__
**externalName**?🔹 | <code>string</code> | externalName is the external reference that kubedns or equivalent will return as a CNAME record for this service.<br/>__*Optional*__
**externalTrafficPolicy**?🔹 | <code>string</code> | externalTrafficPolicy denotes if this Service desires to route external traffic to node-local or cluster-wide endpoints.<br/>__*Optional*__
**healthCheckNodePort**?🔹 | <code>number</code> | healthCheckNodePort specifies the healthcheck nodePort for the service.<br/>__*Optional*__
**loadBalancerIP**?🔹 | <code>string</code> | Only applies to Service Type: LoadBalancer LoadBalancer will get created with the IP specified in this field.<br/>__*Optional*__
**loadBalancerSourceRanges**?🔹 | <code>Array<string></code> | If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs.<br/>__*Optional*__
**ports**?🔹 | <code>Array<[k8s.ServicePort](#opencdk8s-cdk8s-argocd-resources-k8s-serviceport)></code> | The list of ports that are exposed by this service.<br/>__*Optional*__
**publishNotReadyAddresses**?🔹 | <code>boolean</code> | publishNotReadyAddresses, when set to true, indicates that DNS implementations must publish the notReadyAddresses of subsets for the Endpoints associated with the Service.<br/>__*Optional*__
**selector**?🔹 | <code>Map<string, string></code> | Route service traffic to pods with label keys and values matching this selector.<br/>__*Optional*__
**sessionAffinity**?🔹 | <code>string</code> | Supports "ClientIP" and "None".<br/>__*Default*__: None. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
**sessionAffinityConfig**?🔹 | <code>[k8s.SessionAffinityConfig](#opencdk8s-cdk8s-argocd-resources-k8s-sessionaffinityconfig)</code> | sessionAffinityConfig contains the configurations of session affinity.<br/>__*Optional*__
**type**?🔹 | <code>string</code> | type determines how the Service is exposed.<br/>__*Default*__: ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. "ExternalName" maps to the specified externalName. "ClusterIP" allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object. If clusterIP is "None", no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a stable IP. "NodePort" builds on ClusterIP and allocates a port on every node which routes to the clusterIP. "LoadBalancer" builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the clusterIP. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types



## struct SessionAffinityConfig 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-sessionaffinityconfig"></a>


SessionAffinityConfig represents the configurations of session affinity.



Name | Type | Description 
-----|------|-------------
**clientIP**?🔹 | <code>[k8s.ClientIpConfig](#opencdk8s-cdk8s-argocd-resources-k8s-clientipconfig)</code> | clientIP contains the configurations of Client IP based session affinity.<br/>__*Optional*__



## struct StatefulSetSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-statefulsetspec"></a>


A StatefulSetSpec is the specification of a StatefulSet.



Name | Type | Description 
-----|------|-------------
**selector**🔹 | <code>[k8s.LabelSelector](#opencdk8s-cdk8s-argocd-resources-k8s-labelselector)</code> | selector is a label query over pods that should match the replica count.
**serviceName**🔹 | <code>string</code> | serviceName is the name of the service that governs this StatefulSet.
**template**🔹 | <code>[k8s.PodTemplateSpec](#opencdk8s-cdk8s-argocd-resources-k8s-podtemplatespec)</code> | template is the object that describes the pod that will be created if insufficient replicas are detected.
**podManagementPolicy**?🔹 | <code>string</code> | podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down.<br/>__*Optional*__
**replicas**?🔹 | <code>number</code> | replicas is the desired number of replicas of the given Template.<br/>__*Optional*__
**revisionHistoryLimit**?🔹 | <code>number</code> | revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history.<br/>__*Optional*__
**updateStrategy**?🔹 | <code>[k8s.StatefulSetUpdateStrategy](#opencdk8s-cdk8s-argocd-resources-k8s-statefulsetupdatestrategy)</code> | updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.<br/>__*Optional*__
**volumeClaimTemplates**?🔹 | <code>Array<[k8s.KubePersistentVolumeClaimProps](#opencdk8s-cdk8s-argocd-resources-k8s-kubepersistentvolumeclaimprops)></code> | volumeClaimTemplates is a list of claims that pods are allowed to reference.<br/>__*Optional*__



## struct StatefulSetUpdateStrategy 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-statefulsetupdatestrategy"></a>


StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates.

It includes any additional parameters necessary to perform the update for the indicated strategy.



Name | Type | Description 
-----|------|-------------
**rollingUpdate**?🔹 | <code>[k8s.RollingUpdateStatefulSetStrategy](#opencdk8s-cdk8s-argocd-resources-k8s-rollingupdatestatefulsetstrategy)</code> | RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.<br/>__*Optional*__
**type**?🔹 | <code>string</code> | Type indicates the type of the StatefulSetUpdateStrategy.<br/>__*Default*__: RollingUpdate.



## struct StatusCause 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-statuscause"></a>


StatusCause provides more information about an api.Status failure, including cases when multiple errors are encountered.



Name | Type | Description 
-----|------|-------------
**field**?🔹 | <code>string</code> | The field of the resource that has caused this error, as named by its JSON serialization.<br/>__*Optional*__
**message**?🔹 | <code>string</code> | A human-readable description of the cause of the error.<br/>__*Optional*__
**reason**?🔹 | <code>string</code> | A machine-readable description of the cause of the error.<br/>__*Optional*__



## struct StatusDetails 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-statusdetails"></a>


StatusDetails is a set of additional properties that MAY be set by the server to provide additional information about a response.

The Reason field of a Status object defines what attributes will be set. Clients must ignore fields that do not match the defined type of each attribute, and should assume that any attribute may be empty, invalid, or under defined.



Name | Type | Description 
-----|------|-------------
**causes**?🔹 | <code>Array<[k8s.StatusCause](#opencdk8s-cdk8s-argocd-resources-k8s-statuscause)></code> | The Causes array includes more details associated with the StatusReason failure.<br/>__*Optional*__
**group**?🔹 | <code>string</code> | The group attribute of the resource associated with the status StatusReason.<br/>__*Optional*__
**kind**?🔹 | <code>string</code> | The kind attribute of the resource associated with the status StatusReason.<br/>__*Optional*__
**name**?🔹 | <code>string</code> | The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).<br/>__*Optional*__
**retryAfterSeconds**?🔹 | <code>number</code> | If specified, the time in seconds before the operation should be retried.<br/>__*Optional*__
**uid**?🔹 | <code>string</code> | UID of the resource.<br/>__*Optional*__



## struct StorageOsPersistentVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-storageospersistentvolumesource"></a>


Represents a StorageOS persistent volume resource.



Name | Type | Description 
-----|------|-------------
**fsType**?🔹 | <code>string</code> | Filesystem type to mount.<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | Defaults to false (read/write).<br/>__*Default*__: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
**secretRef**?🔹 | <code>[k8s.ObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-objectreference)</code> | SecretRef specifies the secret to use for obtaining the StorageOS API credentials.<br/>__*Optional*__
**volumeName**?🔹 | <code>string</code> | VolumeName is the human-readable name of the StorageOS volume.<br/>__*Optional*__
**volumeNamespace**?🔹 | <code>string</code> | VolumeNamespace specifies the scope of the volume within StorageOS.<br/>__*Optional*__



## struct StorageOsVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-storageosvolumesource"></a>


Represents a StorageOS persistent volume resource.



Name | Type | Description 
-----|------|-------------
**fsType**?🔹 | <code>string</code> | Filesystem type to mount.<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | Defaults to false (read/write).<br/>__*Default*__: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
**secretRef**?🔹 | <code>[k8s.LocalObjectReference](#opencdk8s-cdk8s-argocd-resources-k8s-localobjectreference)</code> | SecretRef specifies the secret to use for obtaining the StorageOS API credentials.<br/>__*Optional*__
**volumeName**?🔹 | <code>string</code> | VolumeName is the human-readable name of the StorageOS volume.<br/>__*Optional*__
**volumeNamespace**?🔹 | <code>string</code> | VolumeNamespace specifies the scope of the volume within StorageOS.<br/>__*Optional*__



## struct Subject 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-subject"></a>


Subject contains a reference to the object or user identities a role binding applies to.

This can either hold a direct API object reference, or a value for non-objects such as user and group names.



Name | Type | Description 
-----|------|-------------
**kind**🔹 | <code>string</code> | Kind of object being referenced.
**name**🔹 | <code>string</code> | Name of the object being referenced.
**apiGroup**?🔹 | <code>string</code> | APIGroup holds the API group of the referenced subject.<br/>__*Default*__: for ServiceAccount subjects. Defaults to "rbac.authorization.k8s.io" for User and Group subjects.
**namespace**?🔹 | <code>string</code> | Namespace of the referenced object.<br/>__*Optional*__



## struct SubjectAccessReviewSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-subjectaccessreviewspec"></a>


SubjectAccessReviewSpec is a description of the access request.

Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set



Name | Type | Description 
-----|------|-------------
**extra**?🔹 | <code>Map<string, Array<string>></code> | Extra corresponds to the user.Info.GetExtra() method from the authenticator.  Since that is input to the authorizer it needs a reflection here.<br/>__*Optional*__
**group**?🔹 | <code>Array<string></code> | Groups is the groups you're testing for.<br/>__*Optional*__
**nonResourceAttributes**?🔹 | <code>[k8s.NonResourceAttributes](#opencdk8s-cdk8s-argocd-resources-k8s-nonresourceattributes)</code> | NonResourceAttributes describes information for a non-resource access request.<br/>__*Optional*__
**resourceAttributes**?🔹 | <code>[k8s.ResourceAttributes](#opencdk8s-cdk8s-argocd-resources-k8s-resourceattributes)</code> | ResourceAuthorizationAttributes describes information for a resource access request.<br/>__*Optional*__
**uid**?🔹 | <code>string</code> | UID information about the requesting user.<br/>__*Optional*__
**user**?🔹 | <code>string</code> | User is the user you're testing for.<br/>__*Optional*__



## struct SupplementalGroupsStrategyOptions 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-supplementalgroupsstrategyoptions"></a>


SupplementalGroupsStrategyOptions defines the strategy type and options used to create the strategy.



Name | Type | Description 
-----|------|-------------
**ranges**?🔹 | <code>Array<[k8s.IdRange](#opencdk8s-cdk8s-argocd-resources-k8s-idrange)></code> | ranges are the allowed ranges of supplemental groups.<br/>__*Optional*__
**rule**?🔹 | <code>string</code> | rule is the strategy that will dictate what supplemental groups is used in the SecurityContext.<br/>__*Optional*__



## struct Sysctl 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-sysctl"></a>


Sysctl defines a kernel parameter to be set.



Name | Type | Description 
-----|------|-------------
**name**🔹 | <code>string</code> | Name of a property to set.
**value**🔹 | <code>string</code> | Value of a property to set.



## struct Taint 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-taint"></a>


The node this Taint is attached to has the "effect" on any pod that does not tolerate the Taint.



Name | Type | Description 
-----|------|-------------
**effect**🔹 | <code>string</code> | Required.
**key**🔹 | <code>string</code> | Required.
**timeAdded**?🔹 | <code>date</code> | TimeAdded represents the time at which the taint was added.<br/>__*Optional*__
**value**?🔹 | <code>string</code> | Required.<br/>__*Optional*__



## struct TcpSocketAction 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-tcpsocketaction"></a>


TCPSocketAction describes an action based on opening a socket.



Name | Type | Description 
-----|------|-------------
**port**🔹 | <code>[k8s.IntOrString](#opencdk8s-cdk8s-argocd-resources-k8s-intorstring)</code> | Number or name of the port to access on the container.
**host**?🔹 | <code>string</code> | Optional: Host name to connect to, defaults to the pod IP.<br/>__*Optional*__



## struct TokenReviewSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-tokenreviewspec"></a>


TokenReviewSpec is a description of the token authentication request.



Name | Type | Description 
-----|------|-------------
**audiences**?🔹 | <code>Array<string></code> | Audiences is a list of the identifiers that the resource server presented with the token identifies as.<br/>__*Optional*__
**token**?🔹 | <code>string</code> | Token is the opaque bearer token.<br/>__*Optional*__



## struct Toleration 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-toleration"></a>


The pod this Toleration is attached to tolerates any taint that matches the triple <key,value,effect> using the matching operator <operator>.



Name | Type | Description 
-----|------|-------------
**effect**?🔹 | <code>string</code> | Effect indicates the taint effect to match.<br/>__*Optional*__
**key**?🔹 | <code>string</code> | Key is the taint key that the toleration applies to.<br/>__*Optional*__
**operator**?🔹 | <code>string</code> | Operator represents a key's relationship to the value.<br/>__*Default*__: Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.
**tolerationSeconds**?🔹 | <code>number</code> | TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint.<br/>__*Optional*__
**value**?🔹 | <code>string</code> | Value is the taint value the toleration matches to.<br/>__*Optional*__



## struct TopologySelectorLabelRequirement 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-topologyselectorlabelrequirement"></a>


A topology selector requirement is a selector that matches given label.

This is an alpha feature and may change in the future.



Name | Type | Description 
-----|------|-------------
**key**🔹 | <code>string</code> | The label key that the selector applies to.
**values**🔹 | <code>Array<string></code> | An array of string values.



## struct TopologySelectorTerm 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-topologyselectorterm"></a>


A topology selector term represents the result of label queries.

A null or empty topology selector term matches no objects. The requirements of them are ANDed. It provides a subset of functionality as NodeSelectorTerm. This is an alpha feature and may change in the future.



Name | Type | Description 
-----|------|-------------
**matchLabelExpressions**?🔹 | <code>Array<[k8s.TopologySelectorLabelRequirement](#opencdk8s-cdk8s-argocd-resources-k8s-topologyselectorlabelrequirement)></code> | A list of topology selector requirements by labels.<br/>__*Optional*__



## struct TypedLocalObjectReference 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-typedlocalobjectreference"></a>


TypedLocalObjectReference contains enough information to let you locate the typed referenced object inside the same namespace.



Name | Type | Description 
-----|------|-------------
**kind**🔹 | <code>string</code> | Kind is the type of resource being referenced.
**name**🔹 | <code>string</code> | Name is the name of resource being referenced.
**apiGroup**?🔹 | <code>string</code> | APIGroup is the group for the resource being referenced.<br/>__*Optional*__



## struct ValidatingWebhook 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-validatingwebhook"></a>


ValidatingWebhook describes an admission webhook and the resources and operations it applies to.



Name | Type | Description 
-----|------|-------------
**clientConfig**🔹 | <code>[k8s.WebhookClientConfig](#opencdk8s-cdk8s-argocd-resources-k8s-webhookclientconfig)</code> | ClientConfig defines how to communicate with the hook.
**name**🔹 | <code>string</code> | The name of the admission webhook.
**admissionReviewVersions**?🔹 | <code>Array<string></code> | AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects.<br/>__*Default*__: v1beta1']`.
**failurePolicy**?🔹 | <code>string</code> | FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail.<br/>__*Default*__: Ignore.
**matchPolicy**?🔹 | <code>string</code> | matchPolicy defines how the "rules" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".<br/>__*Default*__: Exact"
**namespaceSelector**?🔹 | <code>[k8s.LabelSelector](#opencdk8s-cdk8s-argocd-resources-k8s-labelselector)</code> | NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector.<br/>__*Default*__: the empty LabelSelector, which matches everything.
**objectSelector**?🔹 | <code>[k8s.LabelSelector](#opencdk8s-cdk8s-argocd-resources-k8s-labelselector)</code> | ObjectSelector decides whether to run the webhook based on if the object has matching labels.<br/>__*Default*__: the empty LabelSelector, which matches everything.
**rules**?🔹 | <code>Array<[k8s.RuleWithOperations](#opencdk8s-cdk8s-argocd-resources-k8s-rulewithoperations)></code> | Rules describes what operations on what resources/subresources the webhook cares about.<br/>__*Optional*__
**sideEffects**?🔹 | <code>string</code> | SideEffects states whether this webhookk has side effects.<br/>__*Default*__: Unknown.
**timeoutSeconds**?🔹 | <code>number</code> | TimeoutSeconds specifies the timeout for this webhook.<br/>__*Default*__: 30 seconds.



## struct Volume 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-volume"></a>


Volume represents a named volume in a pod that may be accessed by any container in the pod.



Name | Type | Description 
-----|------|-------------
**name**🔹 | <code>string</code> | Volume's name.
**awsElasticBlockStore**?🔹 | <code>[k8s.AwsElasticBlockStoreVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-awselasticblockstorevolumesource)</code> | AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod.<br/>__*Optional*__
**azureDisk**?🔹 | <code>[k8s.AzureDiskVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-azurediskvolumesource)</code> | AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.<br/>__*Optional*__
**azureFile**?🔹 | <code>[k8s.AzureFileVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-azurefilevolumesource)</code> | AzureFile represents an Azure File Service mount on the host and bind mount to the pod.<br/>__*Optional*__
**cephfs**?🔹 | <code>[k8s.CephFsVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-cephfsvolumesource)</code> | CephFS represents a Ceph FS mount on the host that shares a pod's lifetime.<br/>__*Optional*__
**cinder**?🔹 | <code>[k8s.CinderVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-cindervolumesource)</code> | Cinder represents a cinder volume attached and mounted on kubelets host machine More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md.<br/>__*Optional*__
**configMap**?🔹 | <code>[k8s.ConfigMapVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-configmapvolumesource)</code> | ConfigMap represents a configMap that should populate this volume.<br/>__*Optional*__
**csi**?🔹 | <code>[k8s.CsiVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-csivolumesource)</code> | CSI (Container Storage Interface) represents storage that is handled by an external CSI driver (Alpha feature).<br/>__*Optional*__
**downwardAPI**?🔹 | <code>[k8s.DownwardApiVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-downwardapivolumesource)</code> | DownwardAPI represents downward API about the pod that should populate this volume.<br/>__*Optional*__
**emptyDir**?🔹 | <code>[k8s.EmptyDirVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-emptydirvolumesource)</code> | EmptyDir represents a temporary directory that shares a pod's lifetime.<br/>__*Optional*__
**fc**?🔹 | <code>[k8s.FcVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-fcvolumesource)</code> | FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.<br/>__*Optional*__
**flexVolume**?🔹 | <code>[k8s.FlexVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-flexvolumesource)</code> | FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.<br/>__*Optional*__
**flocker**?🔹 | <code>[k8s.FlockerVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-flockervolumesource)</code> | Flocker represents a Flocker volume attached to a kubelet's host machine.<br/>__*Optional*__
**gcePersistentDisk**?🔹 | <code>[k8s.GcePersistentDiskVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-gcepersistentdiskvolumesource)</code> | GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod.<br/>__*Optional*__
**gitRepo**?🔹 | <code>[k8s.GitRepoVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-gitrepovolumesource)</code> | GitRepo represents a git repository at a particular revision.<br/>__*Optional*__
**glusterfs**?🔹 | <code>[k8s.GlusterfsVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-glusterfsvolumesource)</code> | Glusterfs represents a Glusterfs mount on the host that shares a pod's lifetime.<br/>__*Optional*__
**hostPath**?🔹 | <code>[k8s.HostPathVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-hostpathvolumesource)</code> | HostPath represents a pre-existing file or directory on the host machine that is directly exposed to the container.<br/>__*Optional*__
**iscsi**?🔹 | <code>[k8s.IscsiVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-iscsivolumesource)</code> | ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod.<br/>__*Optional*__
**nfs**?🔹 | <code>[k8s.NfsVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-nfsvolumesource)</code> | NFS represents an NFS mount on the host that shares a pod's lifetime More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs.<br/>__*Optional*__
**persistentVolumeClaim**?🔹 | <code>[k8s.PersistentVolumeClaimVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-persistentvolumeclaimvolumesource)</code> | PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace.<br/>__*Optional*__
**photonPersistentDisk**?🔹 | <code>[k8s.PhotonPersistentDiskVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-photonpersistentdiskvolumesource)</code> | PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine.<br/>__*Optional*__
**portworxVolume**?🔹 | <code>[k8s.PortworxVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-portworxvolumesource)</code> | PortworxVolume represents a portworx volume attached and mounted on kubelets host machine.<br/>__*Optional*__
**projected**?🔹 | <code>[k8s.ProjectedVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-projectedvolumesource)</code> | Items for all in one resources secrets, configmaps, and downward API.<br/>__*Optional*__
**quobyte**?🔹 | <code>[k8s.QuobyteVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-quobytevolumesource)</code> | Quobyte represents a Quobyte mount on the host that shares a pod's lifetime.<br/>__*Optional*__
**rbd**?🔹 | <code>[k8s.RbdVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-rbdvolumesource)</code> | RBD represents a Rados Block Device mount on the host that shares a pod's lifetime.<br/>__*Optional*__
**scaleIO**?🔹 | <code>[k8s.ScaleIoVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-scaleiovolumesource)</code> | ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.<br/>__*Optional*__
**secret**?🔹 | <code>[k8s.SecretVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-secretvolumesource)</code> | Secret represents a secret that should populate this volume.<br/>__*Optional*__
**storageos**?🔹 | <code>[k8s.StorageOsVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-storageosvolumesource)</code> | StorageOS represents a StorageOS volume attached and mounted on Kubernetes nodes.<br/>__*Optional*__
**vsphereVolume**?🔹 | <code>[k8s.VsphereVirtualDiskVolumeSource](#opencdk8s-cdk8s-argocd-resources-k8s-vspherevirtualdiskvolumesource)</code> | VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine.<br/>__*Optional*__



## struct VolumeAttachmentSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-volumeattachmentsource"></a>


VolumeAttachmentSource represents a volume that should be attached.

Right now only PersistenVolumes can be attached via external attacher, in future we may allow also inline volumes in pods. Exactly one member can be set.



Name | Type | Description 
-----|------|-------------
**inlineVolumeSpec**?🔹 | <code>[k8s.PersistentVolumeSpec](#opencdk8s-cdk8s-argocd-resources-k8s-persistentvolumespec)</code> | inlineVolumeSpec contains all the information necessary to attach a persistent volume defined by a pod's inline VolumeSource.<br/>__*Optional*__
**persistentVolumeName**?🔹 | <code>string</code> | Name of the persistent volume to attach.<br/>__*Optional*__



## struct VolumeAttachmentSpec 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-volumeattachmentspec"></a>


VolumeAttachmentSpec is the specification of a VolumeAttachment request.



Name | Type | Description 
-----|------|-------------
**attacher**🔹 | <code>string</code> | Attacher indicates the name of the volume driver that MUST handle this request.
**nodeName**🔹 | <code>string</code> | The node that the volume should be attached to.
**source**🔹 | <code>[k8s.VolumeAttachmentSource](#opencdk8s-cdk8s-argocd-resources-k8s-volumeattachmentsource)</code> | Source represents the volume that should be attached.



## struct VolumeDevice 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-volumedevice"></a>


volumeDevice describes a mapping of a raw block device within a container.



Name | Type | Description 
-----|------|-------------
**devicePath**🔹 | <code>string</code> | devicePath is the path inside of the container that the device will be mapped to.
**name**🔹 | <code>string</code> | name must match the name of a persistentVolumeClaim in the pod.



## struct VolumeMount 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-volumemount"></a>


VolumeMount describes a mounting of a Volume within a container.



Name | Type | Description 
-----|------|-------------
**mountPath**🔹 | <code>string</code> | Path within the container at which the volume should be mounted.
**name**🔹 | <code>string</code> | This must match the Name of a Volume.
**mountPropagation**?🔹 | <code>string</code> | mountPropagation determines how mounts are propagated from the host to container and the other way around.<br/>__*Optional*__
**readOnly**?🔹 | <code>boolean</code> | Mounted read-only if true, read-write otherwise (false or unspecified).<br/>__*Default*__: false.
**subPath**?🔹 | <code>string</code> | Path within the volume from which the container's volume should be mounted.<br/>__*Default*__: volume's root).
**subPathExpr**?🔹 | <code>string</code> | Expanded path within the volume from which the container's volume should be mounted.<br/>__*Default*__: volume's root). SubPathExpr and SubPath are mutually exclusive. This field is beta in 1.15.



## struct VolumeNodeAffinity 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-volumenodeaffinity"></a>


VolumeNodeAffinity defines constraints that limit what nodes this volume can be accessed from.



Name | Type | Description 
-----|------|-------------
**required**?🔹 | <code>[k8s.NodeSelector](#opencdk8s-cdk8s-argocd-resources-k8s-nodeselector)</code> | Required specifies hard node constraints that must be met.<br/>__*Optional*__



## struct VolumeProjection 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-volumeprojection"></a>


Projection that may be projected along with other supported volume types.



Name | Type | Description 
-----|------|-------------
**configMap**?🔹 | <code>[k8s.ConfigMapProjection](#opencdk8s-cdk8s-argocd-resources-k8s-configmapprojection)</code> | information about the configMap data to project.<br/>__*Optional*__
**downwardAPI**?🔹 | <code>[k8s.DownwardApiProjection](#opencdk8s-cdk8s-argocd-resources-k8s-downwardapiprojection)</code> | information about the downwardAPI data to project.<br/>__*Optional*__
**secret**?🔹 | <code>[k8s.SecretProjection](#opencdk8s-cdk8s-argocd-resources-k8s-secretprojection)</code> | information about the secret data to project.<br/>__*Optional*__
**serviceAccountToken**?🔹 | <code>[k8s.ServiceAccountTokenProjection](#opencdk8s-cdk8s-argocd-resources-k8s-serviceaccounttokenprojection)</code> | information about the serviceAccountToken data to project.<br/>__*Optional*__



## struct VsphereVirtualDiskVolumeSource 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-vspherevirtualdiskvolumesource"></a>


Represents a vSphere volume resource.



Name | Type | Description 
-----|------|-------------
**volumePath**🔹 | <code>string</code> | Path that identifies vSphere volume vmdk.
**fsType**?🔹 | <code>string</code> | Filesystem type to mount.<br/>__*Optional*__
**storagePolicyID**?🔹 | <code>string</code> | Storage Policy Based Management (SPBM) profile ID associated with the StoragePolicyName.<br/>__*Optional*__
**storagePolicyName**?🔹 | <code>string</code> | Storage Policy Based Management (SPBM) profile name.<br/>__*Optional*__



## struct Webhook 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-webhook"></a>


Webhook holds the configuration of the webhook.



Name | Type | Description 
-----|------|-------------
**clientConfig**🔹 | <code>[k8s.WebhookClientConfig](#opencdk8s-cdk8s-argocd-resources-k8s-webhookclientconfig)</code> | ClientConfig holds the connection parameters for the webhook required.
**throttle**?🔹 | <code>[k8s.WebhookThrottleConfig](#opencdk8s-cdk8s-argocd-resources-k8s-webhookthrottleconfig)</code> | Throttle holds the options for throttling the webhook.<br/>__*Optional*__



## struct WebhookClientConfig 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-webhookclientconfig"></a>


WebhookClientConfig contains the information to make a TLS connection with the webhook.



Name | Type | Description 
-----|------|-------------
**caBundle**?🔹 | <code>string</code> | `caBundle` is a PEM encoded CA bundle which will be used to validate the webhook's server certificate.<br/>__*Optional*__
**service**?🔹 | <code>[k8s.ServiceReference](#opencdk8s-cdk8s-argocd-resources-k8s-servicereference)</code> | `service` is a reference to the service for this webhook. Either `service` or `url` must be specified.<br/>__*Optional*__
**url**?🔹 | <code>string</code> | `url` gives the location of the webhook, in standard URL form (`scheme://host:port/path`).<br/>__*Optional*__



## struct WebhookThrottleConfig 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-webhookthrottleconfig"></a>


WebhookThrottleConfig holds the configuration for throttling events.



Name | Type | Description 
-----|------|-------------
**burst**?🔹 | <code>number</code> | ThrottleBurst is the maximum number of events sent at the same moment default 15 QPS.<br/>__*Optional*__
**qps**?🔹 | <code>number</code> | ThrottleQPS maximum number of batches per second default 10 QPS.<br/>__*Optional*__



## struct WeightedPodAffinityTerm 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-weightedpodaffinityterm"></a>


The weights of all of the matched WeightedPodAffinityTerm fields are added per-node to find the most preferred node(s).



Name | Type | Description 
-----|------|-------------
**podAffinityTerm**🔹 | <code>[k8s.PodAffinityTerm](#opencdk8s-cdk8s-argocd-resources-k8s-podaffinityterm)</code> | Required.
**weight**🔹 | <code>number</code> | weight associated with matching the corresponding podAffinityTerm, in the range 1-100.



## struct WindowsSecurityContextOptions 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-windowssecuritycontextoptions"></a>


WindowsSecurityContextOptions contain Windows-specific options and credentials.



Name | Type | Description 
-----|------|-------------
**gmsaCredentialSpec**?🔹 | <code>string</code> | GMSACredentialSpec is where the GMSA admission webhook (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the GMSA credential spec named by the GMSACredentialSpecName field. This field is alpha-level and is only honored by servers that enable the WindowsGMSA feature flag.<br/>__*Optional*__
**gmsaCredentialSpecName**?🔹 | <code>string</code> | GMSACredentialSpecName is the name of the GMSA credential spec to use.<br/>__*Optional*__



## enum IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind 🔹 <a id="opencdk8s-cdk8s-argocd-resources-k8s-iok8sapimachinerypkgapismetav1deleteoptionskind"></a>

Kind is a string value representing the REST resource this object represents.

Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

Name | Description
-----|-----
**DELETE_OPTIONS** 🔹|DeleteOptions.


