# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetServiceComponentResult',
    'AwaitableGetServiceComponentResult',
    'get_service_component',
]

@pulumi.output_type
class GetServiceComponentResult:
    """
    A collection of values returned by getServiceComponent.
    """
    def __init__(__self__, component=None, host=None, id=None, kafka_authentication_method=None, port=None, project=None, route=None, service_name=None, ssl=None, usage=None):
        if component and not isinstance(component, str):
            raise TypeError("Expected argument 'component' to be a str")
        pulumi.set(__self__, "component", component)
        if host and not isinstance(host, str):
            raise TypeError("Expected argument 'host' to be a str")
        pulumi.set(__self__, "host", host)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kafka_authentication_method and not isinstance(kafka_authentication_method, str):
            raise TypeError("Expected argument 'kafka_authentication_method' to be a str")
        pulumi.set(__self__, "kafka_authentication_method", kafka_authentication_method)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if route and not isinstance(route, str):
            raise TypeError("Expected argument 'route' to be a str")
        pulumi.set(__self__, "route", route)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if ssl and not isinstance(ssl, bool):
            raise TypeError("Expected argument 'ssl' to be a bool")
        pulumi.set(__self__, "ssl", ssl)
        if usage and not isinstance(usage, str):
            raise TypeError("Expected argument 'usage' to be a str")
        pulumi.set(__self__, "usage", usage)

    @property
    @pulumi.getter
    def component(self) -> str:
        return pulumi.get(self, "component")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        is DNS name for connecting to the service component.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kafkaAuthenticationMethod")
    def kafka_authentication_method(self) -> Optional[str]:
        return pulumi.get(self, "kafka_authentication_method")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        is port number for connecting to the service component.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def route(self) -> Optional[str]:
        return pulumi.get(self, "route")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[str]:
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def ssl(self) -> Optional[bool]:
        """
        whether the endpoint is encrypted or accepts plaintext. By default endpoints are
        always encrypted and this property is only included for service components they may
        disable encryption. If not set by the user only entries with empty `ssl` or `ssl` set
        to true will be selected.
        """
        return pulumi.get(self, "ssl")

    @property
    @pulumi.getter
    def usage(self) -> Optional[str]:
        """
        is DNS usage name, and can be one of `primary`, `replica` or `syncing`. `replica` 
        is used by services that have separate master and standby roles for which it identifies
        the `replica` DNS name. `syncing` is used by limited set of services to expose nodes
        before they have finished restoring state but may already be partially available, for
        example a PostgreSQL node that is streaming WAL segments from backup or current master
        but hasn't yet fully caught up.
        """
        return pulumi.get(self, "usage")


class AwaitableGetServiceComponentResult(GetServiceComponentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceComponentResult(
            component=self.component,
            host=self.host,
            id=self.id,
            kafka_authentication_method=self.kafka_authentication_method,
            port=self.port,
            project=self.project,
            route=self.route,
            service_name=self.service_name,
            ssl=self.ssl,
            usage=self.usage)


def get_service_component(component: Optional[str] = None,
                          kafka_authentication_method: Optional[str] = None,
                          project: Optional[str] = None,
                          route: Optional[str] = None,
                          service_name: Optional[str] = None,
                          ssl: Optional[bool] = None,
                          usage: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceComponentResult:
    """
    ## # Service Component Data Source

    The Service Component data source provides information about the existing Aiven service Component.

    Service components can be defined to get the connection info for specific service.
    Services may support multiple different access routes (VPC peering and public access),
    have additional components or support various authentication methods. Each of these
    may be represented by different DNS name or TCP port and the specific component to
    match can be selected by specifying appropriate filters as shown below.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    sc1 = aiven.get_service_component(project=aiven_kafka["project1"]["project"],
        service_name=aiven_kafka["service1"]["service_name"],
        component="kafka",
        route="dynamic",
        kafka_authentication_method="certificate")
    ```


    :param str component: is a service component name. Component may match the name of the service 
           (`cassandra`, `elasticsearch`, `grafana`, `influxdb`, `kafka`, `kafka_connect`, `mysql`,
           `pg` and `redis`), in which case the connection info of the service itself is returned.
           Some service types support additional service specific components like `kibana` for
           Elasticsearch, `kafka_connect`, `kafka_rest` and `schema_registry` for Kafka, and
           `pgbouncer` for PostgreSQL. Most service types also support `prometheus`.
    :param str kafka_authentication_method: is Kafka authentication method. This is a value specific 
           to the 'kafka' service components. And has the following available options: `certificate`
           and `sasl`. If not set by the user only entries with empty `kafka_authentication_method`
           will be selected.
    :param str project: and `service_name` - (Required) define the project and service the service component
           belongs to.
    :param str route: is network access route. The route may be one of `dynamic`, `public`, and `private`. 
           Usually, you'll want to use `dynamic`, which for services that are not in a private network
           identifies the regular public DNS name of the service and for services in a private network
           the private DNS name. If the service is in a private network but has also public access
           enabled the `public` route type can be used to get the public DNS name of the service. The
           `private` option should typically not be used.
    :param bool ssl: whether the endpoint is encrypted or accepts plaintext. By default endpoints are
           always encrypted and this property is only included for service components they may
           disable encryption. If not set by the user only entries with empty `ssl` or `ssl` set
           to true will be selected.
    :param str usage: is DNS usage name, and can be one of `primary`, `replica` or `syncing`. `replica` 
           is used by services that have separate master and standby roles for which it identifies
           the `replica` DNS name. `syncing` is used by limited set of services to expose nodes
           before they have finished restoring state but may already be partially available, for
           example a PostgreSQL node that is streaming WAL segments from backup or current master
           but hasn't yet fully caught up.
    """
    __args__ = dict()
    __args__['component'] = component
    __args__['kafkaAuthenticationMethod'] = kafka_authentication_method
    __args__['project'] = project
    __args__['route'] = route
    __args__['serviceName'] = service_name
    __args__['ssl'] = ssl
    __args__['usage'] = usage
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aiven:index/getServiceComponent:getServiceComponent', __args__, opts=opts, typ=GetServiceComponentResult).value

    return AwaitableGetServiceComponentResult(
        component=__ret__.component,
        host=__ret__.host,
        id=__ret__.id,
        kafka_authentication_method=__ret__.kafka_authentication_method,
        port=__ret__.port,
        project=__ret__.project,
        route=__ret__.route,
        service_name=__ret__.service_name,
        ssl=__ret__.ssl,
        usage=__ret__.usage)
