# Useful Tips

## Resource estimation

The BOPs generated by this framework can be use as a good estimator for the on-chip resource consumption, when the following conditions are met:

- `latency` strategy is used.
- `reuse_factor` is set to 1.
- `parallel_factor` is set to match the number of convolution kernel application count (Everything done in parallel).

If `io_parallel` is used, resource consumption in terms of LUTs, can be estimated by: $$\#\mathrm{LUTs}\sim\#\mathrm{BOPs}$$

If `io_stream` is used, you will need to add resources used for FIFOs, which cannot be directly estimated from BOPs, and depends on the specific implementation (i.e. ShiftRegister vs. BRAM).

## Regarding `#pragma HLS DATAFLOW`

If you are using `io_parallel` AND met the above conditions AND and has a colvolution layer in your network, you may get a much larger resource consumption than expected together with terrible latency. In this case, please try changing the `#pragma HLS DATAFLOW` to `#pragma HLS PIPELINE` or simply removing it and re-synthesize the code.

## Regarding `#pragma HLS INLINE RECURSIVE`

If you are using `io_parallel` with `latency` strategy, you may try adding `#pragma HLS INLINE RECURSIVE` to your top function. This **may** reduce the resource consumption for some networks. In many cases, resource consumption can be reduced by $\sim10$%, and latency may or may not be improved.

## When use intra-layer heterogeneous quantization

If using `latency` strategy, it is **recommended** to use intra-layer heterogeneous weight quantization.

For intra-later heterogeneous activation quantization, if you are using `io_parallel` with `latency` strategy, one **may** enable it. For some networks, this may lead to a huge overfitting, and the resource reduction is not as significant as the weight counterpart.

## When using only inter-layer heterogeneous quantization

It is **recommended** one should use inter-layer heterogeneous quantization **if and only if** the model is planned to be deployed with the `resource` strategy in `hls4ml`. This is equivalent to optimizing bitwidths with approximated gradient, and the obtained resource may be better or worse than the `AutoQKeras` counterpart.

When doing this, it is **strongly recommended** to use only `L1` and/or `L2` regulation on weights and activations (i.e., set `beta=0`), as the training time BOPs estimated is **not accurate at all and not relevant**.
