# jgreenepack
The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ``` 

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.42
- Package version: 1.10.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import jgreenepack 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import jgreenepack
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import jgreenepack
from jgreenepack.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = jgreenepack.ConfigApi(jgreenepack.ApiClient(configuration))
body = NULL # object |  (optional)

try:
    # Create a config
    api_response = api_instance.config_create(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ConfigApi->config_create: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/v1.42*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ConfigApi* | [**config_create**](docs/ConfigApi.md#config_create) | **POST** /configs/create | Create a config
*ConfigApi* | [**config_delete**](docs/ConfigApi.md#config_delete) | **DELETE** /configs/{id} | Delete a config
*ConfigApi* | [**config_inspect**](docs/ConfigApi.md#config_inspect) | **GET** /configs/{id} | Inspect a config
*ConfigApi* | [**config_list**](docs/ConfigApi.md#config_list) | **GET** /configs | List configs
*ConfigApi* | [**config_update**](docs/ConfigApi.md#config_update) | **POST** /configs/{id}/update | Update a Config
*ContainerApi* | [**container_archive**](docs/ContainerApi.md#container_archive) | **GET** /containers/{id}/archive | Get an archive of a filesystem resource in a container
*ContainerApi* | [**container_archive_info**](docs/ContainerApi.md#container_archive_info) | **HEAD** /containers/{id}/archive | Get information about files in a container
*ContainerApi* | [**container_attach**](docs/ContainerApi.md#container_attach) | **POST** /containers/{id}/attach | Attach to a container
*ContainerApi* | [**container_attach_websocket**](docs/ContainerApi.md#container_attach_websocket) | **GET** /containers/{id}/attach/ws | Attach to a container via a websocket
*ContainerApi* | [**container_changes**](docs/ContainerApi.md#container_changes) | **GET** /containers/{id}/changes | Get changes on a container’s filesystem
*ContainerApi* | [**container_create**](docs/ContainerApi.md#container_create) | **POST** /containers/create | Create a container
*ContainerApi* | [**container_delete**](docs/ContainerApi.md#container_delete) | **DELETE** /containers/{id} | Remove a container
*ContainerApi* | [**container_export**](docs/ContainerApi.md#container_export) | **GET** /containers/{id}/export | Export a container
*ContainerApi* | [**container_inspect**](docs/ContainerApi.md#container_inspect) | **GET** /containers/{id}/json | Inspect a container
*ContainerApi* | [**container_kill**](docs/ContainerApi.md#container_kill) | **POST** /containers/{id}/kill | Kill a container
*ContainerApi* | [**container_list**](docs/ContainerApi.md#container_list) | **GET** /containers/json | List containers
*ContainerApi* | [**container_logs**](docs/ContainerApi.md#container_logs) | **GET** /containers/{id}/logs | Get container logs
*ContainerApi* | [**container_pause**](docs/ContainerApi.md#container_pause) | **POST** /containers/{id}/pause | Pause a container
*ContainerApi* | [**container_prune**](docs/ContainerApi.md#container_prune) | **POST** /containers/prune | Delete stopped containers
*ContainerApi* | [**container_rename**](docs/ContainerApi.md#container_rename) | **POST** /containers/{id}/rename | Rename a container
*ContainerApi* | [**container_resize**](docs/ContainerApi.md#container_resize) | **POST** /containers/{id}/resize | Resize a container TTY
*ContainerApi* | [**container_restart**](docs/ContainerApi.md#container_restart) | **POST** /containers/{id}/restart | Restart a container
*ContainerApi* | [**container_start**](docs/ContainerApi.md#container_start) | **POST** /containers/{id}/start | Start a container
*ContainerApi* | [**container_stats**](docs/ContainerApi.md#container_stats) | **GET** /containers/{id}/stats | Get container stats based on resource usage
*ContainerApi* | [**container_stop**](docs/ContainerApi.md#container_stop) | **POST** /containers/{id}/stop | Stop a container
*ContainerApi* | [**container_top**](docs/ContainerApi.md#container_top) | **GET** /containers/{id}/top | List processes running inside a container
*ContainerApi* | [**container_unpause**](docs/ContainerApi.md#container_unpause) | **POST** /containers/{id}/unpause | Unpause a container
*ContainerApi* | [**container_update**](docs/ContainerApi.md#container_update) | **POST** /containers/{id}/update | Update a container
*ContainerApi* | [**container_wait**](docs/ContainerApi.md#container_wait) | **POST** /containers/{id}/wait | Wait for a container
*ContainerApi* | [**put_container_archive**](docs/ContainerApi.md#put_container_archive) | **PUT** /containers/{id}/archive | Extract an archive of files or folders to a directory in a container
*DistributionApi* | [**distribution_inspect**](docs/DistributionApi.md#distribution_inspect) | **GET** /distribution/{name}/json | Get image information from the registry
*ExecApi* | [**container_exec**](docs/ExecApi.md#container_exec) | **POST** /containers/{id}/exec | Create an exec instance
*ExecApi* | [**exec_inspect**](docs/ExecApi.md#exec_inspect) | **GET** /exec/{id}/json | Inspect an exec instance
*ExecApi* | [**exec_resize**](docs/ExecApi.md#exec_resize) | **POST** /exec/{id}/resize | Resize an exec instance
*ExecApi* | [**exec_start**](docs/ExecApi.md#exec_start) | **POST** /exec/{id}/start | Start an exec instance
*ImageApi* | [**build_prune**](docs/ImageApi.md#build_prune) | **POST** /build/prune | Delete builder cache
*ImageApi* | [**image_build**](docs/ImageApi.md#image_build) | **POST** /build | Build an image
*ImageApi* | [**image_commit**](docs/ImageApi.md#image_commit) | **POST** /commit | Create a new image from a container
*ImageApi* | [**image_create**](docs/ImageApi.md#image_create) | **POST** /images/create | Create an image
*ImageApi* | [**image_delete**](docs/ImageApi.md#image_delete) | **DELETE** /images/{name} | Remove an image
*ImageApi* | [**image_get**](docs/ImageApi.md#image_get) | **GET** /images/{name}/get | Export an image
*ImageApi* | [**image_get_all**](docs/ImageApi.md#image_get_all) | **GET** /images/get | Export several images
*ImageApi* | [**image_history**](docs/ImageApi.md#image_history) | **GET** /images/{name}/history | Get the history of an image
*ImageApi* | [**image_inspect**](docs/ImageApi.md#image_inspect) | **GET** /images/{name}/json | Inspect an image
*ImageApi* | [**image_list**](docs/ImageApi.md#image_list) | **GET** /images/json | List Images
*ImageApi* | [**image_load**](docs/ImageApi.md#image_load) | **POST** /images/load | Import images
*ImageApi* | [**image_prune**](docs/ImageApi.md#image_prune) | **POST** /images/prune | Delete unused images
*ImageApi* | [**image_push**](docs/ImageApi.md#image_push) | **POST** /images/{name}/push | Push an image
*ImageApi* | [**image_search**](docs/ImageApi.md#image_search) | **GET** /images/search | Search images
*ImageApi* | [**image_tag**](docs/ImageApi.md#image_tag) | **POST** /images/{name}/tag | Tag an image
*NetworkApi* | [**network_connect**](docs/NetworkApi.md#network_connect) | **POST** /networks/{id}/connect | Connect a container to a network
*NetworkApi* | [**network_create**](docs/NetworkApi.md#network_create) | **POST** /networks/create | Create a network
*NetworkApi* | [**network_delete**](docs/NetworkApi.md#network_delete) | **DELETE** /networks/{id} | Remove a network
*NetworkApi* | [**network_disconnect**](docs/NetworkApi.md#network_disconnect) | **POST** /networks/{id}/disconnect | Disconnect a container from a network
*NetworkApi* | [**network_inspect**](docs/NetworkApi.md#network_inspect) | **GET** /networks/{id} | Inspect a network
*NetworkApi* | [**network_list**](docs/NetworkApi.md#network_list) | **GET** /networks | List networks
*NetworkApi* | [**network_prune**](docs/NetworkApi.md#network_prune) | **POST** /networks/prune | Delete unused networks
*NodeApi* | [**node_delete**](docs/NodeApi.md#node_delete) | **DELETE** /nodes/{id} | Delete a node
*NodeApi* | [**node_inspect**](docs/NodeApi.md#node_inspect) | **GET** /nodes/{id} | Inspect a node
*NodeApi* | [**node_list**](docs/NodeApi.md#node_list) | **GET** /nodes | List nodes
*NodeApi* | [**node_update**](docs/NodeApi.md#node_update) | **POST** /nodes/{id}/update | Update a node
*PluginApi* | [**get_plugin_privileges**](docs/PluginApi.md#get_plugin_privileges) | **GET** /plugins/privileges | Get plugin privileges
*PluginApi* | [**plugin_create**](docs/PluginApi.md#plugin_create) | **POST** /plugins/create | Create a plugin
*PluginApi* | [**plugin_delete**](docs/PluginApi.md#plugin_delete) | **DELETE** /plugins/{name} | Remove a plugin
*PluginApi* | [**plugin_disable**](docs/PluginApi.md#plugin_disable) | **POST** /plugins/{name}/disable | Disable a plugin
*PluginApi* | [**plugin_enable**](docs/PluginApi.md#plugin_enable) | **POST** /plugins/{name}/enable | Enable a plugin
*PluginApi* | [**plugin_inspect**](docs/PluginApi.md#plugin_inspect) | **GET** /plugins/{name}/json | Inspect a plugin
*PluginApi* | [**plugin_list**](docs/PluginApi.md#plugin_list) | **GET** /plugins | List plugins
*PluginApi* | [**plugin_pull**](docs/PluginApi.md#plugin_pull) | **POST** /plugins/pull | Install a plugin
*PluginApi* | [**plugin_push**](docs/PluginApi.md#plugin_push) | **POST** /plugins/{name}/push | Push a plugin
*PluginApi* | [**plugin_set**](docs/PluginApi.md#plugin_set) | **POST** /plugins/{name}/set | Configure a plugin
*PluginApi* | [**plugin_upgrade**](docs/PluginApi.md#plugin_upgrade) | **POST** /plugins/{name}/upgrade | Upgrade a plugin
*SecretApi* | [**secret_create**](docs/SecretApi.md#secret_create) | **POST** /secrets/create | Create a secret
*SecretApi* | [**secret_delete**](docs/SecretApi.md#secret_delete) | **DELETE** /secrets/{id} | Delete a secret
*SecretApi* | [**secret_inspect**](docs/SecretApi.md#secret_inspect) | **GET** /secrets/{id} | Inspect a secret
*SecretApi* | [**secret_list**](docs/SecretApi.md#secret_list) | **GET** /secrets | List secrets
*SecretApi* | [**secret_update**](docs/SecretApi.md#secret_update) | **POST** /secrets/{id}/update | Update a Secret
*ServiceApi* | [**service_create**](docs/ServiceApi.md#service_create) | **POST** /services/create | Create a service
*ServiceApi* | [**service_delete**](docs/ServiceApi.md#service_delete) | **DELETE** /services/{id} | Delete a service
*ServiceApi* | [**service_inspect**](docs/ServiceApi.md#service_inspect) | **GET** /services/{id} | Inspect a service
*ServiceApi* | [**service_list**](docs/ServiceApi.md#service_list) | **GET** /services | List services
*ServiceApi* | [**service_logs**](docs/ServiceApi.md#service_logs) | **GET** /services/{id}/logs | Get service logs
*ServiceApi* | [**service_update**](docs/ServiceApi.md#service_update) | **POST** /services/{id}/update | Update a service
*SessionApi* | [**session**](docs/SessionApi.md#session) | **POST** /session | Initialize interactive session
*SwarmApi* | [**swarm_init**](docs/SwarmApi.md#swarm_init) | **POST** /swarm/init | Initialize a new swarm
*SwarmApi* | [**swarm_inspect**](docs/SwarmApi.md#swarm_inspect) | **GET** /swarm | Inspect swarm
*SwarmApi* | [**swarm_join**](docs/SwarmApi.md#swarm_join) | **POST** /swarm/join | Join an existing swarm
*SwarmApi* | [**swarm_leave**](docs/SwarmApi.md#swarm_leave) | **POST** /swarm/leave | Leave a swarm
*SwarmApi* | [**swarm_unlock**](docs/SwarmApi.md#swarm_unlock) | **POST** /swarm/unlock | Unlock a locked manager
*SwarmApi* | [**swarm_unlockkey**](docs/SwarmApi.md#swarm_unlockkey) | **GET** /swarm/unlockkey | Get the unlock key
*SwarmApi* | [**swarm_update**](docs/SwarmApi.md#swarm_update) | **POST** /swarm/update | Update a swarm
*SystemApi* | [**system_auth**](docs/SystemApi.md#system_auth) | **POST** /auth | Check auth configuration
*SystemApi* | [**system_data_usage**](docs/SystemApi.md#system_data_usage) | **GET** /system/df | Get data usage information
*SystemApi* | [**system_events**](docs/SystemApi.md#system_events) | **GET** /events | Monitor events
*SystemApi* | [**system_info**](docs/SystemApi.md#system_info) | **GET** /info | Get system information
*SystemApi* | [**system_ping**](docs/SystemApi.md#system_ping) | **GET** /_ping | Ping
*SystemApi* | [**system_ping_head**](docs/SystemApi.md#system_ping_head) | **HEAD** /_ping | Ping
*SystemApi* | [**system_version**](docs/SystemApi.md#system_version) | **GET** /version | Get version
*TaskApi* | [**task_inspect**](docs/TaskApi.md#task_inspect) | **GET** /tasks/{id} | Inspect a task
*TaskApi* | [**task_list**](docs/TaskApi.md#task_list) | **GET** /tasks | List tasks
*TaskApi* | [**task_logs**](docs/TaskApi.md#task_logs) | **GET** /tasks/{id}/logs | Get task logs
*VolumeApi* | [**volume_create**](docs/VolumeApi.md#volume_create) | **POST** /volumes/create | Create a volume
*VolumeApi* | [**volume_delete**](docs/VolumeApi.md#volume_delete) | **DELETE** /volumes/{name} | Remove a volume
*VolumeApi* | [**volume_inspect**](docs/VolumeApi.md#volume_inspect) | **GET** /volumes/{name} | Inspect a volume
*VolumeApi* | [**volume_list**](docs/VolumeApi.md#volume_list) | **GET** /volumes | List volumes
*VolumeApi* | [**volume_prune**](docs/VolumeApi.md#volume_prune) | **POST** /volumes/prune | Delete unused volumes


## Documentation For Models

 - [Address](docs/Address.md)
 - [AuthConfig](docs/AuthConfig.md)
 - [BuildCache](docs/BuildCache.md)
 - [BuildInfo](docs/BuildInfo.md)
 - [BuildPruneResponse](docs/BuildPruneResponse.md)
 - [ClusterInfo](docs/ClusterInfo.md)
 - [Commit](docs/Commit.md)
 - [Config](docs/Config.md)
 - [ConfigSpec](docs/ConfigSpec.md)
 - [ContainerChangeResponseItem](docs/ContainerChangeResponseItem.md)
 - [ContainerConfig](docs/ContainerConfig.md)
 - [ContainerCreateResponse](docs/ContainerCreateResponse.md)
 - [ContainerInspectResponse](docs/ContainerInspectResponse.md)
 - [ContainerPruneResponse](docs/ContainerPruneResponse.md)
 - [ContainerState](docs/ContainerState.md)
 - [ContainerSummary](docs/ContainerSummary.md)
 - [ContainerSummaryHostConfig](docs/ContainerSummaryHostConfig.md)
 - [ContainerSummaryNetworkSettings](docs/ContainerSummaryNetworkSettings.md)
 - [ContainerTopResponse](docs/ContainerTopResponse.md)
 - [ContainerUpdateResponse](docs/ContainerUpdateResponse.md)
 - [ContainerWaitResponse](docs/ContainerWaitResponse.md)
 - [ContainerWaitResponseError](docs/ContainerWaitResponseError.md)
 - [CreateImageInfo](docs/CreateImageInfo.md)
 - [DeviceMapping](docs/DeviceMapping.md)
 - [DeviceRequest](docs/DeviceRequest.md)
 - [DistributionInspectResponse](docs/DistributionInspectResponse.md)
 - [DistributionInspectResponseDescriptor](docs/DistributionInspectResponseDescriptor.md)
 - [DistributionInspectResponsePlatforms](docs/DistributionInspectResponsePlatforms.md)
 - [Driver](docs/Driver.md)
 - [EndpointIPAMConfig](docs/EndpointIPAMConfig.md)
 - [EndpointPortConfig](docs/EndpointPortConfig.md)
 - [EndpointSettings](docs/EndpointSettings.md)
 - [EndpointSpec](docs/EndpointSpec.md)
 - [EngineDescription](docs/EngineDescription.md)
 - [EngineDescriptionPlugins](docs/EngineDescriptionPlugins.md)
 - [ErrorDetail](docs/ErrorDetail.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [ExecConfig](docs/ExecConfig.md)
 - [ExecInspectResponse](docs/ExecInspectResponse.md)
 - [ExecStartConfig](docs/ExecStartConfig.md)
 - [GenericResources](docs/GenericResources.md)
 - [GenericResourcesInner](docs/GenericResourcesInner.md)
 - [GenericResourcesInnerDiscreteResourceSpec](docs/GenericResourcesInnerDiscreteResourceSpec.md)
 - [GenericResourcesInnerNamedResourceSpec](docs/GenericResourcesInnerNamedResourceSpec.md)
 - [GraphDriverData](docs/GraphDriverData.md)
 - [Health](docs/Health.md)
 - [HealthConfig](docs/HealthConfig.md)
 - [HealthcheckResult](docs/HealthcheckResult.md)
 - [HistoryResponseItem](docs/HistoryResponseItem.md)
 - [HostConfig](docs/HostConfig.md)
 - [HostConfigLogConfig](docs/HostConfigLogConfig.md)
 - [IPAM](docs/IPAM.md)
 - [IdResponse](docs/IdResponse.md)
 - [Image](docs/Image.md)
 - [ImageDeleteResponseItem](docs/ImageDeleteResponseItem.md)
 - [ImageID](docs/ImageID.md)
 - [ImageMetadata](docs/ImageMetadata.md)
 - [ImagePruneResponse](docs/ImagePruneResponse.md)
 - [ImageRootFS](docs/ImageRootFS.md)
 - [ImageSearchResponseItem](docs/ImageSearchResponseItem.md)
 - [ImageSummary](docs/ImageSummary.md)
 - [IndexInfo](docs/IndexInfo.md)
 - [InlineResponse400](docs/InlineResponse400.md)
 - [JoinTokens](docs/JoinTokens.md)
 - [Limit](docs/Limit.md)
 - [LocalNodeState](docs/LocalNodeState.md)
 - [ManagerStatus](docs/ManagerStatus.md)
 - [Mount](docs/Mount.md)
 - [MountBindOptions](docs/MountBindOptions.md)
 - [MountPoint](docs/MountPoint.md)
 - [MountTmpfsOptions](docs/MountTmpfsOptions.md)
 - [MountVolumeOptions](docs/MountVolumeOptions.md)
 - [MountVolumeOptionsDriverConfig](docs/MountVolumeOptionsDriverConfig.md)
 - [Network](docs/Network.md)
 - [NetworkAttachmentConfig](docs/NetworkAttachmentConfig.md)
 - [NetworkConnectRequest](docs/NetworkConnectRequest.md)
 - [NetworkContainer](docs/NetworkContainer.md)
 - [NetworkCreateRequest](docs/NetworkCreateRequest.md)
 - [NetworkCreateResponse](docs/NetworkCreateResponse.md)
 - [NetworkDisconnectRequest](docs/NetworkDisconnectRequest.md)
 - [NetworkPruneResponse](docs/NetworkPruneResponse.md)
 - [NetworkSettings](docs/NetworkSettings.md)
 - [NetworkingConfig](docs/NetworkingConfig.md)
 - [Node](docs/Node.md)
 - [NodeDescription](docs/NodeDescription.md)
 - [NodeSpec](docs/NodeSpec.md)
 - [NodeState](docs/NodeState.md)
 - [NodeStatus](docs/NodeStatus.md)
 - [ObjectVersion](docs/ObjectVersion.md)
 - [PeerNode](docs/PeerNode.md)
 - [Platform](docs/Platform.md)
 - [Plugin](docs/Plugin.md)
 - [PluginConfig](docs/PluginConfig.md)
 - [PluginConfigArgs](docs/PluginConfigArgs.md)
 - [PluginConfigInterface](docs/PluginConfigInterface.md)
 - [PluginConfigLinux](docs/PluginConfigLinux.md)
 - [PluginConfigNetwork](docs/PluginConfigNetwork.md)
 - [PluginConfigRootfs](docs/PluginConfigRootfs.md)
 - [PluginConfigUser](docs/PluginConfigUser.md)
 - [PluginDevice](docs/PluginDevice.md)
 - [PluginEnv](docs/PluginEnv.md)
 - [PluginInterfaceType](docs/PluginInterfaceType.md)
 - [PluginMount](docs/PluginMount.md)
 - [PluginPrivilegeItem](docs/PluginPrivilegeItem.md)
 - [PluginSettings](docs/PluginSettings.md)
 - [PluginsInfo](docs/PluginsInfo.md)
 - [Port](docs/Port.md)
 - [PortBinding](docs/PortBinding.md)
 - [PortMap](docs/PortMap.md)
 - [ProcessConfig](docs/ProcessConfig.md)
 - [ProgressDetail](docs/ProgressDetail.md)
 - [PushImageInfo](docs/PushImageInfo.md)
 - [Reachability](docs/Reachability.md)
 - [RegistryServiceConfig](docs/RegistryServiceConfig.md)
 - [ResourceObject](docs/ResourceObject.md)
 - [Resources](docs/Resources.md)
 - [ResourcesBlkioWeightDevice](docs/ResourcesBlkioWeightDevice.md)
 - [ResourcesUlimits](docs/ResourcesUlimits.md)
 - [RestartPolicy](docs/RestartPolicy.md)
 - [Runtime](docs/Runtime.md)
 - [Secret](docs/Secret.md)
 - [SecretSpec](docs/SecretSpec.md)
 - [Service](docs/Service.md)
 - [ServiceCreateResponse](docs/ServiceCreateResponse.md)
 - [ServiceEndpoint](docs/ServiceEndpoint.md)
 - [ServiceEndpointVirtualIPs](docs/ServiceEndpointVirtualIPs.md)
 - [ServiceJobStatus](docs/ServiceJobStatus.md)
 - [ServiceServiceStatus](docs/ServiceServiceStatus.md)
 - [ServiceSpec](docs/ServiceSpec.md)
 - [ServiceSpecMode](docs/ServiceSpecMode.md)
 - [ServiceSpecModeReplicated](docs/ServiceSpecModeReplicated.md)
 - [ServiceSpecModeReplicatedJob](docs/ServiceSpecModeReplicatedJob.md)
 - [ServiceSpecRollbackConfig](docs/ServiceSpecRollbackConfig.md)
 - [ServiceSpecUpdateConfig](docs/ServiceSpecUpdateConfig.md)
 - [ServiceUpdateResponse](docs/ServiceUpdateResponse.md)
 - [ServiceUpdateStatus](docs/ServiceUpdateStatus.md)
 - [Swarm](docs/Swarm.md)
 - [SwarmInfo](docs/SwarmInfo.md)
 - [SwarmInitRequest](docs/SwarmInitRequest.md)
 - [SwarmJoinRequest](docs/SwarmJoinRequest.md)
 - [SwarmSpec](docs/SwarmSpec.md)
 - [SwarmSpecCAConfig](docs/SwarmSpecCAConfig.md)
 - [SwarmSpecCAConfigExternalCAs](docs/SwarmSpecCAConfigExternalCAs.md)
 - [SwarmSpecDispatcher](docs/SwarmSpecDispatcher.md)
 - [SwarmSpecEncryptionConfig](docs/SwarmSpecEncryptionConfig.md)
 - [SwarmSpecOrchestration](docs/SwarmSpecOrchestration.md)
 - [SwarmSpecRaft](docs/SwarmSpecRaft.md)
 - [SwarmSpecTaskDefaults](docs/SwarmSpecTaskDefaults.md)
 - [SwarmSpecTaskDefaultsLogDriver](docs/SwarmSpecTaskDefaultsLogDriver.md)
 - [SwarmUnlockRequest](docs/SwarmUnlockRequest.md)
 - [SystemAuthResponse](docs/SystemAuthResponse.md)
 - [SystemDataUsageResponse](docs/SystemDataUsageResponse.md)
 - [SystemEventsResponse](docs/SystemEventsResponse.md)
 - [SystemEventsResponseActor](docs/SystemEventsResponseActor.md)
 - [SystemInfo](docs/SystemInfo.md)
 - [SystemInfoDefaultAddressPools](docs/SystemInfoDefaultAddressPools.md)
 - [SystemVersion](docs/SystemVersion.md)
 - [SystemVersionComponents](docs/SystemVersionComponents.md)
 - [SystemVersionPlatform](docs/SystemVersionPlatform.md)
 - [TLSInfo](docs/TLSInfo.md)
 - [Task](docs/Task.md)
 - [TaskSpec](docs/TaskSpec.md)
 - [TaskSpecContainerSpec](docs/TaskSpecContainerSpec.md)
 - [TaskSpecContainerSpecConfigs](docs/TaskSpecContainerSpecConfigs.md)
 - [TaskSpecContainerSpecDNSConfig](docs/TaskSpecContainerSpecDNSConfig.md)
 - [TaskSpecContainerSpecFile](docs/TaskSpecContainerSpecFile.md)
 - [TaskSpecContainerSpecFile1](docs/TaskSpecContainerSpecFile1.md)
 - [TaskSpecContainerSpecPrivileges](docs/TaskSpecContainerSpecPrivileges.md)
 - [TaskSpecContainerSpecPrivilegesCredentialSpec](docs/TaskSpecContainerSpecPrivilegesCredentialSpec.md)
 - [TaskSpecContainerSpecPrivilegesSELinuxContext](docs/TaskSpecContainerSpecPrivilegesSELinuxContext.md)
 - [TaskSpecContainerSpecSecrets](docs/TaskSpecContainerSpecSecrets.md)
 - [TaskSpecLogDriver](docs/TaskSpecLogDriver.md)
 - [TaskSpecNetworkAttachmentSpec](docs/TaskSpecNetworkAttachmentSpec.md)
 - [TaskSpecPlacement](docs/TaskSpecPlacement.md)
 - [TaskSpecPlacementPreferences](docs/TaskSpecPlacementPreferences.md)
 - [TaskSpecPlacementSpread](docs/TaskSpecPlacementSpread.md)
 - [TaskSpecPluginSpec](docs/TaskSpecPluginSpec.md)
 - [TaskSpecResources](docs/TaskSpecResources.md)
 - [TaskSpecRestartPolicy](docs/TaskSpecRestartPolicy.md)
 - [TaskState](docs/TaskState.md)
 - [TaskStatus](docs/TaskStatus.md)
 - [TaskStatusContainerStatus](docs/TaskStatusContainerStatus.md)
 - [ThrottleDevice](docs/ThrottleDevice.md)
 - [UnlockKeyResponse](docs/UnlockKeyResponse.md)
 - [Volume](docs/Volume.md)
 - [VolumeConfig](docs/VolumeConfig.md)
 - [VolumeListResponse](docs/VolumeListResponse.md)
 - [VolumePruneResponse](docs/VolumePruneResponse.md)
 - [VolumeUsageData](docs/VolumeUsageData.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author



