# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from jgreenepack.api_client import ApiClient


class ImageApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def build_prune(self, **kwargs):  # noqa: E501
        """Delete builder cache  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.build_prune(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int keep_storage: Amount of disk space in bytes to keep for cache
        :param bool all: Remove all types of build cache
        :param str filters: A JSON encoded value of the filters (a `map[string][]string`) to process on the list of build cache objects.  Available filters:  - `until=<duration>`: duration relative to daemon's time, during which build cache was not used, in Go's duration format (e.g., '24h') - `id=<id>` - `parent=<id>` - `type=<string>` - `description=<string>` - `inuse` - `shared` - `private` 
        :return: BuildPruneResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.build_prune_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.build_prune_with_http_info(**kwargs)  # noqa: E501
            return data

    def build_prune_with_http_info(self, **kwargs):  # noqa: E501
        """Delete builder cache  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.build_prune_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int keep_storage: Amount of disk space in bytes to keep for cache
        :param bool all: Remove all types of build cache
        :param str filters: A JSON encoded value of the filters (a `map[string][]string`) to process on the list of build cache objects.  Available filters:  - `until=<duration>`: duration relative to daemon's time, during which build cache was not used, in Go's duration format (e.g., '24h') - `id=<id>` - `parent=<id>` - `type=<string>` - `description=<string>` - `inuse` - `shared` - `private` 
        :return: BuildPruneResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['keep_storage', 'all', 'filters']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method build_prune" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'keep_storage' in params:
            query_params.append(('keep-storage', params['keep_storage']))  # noqa: E501
        if 'all' in params:
            query_params.append(('all', params['all']))  # noqa: E501
        if 'filters' in params:
            query_params.append(('filters', params['filters']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/build/prune', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BuildPruneResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def image_build(self, **kwargs):  # noqa: E501
        """Build an image  # noqa: E501

        Build an image from a tar archive with a `Dockerfile` in it.  The `Dockerfile` specifies how the image is built from the tar archive. It is typically in the archive's root, but can be at a different path or have a different name by specifying the `dockerfile` parameter. [See the `Dockerfile` reference for more information](https://docs.docker.com/engine/reference/builder/).  The Docker daemon performs a preliminary validation of the `Dockerfile` before starting the build, and returns an error if the syntax is incorrect. After that, each instruction is run one-by-one until the ID of the new image is output.  The build is canceled if the client drops the connection by quitting or being killed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_build(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str input_stream: A tar archive compressed with one of the following algorithms: identity (no compression), gzip, bzip2, xz.
        :param str dockerfile: Path within the build context to the `Dockerfile`. This is ignored if `remote` is specified and points to an external `Dockerfile`.
        :param str t: A name and optional tag to apply to the image in the `name:tag` format. If you omit the tag the default `latest` value is assumed. You can provide several `t` parameters.
        :param str extrahosts: Extra hosts to add to /etc/hosts
        :param str remote: A Git repository URI or HTTP/HTTPS context URI. If the URI points to a single text file, the file’s contents are placed into a file called `Dockerfile` and the image is built from that file. If the URI points to a tarball, the file is downloaded by the daemon and the contents therein used as the context for the build. If the URI points to a tarball and the `dockerfile` parameter is also specified, there must be a file with the corresponding path inside the tarball.
        :param bool q: Suppress verbose build output.
        :param bool nocache: Do not use the cache when building the image.
        :param str cachefrom: JSON array of images used for build cache resolution.
        :param str pull: Attempt to pull the image even if an older image exists locally.
        :param bool rm: Remove intermediate containers after a successful build.
        :param bool forcerm: Always remove intermediate containers, even upon failure.
        :param int memory: Set memory limit for build.
        :param int memswap: Total memory (memory + swap). Set as `-1` to disable swap.
        :param int cpushares: CPU shares (relative weight).
        :param str cpusetcpus: CPUs in which to allow execution (e.g., `0-3`, `0,1`).
        :param int cpuperiod: The length of a CPU period in microseconds.
        :param int cpuquota: Microseconds of CPU time that the container can get in a CPU period.
        :param str buildargs: JSON map of string pairs for build-time variables. Users pass these values at build-time. Docker uses the buildargs as the environment context for commands run via the `Dockerfile` RUN instruction, or for variable expansion in other `Dockerfile` instructions. This is not meant for passing secret values.  For example, the build arg `FOO=bar` would become `{\"FOO\":\"bar\"}` in JSON. This would result in the query parameter `buildargs={\"FOO\":\"bar\"}`. Note that `{\"FOO\":\"bar\"}` should be URI component encoded.  [Read more about the buildargs instruction.](https://docs.docker.com/engine/reference/builder/#arg) 
        :param int shmsize: Size of `/dev/shm` in bytes. The size must be greater than 0. If omitted the system uses 64MB.
        :param bool squash: Squash the resulting images layers into a single layer. *(Experimental release only.)*
        :param str labels: Arbitrary key/value labels to set on the image, as a JSON map of string pairs.
        :param str networkmode: Sets the networking mode for the run commands during build. Supported standard values are: `bridge`, `host`, `none`, and `container:<name|id>`. Any other value is taken as a custom network's name or ID to which this container should connect to. 
        :param str content_type:
        :param str x_registry_config: This is a base64-encoded JSON object with auth configurations for multiple registries that a build may refer to.  The key is a registry URL, and the value is an auth configuration object, [as described in the authentication section](#section/Authentication). For example:  ``` {   \"docker.example.com\": {     \"username\": \"janedoe\",     \"password\": \"hunter2\"   },   \"https://index.docker.io/v1/\": {     \"username\": \"mobydock\",     \"password\": \"conta1n3rize14\"   } } ```  Only the registry domain name (and port if not the default 443) are required. However, for legacy reasons, the Docker Hub registry must be specified with both a `https://` prefix and a `/v1/` suffix even though Docker will prefer to use the v2 registry API. 
        :param str platform: Platform in the format os[/arch[/variant]]
        :param str target: Target build stage
        :param str outputs: BuildKit output configuration
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.image_build_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.image_build_with_http_info(**kwargs)  # noqa: E501
            return data

    def image_build_with_http_info(self, **kwargs):  # noqa: E501
        """Build an image  # noqa: E501

        Build an image from a tar archive with a `Dockerfile` in it.  The `Dockerfile` specifies how the image is built from the tar archive. It is typically in the archive's root, but can be at a different path or have a different name by specifying the `dockerfile` parameter. [See the `Dockerfile` reference for more information](https://docs.docker.com/engine/reference/builder/).  The Docker daemon performs a preliminary validation of the `Dockerfile` before starting the build, and returns an error if the syntax is incorrect. After that, each instruction is run one-by-one until the ID of the new image is output.  The build is canceled if the client drops the connection by quitting or being killed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_build_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str input_stream: A tar archive compressed with one of the following algorithms: identity (no compression), gzip, bzip2, xz.
        :param str dockerfile: Path within the build context to the `Dockerfile`. This is ignored if `remote` is specified and points to an external `Dockerfile`.
        :param str t: A name and optional tag to apply to the image in the `name:tag` format. If you omit the tag the default `latest` value is assumed. You can provide several `t` parameters.
        :param str extrahosts: Extra hosts to add to /etc/hosts
        :param str remote: A Git repository URI or HTTP/HTTPS context URI. If the URI points to a single text file, the file’s contents are placed into a file called `Dockerfile` and the image is built from that file. If the URI points to a tarball, the file is downloaded by the daemon and the contents therein used as the context for the build. If the URI points to a tarball and the `dockerfile` parameter is also specified, there must be a file with the corresponding path inside the tarball.
        :param bool q: Suppress verbose build output.
        :param bool nocache: Do not use the cache when building the image.
        :param str cachefrom: JSON array of images used for build cache resolution.
        :param str pull: Attempt to pull the image even if an older image exists locally.
        :param bool rm: Remove intermediate containers after a successful build.
        :param bool forcerm: Always remove intermediate containers, even upon failure.
        :param int memory: Set memory limit for build.
        :param int memswap: Total memory (memory + swap). Set as `-1` to disable swap.
        :param int cpushares: CPU shares (relative weight).
        :param str cpusetcpus: CPUs in which to allow execution (e.g., `0-3`, `0,1`).
        :param int cpuperiod: The length of a CPU period in microseconds.
        :param int cpuquota: Microseconds of CPU time that the container can get in a CPU period.
        :param str buildargs: JSON map of string pairs for build-time variables. Users pass these values at build-time. Docker uses the buildargs as the environment context for commands run via the `Dockerfile` RUN instruction, or for variable expansion in other `Dockerfile` instructions. This is not meant for passing secret values.  For example, the build arg `FOO=bar` would become `{\"FOO\":\"bar\"}` in JSON. This would result in the query parameter `buildargs={\"FOO\":\"bar\"}`. Note that `{\"FOO\":\"bar\"}` should be URI component encoded.  [Read more about the buildargs instruction.](https://docs.docker.com/engine/reference/builder/#arg) 
        :param int shmsize: Size of `/dev/shm` in bytes. The size must be greater than 0. If omitted the system uses 64MB.
        :param bool squash: Squash the resulting images layers into a single layer. *(Experimental release only.)*
        :param str labels: Arbitrary key/value labels to set on the image, as a JSON map of string pairs.
        :param str networkmode: Sets the networking mode for the run commands during build. Supported standard values are: `bridge`, `host`, `none`, and `container:<name|id>`. Any other value is taken as a custom network's name or ID to which this container should connect to. 
        :param str content_type:
        :param str x_registry_config: This is a base64-encoded JSON object with auth configurations for multiple registries that a build may refer to.  The key is a registry URL, and the value is an auth configuration object, [as described in the authentication section](#section/Authentication). For example:  ``` {   \"docker.example.com\": {     \"username\": \"janedoe\",     \"password\": \"hunter2\"   },   \"https://index.docker.io/v1/\": {     \"username\": \"mobydock\",     \"password\": \"conta1n3rize14\"   } } ```  Only the registry domain name (and port if not the default 443) are required. However, for legacy reasons, the Docker Hub registry must be specified with both a `https://` prefix and a `/v1/` suffix even though Docker will prefer to use the v2 registry API. 
        :param str platform: Platform in the format os[/arch[/variant]]
        :param str target: Target build stage
        :param str outputs: BuildKit output configuration
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_stream', 'dockerfile', 't', 'extrahosts', 'remote', 'q', 'nocache', 'cachefrom', 'pull', 'rm', 'forcerm', 'memory', 'memswap', 'cpushares', 'cpusetcpus', 'cpuperiod', 'cpuquota', 'buildargs', 'shmsize', 'squash', 'labels', 'networkmode', 'content_type', 'x_registry_config', 'platform', 'target', 'outputs']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method image_build" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dockerfile' in params:
            query_params.append(('dockerfile', params['dockerfile']))  # noqa: E501
        if 't' in params:
            query_params.append(('t', params['t']))  # noqa: E501
        if 'extrahosts' in params:
            query_params.append(('extrahosts', params['extrahosts']))  # noqa: E501
        if 'remote' in params:
            query_params.append(('remote', params['remote']))  # noqa: E501
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501
        if 'nocache' in params:
            query_params.append(('nocache', params['nocache']))  # noqa: E501
        if 'cachefrom' in params:
            query_params.append(('cachefrom', params['cachefrom']))  # noqa: E501
        if 'pull' in params:
            query_params.append(('pull', params['pull']))  # noqa: E501
        if 'rm' in params:
            query_params.append(('rm', params['rm']))  # noqa: E501
        if 'forcerm' in params:
            query_params.append(('forcerm', params['forcerm']))  # noqa: E501
        if 'memory' in params:
            query_params.append(('memory', params['memory']))  # noqa: E501
        if 'memswap' in params:
            query_params.append(('memswap', params['memswap']))  # noqa: E501
        if 'cpushares' in params:
            query_params.append(('cpushares', params['cpushares']))  # noqa: E501
        if 'cpusetcpus' in params:
            query_params.append(('cpusetcpus', params['cpusetcpus']))  # noqa: E501
        if 'cpuperiod' in params:
            query_params.append(('cpuperiod', params['cpuperiod']))  # noqa: E501
        if 'cpuquota' in params:
            query_params.append(('cpuquota', params['cpuquota']))  # noqa: E501
        if 'buildargs' in params:
            query_params.append(('buildargs', params['buildargs']))  # noqa: E501
        if 'shmsize' in params:
            query_params.append(('shmsize', params['shmsize']))  # noqa: E501
        if 'squash' in params:
            query_params.append(('squash', params['squash']))  # noqa: E501
        if 'labels' in params:
            query_params.append(('labels', params['labels']))  # noqa: E501
        if 'networkmode' in params:
            query_params.append(('networkmode', params['networkmode']))  # noqa: E501
        if 'platform' in params:
            query_params.append(('platform', params['platform']))  # noqa: E501
        if 'target' in params:
            query_params.append(('target', params['target']))  # noqa: E501
        if 'outputs' in params:
            query_params.append(('outputs', params['outputs']))  # noqa: E501

        header_params = {}
        if 'content_type' in params:
            header_params['Content-type'] = params['content_type']  # noqa: E501
        if 'x_registry_config' in params:
            header_params['X-Registry-Config'] = params['x_registry_config']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input_stream' in params:
            body_params = params['input_stream']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/build', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def image_commit(self, **kwargs):  # noqa: E501
        """Create a new image from a container  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_commit(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ContainerConfig container_config: The container configuration
        :param str container: The ID or name of the container to commit
        :param str repo: Repository name for the created image
        :param str tag: Tag name for the create image
        :param str comment: Commit message
        :param str author: Author of the image (e.g., `John Hannibal Smith <hannibal@a-team.com>`)
        :param bool pause: Whether to pause the container before committing
        :param str changes: `Dockerfile` instructions to apply while committing
        :return: IdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.image_commit_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.image_commit_with_http_info(**kwargs)  # noqa: E501
            return data

    def image_commit_with_http_info(self, **kwargs):  # noqa: E501
        """Create a new image from a container  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_commit_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ContainerConfig container_config: The container configuration
        :param str container: The ID or name of the container to commit
        :param str repo: Repository name for the created image
        :param str tag: Tag name for the create image
        :param str comment: Commit message
        :param str author: Author of the image (e.g., `John Hannibal Smith <hannibal@a-team.com>`)
        :param bool pause: Whether to pause the container before committing
        :param str changes: `Dockerfile` instructions to apply while committing
        :return: IdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_config', 'container', 'repo', 'tag', 'comment', 'author', 'pause', 'changes']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method image_commit" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'container' in params:
            query_params.append(('container', params['container']))  # noqa: E501
        if 'repo' in params:
            query_params.append(('repo', params['repo']))  # noqa: E501
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'comment' in params:
            query_params.append(('comment', params['comment']))  # noqa: E501
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501
        if 'pause' in params:
            query_params.append(('pause', params['pause']))  # noqa: E501
        if 'changes' in params:
            query_params.append(('changes', params['changes']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'container_config' in params:
            body_params = params['container_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/commit', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IdResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def image_create(self, **kwargs):  # noqa: E501
        """Create an image  # noqa: E501

        Create an image by either pulling it from a registry or importing it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_create(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str from_image: Name of the image to pull. The name may include a tag or digest. This parameter may only be used when pulling an image. The pull is cancelled if the HTTP connection is closed.
        :param str from_src: Source to import. The value may be a URL from which the image can be retrieved or `-` to read the image from the request body. This parameter may only be used when importing an image.
        :param str repo: Repository name given to an image when it is imported. The repo may include a tag. This parameter may only be used when importing an image.
        :param str tag: Tag or digest. If empty when pulling an image, this causes all tags for the given image to be pulled.
        :param str message: Set commit message for imported image.
        :param str input_image: Image content if the value `-` has been specified in fromSrc query parameter
        :param str x_registry_auth: A base64url-encoded auth configuration.  Refer to the [authentication section](#section/Authentication) for details. 
        :param list[str] changes: Apply `Dockerfile` instructions to the image that is created, for example: `changes=ENV DEBUG=true`. Note that `ENV DEBUG=true` should be URI component encoded.  Supported `Dockerfile` instructions: `CMD`|`ENTRYPOINT`|`ENV`|`EXPOSE`|`ONBUILD`|`USER`|`VOLUME`|`WORKDIR` 
        :param str platform: Platform in the format os[/arch[/variant]]
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.image_create_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.image_create_with_http_info(**kwargs)  # noqa: E501
            return data

    def image_create_with_http_info(self, **kwargs):  # noqa: E501
        """Create an image  # noqa: E501

        Create an image by either pulling it from a registry or importing it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_create_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str from_image: Name of the image to pull. The name may include a tag or digest. This parameter may only be used when pulling an image. The pull is cancelled if the HTTP connection is closed.
        :param str from_src: Source to import. The value may be a URL from which the image can be retrieved or `-` to read the image from the request body. This parameter may only be used when importing an image.
        :param str repo: Repository name given to an image when it is imported. The repo may include a tag. This parameter may only be used when importing an image.
        :param str tag: Tag or digest. If empty when pulling an image, this causes all tags for the given image to be pulled.
        :param str message: Set commit message for imported image.
        :param str input_image: Image content if the value `-` has been specified in fromSrc query parameter
        :param str x_registry_auth: A base64url-encoded auth configuration.  Refer to the [authentication section](#section/Authentication) for details. 
        :param list[str] changes: Apply `Dockerfile` instructions to the image that is created, for example: `changes=ENV DEBUG=true`. Note that `ENV DEBUG=true` should be URI component encoded.  Supported `Dockerfile` instructions: `CMD`|`ENTRYPOINT`|`ENV`|`EXPOSE`|`ONBUILD`|`USER`|`VOLUME`|`WORKDIR` 
        :param str platform: Platform in the format os[/arch[/variant]]
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['from_image', 'from_src', 'repo', 'tag', 'message', 'input_image', 'x_registry_auth', 'changes', 'platform']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method image_create" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'from_image' in params:
            query_params.append(('fromImage', params['from_image']))  # noqa: E501
        if 'from_src' in params:
            query_params.append(('fromSrc', params['from_src']))  # noqa: E501
        if 'repo' in params:
            query_params.append(('repo', params['repo']))  # noqa: E501
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'message' in params:
            query_params.append(('message', params['message']))  # noqa: E501
        if 'changes' in params:
            query_params.append(('changes', params['changes']))  # noqa: E501
            collection_formats['changes'] = 'csv'  # noqa: E501
        if 'platform' in params:
            query_params.append(('platform', params['platform']))  # noqa: E501

        header_params = {}
        if 'x_registry_auth' in params:
            header_params['X-Registry-Auth'] = params['x_registry_auth']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input_image' in params:
            body_params = params['input_image']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain', 'application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/images/create', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def image_delete(self, name, **kwargs):  # noqa: E501
        """Remove an image  # noqa: E501

        Remove an image, along with any untagged parent images that were referenced by that image.  Images can't be removed if they have descendant images, are being used by a running container or are being used by a build.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_delete(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Image name or ID (required)
        :param bool force: Remove the image even if it is being used by stopped containers or has other tags
        :param bool noprune: Do not delete untagged parent images
        :return: list[ImageDeleteResponseItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.image_delete_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.image_delete_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def image_delete_with_http_info(self, name, **kwargs):  # noqa: E501
        """Remove an image  # noqa: E501

        Remove an image, along with any untagged parent images that were referenced by that image.  Images can't be removed if they have descendant images, are being used by a running container or are being used by a build.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_delete_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Image name or ID (required)
        :param bool force: Remove the image even if it is being used by stopped containers or has other tags
        :param bool noprune: Do not delete untagged parent images
        :return: list[ImageDeleteResponseItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'force', 'noprune']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method image_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `image_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'noprune' in params:
            query_params.append(('noprune', params['noprune']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/images/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ImageDeleteResponseItem]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def image_get(self, name, **kwargs):  # noqa: E501
        """Export an image  # noqa: E501

        Get a tarball containing all images and metadata for a repository.  If `name` is a specific name and tag (e.g. `ubuntu:latest`), then only that image (and its parents) are returned. If `name` is an image ID, similarly only that image (and its parents) are returned, but with the exclusion of the `repositories` file in the tarball, as there were no image names referenced.  ### Image tarball format  An image tarball contains one directory per image layer (named using its long ID), each containing these files:  - `VERSION`: currently `1.0` - the file format version - `json`: detailed layer information, similar to `docker inspect layer_id` - `layer.tar`: A tarfile containing the filesystem changes in this layer  The `layer.tar` file contains `aufs` style `.wh..wh.aufs` files and directories for storing attribute changes and deletions.  If the tarball defines a repository, the tarball should also include a `repositories` file at the root that contains a list of repository and tag names mapped to layer IDs.  ```json {   \"hello-world\": {     \"latest\": \"565a9d68a73f6706862bfe8409a7f659776d4d60a8d096eb4a3cbce6999cc2a1\"   } } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_get(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Image name or ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.image_get_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.image_get_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def image_get_with_http_info(self, name, **kwargs):  # noqa: E501
        """Export an image  # noqa: E501

        Get a tarball containing all images and metadata for a repository.  If `name` is a specific name and tag (e.g. `ubuntu:latest`), then only that image (and its parents) are returned. If `name` is an image ID, similarly only that image (and its parents) are returned, but with the exclusion of the `repositories` file in the tarball, as there were no image names referenced.  ### Image tarball format  An image tarball contains one directory per image layer (named using its long ID), each containing these files:  - `VERSION`: currently `1.0` - the file format version - `json`: detailed layer information, similar to `docker inspect layer_id` - `layer.tar`: A tarfile containing the filesystem changes in this layer  The `layer.tar` file contains `aufs` style `.wh..wh.aufs` files and directories for storing attribute changes and deletions.  If the tarball defines a repository, the tarball should also include a `repositories` file at the root that contains a list of repository and tag names mapped to layer IDs.  ```json {   \"hello-world\": {     \"latest\": \"565a9d68a73f6706862bfe8409a7f659776d4d60a8d096eb4a3cbce6999cc2a1\"   } } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_get_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Image name or ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method image_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `image_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/x-tar'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/images/{name}/get', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def image_get_all(self, **kwargs):  # noqa: E501
        """Export several images  # noqa: E501

        Get a tarball containing all images and metadata for several image repositories.  For each value of the `names` parameter: if it is a specific name and tag (e.g. `ubuntu:latest`), then only that image (and its parents) are returned; if it is an image ID, similarly only that image (and its parents) are returned and there would be no names referenced in the 'repositories' file for this image ID.  For details on the format, see the [export image endpoint](#operation/ImageGet).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_get_all(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] names: Image names to filter by
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.image_get_all_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.image_get_all_with_http_info(**kwargs)  # noqa: E501
            return data

    def image_get_all_with_http_info(self, **kwargs):  # noqa: E501
        """Export several images  # noqa: E501

        Get a tarball containing all images and metadata for several image repositories.  For each value of the `names` parameter: if it is a specific name and tag (e.g. `ubuntu:latest`), then only that image (and its parents) are returned; if it is an image ID, similarly only that image (and its parents) are returned and there would be no names referenced in the 'repositories' file for this image ID.  For details on the format, see the [export image endpoint](#operation/ImageGet).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_get_all_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] names: Image names to filter by
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['names']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method image_get_all" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'names' in params:
            query_params.append(('names', params['names']))  # noqa: E501
            collection_formats['names'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/x-tar'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/images/get', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def image_history(self, name, **kwargs):  # noqa: E501
        """Get the history of an image  # noqa: E501

        Return parent layers of an image.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_history(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Image name or ID (required)
        :return: list[HistoryResponseItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.image_history_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.image_history_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def image_history_with_http_info(self, name, **kwargs):  # noqa: E501
        """Get the history of an image  # noqa: E501

        Return parent layers of an image.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_history_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Image name or ID (required)
        :return: list[HistoryResponseItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method image_history" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `image_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/images/{name}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[HistoryResponseItem]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def image_inspect(self, name, **kwargs):  # noqa: E501
        """Inspect an image  # noqa: E501

        Return low-level information about an image.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_inspect(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Image name or id (required)
        :return: Image
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.image_inspect_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.image_inspect_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def image_inspect_with_http_info(self, name, **kwargs):  # noqa: E501
        """Inspect an image  # noqa: E501

        Return low-level information about an image.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_inspect_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Image name or id (required)
        :return: Image
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method image_inspect" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `image_inspect`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/images/{name}/json', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Image',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def image_list(self, **kwargs):  # noqa: E501
        """List Images  # noqa: E501

        Returns a list of images on the server. Note that it uses a different, smaller representation of an image than inspecting a single image.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool all: Show all images. Only images from a final layer (no children) are shown by default.
        :param str filters: A JSON encoded value of the filters (a `map[string][]string`) to process on the images list.  Available filters:  - `before`=(`<image-name>[:<tag>]`,  `<image id>` or `<image@digest>`) - `dangling=true` - `label=key` or `label=\"key=value\"` of an image label - `reference`=(`<image-name>[:<tag>]`) - `since`=(`<image-name>[:<tag>]`,  `<image id>` or `<image@digest>`) 
        :param bool shared_size: Compute and show shared size as a `SharedSize` field on each image.
        :param bool digests: Show digest information as a `RepoDigests` field on each image.
        :return: list[ImageSummary]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.image_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.image_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def image_list_with_http_info(self, **kwargs):  # noqa: E501
        """List Images  # noqa: E501

        Returns a list of images on the server. Note that it uses a different, smaller representation of an image than inspecting a single image.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool all: Show all images. Only images from a final layer (no children) are shown by default.
        :param str filters: A JSON encoded value of the filters (a `map[string][]string`) to process on the images list.  Available filters:  - `before`=(`<image-name>[:<tag>]`,  `<image id>` or `<image@digest>`) - `dangling=true` - `label=key` or `label=\"key=value\"` of an image label - `reference`=(`<image-name>[:<tag>]`) - `since`=(`<image-name>[:<tag>]`,  `<image id>` or `<image@digest>`) 
        :param bool shared_size: Compute and show shared size as a `SharedSize` field on each image.
        :param bool digests: Show digest information as a `RepoDigests` field on each image.
        :return: list[ImageSummary]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['all', 'filters', 'shared_size', 'digests']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method image_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'all' in params:
            query_params.append(('all', params['all']))  # noqa: E501
        if 'filters' in params:
            query_params.append(('filters', params['filters']))  # noqa: E501
        if 'shared_size' in params:
            query_params.append(('shared-size', params['shared_size']))  # noqa: E501
        if 'digests' in params:
            query_params.append(('digests', params['digests']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/images/json', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ImageSummary]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def image_load(self, **kwargs):  # noqa: E501
        """Import images  # noqa: E501

        Load a set of images and tags into a repository.  For details on the format, see the [export image endpoint](#operation/ImageGet).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_load(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str images_tarball: Tar archive containing images
        :param bool quiet: Suppress progress details during load.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.image_load_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.image_load_with_http_info(**kwargs)  # noqa: E501
            return data

    def image_load_with_http_info(self, **kwargs):  # noqa: E501
        """Import images  # noqa: E501

        Load a set of images and tags into a repository.  For details on the format, see the [export image endpoint](#operation/ImageGet).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_load_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str images_tarball: Tar archive containing images
        :param bool quiet: Suppress progress details during load.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['images_tarball', 'quiet']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method image_load" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'quiet' in params:
            query_params.append(('quiet', params['quiet']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'images_tarball' in params:
            body_params = params['images_tarball']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/x-tar'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/images/load', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def image_prune(self, **kwargs):  # noqa: E501
        """Delete unused images  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_prune(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filters: Filters to process on the prune list, encoded as JSON (a `map[string][]string`). Available filters:  - `dangling=<boolean>` When set to `true` (or `1`), prune only    unused *and* untagged images. When set to `false`    (or `0`), all unused images are pruned. - `until=<string>` Prune images created before this timestamp. The `<timestamp>` can be Unix timestamps, date formatted timestamps, or Go duration strings (e.g. `10m`, `1h30m`) computed relative to the daemon machine’s time. - `label` (`label=<key>`, `label=<key>=<value>`, `label!=<key>`, or `label!=<key>=<value>`) Prune images with (or without, in case `label!=...` is used) the specified labels. 
        :return: ImagePruneResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.image_prune_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.image_prune_with_http_info(**kwargs)  # noqa: E501
            return data

    def image_prune_with_http_info(self, **kwargs):  # noqa: E501
        """Delete unused images  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_prune_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filters: Filters to process on the prune list, encoded as JSON (a `map[string][]string`). Available filters:  - `dangling=<boolean>` When set to `true` (or `1`), prune only    unused *and* untagged images. When set to `false`    (or `0`), all unused images are pruned. - `until=<string>` Prune images created before this timestamp. The `<timestamp>` can be Unix timestamps, date formatted timestamps, or Go duration strings (e.g. `10m`, `1h30m`) computed relative to the daemon machine’s time. - `label` (`label=<key>`, `label=<key>=<value>`, `label!=<key>`, or `label!=<key>=<value>`) Prune images with (or without, in case `label!=...` is used) the specified labels. 
        :return: ImagePruneResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filters']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method image_prune" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filters' in params:
            query_params.append(('filters', params['filters']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/images/prune', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImagePruneResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def image_push(self, name, x_registry_auth, **kwargs):  # noqa: E501
        """Push an image  # noqa: E501

        Push an image to a registry.  If you wish to push an image on to a private registry, that image must already have a tag which references the registry. For example, `registry.example.com/myimage:latest`.  The push is cancelled if the HTTP connection is closed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_push(name, x_registry_auth, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Image name or ID. (required)
        :param str x_registry_auth: A base64url-encoded auth configuration.  Refer to the [authentication section](#section/Authentication) for details.  (required)
        :param str tag: The tag to associate with the image on the registry.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.image_push_with_http_info(name, x_registry_auth, **kwargs)  # noqa: E501
        else:
            (data) = self.image_push_with_http_info(name, x_registry_auth, **kwargs)  # noqa: E501
            return data

    def image_push_with_http_info(self, name, x_registry_auth, **kwargs):  # noqa: E501
        """Push an image  # noqa: E501

        Push an image to a registry.  If you wish to push an image on to a private registry, that image must already have a tag which references the registry. For example, `registry.example.com/myimage:latest`.  The push is cancelled if the HTTP connection is closed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_push_with_http_info(name, x_registry_auth, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Image name or ID. (required)
        :param str x_registry_auth: A base64url-encoded auth configuration.  Refer to the [authentication section](#section/Authentication) for details.  (required)
        :param str tag: The tag to associate with the image on the registry.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'x_registry_auth', 'tag']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method image_push" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `image_push`")  # noqa: E501
        # verify the required parameter 'x_registry_auth' is set
        if self.api_client.client_side_validation and ('x_registry_auth' not in params or
                                                       params['x_registry_auth'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `x_registry_auth` when calling `image_push`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501

        header_params = {}
        if 'x_registry_auth' in params:
            header_params['X-Registry-Auth'] = params['x_registry_auth']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/images/{name}/push', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def image_search(self, term, **kwargs):  # noqa: E501
        """Search images  # noqa: E501

        Search for an image on Docker Hub.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_search(term, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str term: Term to search (required)
        :param int limit: Maximum number of results to return
        :param str filters: A JSON encoded value of the filters (a `map[string][]string`) to process on the images list. Available filters:  - `is-automated=(true|false)` - `is-official=(true|false)` - `stars=<number>` Matches images that has at least 'number' stars. 
        :return: list[ImageSearchResponseItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.image_search_with_http_info(term, **kwargs)  # noqa: E501
        else:
            (data) = self.image_search_with_http_info(term, **kwargs)  # noqa: E501
            return data

    def image_search_with_http_info(self, term, **kwargs):  # noqa: E501
        """Search images  # noqa: E501

        Search for an image on Docker Hub.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_search_with_http_info(term, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str term: Term to search (required)
        :param int limit: Maximum number of results to return
        :param str filters: A JSON encoded value of the filters (a `map[string][]string`) to process on the images list. Available filters:  - `is-automated=(true|false)` - `is-official=(true|false)` - `stars=<number>` Matches images that has at least 'number' stars. 
        :return: list[ImageSearchResponseItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['term', 'limit', 'filters']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method image_search" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'term' is set
        if self.api_client.client_side_validation and ('term' not in params or
                                                       params['term'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `term` when calling `image_search`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'term' in params:
            query_params.append(('term', params['term']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'filters' in params:
            query_params.append(('filters', params['filters']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/images/search', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ImageSearchResponseItem]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def image_tag(self, name, **kwargs):  # noqa: E501
        """Tag an image  # noqa: E501

        Tag an image so that it becomes part of a repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_tag(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Image name or ID to tag. (required)
        :param str repo: The repository to tag in. For example, `someuser/someimage`.
        :param str tag: The name of the new tag.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.image_tag_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.image_tag_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def image_tag_with_http_info(self, name, **kwargs):  # noqa: E501
        """Tag an image  # noqa: E501

        Tag an image so that it becomes part of a repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.image_tag_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Image name or ID to tag. (required)
        :param str repo: The repository to tag in. For example, `someuser/someimage`.
        :param str tag: The name of the new tag.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'repo', 'tag']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method image_tag" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `image_tag`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'repo' in params:
            query_params.append(('repo', params['repo']))  # noqa: E501
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/images/{name}/tag', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
