# coding: utf-8

# flake8: noqa
"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

# import models into model package
from jgreenepack.models.address import Address
from jgreenepack.models.auth_config import AuthConfig
from jgreenepack.models.build_cache import BuildCache
from jgreenepack.models.build_info import BuildInfo
from jgreenepack.models.build_prune_response import BuildPruneResponse
from jgreenepack.models.cluster_info import ClusterInfo
from jgreenepack.models.commit import Commit
from jgreenepack.models.config import Config
from jgreenepack.models.config_spec import ConfigSpec
from jgreenepack.models.container_change_response_item import ContainerChangeResponseItem
from jgreenepack.models.container_config import ContainerConfig
from jgreenepack.models.container_create_response import ContainerCreateResponse
from jgreenepack.models.container_inspect_response import ContainerInspectResponse
from jgreenepack.models.container_prune_response import ContainerPruneResponse
from jgreenepack.models.container_state import ContainerState
from jgreenepack.models.container_summary import ContainerSummary
from jgreenepack.models.container_summary_host_config import ContainerSummaryHostConfig
from jgreenepack.models.container_summary_network_settings import ContainerSummaryNetworkSettings
from jgreenepack.models.container_top_response import ContainerTopResponse
from jgreenepack.models.container_update_response import ContainerUpdateResponse
from jgreenepack.models.container_wait_response import ContainerWaitResponse
from jgreenepack.models.container_wait_response_error import ContainerWaitResponseError
from jgreenepack.models.create_image_info import CreateImageInfo
from jgreenepack.models.device_mapping import DeviceMapping
from jgreenepack.models.device_request import DeviceRequest
from jgreenepack.models.distribution_inspect_response import DistributionInspectResponse
from jgreenepack.models.distribution_inspect_response_descriptor import DistributionInspectResponseDescriptor
from jgreenepack.models.distribution_inspect_response_platforms import DistributionInspectResponsePlatforms
from jgreenepack.models.driver import Driver
from jgreenepack.models.endpoint_ipam_config import EndpointIPAMConfig
from jgreenepack.models.endpoint_port_config import EndpointPortConfig
from jgreenepack.models.endpoint_settings import EndpointSettings
from jgreenepack.models.endpoint_spec import EndpointSpec
from jgreenepack.models.engine_description import EngineDescription
from jgreenepack.models.engine_description_plugins import EngineDescriptionPlugins
from jgreenepack.models.error_detail import ErrorDetail
from jgreenepack.models.error_response import ErrorResponse
from jgreenepack.models.exec_config import ExecConfig
from jgreenepack.models.exec_inspect_response import ExecInspectResponse
from jgreenepack.models.exec_start_config import ExecStartConfig
from jgreenepack.models.generic_resources import GenericResources
from jgreenepack.models.generic_resources_inner import GenericResourcesInner
from jgreenepack.models.generic_resources_inner_discrete_resource_spec import GenericResourcesInnerDiscreteResourceSpec
from jgreenepack.models.generic_resources_inner_named_resource_spec import GenericResourcesInnerNamedResourceSpec
from jgreenepack.models.graph_driver_data import GraphDriverData
from jgreenepack.models.health import Health
from jgreenepack.models.health_config import HealthConfig
from jgreenepack.models.healthcheck_result import HealthcheckResult
from jgreenepack.models.history_response_item import HistoryResponseItem
from jgreenepack.models.host_config import HostConfig
from jgreenepack.models.host_config_log_config import HostConfigLogConfig
from jgreenepack.models.ipam import IPAM
from jgreenepack.models.id_response import IdResponse
from jgreenepack.models.image import Image
from jgreenepack.models.image_delete_response_item import ImageDeleteResponseItem
from jgreenepack.models.image_id import ImageID
from jgreenepack.models.image_metadata import ImageMetadata
from jgreenepack.models.image_prune_response import ImagePruneResponse
from jgreenepack.models.image_root_fs import ImageRootFS
from jgreenepack.models.image_search_response_item import ImageSearchResponseItem
from jgreenepack.models.image_summary import ImageSummary
from jgreenepack.models.index_info import IndexInfo
from jgreenepack.models.inline_response400 import InlineResponse400
from jgreenepack.models.join_tokens import JoinTokens
from jgreenepack.models.limit import Limit
from jgreenepack.models.local_node_state import LocalNodeState
from jgreenepack.models.manager_status import ManagerStatus
from jgreenepack.models.mount import Mount
from jgreenepack.models.mount_bind_options import MountBindOptions
from jgreenepack.models.mount_point import MountPoint
from jgreenepack.models.mount_tmpfs_options import MountTmpfsOptions
from jgreenepack.models.mount_volume_options import MountVolumeOptions
from jgreenepack.models.mount_volume_options_driver_config import MountVolumeOptionsDriverConfig
from jgreenepack.models.network import Network
from jgreenepack.models.network_attachment_config import NetworkAttachmentConfig
from jgreenepack.models.network_connect_request import NetworkConnectRequest
from jgreenepack.models.network_container import NetworkContainer
from jgreenepack.models.network_create_request import NetworkCreateRequest
from jgreenepack.models.network_create_response import NetworkCreateResponse
from jgreenepack.models.network_disconnect_request import NetworkDisconnectRequest
from jgreenepack.models.network_prune_response import NetworkPruneResponse
from jgreenepack.models.network_settings import NetworkSettings
from jgreenepack.models.networking_config import NetworkingConfig
from jgreenepack.models.node import Node
from jgreenepack.models.node_description import NodeDescription
from jgreenepack.models.node_spec import NodeSpec
from jgreenepack.models.node_state import NodeState
from jgreenepack.models.node_status import NodeStatus
from jgreenepack.models.object_version import ObjectVersion
from jgreenepack.models.peer_node import PeerNode
from jgreenepack.models.platform import Platform
from jgreenepack.models.plugin import Plugin
from jgreenepack.models.plugin_config import PluginConfig
from jgreenepack.models.plugin_config_args import PluginConfigArgs
from jgreenepack.models.plugin_config_interface import PluginConfigInterface
from jgreenepack.models.plugin_config_linux import PluginConfigLinux
from jgreenepack.models.plugin_config_network import PluginConfigNetwork
from jgreenepack.models.plugin_config_rootfs import PluginConfigRootfs
from jgreenepack.models.plugin_config_user import PluginConfigUser
from jgreenepack.models.plugin_device import PluginDevice
from jgreenepack.models.plugin_env import PluginEnv
from jgreenepack.models.plugin_interface_type import PluginInterfaceType
from jgreenepack.models.plugin_mount import PluginMount
from jgreenepack.models.plugin_privilege_item import PluginPrivilegeItem
from jgreenepack.models.plugin_settings import PluginSettings
from jgreenepack.models.plugins_info import PluginsInfo
from jgreenepack.models.port import Port
from jgreenepack.models.port_binding import PortBinding
from jgreenepack.models.port_map import PortMap
from jgreenepack.models.process_config import ProcessConfig
from jgreenepack.models.progress_detail import ProgressDetail
from jgreenepack.models.push_image_info import PushImageInfo
from jgreenepack.models.reachability import Reachability
from jgreenepack.models.registry_service_config import RegistryServiceConfig
from jgreenepack.models.resource_object import ResourceObject
from jgreenepack.models.resources import Resources
from jgreenepack.models.resources_blkio_weight_device import ResourcesBlkioWeightDevice
from jgreenepack.models.resources_ulimits import ResourcesUlimits
from jgreenepack.models.restart_policy import RestartPolicy
from jgreenepack.models.runtime import Runtime
from jgreenepack.models.secret import Secret
from jgreenepack.models.secret_spec import SecretSpec
from jgreenepack.models.service import Service
from jgreenepack.models.service_create_response import ServiceCreateResponse
from jgreenepack.models.service_endpoint import ServiceEndpoint
from jgreenepack.models.service_endpoint_virtual_i_ps import ServiceEndpointVirtualIPs
from jgreenepack.models.service_job_status import ServiceJobStatus
from jgreenepack.models.service_service_status import ServiceServiceStatus
from jgreenepack.models.service_spec import ServiceSpec
from jgreenepack.models.service_spec_mode import ServiceSpecMode
from jgreenepack.models.service_spec_mode_replicated import ServiceSpecModeReplicated
from jgreenepack.models.service_spec_mode_replicated_job import ServiceSpecModeReplicatedJob
from jgreenepack.models.service_spec_rollback_config import ServiceSpecRollbackConfig
from jgreenepack.models.service_spec_update_config import ServiceSpecUpdateConfig
from jgreenepack.models.service_update_response import ServiceUpdateResponse
from jgreenepack.models.service_update_status import ServiceUpdateStatus
from jgreenepack.models.swarm import Swarm
from jgreenepack.models.swarm_info import SwarmInfo
from jgreenepack.models.swarm_init_request import SwarmInitRequest
from jgreenepack.models.swarm_join_request import SwarmJoinRequest
from jgreenepack.models.swarm_spec import SwarmSpec
from jgreenepack.models.swarm_spec_ca_config import SwarmSpecCAConfig
from jgreenepack.models.swarm_spec_ca_config_external_c_as import SwarmSpecCAConfigExternalCAs
from jgreenepack.models.swarm_spec_dispatcher import SwarmSpecDispatcher
from jgreenepack.models.swarm_spec_encryption_config import SwarmSpecEncryptionConfig
from jgreenepack.models.swarm_spec_orchestration import SwarmSpecOrchestration
from jgreenepack.models.swarm_spec_raft import SwarmSpecRaft
from jgreenepack.models.swarm_spec_task_defaults import SwarmSpecTaskDefaults
from jgreenepack.models.swarm_spec_task_defaults_log_driver import SwarmSpecTaskDefaultsLogDriver
from jgreenepack.models.swarm_unlock_request import SwarmUnlockRequest
from jgreenepack.models.system_auth_response import SystemAuthResponse
from jgreenepack.models.system_data_usage_response import SystemDataUsageResponse
from jgreenepack.models.system_events_response import SystemEventsResponse
from jgreenepack.models.system_events_response_actor import SystemEventsResponseActor
from jgreenepack.models.system_info import SystemInfo
from jgreenepack.models.system_info_default_address_pools import SystemInfoDefaultAddressPools
from jgreenepack.models.system_version import SystemVersion
from jgreenepack.models.system_version_components import SystemVersionComponents
from jgreenepack.models.system_version_platform import SystemVersionPlatform
from jgreenepack.models.tls_info import TLSInfo
from jgreenepack.models.task import Task
from jgreenepack.models.task_spec import TaskSpec
from jgreenepack.models.task_spec_container_spec import TaskSpecContainerSpec
from jgreenepack.models.task_spec_container_spec_configs import TaskSpecContainerSpecConfigs
from jgreenepack.models.task_spec_container_spec_dns_config import TaskSpecContainerSpecDNSConfig
from jgreenepack.models.task_spec_container_spec_file import TaskSpecContainerSpecFile
from jgreenepack.models.task_spec_container_spec_file1 import TaskSpecContainerSpecFile1
from jgreenepack.models.task_spec_container_spec_privileges import TaskSpecContainerSpecPrivileges
from jgreenepack.models.task_spec_container_spec_privileges_credential_spec import TaskSpecContainerSpecPrivilegesCredentialSpec
from jgreenepack.models.task_spec_container_spec_privileges_se_linux_context import TaskSpecContainerSpecPrivilegesSELinuxContext
from jgreenepack.models.task_spec_container_spec_secrets import TaskSpecContainerSpecSecrets
from jgreenepack.models.task_spec_log_driver import TaskSpecLogDriver
from jgreenepack.models.task_spec_network_attachment_spec import TaskSpecNetworkAttachmentSpec
from jgreenepack.models.task_spec_placement import TaskSpecPlacement
from jgreenepack.models.task_spec_placement_preferences import TaskSpecPlacementPreferences
from jgreenepack.models.task_spec_placement_spread import TaskSpecPlacementSpread
from jgreenepack.models.task_spec_plugin_spec import TaskSpecPluginSpec
from jgreenepack.models.task_spec_resources import TaskSpecResources
from jgreenepack.models.task_spec_restart_policy import TaskSpecRestartPolicy
from jgreenepack.models.task_state import TaskState
from jgreenepack.models.task_status import TaskStatus
from jgreenepack.models.task_status_container_status import TaskStatusContainerStatus
from jgreenepack.models.throttle_device import ThrottleDevice
from jgreenepack.models.unlock_key_response import UnlockKeyResponse
from jgreenepack.models.volume import Volume
from jgreenepack.models.volume_config import VolumeConfig
from jgreenepack.models.volume_list_response import VolumeListResponse
from jgreenepack.models.volume_prune_response import VolumePruneResponse
from jgreenepack.models.volume_usage_data import VolumeUsageData
