# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class BuildCache(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'parent': 'str',
        'type': 'str',
        'description': 'str',
        'in_use': 'bool',
        'shared': 'bool',
        'size': 'int',
        'created_at': 'str',
        'last_used_at': 'str',
        'usage_count': 'int'
    }

    attribute_map = {
        'id': 'ID',
        'parent': 'Parent',
        'type': 'Type',
        'description': 'Description',
        'in_use': 'InUse',
        'shared': 'Shared',
        'size': 'Size',
        'created_at': 'CreatedAt',
        'last_used_at': 'LastUsedAt',
        'usage_count': 'UsageCount'
    }

    def __init__(self, id=None, parent=None, type=None, description=None, in_use=None, shared=None, size=None, created_at=None, last_used_at=None, usage_count=None, _configuration=None):  # noqa: E501
        """BuildCache - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._id = None
        self._parent = None
        self._type = None
        self._description = None
        self._in_use = None
        self._shared = None
        self._size = None
        self._created_at = None
        self._last_used_at = None
        self._usage_count = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if parent is not None:
            self.parent = parent
        if type is not None:
            self.type = type
        if description is not None:
            self.description = description
        if in_use is not None:
            self.in_use = in_use
        if shared is not None:
            self.shared = shared
        if size is not None:
            self.size = size
        if created_at is not None:
            self.created_at = created_at
        if last_used_at is not None:
            self.last_used_at = last_used_at
        if usage_count is not None:
            self.usage_count = usage_count

    @property
    def id(self):
        """Gets the id of this BuildCache.  # noqa: E501


        :return: The id of this BuildCache.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BuildCache.


        :param id: The id of this BuildCache.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def parent(self):
        """Gets the parent of this BuildCache.  # noqa: E501


        :return: The parent of this BuildCache.  # noqa: E501
        :rtype: str
        """
        return self._parent

    @parent.setter
    def parent(self, parent):
        """Sets the parent of this BuildCache.


        :param parent: The parent of this BuildCache.  # noqa: E501
        :type: str
        """

        self._parent = parent

    @property
    def type(self):
        """Gets the type of this BuildCache.  # noqa: E501


        :return: The type of this BuildCache.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this BuildCache.


        :param type: The type of this BuildCache.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def description(self):
        """Gets the description of this BuildCache.  # noqa: E501


        :return: The description of this BuildCache.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this BuildCache.


        :param description: The description of this BuildCache.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def in_use(self):
        """Gets the in_use of this BuildCache.  # noqa: E501


        :return: The in_use of this BuildCache.  # noqa: E501
        :rtype: bool
        """
        return self._in_use

    @in_use.setter
    def in_use(self, in_use):
        """Sets the in_use of this BuildCache.


        :param in_use: The in_use of this BuildCache.  # noqa: E501
        :type: bool
        """

        self._in_use = in_use

    @property
    def shared(self):
        """Gets the shared of this BuildCache.  # noqa: E501


        :return: The shared of this BuildCache.  # noqa: E501
        :rtype: bool
        """
        return self._shared

    @shared.setter
    def shared(self, shared):
        """Sets the shared of this BuildCache.


        :param shared: The shared of this BuildCache.  # noqa: E501
        :type: bool
        """

        self._shared = shared

    @property
    def size(self):
        """Gets the size of this BuildCache.  # noqa: E501

        Amount of disk space used by the build cache (in bytes).   # noqa: E501

        :return: The size of this BuildCache.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this BuildCache.

        Amount of disk space used by the build cache (in bytes).   # noqa: E501

        :param size: The size of this BuildCache.  # noqa: E501
        :type: int
        """

        self._size = size

    @property
    def created_at(self):
        """Gets the created_at of this BuildCache.  # noqa: E501

        Date and time at which the build cache was created in [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format with nano-seconds.   # noqa: E501

        :return: The created_at of this BuildCache.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this BuildCache.

        Date and time at which the build cache was created in [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format with nano-seconds.   # noqa: E501

        :param created_at: The created_at of this BuildCache.  # noqa: E501
        :type: str
        """

        self._created_at = created_at

    @property
    def last_used_at(self):
        """Gets the last_used_at of this BuildCache.  # noqa: E501

        Date and time at which the build cache was last used in [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format with nano-seconds.   # noqa: E501

        :return: The last_used_at of this BuildCache.  # noqa: E501
        :rtype: str
        """
        return self._last_used_at

    @last_used_at.setter
    def last_used_at(self, last_used_at):
        """Sets the last_used_at of this BuildCache.

        Date and time at which the build cache was last used in [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format with nano-seconds.   # noqa: E501

        :param last_used_at: The last_used_at of this BuildCache.  # noqa: E501
        :type: str
        """

        self._last_used_at = last_used_at

    @property
    def usage_count(self):
        """Gets the usage_count of this BuildCache.  # noqa: E501


        :return: The usage_count of this BuildCache.  # noqa: E501
        :rtype: int
        """
        return self._usage_count

    @usage_count.setter
    def usage_count(self, usage_count):
        """Sets the usage_count of this BuildCache.


        :param usage_count: The usage_count of this BuildCache.  # noqa: E501
        :type: int
        """

        self._usage_count = usage_count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(BuildCache, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BuildCache):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BuildCache):
            return True

        return self.to_dict() != other.to_dict()
