# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class ClusterInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'version': 'ObjectVersion',
        'created_at': 'str',
        'updated_at': 'str',
        'spec': 'SwarmSpec',
        'tls_info': 'TLSInfo',
        'root_rotation_in_progress': 'bool',
        'data_path_port': 'int',
        'default_addr_pool': 'list[str]',
        'subnet_size': 'int'
    }

    attribute_map = {
        'id': 'ID',
        'version': 'Version',
        'created_at': 'CreatedAt',
        'updated_at': 'UpdatedAt',
        'spec': 'Spec',
        'tls_info': 'TLSInfo',
        'root_rotation_in_progress': 'RootRotationInProgress',
        'data_path_port': 'DataPathPort',
        'default_addr_pool': 'DefaultAddrPool',
        'subnet_size': 'SubnetSize'
    }

    def __init__(self, id=None, version=None, created_at=None, updated_at=None, spec=None, tls_info=None, root_rotation_in_progress=None, data_path_port=None, default_addr_pool=None, subnet_size=None, _configuration=None):  # noqa: E501
        """ClusterInfo - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._id = None
        self._version = None
        self._created_at = None
        self._updated_at = None
        self._spec = None
        self._tls_info = None
        self._root_rotation_in_progress = None
        self._data_path_port = None
        self._default_addr_pool = None
        self._subnet_size = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if version is not None:
            self.version = version
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if spec is not None:
            self.spec = spec
        if tls_info is not None:
            self.tls_info = tls_info
        if root_rotation_in_progress is not None:
            self.root_rotation_in_progress = root_rotation_in_progress
        if data_path_port is not None:
            self.data_path_port = data_path_port
        if default_addr_pool is not None:
            self.default_addr_pool = default_addr_pool
        if subnet_size is not None:
            self.subnet_size = subnet_size

    @property
    def id(self):
        """Gets the id of this ClusterInfo.  # noqa: E501

        The ID of the swarm.  # noqa: E501

        :return: The id of this ClusterInfo.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ClusterInfo.

        The ID of the swarm.  # noqa: E501

        :param id: The id of this ClusterInfo.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def version(self):
        """Gets the version of this ClusterInfo.  # noqa: E501


        :return: The version of this ClusterInfo.  # noqa: E501
        :rtype: ObjectVersion
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this ClusterInfo.


        :param version: The version of this ClusterInfo.  # noqa: E501
        :type: ObjectVersion
        """

        self._version = version

    @property
    def created_at(self):
        """Gets the created_at of this ClusterInfo.  # noqa: E501

        Date and time at which the swarm was initialised in [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format with nano-seconds.   # noqa: E501

        :return: The created_at of this ClusterInfo.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this ClusterInfo.

        Date and time at which the swarm was initialised in [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format with nano-seconds.   # noqa: E501

        :param created_at: The created_at of this ClusterInfo.  # noqa: E501
        :type: str
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this ClusterInfo.  # noqa: E501

        Date and time at which the swarm was last updated in [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format with nano-seconds.   # noqa: E501

        :return: The updated_at of this ClusterInfo.  # noqa: E501
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this ClusterInfo.

        Date and time at which the swarm was last updated in [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format with nano-seconds.   # noqa: E501

        :param updated_at: The updated_at of this ClusterInfo.  # noqa: E501
        :type: str
        """

        self._updated_at = updated_at

    @property
    def spec(self):
        """Gets the spec of this ClusterInfo.  # noqa: E501


        :return: The spec of this ClusterInfo.  # noqa: E501
        :rtype: SwarmSpec
        """
        return self._spec

    @spec.setter
    def spec(self, spec):
        """Sets the spec of this ClusterInfo.


        :param spec: The spec of this ClusterInfo.  # noqa: E501
        :type: SwarmSpec
        """

        self._spec = spec

    @property
    def tls_info(self):
        """Gets the tls_info of this ClusterInfo.  # noqa: E501


        :return: The tls_info of this ClusterInfo.  # noqa: E501
        :rtype: TLSInfo
        """
        return self._tls_info

    @tls_info.setter
    def tls_info(self, tls_info):
        """Sets the tls_info of this ClusterInfo.


        :param tls_info: The tls_info of this ClusterInfo.  # noqa: E501
        :type: TLSInfo
        """

        self._tls_info = tls_info

    @property
    def root_rotation_in_progress(self):
        """Gets the root_rotation_in_progress of this ClusterInfo.  # noqa: E501

        Whether there is currently a root CA rotation in progress for the swarm   # noqa: E501

        :return: The root_rotation_in_progress of this ClusterInfo.  # noqa: E501
        :rtype: bool
        """
        return self._root_rotation_in_progress

    @root_rotation_in_progress.setter
    def root_rotation_in_progress(self, root_rotation_in_progress):
        """Sets the root_rotation_in_progress of this ClusterInfo.

        Whether there is currently a root CA rotation in progress for the swarm   # noqa: E501

        :param root_rotation_in_progress: The root_rotation_in_progress of this ClusterInfo.  # noqa: E501
        :type: bool
        """

        self._root_rotation_in_progress = root_rotation_in_progress

    @property
    def data_path_port(self):
        """Gets the data_path_port of this ClusterInfo.  # noqa: E501

        DataPathPort specifies the data path port number for data traffic. Acceptable port range is 1024 to 49151. If no port is set or is set to 0, the default port (4789) is used.   # noqa: E501

        :return: The data_path_port of this ClusterInfo.  # noqa: E501
        :rtype: int
        """
        return self._data_path_port

    @data_path_port.setter
    def data_path_port(self, data_path_port):
        """Sets the data_path_port of this ClusterInfo.

        DataPathPort specifies the data path port number for data traffic. Acceptable port range is 1024 to 49151. If no port is set or is set to 0, the default port (4789) is used.   # noqa: E501

        :param data_path_port: The data_path_port of this ClusterInfo.  # noqa: E501
        :type: int
        """

        self._data_path_port = data_path_port

    @property
    def default_addr_pool(self):
        """Gets the default_addr_pool of this ClusterInfo.  # noqa: E501

        Default Address Pool specifies default subnet pools for global scope networks.   # noqa: E501

        :return: The default_addr_pool of this ClusterInfo.  # noqa: E501
        :rtype: list[str]
        """
        return self._default_addr_pool

    @default_addr_pool.setter
    def default_addr_pool(self, default_addr_pool):
        """Sets the default_addr_pool of this ClusterInfo.

        Default Address Pool specifies default subnet pools for global scope networks.   # noqa: E501

        :param default_addr_pool: The default_addr_pool of this ClusterInfo.  # noqa: E501
        :type: list[str]
        """

        self._default_addr_pool = default_addr_pool

    @property
    def subnet_size(self):
        """Gets the subnet_size of this ClusterInfo.  # noqa: E501

        SubnetSize specifies the subnet size of the networks created from the default subnet pool.   # noqa: E501

        :return: The subnet_size of this ClusterInfo.  # noqa: E501
        :rtype: int
        """
        return self._subnet_size

    @subnet_size.setter
    def subnet_size(self, subnet_size):
        """Sets the subnet_size of this ClusterInfo.

        SubnetSize specifies the subnet size of the networks created from the default subnet pool.   # noqa: E501

        :param subnet_size: The subnet_size of this ClusterInfo.  # noqa: E501
        :type: int
        """
        if (self._configuration.client_side_validation and
                subnet_size is not None and subnet_size > 29):  # noqa: E501
            raise ValueError("Invalid value for `subnet_size`, must be a value less than or equal to `29`")  # noqa: E501

        self._subnet_size = subnet_size

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ClusterInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ClusterInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ClusterInfo):
            return True

        return self.to_dict() != other.to_dict()
