# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class ContainerConfig(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'hostname': 'str',
        'domainname': 'str',
        'user': 'str',
        'attach_stdin': 'bool',
        'attach_stdout': 'bool',
        'attach_stderr': 'bool',
        'exposed_ports': 'dict(str, object)',
        'tty': 'bool',
        'open_stdin': 'bool',
        'stdin_once': 'bool',
        'env': 'list[str]',
        'cmd': 'list[str]',
        'healthcheck': 'HealthConfig',
        'args_escaped': 'bool',
        'image': 'str',
        'volumes': 'dict(str, object)',
        'working_dir': 'str',
        'entrypoint': 'list[str]',
        'network_disabled': 'bool',
        'mac_address': 'str',
        'on_build': 'list[str]',
        'labels': 'dict(str, str)',
        'stop_signal': 'str',
        'stop_timeout': 'int',
        'shell': 'list[str]'
    }

    attribute_map = {
        'hostname': 'Hostname',
        'domainname': 'Domainname',
        'user': 'User',
        'attach_stdin': 'AttachStdin',
        'attach_stdout': 'AttachStdout',
        'attach_stderr': 'AttachStderr',
        'exposed_ports': 'ExposedPorts',
        'tty': 'Tty',
        'open_stdin': 'OpenStdin',
        'stdin_once': 'StdinOnce',
        'env': 'Env',
        'cmd': 'Cmd',
        'healthcheck': 'Healthcheck',
        'args_escaped': 'ArgsEscaped',
        'image': 'Image',
        'volumes': 'Volumes',
        'working_dir': 'WorkingDir',
        'entrypoint': 'Entrypoint',
        'network_disabled': 'NetworkDisabled',
        'mac_address': 'MacAddress',
        'on_build': 'OnBuild',
        'labels': 'Labels',
        'stop_signal': 'StopSignal',
        'stop_timeout': 'StopTimeout',
        'shell': 'Shell'
    }

    def __init__(self, hostname=None, domainname=None, user=None, attach_stdin=False, attach_stdout=True, attach_stderr=True, exposed_ports=None, tty=False, open_stdin=False, stdin_once=False, env=None, cmd=None, healthcheck=None, args_escaped=None, image=None, volumes=None, working_dir=None, entrypoint=None, network_disabled=None, mac_address=None, on_build=None, labels=None, stop_signal='SIGTERM', stop_timeout=None, shell=None, _configuration=None):  # noqa: E501
        """ContainerConfig - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._hostname = None
        self._domainname = None
        self._user = None
        self._attach_stdin = None
        self._attach_stdout = None
        self._attach_stderr = None
        self._exposed_ports = None
        self._tty = None
        self._open_stdin = None
        self._stdin_once = None
        self._env = None
        self._cmd = None
        self._healthcheck = None
        self._args_escaped = None
        self._image = None
        self._volumes = None
        self._working_dir = None
        self._entrypoint = None
        self._network_disabled = None
        self._mac_address = None
        self._on_build = None
        self._labels = None
        self._stop_signal = None
        self._stop_timeout = None
        self._shell = None
        self.discriminator = None

        if hostname is not None:
            self.hostname = hostname
        if domainname is not None:
            self.domainname = domainname
        if user is not None:
            self.user = user
        if attach_stdin is not None:
            self.attach_stdin = attach_stdin
        if attach_stdout is not None:
            self.attach_stdout = attach_stdout
        if attach_stderr is not None:
            self.attach_stderr = attach_stderr
        if exposed_ports is not None:
            self.exposed_ports = exposed_ports
        if tty is not None:
            self.tty = tty
        if open_stdin is not None:
            self.open_stdin = open_stdin
        if stdin_once is not None:
            self.stdin_once = stdin_once
        if env is not None:
            self.env = env
        if cmd is not None:
            self.cmd = cmd
        if healthcheck is not None:
            self.healthcheck = healthcheck
        if args_escaped is not None:
            self.args_escaped = args_escaped
        if image is not None:
            self.image = image
        if volumes is not None:
            self.volumes = volumes
        if working_dir is not None:
            self.working_dir = working_dir
        if entrypoint is not None:
            self.entrypoint = entrypoint
        if network_disabled is not None:
            self.network_disabled = network_disabled
        if mac_address is not None:
            self.mac_address = mac_address
        if on_build is not None:
            self.on_build = on_build
        if labels is not None:
            self.labels = labels
        if stop_signal is not None:
            self.stop_signal = stop_signal
        if stop_timeout is not None:
            self.stop_timeout = stop_timeout
        if shell is not None:
            self.shell = shell

    @property
    def hostname(self):
        """Gets the hostname of this ContainerConfig.  # noqa: E501

        The hostname to use for the container, as a valid RFC 1123 hostname.  # noqa: E501

        :return: The hostname of this ContainerConfig.  # noqa: E501
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """Sets the hostname of this ContainerConfig.

        The hostname to use for the container, as a valid RFC 1123 hostname.  # noqa: E501

        :param hostname: The hostname of this ContainerConfig.  # noqa: E501
        :type: str
        """

        self._hostname = hostname

    @property
    def domainname(self):
        """Gets the domainname of this ContainerConfig.  # noqa: E501

        The domain name to use for the container.  # noqa: E501

        :return: The domainname of this ContainerConfig.  # noqa: E501
        :rtype: str
        """
        return self._domainname

    @domainname.setter
    def domainname(self, domainname):
        """Sets the domainname of this ContainerConfig.

        The domain name to use for the container.  # noqa: E501

        :param domainname: The domainname of this ContainerConfig.  # noqa: E501
        :type: str
        """

        self._domainname = domainname

    @property
    def user(self):
        """Gets the user of this ContainerConfig.  # noqa: E501

        The user that commands are run as inside the container.  # noqa: E501

        :return: The user of this ContainerConfig.  # noqa: E501
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this ContainerConfig.

        The user that commands are run as inside the container.  # noqa: E501

        :param user: The user of this ContainerConfig.  # noqa: E501
        :type: str
        """

        self._user = user

    @property
    def attach_stdin(self):
        """Gets the attach_stdin of this ContainerConfig.  # noqa: E501

        Whether to attach to `stdin`.  # noqa: E501

        :return: The attach_stdin of this ContainerConfig.  # noqa: E501
        :rtype: bool
        """
        return self._attach_stdin

    @attach_stdin.setter
    def attach_stdin(self, attach_stdin):
        """Sets the attach_stdin of this ContainerConfig.

        Whether to attach to `stdin`.  # noqa: E501

        :param attach_stdin: The attach_stdin of this ContainerConfig.  # noqa: E501
        :type: bool
        """

        self._attach_stdin = attach_stdin

    @property
    def attach_stdout(self):
        """Gets the attach_stdout of this ContainerConfig.  # noqa: E501

        Whether to attach to `stdout`.  # noqa: E501

        :return: The attach_stdout of this ContainerConfig.  # noqa: E501
        :rtype: bool
        """
        return self._attach_stdout

    @attach_stdout.setter
    def attach_stdout(self, attach_stdout):
        """Sets the attach_stdout of this ContainerConfig.

        Whether to attach to `stdout`.  # noqa: E501

        :param attach_stdout: The attach_stdout of this ContainerConfig.  # noqa: E501
        :type: bool
        """

        self._attach_stdout = attach_stdout

    @property
    def attach_stderr(self):
        """Gets the attach_stderr of this ContainerConfig.  # noqa: E501

        Whether to attach to `stderr`.  # noqa: E501

        :return: The attach_stderr of this ContainerConfig.  # noqa: E501
        :rtype: bool
        """
        return self._attach_stderr

    @attach_stderr.setter
    def attach_stderr(self, attach_stderr):
        """Sets the attach_stderr of this ContainerConfig.

        Whether to attach to `stderr`.  # noqa: E501

        :param attach_stderr: The attach_stderr of this ContainerConfig.  # noqa: E501
        :type: bool
        """

        self._attach_stderr = attach_stderr

    @property
    def exposed_ports(self):
        """Gets the exposed_ports of this ContainerConfig.  # noqa: E501

        An object mapping ports to an empty object in the form:  `{\"<port>/<tcp|udp|sctp>\": {}}`   # noqa: E501

        :return: The exposed_ports of this ContainerConfig.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._exposed_ports

    @exposed_ports.setter
    def exposed_ports(self, exposed_ports):
        """Sets the exposed_ports of this ContainerConfig.

        An object mapping ports to an empty object in the form:  `{\"<port>/<tcp|udp|sctp>\": {}}`   # noqa: E501

        :param exposed_ports: The exposed_ports of this ContainerConfig.  # noqa: E501
        :type: dict(str, object)
        """

        self._exposed_ports = exposed_ports

    @property
    def tty(self):
        """Gets the tty of this ContainerConfig.  # noqa: E501

        Attach standard streams to a TTY, including `stdin` if it is not closed.   # noqa: E501

        :return: The tty of this ContainerConfig.  # noqa: E501
        :rtype: bool
        """
        return self._tty

    @tty.setter
    def tty(self, tty):
        """Sets the tty of this ContainerConfig.

        Attach standard streams to a TTY, including `stdin` if it is not closed.   # noqa: E501

        :param tty: The tty of this ContainerConfig.  # noqa: E501
        :type: bool
        """

        self._tty = tty

    @property
    def open_stdin(self):
        """Gets the open_stdin of this ContainerConfig.  # noqa: E501

        Open `stdin`  # noqa: E501

        :return: The open_stdin of this ContainerConfig.  # noqa: E501
        :rtype: bool
        """
        return self._open_stdin

    @open_stdin.setter
    def open_stdin(self, open_stdin):
        """Sets the open_stdin of this ContainerConfig.

        Open `stdin`  # noqa: E501

        :param open_stdin: The open_stdin of this ContainerConfig.  # noqa: E501
        :type: bool
        """

        self._open_stdin = open_stdin

    @property
    def stdin_once(self):
        """Gets the stdin_once of this ContainerConfig.  # noqa: E501

        Close `stdin` after one attached client disconnects  # noqa: E501

        :return: The stdin_once of this ContainerConfig.  # noqa: E501
        :rtype: bool
        """
        return self._stdin_once

    @stdin_once.setter
    def stdin_once(self, stdin_once):
        """Sets the stdin_once of this ContainerConfig.

        Close `stdin` after one attached client disconnects  # noqa: E501

        :param stdin_once: The stdin_once of this ContainerConfig.  # noqa: E501
        :type: bool
        """

        self._stdin_once = stdin_once

    @property
    def env(self):
        """Gets the env of this ContainerConfig.  # noqa: E501

        A list of environment variables to set inside the container in the form `[\"VAR=value\", ...]`. A variable without `=` is removed from the environment, rather than to have an empty value.   # noqa: E501

        :return: The env of this ContainerConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._env

    @env.setter
    def env(self, env):
        """Sets the env of this ContainerConfig.

        A list of environment variables to set inside the container in the form `[\"VAR=value\", ...]`. A variable without `=` is removed from the environment, rather than to have an empty value.   # noqa: E501

        :param env: The env of this ContainerConfig.  # noqa: E501
        :type: list[str]
        """

        self._env = env

    @property
    def cmd(self):
        """Gets the cmd of this ContainerConfig.  # noqa: E501

        Command to run specified as a string or an array of strings.   # noqa: E501

        :return: The cmd of this ContainerConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._cmd

    @cmd.setter
    def cmd(self, cmd):
        """Sets the cmd of this ContainerConfig.

        Command to run specified as a string or an array of strings.   # noqa: E501

        :param cmd: The cmd of this ContainerConfig.  # noqa: E501
        :type: list[str]
        """

        self._cmd = cmd

    @property
    def healthcheck(self):
        """Gets the healthcheck of this ContainerConfig.  # noqa: E501


        :return: The healthcheck of this ContainerConfig.  # noqa: E501
        :rtype: HealthConfig
        """
        return self._healthcheck

    @healthcheck.setter
    def healthcheck(self, healthcheck):
        """Sets the healthcheck of this ContainerConfig.


        :param healthcheck: The healthcheck of this ContainerConfig.  # noqa: E501
        :type: HealthConfig
        """

        self._healthcheck = healthcheck

    @property
    def args_escaped(self):
        """Gets the args_escaped of this ContainerConfig.  # noqa: E501

        Command is already escaped (Windows only)  # noqa: E501

        :return: The args_escaped of this ContainerConfig.  # noqa: E501
        :rtype: bool
        """
        return self._args_escaped

    @args_escaped.setter
    def args_escaped(self, args_escaped):
        """Sets the args_escaped of this ContainerConfig.

        Command is already escaped (Windows only)  # noqa: E501

        :param args_escaped: The args_escaped of this ContainerConfig.  # noqa: E501
        :type: bool
        """

        self._args_escaped = args_escaped

    @property
    def image(self):
        """Gets the image of this ContainerConfig.  # noqa: E501

        The name of the image to use when creating the container/   # noqa: E501

        :return: The image of this ContainerConfig.  # noqa: E501
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this ContainerConfig.

        The name of the image to use when creating the container/   # noqa: E501

        :param image: The image of this ContainerConfig.  # noqa: E501
        :type: str
        """

        self._image = image

    @property
    def volumes(self):
        """Gets the volumes of this ContainerConfig.  # noqa: E501

        An object mapping mount point paths inside the container to empty objects.   # noqa: E501

        :return: The volumes of this ContainerConfig.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._volumes

    @volumes.setter
    def volumes(self, volumes):
        """Sets the volumes of this ContainerConfig.

        An object mapping mount point paths inside the container to empty objects.   # noqa: E501

        :param volumes: The volumes of this ContainerConfig.  # noqa: E501
        :type: dict(str, object)
        """

        self._volumes = volumes

    @property
    def working_dir(self):
        """Gets the working_dir of this ContainerConfig.  # noqa: E501

        The working directory for commands to run in.  # noqa: E501

        :return: The working_dir of this ContainerConfig.  # noqa: E501
        :rtype: str
        """
        return self._working_dir

    @working_dir.setter
    def working_dir(self, working_dir):
        """Sets the working_dir of this ContainerConfig.

        The working directory for commands to run in.  # noqa: E501

        :param working_dir: The working_dir of this ContainerConfig.  # noqa: E501
        :type: str
        """

        self._working_dir = working_dir

    @property
    def entrypoint(self):
        """Gets the entrypoint of this ContainerConfig.  # noqa: E501

        The entry point for the container as a string or an array of strings.  If the array consists of exactly one empty string (`[\"\"]`) then the entry point is reset to system default (i.e., the entry point used by docker when there is no `ENTRYPOINT` instruction in the `Dockerfile`).   # noqa: E501

        :return: The entrypoint of this ContainerConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._entrypoint

    @entrypoint.setter
    def entrypoint(self, entrypoint):
        """Sets the entrypoint of this ContainerConfig.

        The entry point for the container as a string or an array of strings.  If the array consists of exactly one empty string (`[\"\"]`) then the entry point is reset to system default (i.e., the entry point used by docker when there is no `ENTRYPOINT` instruction in the `Dockerfile`).   # noqa: E501

        :param entrypoint: The entrypoint of this ContainerConfig.  # noqa: E501
        :type: list[str]
        """

        self._entrypoint = entrypoint

    @property
    def network_disabled(self):
        """Gets the network_disabled of this ContainerConfig.  # noqa: E501

        Disable networking for the container.  # noqa: E501

        :return: The network_disabled of this ContainerConfig.  # noqa: E501
        :rtype: bool
        """
        return self._network_disabled

    @network_disabled.setter
    def network_disabled(self, network_disabled):
        """Sets the network_disabled of this ContainerConfig.

        Disable networking for the container.  # noqa: E501

        :param network_disabled: The network_disabled of this ContainerConfig.  # noqa: E501
        :type: bool
        """

        self._network_disabled = network_disabled

    @property
    def mac_address(self):
        """Gets the mac_address of this ContainerConfig.  # noqa: E501

        MAC address of the container.  # noqa: E501

        :return: The mac_address of this ContainerConfig.  # noqa: E501
        :rtype: str
        """
        return self._mac_address

    @mac_address.setter
    def mac_address(self, mac_address):
        """Sets the mac_address of this ContainerConfig.

        MAC address of the container.  # noqa: E501

        :param mac_address: The mac_address of this ContainerConfig.  # noqa: E501
        :type: str
        """

        self._mac_address = mac_address

    @property
    def on_build(self):
        """Gets the on_build of this ContainerConfig.  # noqa: E501

        `ONBUILD` metadata that were defined in the image's `Dockerfile`.   # noqa: E501

        :return: The on_build of this ContainerConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._on_build

    @on_build.setter
    def on_build(self, on_build):
        """Sets the on_build of this ContainerConfig.

        `ONBUILD` metadata that were defined in the image's `Dockerfile`.   # noqa: E501

        :param on_build: The on_build of this ContainerConfig.  # noqa: E501
        :type: list[str]
        """

        self._on_build = on_build

    @property
    def labels(self):
        """Gets the labels of this ContainerConfig.  # noqa: E501

        User-defined key/value metadata.  # noqa: E501

        :return: The labels of this ContainerConfig.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this ContainerConfig.

        User-defined key/value metadata.  # noqa: E501

        :param labels: The labels of this ContainerConfig.  # noqa: E501
        :type: dict(str, str)
        """

        self._labels = labels

    @property
    def stop_signal(self):
        """Gets the stop_signal of this ContainerConfig.  # noqa: E501

        Signal to stop a container as a string or unsigned integer.   # noqa: E501

        :return: The stop_signal of this ContainerConfig.  # noqa: E501
        :rtype: str
        """
        return self._stop_signal

    @stop_signal.setter
    def stop_signal(self, stop_signal):
        """Sets the stop_signal of this ContainerConfig.

        Signal to stop a container as a string or unsigned integer.   # noqa: E501

        :param stop_signal: The stop_signal of this ContainerConfig.  # noqa: E501
        :type: str
        """

        self._stop_signal = stop_signal

    @property
    def stop_timeout(self):
        """Gets the stop_timeout of this ContainerConfig.  # noqa: E501

        Timeout to stop a container in seconds.  # noqa: E501

        :return: The stop_timeout of this ContainerConfig.  # noqa: E501
        :rtype: int
        """
        return self._stop_timeout

    @stop_timeout.setter
    def stop_timeout(self, stop_timeout):
        """Sets the stop_timeout of this ContainerConfig.

        Timeout to stop a container in seconds.  # noqa: E501

        :param stop_timeout: The stop_timeout of this ContainerConfig.  # noqa: E501
        :type: int
        """

        self._stop_timeout = stop_timeout

    @property
    def shell(self):
        """Gets the shell of this ContainerConfig.  # noqa: E501

        Shell for when `RUN`, `CMD`, and `ENTRYPOINT` uses a shell.   # noqa: E501

        :return: The shell of this ContainerConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._shell

    @shell.setter
    def shell(self, shell):
        """Sets the shell of this ContainerConfig.

        Shell for when `RUN`, `CMD`, and `ENTRYPOINT` uses a shell.   # noqa: E501

        :param shell: The shell of this ContainerConfig.  # noqa: E501
        :type: list[str]
        """

        self._shell = shell

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ContainerConfig, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ContainerConfig):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ContainerConfig):
            return True

        return self.to_dict() != other.to_dict()
