# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class ContainerInspectResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'created': 'str',
        'path': 'str',
        'args': 'list[str]',
        'state': 'ContainerState',
        'image': 'str',
        'resolv_conf_path': 'str',
        'hostname_path': 'str',
        'hosts_path': 'str',
        'log_path': 'str',
        'name': 'str',
        'restart_count': 'int',
        'driver': 'str',
        'platform': 'str',
        'mount_label': 'str',
        'process_label': 'str',
        'app_armor_profile': 'str',
        'exec_i_ds': 'list[str]',
        'host_config': 'HostConfig',
        'graph_driver': 'GraphDriverData',
        'size_rw': 'int',
        'size_root_fs': 'int',
        'mounts': 'list[MountPoint]',
        'config': 'ContainerConfig',
        'network_settings': 'NetworkSettings'
    }

    attribute_map = {
        'id': 'Id',
        'created': 'Created',
        'path': 'Path',
        'args': 'Args',
        'state': 'State',
        'image': 'Image',
        'resolv_conf_path': 'ResolvConfPath',
        'hostname_path': 'HostnamePath',
        'hosts_path': 'HostsPath',
        'log_path': 'LogPath',
        'name': 'Name',
        'restart_count': 'RestartCount',
        'driver': 'Driver',
        'platform': 'Platform',
        'mount_label': 'MountLabel',
        'process_label': 'ProcessLabel',
        'app_armor_profile': 'AppArmorProfile',
        'exec_i_ds': 'ExecIDs',
        'host_config': 'HostConfig',
        'graph_driver': 'GraphDriver',
        'size_rw': 'SizeRw',
        'size_root_fs': 'SizeRootFs',
        'mounts': 'Mounts',
        'config': 'Config',
        'network_settings': 'NetworkSettings'
    }

    def __init__(self, id=None, created=None, path=None, args=None, state=None, image=None, resolv_conf_path=None, hostname_path=None, hosts_path=None, log_path=None, name=None, restart_count=None, driver=None, platform=None, mount_label=None, process_label=None, app_armor_profile=None, exec_i_ds=None, host_config=None, graph_driver=None, size_rw=None, size_root_fs=None, mounts=None, config=None, network_settings=None, _configuration=None):  # noqa: E501
        """ContainerInspectResponse - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._id = None
        self._created = None
        self._path = None
        self._args = None
        self._state = None
        self._image = None
        self._resolv_conf_path = None
        self._hostname_path = None
        self._hosts_path = None
        self._log_path = None
        self._name = None
        self._restart_count = None
        self._driver = None
        self._platform = None
        self._mount_label = None
        self._process_label = None
        self._app_armor_profile = None
        self._exec_i_ds = None
        self._host_config = None
        self._graph_driver = None
        self._size_rw = None
        self._size_root_fs = None
        self._mounts = None
        self._config = None
        self._network_settings = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if created is not None:
            self.created = created
        if path is not None:
            self.path = path
        if args is not None:
            self.args = args
        if state is not None:
            self.state = state
        if image is not None:
            self.image = image
        if resolv_conf_path is not None:
            self.resolv_conf_path = resolv_conf_path
        if hostname_path is not None:
            self.hostname_path = hostname_path
        if hosts_path is not None:
            self.hosts_path = hosts_path
        if log_path is not None:
            self.log_path = log_path
        if name is not None:
            self.name = name
        if restart_count is not None:
            self.restart_count = restart_count
        if driver is not None:
            self.driver = driver
        if platform is not None:
            self.platform = platform
        if mount_label is not None:
            self.mount_label = mount_label
        if process_label is not None:
            self.process_label = process_label
        if app_armor_profile is not None:
            self.app_armor_profile = app_armor_profile
        if exec_i_ds is not None:
            self.exec_i_ds = exec_i_ds
        if host_config is not None:
            self.host_config = host_config
        if graph_driver is not None:
            self.graph_driver = graph_driver
        if size_rw is not None:
            self.size_rw = size_rw
        if size_root_fs is not None:
            self.size_root_fs = size_root_fs
        if mounts is not None:
            self.mounts = mounts
        if config is not None:
            self.config = config
        if network_settings is not None:
            self.network_settings = network_settings

    @property
    def id(self):
        """Gets the id of this ContainerInspectResponse.  # noqa: E501

        The ID of the container  # noqa: E501

        :return: The id of this ContainerInspectResponse.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ContainerInspectResponse.

        The ID of the container  # noqa: E501

        :param id: The id of this ContainerInspectResponse.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def created(self):
        """Gets the created of this ContainerInspectResponse.  # noqa: E501

        The time the container was created  # noqa: E501

        :return: The created of this ContainerInspectResponse.  # noqa: E501
        :rtype: str
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this ContainerInspectResponse.

        The time the container was created  # noqa: E501

        :param created: The created of this ContainerInspectResponse.  # noqa: E501
        :type: str
        """

        self._created = created

    @property
    def path(self):
        """Gets the path of this ContainerInspectResponse.  # noqa: E501

        The path to the command being run  # noqa: E501

        :return: The path of this ContainerInspectResponse.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this ContainerInspectResponse.

        The path to the command being run  # noqa: E501

        :param path: The path of this ContainerInspectResponse.  # noqa: E501
        :type: str
        """

        self._path = path

    @property
    def args(self):
        """Gets the args of this ContainerInspectResponse.  # noqa: E501

        The arguments to the command being run  # noqa: E501

        :return: The args of this ContainerInspectResponse.  # noqa: E501
        :rtype: list[str]
        """
        return self._args

    @args.setter
    def args(self, args):
        """Sets the args of this ContainerInspectResponse.

        The arguments to the command being run  # noqa: E501

        :param args: The args of this ContainerInspectResponse.  # noqa: E501
        :type: list[str]
        """

        self._args = args

    @property
    def state(self):
        """Gets the state of this ContainerInspectResponse.  # noqa: E501


        :return: The state of this ContainerInspectResponse.  # noqa: E501
        :rtype: ContainerState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this ContainerInspectResponse.


        :param state: The state of this ContainerInspectResponse.  # noqa: E501
        :type: ContainerState
        """

        self._state = state

    @property
    def image(self):
        """Gets the image of this ContainerInspectResponse.  # noqa: E501

        The container's image ID  # noqa: E501

        :return: The image of this ContainerInspectResponse.  # noqa: E501
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this ContainerInspectResponse.

        The container's image ID  # noqa: E501

        :param image: The image of this ContainerInspectResponse.  # noqa: E501
        :type: str
        """

        self._image = image

    @property
    def resolv_conf_path(self):
        """Gets the resolv_conf_path of this ContainerInspectResponse.  # noqa: E501


        :return: The resolv_conf_path of this ContainerInspectResponse.  # noqa: E501
        :rtype: str
        """
        return self._resolv_conf_path

    @resolv_conf_path.setter
    def resolv_conf_path(self, resolv_conf_path):
        """Sets the resolv_conf_path of this ContainerInspectResponse.


        :param resolv_conf_path: The resolv_conf_path of this ContainerInspectResponse.  # noqa: E501
        :type: str
        """

        self._resolv_conf_path = resolv_conf_path

    @property
    def hostname_path(self):
        """Gets the hostname_path of this ContainerInspectResponse.  # noqa: E501


        :return: The hostname_path of this ContainerInspectResponse.  # noqa: E501
        :rtype: str
        """
        return self._hostname_path

    @hostname_path.setter
    def hostname_path(self, hostname_path):
        """Sets the hostname_path of this ContainerInspectResponse.


        :param hostname_path: The hostname_path of this ContainerInspectResponse.  # noqa: E501
        :type: str
        """

        self._hostname_path = hostname_path

    @property
    def hosts_path(self):
        """Gets the hosts_path of this ContainerInspectResponse.  # noqa: E501


        :return: The hosts_path of this ContainerInspectResponse.  # noqa: E501
        :rtype: str
        """
        return self._hosts_path

    @hosts_path.setter
    def hosts_path(self, hosts_path):
        """Sets the hosts_path of this ContainerInspectResponse.


        :param hosts_path: The hosts_path of this ContainerInspectResponse.  # noqa: E501
        :type: str
        """

        self._hosts_path = hosts_path

    @property
    def log_path(self):
        """Gets the log_path of this ContainerInspectResponse.  # noqa: E501


        :return: The log_path of this ContainerInspectResponse.  # noqa: E501
        :rtype: str
        """
        return self._log_path

    @log_path.setter
    def log_path(self, log_path):
        """Sets the log_path of this ContainerInspectResponse.


        :param log_path: The log_path of this ContainerInspectResponse.  # noqa: E501
        :type: str
        """

        self._log_path = log_path

    @property
    def name(self):
        """Gets the name of this ContainerInspectResponse.  # noqa: E501


        :return: The name of this ContainerInspectResponse.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ContainerInspectResponse.


        :param name: The name of this ContainerInspectResponse.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def restart_count(self):
        """Gets the restart_count of this ContainerInspectResponse.  # noqa: E501


        :return: The restart_count of this ContainerInspectResponse.  # noqa: E501
        :rtype: int
        """
        return self._restart_count

    @restart_count.setter
    def restart_count(self, restart_count):
        """Sets the restart_count of this ContainerInspectResponse.


        :param restart_count: The restart_count of this ContainerInspectResponse.  # noqa: E501
        :type: int
        """

        self._restart_count = restart_count

    @property
    def driver(self):
        """Gets the driver of this ContainerInspectResponse.  # noqa: E501


        :return: The driver of this ContainerInspectResponse.  # noqa: E501
        :rtype: str
        """
        return self._driver

    @driver.setter
    def driver(self, driver):
        """Sets the driver of this ContainerInspectResponse.


        :param driver: The driver of this ContainerInspectResponse.  # noqa: E501
        :type: str
        """

        self._driver = driver

    @property
    def platform(self):
        """Gets the platform of this ContainerInspectResponse.  # noqa: E501


        :return: The platform of this ContainerInspectResponse.  # noqa: E501
        :rtype: str
        """
        return self._platform

    @platform.setter
    def platform(self, platform):
        """Sets the platform of this ContainerInspectResponse.


        :param platform: The platform of this ContainerInspectResponse.  # noqa: E501
        :type: str
        """

        self._platform = platform

    @property
    def mount_label(self):
        """Gets the mount_label of this ContainerInspectResponse.  # noqa: E501


        :return: The mount_label of this ContainerInspectResponse.  # noqa: E501
        :rtype: str
        """
        return self._mount_label

    @mount_label.setter
    def mount_label(self, mount_label):
        """Sets the mount_label of this ContainerInspectResponse.


        :param mount_label: The mount_label of this ContainerInspectResponse.  # noqa: E501
        :type: str
        """

        self._mount_label = mount_label

    @property
    def process_label(self):
        """Gets the process_label of this ContainerInspectResponse.  # noqa: E501


        :return: The process_label of this ContainerInspectResponse.  # noqa: E501
        :rtype: str
        """
        return self._process_label

    @process_label.setter
    def process_label(self, process_label):
        """Sets the process_label of this ContainerInspectResponse.


        :param process_label: The process_label of this ContainerInspectResponse.  # noqa: E501
        :type: str
        """

        self._process_label = process_label

    @property
    def app_armor_profile(self):
        """Gets the app_armor_profile of this ContainerInspectResponse.  # noqa: E501


        :return: The app_armor_profile of this ContainerInspectResponse.  # noqa: E501
        :rtype: str
        """
        return self._app_armor_profile

    @app_armor_profile.setter
    def app_armor_profile(self, app_armor_profile):
        """Sets the app_armor_profile of this ContainerInspectResponse.


        :param app_armor_profile: The app_armor_profile of this ContainerInspectResponse.  # noqa: E501
        :type: str
        """

        self._app_armor_profile = app_armor_profile

    @property
    def exec_i_ds(self):
        """Gets the exec_i_ds of this ContainerInspectResponse.  # noqa: E501

        IDs of exec instances that are running in the container.  # noqa: E501

        :return: The exec_i_ds of this ContainerInspectResponse.  # noqa: E501
        :rtype: list[str]
        """
        return self._exec_i_ds

    @exec_i_ds.setter
    def exec_i_ds(self, exec_i_ds):
        """Sets the exec_i_ds of this ContainerInspectResponse.

        IDs of exec instances that are running in the container.  # noqa: E501

        :param exec_i_ds: The exec_i_ds of this ContainerInspectResponse.  # noqa: E501
        :type: list[str]
        """

        self._exec_i_ds = exec_i_ds

    @property
    def host_config(self):
        """Gets the host_config of this ContainerInspectResponse.  # noqa: E501


        :return: The host_config of this ContainerInspectResponse.  # noqa: E501
        :rtype: HostConfig
        """
        return self._host_config

    @host_config.setter
    def host_config(self, host_config):
        """Sets the host_config of this ContainerInspectResponse.


        :param host_config: The host_config of this ContainerInspectResponse.  # noqa: E501
        :type: HostConfig
        """

        self._host_config = host_config

    @property
    def graph_driver(self):
        """Gets the graph_driver of this ContainerInspectResponse.  # noqa: E501


        :return: The graph_driver of this ContainerInspectResponse.  # noqa: E501
        :rtype: GraphDriverData
        """
        return self._graph_driver

    @graph_driver.setter
    def graph_driver(self, graph_driver):
        """Sets the graph_driver of this ContainerInspectResponse.


        :param graph_driver: The graph_driver of this ContainerInspectResponse.  # noqa: E501
        :type: GraphDriverData
        """

        self._graph_driver = graph_driver

    @property
    def size_rw(self):
        """Gets the size_rw of this ContainerInspectResponse.  # noqa: E501

        The size of files that have been created or changed by this container.   # noqa: E501

        :return: The size_rw of this ContainerInspectResponse.  # noqa: E501
        :rtype: int
        """
        return self._size_rw

    @size_rw.setter
    def size_rw(self, size_rw):
        """Sets the size_rw of this ContainerInspectResponse.

        The size of files that have been created or changed by this container.   # noqa: E501

        :param size_rw: The size_rw of this ContainerInspectResponse.  # noqa: E501
        :type: int
        """

        self._size_rw = size_rw

    @property
    def size_root_fs(self):
        """Gets the size_root_fs of this ContainerInspectResponse.  # noqa: E501

        The total size of all the files in this container.  # noqa: E501

        :return: The size_root_fs of this ContainerInspectResponse.  # noqa: E501
        :rtype: int
        """
        return self._size_root_fs

    @size_root_fs.setter
    def size_root_fs(self, size_root_fs):
        """Sets the size_root_fs of this ContainerInspectResponse.

        The total size of all the files in this container.  # noqa: E501

        :param size_root_fs: The size_root_fs of this ContainerInspectResponse.  # noqa: E501
        :type: int
        """

        self._size_root_fs = size_root_fs

    @property
    def mounts(self):
        """Gets the mounts of this ContainerInspectResponse.  # noqa: E501


        :return: The mounts of this ContainerInspectResponse.  # noqa: E501
        :rtype: list[MountPoint]
        """
        return self._mounts

    @mounts.setter
    def mounts(self, mounts):
        """Sets the mounts of this ContainerInspectResponse.


        :param mounts: The mounts of this ContainerInspectResponse.  # noqa: E501
        :type: list[MountPoint]
        """

        self._mounts = mounts

    @property
    def config(self):
        """Gets the config of this ContainerInspectResponse.  # noqa: E501


        :return: The config of this ContainerInspectResponse.  # noqa: E501
        :rtype: ContainerConfig
        """
        return self._config

    @config.setter
    def config(self, config):
        """Sets the config of this ContainerInspectResponse.


        :param config: The config of this ContainerInspectResponse.  # noqa: E501
        :type: ContainerConfig
        """

        self._config = config

    @property
    def network_settings(self):
        """Gets the network_settings of this ContainerInspectResponse.  # noqa: E501


        :return: The network_settings of this ContainerInspectResponse.  # noqa: E501
        :rtype: NetworkSettings
        """
        return self._network_settings

    @network_settings.setter
    def network_settings(self, network_settings):
        """Sets the network_settings of this ContainerInspectResponse.


        :param network_settings: The network_settings of this ContainerInspectResponse.  # noqa: E501
        :type: NetworkSettings
        """

        self._network_settings = network_settings

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ContainerInspectResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ContainerInspectResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ContainerInspectResponse):
            return True

        return self.to_dict() != other.to_dict()
