# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class ContainerState(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'status': 'str',
        'running': 'bool',
        'paused': 'bool',
        'restarting': 'bool',
        'oom_killed': 'bool',
        'dead': 'bool',
        'pid': 'int',
        'exit_code': 'int',
        'error': 'str',
        'started_at': 'str',
        'finished_at': 'str',
        'health': 'Health'
    }

    attribute_map = {
        'status': 'Status',
        'running': 'Running',
        'paused': 'Paused',
        'restarting': 'Restarting',
        'oom_killed': 'OOMKilled',
        'dead': 'Dead',
        'pid': 'Pid',
        'exit_code': 'ExitCode',
        'error': 'Error',
        'started_at': 'StartedAt',
        'finished_at': 'FinishedAt',
        'health': 'Health'
    }

    def __init__(self, status=None, running=None, paused=None, restarting=None, oom_killed=None, dead=None, pid=None, exit_code=None, error=None, started_at=None, finished_at=None, health=None, _configuration=None):  # noqa: E501
        """ContainerState - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._status = None
        self._running = None
        self._paused = None
        self._restarting = None
        self._oom_killed = None
        self._dead = None
        self._pid = None
        self._exit_code = None
        self._error = None
        self._started_at = None
        self._finished_at = None
        self._health = None
        self.discriminator = None

        if status is not None:
            self.status = status
        if running is not None:
            self.running = running
        if paused is not None:
            self.paused = paused
        if restarting is not None:
            self.restarting = restarting
        if oom_killed is not None:
            self.oom_killed = oom_killed
        if dead is not None:
            self.dead = dead
        if pid is not None:
            self.pid = pid
        if exit_code is not None:
            self.exit_code = exit_code
        if error is not None:
            self.error = error
        if started_at is not None:
            self.started_at = started_at
        if finished_at is not None:
            self.finished_at = finished_at
        if health is not None:
            self.health = health

    @property
    def status(self):
        """Gets the status of this ContainerState.  # noqa: E501

        String representation of the container state. Can be one of \"created\", \"running\", \"paused\", \"restarting\", \"removing\", \"exited\", or \"dead\".   # noqa: E501

        :return: The status of this ContainerState.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this ContainerState.

        String representation of the container state. Can be one of \"created\", \"running\", \"paused\", \"restarting\", \"removing\", \"exited\", or \"dead\".   # noqa: E501

        :param status: The status of this ContainerState.  # noqa: E501
        :type: str
        """
        allowed_values = ["created", "running", "paused", "restarting", "removing", "exited", "dead"]  # noqa: E501
        if (self._configuration.client_side_validation and
                status not in allowed_values):
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def running(self):
        """Gets the running of this ContainerState.  # noqa: E501

        Whether this container is running.  Note that a running container can be _paused_. The `Running` and `Paused` booleans are not mutually exclusive:  When pausing a container (on Linux), the freezer cgroup is used to suspend all processes in the container. Freezing the process requires the process to be running. As a result, paused containers are both `Running` _and_ `Paused`.  Use the `Status` field instead to determine if a container's state is \"running\".   # noqa: E501

        :return: The running of this ContainerState.  # noqa: E501
        :rtype: bool
        """
        return self._running

    @running.setter
    def running(self, running):
        """Sets the running of this ContainerState.

        Whether this container is running.  Note that a running container can be _paused_. The `Running` and `Paused` booleans are not mutually exclusive:  When pausing a container (on Linux), the freezer cgroup is used to suspend all processes in the container. Freezing the process requires the process to be running. As a result, paused containers are both `Running` _and_ `Paused`.  Use the `Status` field instead to determine if a container's state is \"running\".   # noqa: E501

        :param running: The running of this ContainerState.  # noqa: E501
        :type: bool
        """

        self._running = running

    @property
    def paused(self):
        """Gets the paused of this ContainerState.  # noqa: E501

        Whether this container is paused.  # noqa: E501

        :return: The paused of this ContainerState.  # noqa: E501
        :rtype: bool
        """
        return self._paused

    @paused.setter
    def paused(self, paused):
        """Sets the paused of this ContainerState.

        Whether this container is paused.  # noqa: E501

        :param paused: The paused of this ContainerState.  # noqa: E501
        :type: bool
        """

        self._paused = paused

    @property
    def restarting(self):
        """Gets the restarting of this ContainerState.  # noqa: E501

        Whether this container is restarting.  # noqa: E501

        :return: The restarting of this ContainerState.  # noqa: E501
        :rtype: bool
        """
        return self._restarting

    @restarting.setter
    def restarting(self, restarting):
        """Sets the restarting of this ContainerState.

        Whether this container is restarting.  # noqa: E501

        :param restarting: The restarting of this ContainerState.  # noqa: E501
        :type: bool
        """

        self._restarting = restarting

    @property
    def oom_killed(self):
        """Gets the oom_killed of this ContainerState.  # noqa: E501

        Whether this container has been killed because it ran out of memory.   # noqa: E501

        :return: The oom_killed of this ContainerState.  # noqa: E501
        :rtype: bool
        """
        return self._oom_killed

    @oom_killed.setter
    def oom_killed(self, oom_killed):
        """Sets the oom_killed of this ContainerState.

        Whether this container has been killed because it ran out of memory.   # noqa: E501

        :param oom_killed: The oom_killed of this ContainerState.  # noqa: E501
        :type: bool
        """

        self._oom_killed = oom_killed

    @property
    def dead(self):
        """Gets the dead of this ContainerState.  # noqa: E501


        :return: The dead of this ContainerState.  # noqa: E501
        :rtype: bool
        """
        return self._dead

    @dead.setter
    def dead(self, dead):
        """Sets the dead of this ContainerState.


        :param dead: The dead of this ContainerState.  # noqa: E501
        :type: bool
        """

        self._dead = dead

    @property
    def pid(self):
        """Gets the pid of this ContainerState.  # noqa: E501

        The process ID of this container  # noqa: E501

        :return: The pid of this ContainerState.  # noqa: E501
        :rtype: int
        """
        return self._pid

    @pid.setter
    def pid(self, pid):
        """Sets the pid of this ContainerState.

        The process ID of this container  # noqa: E501

        :param pid: The pid of this ContainerState.  # noqa: E501
        :type: int
        """

        self._pid = pid

    @property
    def exit_code(self):
        """Gets the exit_code of this ContainerState.  # noqa: E501

        The last exit code of this container  # noqa: E501

        :return: The exit_code of this ContainerState.  # noqa: E501
        :rtype: int
        """
        return self._exit_code

    @exit_code.setter
    def exit_code(self, exit_code):
        """Sets the exit_code of this ContainerState.

        The last exit code of this container  # noqa: E501

        :param exit_code: The exit_code of this ContainerState.  # noqa: E501
        :type: int
        """

        self._exit_code = exit_code

    @property
    def error(self):
        """Gets the error of this ContainerState.  # noqa: E501


        :return: The error of this ContainerState.  # noqa: E501
        :rtype: str
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this ContainerState.


        :param error: The error of this ContainerState.  # noqa: E501
        :type: str
        """

        self._error = error

    @property
    def started_at(self):
        """Gets the started_at of this ContainerState.  # noqa: E501

        The time when this container was last started.  # noqa: E501

        :return: The started_at of this ContainerState.  # noqa: E501
        :rtype: str
        """
        return self._started_at

    @started_at.setter
    def started_at(self, started_at):
        """Sets the started_at of this ContainerState.

        The time when this container was last started.  # noqa: E501

        :param started_at: The started_at of this ContainerState.  # noqa: E501
        :type: str
        """

        self._started_at = started_at

    @property
    def finished_at(self):
        """Gets the finished_at of this ContainerState.  # noqa: E501

        The time when this container last exited.  # noqa: E501

        :return: The finished_at of this ContainerState.  # noqa: E501
        :rtype: str
        """
        return self._finished_at

    @finished_at.setter
    def finished_at(self, finished_at):
        """Sets the finished_at of this ContainerState.

        The time when this container last exited.  # noqa: E501

        :param finished_at: The finished_at of this ContainerState.  # noqa: E501
        :type: str
        """

        self._finished_at = finished_at

    @property
    def health(self):
        """Gets the health of this ContainerState.  # noqa: E501


        :return: The health of this ContainerState.  # noqa: E501
        :rtype: Health
        """
        return self._health

    @health.setter
    def health(self, health):
        """Sets the health of this ContainerState.


        :param health: The health of this ContainerState.  # noqa: E501
        :type: Health
        """

        self._health = health

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ContainerState, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ContainerState):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ContainerState):
            return True

        return self.to_dict() != other.to_dict()
