# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class ContainerSummary(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'names': 'list[str]',
        'image': 'str',
        'image_id': 'str',
        'command': 'str',
        'created': 'int',
        'ports': 'list[Port]',
        'size_rw': 'int',
        'size_root_fs': 'int',
        'labels': 'dict(str, str)',
        'state': 'str',
        'status': 'str',
        'host_config': 'ContainerSummaryHostConfig',
        'network_settings': 'ContainerSummaryNetworkSettings',
        'mounts': 'list[Mount]'
    }

    attribute_map = {
        'id': 'Id',
        'names': 'Names',
        'image': 'Image',
        'image_id': 'ImageID',
        'command': 'Command',
        'created': 'Created',
        'ports': 'Ports',
        'size_rw': 'SizeRw',
        'size_root_fs': 'SizeRootFs',
        'labels': 'Labels',
        'state': 'State',
        'status': 'Status',
        'host_config': 'HostConfig',
        'network_settings': 'NetworkSettings',
        'mounts': 'Mounts'
    }

    def __init__(self, id=None, names=None, image=None, image_id=None, command=None, created=None, ports=None, size_rw=None, size_root_fs=None, labels=None, state=None, status=None, host_config=None, network_settings=None, mounts=None, _configuration=None):  # noqa: E501
        """ContainerSummary - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._id = None
        self._names = None
        self._image = None
        self._image_id = None
        self._command = None
        self._created = None
        self._ports = None
        self._size_rw = None
        self._size_root_fs = None
        self._labels = None
        self._state = None
        self._status = None
        self._host_config = None
        self._network_settings = None
        self._mounts = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if names is not None:
            self.names = names
        if image is not None:
            self.image = image
        if image_id is not None:
            self.image_id = image_id
        if command is not None:
            self.command = command
        if created is not None:
            self.created = created
        if ports is not None:
            self.ports = ports
        if size_rw is not None:
            self.size_rw = size_rw
        if size_root_fs is not None:
            self.size_root_fs = size_root_fs
        if labels is not None:
            self.labels = labels
        if state is not None:
            self.state = state
        if status is not None:
            self.status = status
        if host_config is not None:
            self.host_config = host_config
        if network_settings is not None:
            self.network_settings = network_settings
        if mounts is not None:
            self.mounts = mounts

    @property
    def id(self):
        """Gets the id of this ContainerSummary.  # noqa: E501

        The ID of this container  # noqa: E501

        :return: The id of this ContainerSummary.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ContainerSummary.

        The ID of this container  # noqa: E501

        :param id: The id of this ContainerSummary.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def names(self):
        """Gets the names of this ContainerSummary.  # noqa: E501

        The names that this container has been given  # noqa: E501

        :return: The names of this ContainerSummary.  # noqa: E501
        :rtype: list[str]
        """
        return self._names

    @names.setter
    def names(self, names):
        """Sets the names of this ContainerSummary.

        The names that this container has been given  # noqa: E501

        :param names: The names of this ContainerSummary.  # noqa: E501
        :type: list[str]
        """

        self._names = names

    @property
    def image(self):
        """Gets the image of this ContainerSummary.  # noqa: E501

        The name of the image used when creating this container  # noqa: E501

        :return: The image of this ContainerSummary.  # noqa: E501
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this ContainerSummary.

        The name of the image used when creating this container  # noqa: E501

        :param image: The image of this ContainerSummary.  # noqa: E501
        :type: str
        """

        self._image = image

    @property
    def image_id(self):
        """Gets the image_id of this ContainerSummary.  # noqa: E501

        The ID of the image that this container was created from  # noqa: E501

        :return: The image_id of this ContainerSummary.  # noqa: E501
        :rtype: str
        """
        return self._image_id

    @image_id.setter
    def image_id(self, image_id):
        """Sets the image_id of this ContainerSummary.

        The ID of the image that this container was created from  # noqa: E501

        :param image_id: The image_id of this ContainerSummary.  # noqa: E501
        :type: str
        """

        self._image_id = image_id

    @property
    def command(self):
        """Gets the command of this ContainerSummary.  # noqa: E501

        Command to run when starting the container  # noqa: E501

        :return: The command of this ContainerSummary.  # noqa: E501
        :rtype: str
        """
        return self._command

    @command.setter
    def command(self, command):
        """Sets the command of this ContainerSummary.

        Command to run when starting the container  # noqa: E501

        :param command: The command of this ContainerSummary.  # noqa: E501
        :type: str
        """

        self._command = command

    @property
    def created(self):
        """Gets the created of this ContainerSummary.  # noqa: E501

        When the container was created  # noqa: E501

        :return: The created of this ContainerSummary.  # noqa: E501
        :rtype: int
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this ContainerSummary.

        When the container was created  # noqa: E501

        :param created: The created of this ContainerSummary.  # noqa: E501
        :type: int
        """

        self._created = created

    @property
    def ports(self):
        """Gets the ports of this ContainerSummary.  # noqa: E501

        The ports exposed by this container  # noqa: E501

        :return: The ports of this ContainerSummary.  # noqa: E501
        :rtype: list[Port]
        """
        return self._ports

    @ports.setter
    def ports(self, ports):
        """Sets the ports of this ContainerSummary.

        The ports exposed by this container  # noqa: E501

        :param ports: The ports of this ContainerSummary.  # noqa: E501
        :type: list[Port]
        """

        self._ports = ports

    @property
    def size_rw(self):
        """Gets the size_rw of this ContainerSummary.  # noqa: E501

        The size of files that have been created or changed by this container  # noqa: E501

        :return: The size_rw of this ContainerSummary.  # noqa: E501
        :rtype: int
        """
        return self._size_rw

    @size_rw.setter
    def size_rw(self, size_rw):
        """Sets the size_rw of this ContainerSummary.

        The size of files that have been created or changed by this container  # noqa: E501

        :param size_rw: The size_rw of this ContainerSummary.  # noqa: E501
        :type: int
        """

        self._size_rw = size_rw

    @property
    def size_root_fs(self):
        """Gets the size_root_fs of this ContainerSummary.  # noqa: E501

        The total size of all the files in this container  # noqa: E501

        :return: The size_root_fs of this ContainerSummary.  # noqa: E501
        :rtype: int
        """
        return self._size_root_fs

    @size_root_fs.setter
    def size_root_fs(self, size_root_fs):
        """Sets the size_root_fs of this ContainerSummary.

        The total size of all the files in this container  # noqa: E501

        :param size_root_fs: The size_root_fs of this ContainerSummary.  # noqa: E501
        :type: int
        """

        self._size_root_fs = size_root_fs

    @property
    def labels(self):
        """Gets the labels of this ContainerSummary.  # noqa: E501

        User-defined key/value metadata.  # noqa: E501

        :return: The labels of this ContainerSummary.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this ContainerSummary.

        User-defined key/value metadata.  # noqa: E501

        :param labels: The labels of this ContainerSummary.  # noqa: E501
        :type: dict(str, str)
        """

        self._labels = labels

    @property
    def state(self):
        """Gets the state of this ContainerSummary.  # noqa: E501

        The state of this container (e.g. `Exited`)  # noqa: E501

        :return: The state of this ContainerSummary.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this ContainerSummary.

        The state of this container (e.g. `Exited`)  # noqa: E501

        :param state: The state of this ContainerSummary.  # noqa: E501
        :type: str
        """

        self._state = state

    @property
    def status(self):
        """Gets the status of this ContainerSummary.  # noqa: E501

        Additional human-readable status of this container (e.g. `Exit 0`)  # noqa: E501

        :return: The status of this ContainerSummary.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this ContainerSummary.

        Additional human-readable status of this container (e.g. `Exit 0`)  # noqa: E501

        :param status: The status of this ContainerSummary.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def host_config(self):
        """Gets the host_config of this ContainerSummary.  # noqa: E501


        :return: The host_config of this ContainerSummary.  # noqa: E501
        :rtype: ContainerSummaryHostConfig
        """
        return self._host_config

    @host_config.setter
    def host_config(self, host_config):
        """Sets the host_config of this ContainerSummary.


        :param host_config: The host_config of this ContainerSummary.  # noqa: E501
        :type: ContainerSummaryHostConfig
        """

        self._host_config = host_config

    @property
    def network_settings(self):
        """Gets the network_settings of this ContainerSummary.  # noqa: E501


        :return: The network_settings of this ContainerSummary.  # noqa: E501
        :rtype: ContainerSummaryNetworkSettings
        """
        return self._network_settings

    @network_settings.setter
    def network_settings(self, network_settings):
        """Sets the network_settings of this ContainerSummary.


        :param network_settings: The network_settings of this ContainerSummary.  # noqa: E501
        :type: ContainerSummaryNetworkSettings
        """

        self._network_settings = network_settings

    @property
    def mounts(self):
        """Gets the mounts of this ContainerSummary.  # noqa: E501


        :return: The mounts of this ContainerSummary.  # noqa: E501
        :rtype: list[Mount]
        """
        return self._mounts

    @mounts.setter
    def mounts(self, mounts):
        """Sets the mounts of this ContainerSummary.


        :param mounts: The mounts of this ContainerSummary.  # noqa: E501
        :type: list[Mount]
        """

        self._mounts = mounts

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ContainerSummary, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ContainerSummary):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ContainerSummary):
            return True

        return self.to_dict() != other.to_dict()
