# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class EndpointPortConfig(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'protocol': 'str',
        'target_port': 'int',
        'published_port': 'int',
        'publish_mode': 'str'
    }

    attribute_map = {
        'name': 'Name',
        'protocol': 'Protocol',
        'target_port': 'TargetPort',
        'published_port': 'PublishedPort',
        'publish_mode': 'PublishMode'
    }

    def __init__(self, name=None, protocol=None, target_port=None, published_port=None, publish_mode='ingress', _configuration=None):  # noqa: E501
        """EndpointPortConfig - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._name = None
        self._protocol = None
        self._target_port = None
        self._published_port = None
        self._publish_mode = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if protocol is not None:
            self.protocol = protocol
        if target_port is not None:
            self.target_port = target_port
        if published_port is not None:
            self.published_port = published_port
        if publish_mode is not None:
            self.publish_mode = publish_mode

    @property
    def name(self):
        """Gets the name of this EndpointPortConfig.  # noqa: E501


        :return: The name of this EndpointPortConfig.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this EndpointPortConfig.


        :param name: The name of this EndpointPortConfig.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def protocol(self):
        """Gets the protocol of this EndpointPortConfig.  # noqa: E501


        :return: The protocol of this EndpointPortConfig.  # noqa: E501
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """Sets the protocol of this EndpointPortConfig.


        :param protocol: The protocol of this EndpointPortConfig.  # noqa: E501
        :type: str
        """
        allowed_values = ["tcp", "udp", "sctp"]  # noqa: E501
        if (self._configuration.client_side_validation and
                protocol not in allowed_values):
            raise ValueError(
                "Invalid value for `protocol` ({0}), must be one of {1}"  # noqa: E501
                .format(protocol, allowed_values)
            )

        self._protocol = protocol

    @property
    def target_port(self):
        """Gets the target_port of this EndpointPortConfig.  # noqa: E501

        The port inside the container.  # noqa: E501

        :return: The target_port of this EndpointPortConfig.  # noqa: E501
        :rtype: int
        """
        return self._target_port

    @target_port.setter
    def target_port(self, target_port):
        """Sets the target_port of this EndpointPortConfig.

        The port inside the container.  # noqa: E501

        :param target_port: The target_port of this EndpointPortConfig.  # noqa: E501
        :type: int
        """

        self._target_port = target_port

    @property
    def published_port(self):
        """Gets the published_port of this EndpointPortConfig.  # noqa: E501

        The port on the swarm hosts.  # noqa: E501

        :return: The published_port of this EndpointPortConfig.  # noqa: E501
        :rtype: int
        """
        return self._published_port

    @published_port.setter
    def published_port(self, published_port):
        """Sets the published_port of this EndpointPortConfig.

        The port on the swarm hosts.  # noqa: E501

        :param published_port: The published_port of this EndpointPortConfig.  # noqa: E501
        :type: int
        """

        self._published_port = published_port

    @property
    def publish_mode(self):
        """Gets the publish_mode of this EndpointPortConfig.  # noqa: E501

        The mode in which port is published.  <p><br /></p>  - \"ingress\" makes the target port accessible on every node,   regardless of whether there is a task for the service running on   that node or not. - \"host\" bypasses the routing mesh and publish the port directly on   the swarm node where that service is running.   # noqa: E501

        :return: The publish_mode of this EndpointPortConfig.  # noqa: E501
        :rtype: str
        """
        return self._publish_mode

    @publish_mode.setter
    def publish_mode(self, publish_mode):
        """Sets the publish_mode of this EndpointPortConfig.

        The mode in which port is published.  <p><br /></p>  - \"ingress\" makes the target port accessible on every node,   regardless of whether there is a task for the service running on   that node or not. - \"host\" bypasses the routing mesh and publish the port directly on   the swarm node where that service is running.   # noqa: E501

        :param publish_mode: The publish_mode of this EndpointPortConfig.  # noqa: E501
        :type: str
        """
        allowed_values = ["ingress", "host"]  # noqa: E501
        if (self._configuration.client_side_validation and
                publish_mode not in allowed_values):
            raise ValueError(
                "Invalid value for `publish_mode` ({0}), must be one of {1}"  # noqa: E501
                .format(publish_mode, allowed_values)
            )

        self._publish_mode = publish_mode

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EndpointPortConfig, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EndpointPortConfig):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, EndpointPortConfig):
            return True

        return self.to_dict() != other.to_dict()
