# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class ExecConfig(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'attach_stdin': 'bool',
        'attach_stdout': 'bool',
        'attach_stderr': 'bool',
        'detach_keys': 'str',
        'tty': 'bool',
        'env': 'list[str]',
        'cmd': 'list[str]',
        'privileged': 'bool',
        'user': 'str',
        'working_dir': 'str'
    }

    attribute_map = {
        'attach_stdin': 'AttachStdin',
        'attach_stdout': 'AttachStdout',
        'attach_stderr': 'AttachStderr',
        'detach_keys': 'DetachKeys',
        'tty': 'Tty',
        'env': 'Env',
        'cmd': 'Cmd',
        'privileged': 'Privileged',
        'user': 'User',
        'working_dir': 'WorkingDir'
    }

    def __init__(self, attach_stdin=None, attach_stdout=None, attach_stderr=None, detach_keys=None, tty=None, env=None, cmd=None, privileged=False, user=None, working_dir=None, _configuration=None):  # noqa: E501
        """ExecConfig - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._attach_stdin = None
        self._attach_stdout = None
        self._attach_stderr = None
        self._detach_keys = None
        self._tty = None
        self._env = None
        self._cmd = None
        self._privileged = None
        self._user = None
        self._working_dir = None
        self.discriminator = None

        if attach_stdin is not None:
            self.attach_stdin = attach_stdin
        if attach_stdout is not None:
            self.attach_stdout = attach_stdout
        if attach_stderr is not None:
            self.attach_stderr = attach_stderr
        if detach_keys is not None:
            self.detach_keys = detach_keys
        if tty is not None:
            self.tty = tty
        if env is not None:
            self.env = env
        if cmd is not None:
            self.cmd = cmd
        if privileged is not None:
            self.privileged = privileged
        if user is not None:
            self.user = user
        if working_dir is not None:
            self.working_dir = working_dir

    @property
    def attach_stdin(self):
        """Gets the attach_stdin of this ExecConfig.  # noqa: E501

        Attach to `stdin` of the exec command.  # noqa: E501

        :return: The attach_stdin of this ExecConfig.  # noqa: E501
        :rtype: bool
        """
        return self._attach_stdin

    @attach_stdin.setter
    def attach_stdin(self, attach_stdin):
        """Sets the attach_stdin of this ExecConfig.

        Attach to `stdin` of the exec command.  # noqa: E501

        :param attach_stdin: The attach_stdin of this ExecConfig.  # noqa: E501
        :type: bool
        """

        self._attach_stdin = attach_stdin

    @property
    def attach_stdout(self):
        """Gets the attach_stdout of this ExecConfig.  # noqa: E501

        Attach to `stdout` of the exec command.  # noqa: E501

        :return: The attach_stdout of this ExecConfig.  # noqa: E501
        :rtype: bool
        """
        return self._attach_stdout

    @attach_stdout.setter
    def attach_stdout(self, attach_stdout):
        """Sets the attach_stdout of this ExecConfig.

        Attach to `stdout` of the exec command.  # noqa: E501

        :param attach_stdout: The attach_stdout of this ExecConfig.  # noqa: E501
        :type: bool
        """

        self._attach_stdout = attach_stdout

    @property
    def attach_stderr(self):
        """Gets the attach_stderr of this ExecConfig.  # noqa: E501

        Attach to `stderr` of the exec command.  # noqa: E501

        :return: The attach_stderr of this ExecConfig.  # noqa: E501
        :rtype: bool
        """
        return self._attach_stderr

    @attach_stderr.setter
    def attach_stderr(self, attach_stderr):
        """Sets the attach_stderr of this ExecConfig.

        Attach to `stderr` of the exec command.  # noqa: E501

        :param attach_stderr: The attach_stderr of this ExecConfig.  # noqa: E501
        :type: bool
        """

        self._attach_stderr = attach_stderr

    @property
    def detach_keys(self):
        """Gets the detach_keys of this ExecConfig.  # noqa: E501

        Override the key sequence for detaching a container. Format is a single character `[a-Z]` or `ctrl-<value>` where `<value>` is one of: `a-z`, `@`, `^`, `[`, `,` or `_`.   # noqa: E501

        :return: The detach_keys of this ExecConfig.  # noqa: E501
        :rtype: str
        """
        return self._detach_keys

    @detach_keys.setter
    def detach_keys(self, detach_keys):
        """Sets the detach_keys of this ExecConfig.

        Override the key sequence for detaching a container. Format is a single character `[a-Z]` or `ctrl-<value>` where `<value>` is one of: `a-z`, `@`, `^`, `[`, `,` or `_`.   # noqa: E501

        :param detach_keys: The detach_keys of this ExecConfig.  # noqa: E501
        :type: str
        """

        self._detach_keys = detach_keys

    @property
    def tty(self):
        """Gets the tty of this ExecConfig.  # noqa: E501

        Allocate a pseudo-TTY.  # noqa: E501

        :return: The tty of this ExecConfig.  # noqa: E501
        :rtype: bool
        """
        return self._tty

    @tty.setter
    def tty(self, tty):
        """Sets the tty of this ExecConfig.

        Allocate a pseudo-TTY.  # noqa: E501

        :param tty: The tty of this ExecConfig.  # noqa: E501
        :type: bool
        """

        self._tty = tty

    @property
    def env(self):
        """Gets the env of this ExecConfig.  # noqa: E501

        A list of environment variables in the form `[\"VAR=value\", ...]`.   # noqa: E501

        :return: The env of this ExecConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._env

    @env.setter
    def env(self, env):
        """Sets the env of this ExecConfig.

        A list of environment variables in the form `[\"VAR=value\", ...]`.   # noqa: E501

        :param env: The env of this ExecConfig.  # noqa: E501
        :type: list[str]
        """

        self._env = env

    @property
    def cmd(self):
        """Gets the cmd of this ExecConfig.  # noqa: E501

        Command to run, as a string or array of strings.  # noqa: E501

        :return: The cmd of this ExecConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._cmd

    @cmd.setter
    def cmd(self, cmd):
        """Sets the cmd of this ExecConfig.

        Command to run, as a string or array of strings.  # noqa: E501

        :param cmd: The cmd of this ExecConfig.  # noqa: E501
        :type: list[str]
        """

        self._cmd = cmd

    @property
    def privileged(self):
        """Gets the privileged of this ExecConfig.  # noqa: E501

        Runs the exec process with extended privileges.  # noqa: E501

        :return: The privileged of this ExecConfig.  # noqa: E501
        :rtype: bool
        """
        return self._privileged

    @privileged.setter
    def privileged(self, privileged):
        """Sets the privileged of this ExecConfig.

        Runs the exec process with extended privileges.  # noqa: E501

        :param privileged: The privileged of this ExecConfig.  # noqa: E501
        :type: bool
        """

        self._privileged = privileged

    @property
    def user(self):
        """Gets the user of this ExecConfig.  # noqa: E501

        The user, and optionally, group to run the exec process inside the container. Format is one of: `user`, `user:group`, `uid`, or `uid:gid`.   # noqa: E501

        :return: The user of this ExecConfig.  # noqa: E501
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this ExecConfig.

        The user, and optionally, group to run the exec process inside the container. Format is one of: `user`, `user:group`, `uid`, or `uid:gid`.   # noqa: E501

        :param user: The user of this ExecConfig.  # noqa: E501
        :type: str
        """

        self._user = user

    @property
    def working_dir(self):
        """Gets the working_dir of this ExecConfig.  # noqa: E501

        The working directory for the exec process inside the container.   # noqa: E501

        :return: The working_dir of this ExecConfig.  # noqa: E501
        :rtype: str
        """
        return self._working_dir

    @working_dir.setter
    def working_dir(self, working_dir):
        """Sets the working_dir of this ExecConfig.

        The working directory for the exec process inside the container.   # noqa: E501

        :param working_dir: The working_dir of this ExecConfig.  # noqa: E501
        :type: str
        """

        self._working_dir = working_dir

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ExecConfig, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExecConfig):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExecConfig):
            return True

        return self.to_dict() != other.to_dict()
