# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class ExecInspectResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'can_remove': 'bool',
        'detach_keys': 'str',
        'id': 'str',
        'running': 'bool',
        'exit_code': 'int',
        'process_config': 'ProcessConfig',
        'open_stdin': 'bool',
        'open_stderr': 'bool',
        'open_stdout': 'bool',
        'container_id': 'str',
        'pid': 'int'
    }

    attribute_map = {
        'can_remove': 'CanRemove',
        'detach_keys': 'DetachKeys',
        'id': 'ID',
        'running': 'Running',
        'exit_code': 'ExitCode',
        'process_config': 'ProcessConfig',
        'open_stdin': 'OpenStdin',
        'open_stderr': 'OpenStderr',
        'open_stdout': 'OpenStdout',
        'container_id': 'ContainerID',
        'pid': 'Pid'
    }

    def __init__(self, can_remove=None, detach_keys=None, id=None, running=None, exit_code=None, process_config=None, open_stdin=None, open_stderr=None, open_stdout=None, container_id=None, pid=None, _configuration=None):  # noqa: E501
        """ExecInspectResponse - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._can_remove = None
        self._detach_keys = None
        self._id = None
        self._running = None
        self._exit_code = None
        self._process_config = None
        self._open_stdin = None
        self._open_stderr = None
        self._open_stdout = None
        self._container_id = None
        self._pid = None
        self.discriminator = None

        if can_remove is not None:
            self.can_remove = can_remove
        if detach_keys is not None:
            self.detach_keys = detach_keys
        if id is not None:
            self.id = id
        if running is not None:
            self.running = running
        if exit_code is not None:
            self.exit_code = exit_code
        if process_config is not None:
            self.process_config = process_config
        if open_stdin is not None:
            self.open_stdin = open_stdin
        if open_stderr is not None:
            self.open_stderr = open_stderr
        if open_stdout is not None:
            self.open_stdout = open_stdout
        if container_id is not None:
            self.container_id = container_id
        if pid is not None:
            self.pid = pid

    @property
    def can_remove(self):
        """Gets the can_remove of this ExecInspectResponse.  # noqa: E501


        :return: The can_remove of this ExecInspectResponse.  # noqa: E501
        :rtype: bool
        """
        return self._can_remove

    @can_remove.setter
    def can_remove(self, can_remove):
        """Sets the can_remove of this ExecInspectResponse.


        :param can_remove: The can_remove of this ExecInspectResponse.  # noqa: E501
        :type: bool
        """

        self._can_remove = can_remove

    @property
    def detach_keys(self):
        """Gets the detach_keys of this ExecInspectResponse.  # noqa: E501


        :return: The detach_keys of this ExecInspectResponse.  # noqa: E501
        :rtype: str
        """
        return self._detach_keys

    @detach_keys.setter
    def detach_keys(self, detach_keys):
        """Sets the detach_keys of this ExecInspectResponse.


        :param detach_keys: The detach_keys of this ExecInspectResponse.  # noqa: E501
        :type: str
        """

        self._detach_keys = detach_keys

    @property
    def id(self):
        """Gets the id of this ExecInspectResponse.  # noqa: E501


        :return: The id of this ExecInspectResponse.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ExecInspectResponse.


        :param id: The id of this ExecInspectResponse.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def running(self):
        """Gets the running of this ExecInspectResponse.  # noqa: E501


        :return: The running of this ExecInspectResponse.  # noqa: E501
        :rtype: bool
        """
        return self._running

    @running.setter
    def running(self, running):
        """Sets the running of this ExecInspectResponse.


        :param running: The running of this ExecInspectResponse.  # noqa: E501
        :type: bool
        """

        self._running = running

    @property
    def exit_code(self):
        """Gets the exit_code of this ExecInspectResponse.  # noqa: E501


        :return: The exit_code of this ExecInspectResponse.  # noqa: E501
        :rtype: int
        """
        return self._exit_code

    @exit_code.setter
    def exit_code(self, exit_code):
        """Sets the exit_code of this ExecInspectResponse.


        :param exit_code: The exit_code of this ExecInspectResponse.  # noqa: E501
        :type: int
        """

        self._exit_code = exit_code

    @property
    def process_config(self):
        """Gets the process_config of this ExecInspectResponse.  # noqa: E501


        :return: The process_config of this ExecInspectResponse.  # noqa: E501
        :rtype: ProcessConfig
        """
        return self._process_config

    @process_config.setter
    def process_config(self, process_config):
        """Sets the process_config of this ExecInspectResponse.


        :param process_config: The process_config of this ExecInspectResponse.  # noqa: E501
        :type: ProcessConfig
        """

        self._process_config = process_config

    @property
    def open_stdin(self):
        """Gets the open_stdin of this ExecInspectResponse.  # noqa: E501


        :return: The open_stdin of this ExecInspectResponse.  # noqa: E501
        :rtype: bool
        """
        return self._open_stdin

    @open_stdin.setter
    def open_stdin(self, open_stdin):
        """Sets the open_stdin of this ExecInspectResponse.


        :param open_stdin: The open_stdin of this ExecInspectResponse.  # noqa: E501
        :type: bool
        """

        self._open_stdin = open_stdin

    @property
    def open_stderr(self):
        """Gets the open_stderr of this ExecInspectResponse.  # noqa: E501


        :return: The open_stderr of this ExecInspectResponse.  # noqa: E501
        :rtype: bool
        """
        return self._open_stderr

    @open_stderr.setter
    def open_stderr(self, open_stderr):
        """Sets the open_stderr of this ExecInspectResponse.


        :param open_stderr: The open_stderr of this ExecInspectResponse.  # noqa: E501
        :type: bool
        """

        self._open_stderr = open_stderr

    @property
    def open_stdout(self):
        """Gets the open_stdout of this ExecInspectResponse.  # noqa: E501


        :return: The open_stdout of this ExecInspectResponse.  # noqa: E501
        :rtype: bool
        """
        return self._open_stdout

    @open_stdout.setter
    def open_stdout(self, open_stdout):
        """Sets the open_stdout of this ExecInspectResponse.


        :param open_stdout: The open_stdout of this ExecInspectResponse.  # noqa: E501
        :type: bool
        """

        self._open_stdout = open_stdout

    @property
    def container_id(self):
        """Gets the container_id of this ExecInspectResponse.  # noqa: E501


        :return: The container_id of this ExecInspectResponse.  # noqa: E501
        :rtype: str
        """
        return self._container_id

    @container_id.setter
    def container_id(self, container_id):
        """Sets the container_id of this ExecInspectResponse.


        :param container_id: The container_id of this ExecInspectResponse.  # noqa: E501
        :type: str
        """

        self._container_id = container_id

    @property
    def pid(self):
        """Gets the pid of this ExecInspectResponse.  # noqa: E501

        The system process ID for the exec process.  # noqa: E501

        :return: The pid of this ExecInspectResponse.  # noqa: E501
        :rtype: int
        """
        return self._pid

    @pid.setter
    def pid(self, pid):
        """Sets the pid of this ExecInspectResponse.

        The system process ID for the exec process.  # noqa: E501

        :param pid: The pid of this ExecInspectResponse.  # noqa: E501
        :type: int
        """

        self._pid = pid

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ExecInspectResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExecInspectResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExecInspectResponse):
            return True

        return self.to_dict() != other.to_dict()
