# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class HealthConfig(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'test': 'list[str]',
        'interval': 'int',
        'timeout': 'int',
        'retries': 'int',
        'start_period': 'int'
    }

    attribute_map = {
        'test': 'Test',
        'interval': 'Interval',
        'timeout': 'Timeout',
        'retries': 'Retries',
        'start_period': 'StartPeriod'
    }

    def __init__(self, test=None, interval=None, timeout=None, retries=None, start_period=None, _configuration=None):  # noqa: E501
        """HealthConfig - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._test = None
        self._interval = None
        self._timeout = None
        self._retries = None
        self._start_period = None
        self.discriminator = None

        if test is not None:
            self.test = test
        if interval is not None:
            self.interval = interval
        if timeout is not None:
            self.timeout = timeout
        if retries is not None:
            self.retries = retries
        if start_period is not None:
            self.start_period = start_period

    @property
    def test(self):
        """Gets the test of this HealthConfig.  # noqa: E501

        The test to perform. Possible values are:  - `[]` inherit healthcheck from image or parent image - `[\"NONE\"]` disable healthcheck - `[\"CMD\", args...]` exec arguments directly - `[\"CMD-SHELL\", command]` run command with system's default shell   # noqa: E501

        :return: The test of this HealthConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._test

    @test.setter
    def test(self, test):
        """Sets the test of this HealthConfig.

        The test to perform. Possible values are:  - `[]` inherit healthcheck from image or parent image - `[\"NONE\"]` disable healthcheck - `[\"CMD\", args...]` exec arguments directly - `[\"CMD-SHELL\", command]` run command with system's default shell   # noqa: E501

        :param test: The test of this HealthConfig.  # noqa: E501
        :type: list[str]
        """

        self._test = test

    @property
    def interval(self):
        """Gets the interval of this HealthConfig.  # noqa: E501

        The time to wait between checks in nanoseconds. It should be 0 or at least 1000000 (1 ms). 0 means inherit.   # noqa: E501

        :return: The interval of this HealthConfig.  # noqa: E501
        :rtype: int
        """
        return self._interval

    @interval.setter
    def interval(self, interval):
        """Sets the interval of this HealthConfig.

        The time to wait between checks in nanoseconds. It should be 0 or at least 1000000 (1 ms). 0 means inherit.   # noqa: E501

        :param interval: The interval of this HealthConfig.  # noqa: E501
        :type: int
        """

        self._interval = interval

    @property
    def timeout(self):
        """Gets the timeout of this HealthConfig.  # noqa: E501

        The time to wait before considering the check to have hung. It should be 0 or at least 1000000 (1 ms). 0 means inherit.   # noqa: E501

        :return: The timeout of this HealthConfig.  # noqa: E501
        :rtype: int
        """
        return self._timeout

    @timeout.setter
    def timeout(self, timeout):
        """Sets the timeout of this HealthConfig.

        The time to wait before considering the check to have hung. It should be 0 or at least 1000000 (1 ms). 0 means inherit.   # noqa: E501

        :param timeout: The timeout of this HealthConfig.  # noqa: E501
        :type: int
        """

        self._timeout = timeout

    @property
    def retries(self):
        """Gets the retries of this HealthConfig.  # noqa: E501

        The number of consecutive failures needed to consider a container as unhealthy. 0 means inherit.   # noqa: E501

        :return: The retries of this HealthConfig.  # noqa: E501
        :rtype: int
        """
        return self._retries

    @retries.setter
    def retries(self, retries):
        """Sets the retries of this HealthConfig.

        The number of consecutive failures needed to consider a container as unhealthy. 0 means inherit.   # noqa: E501

        :param retries: The retries of this HealthConfig.  # noqa: E501
        :type: int
        """

        self._retries = retries

    @property
    def start_period(self):
        """Gets the start_period of this HealthConfig.  # noqa: E501

        Start period for the container to initialize before starting health-retries countdown in nanoseconds. It should be 0 or at least 1000000 (1 ms). 0 means inherit.   # noqa: E501

        :return: The start_period of this HealthConfig.  # noqa: E501
        :rtype: int
        """
        return self._start_period

    @start_period.setter
    def start_period(self, start_period):
        """Sets the start_period of this HealthConfig.

        Start period for the container to initialize before starting health-retries countdown in nanoseconds. It should be 0 or at least 1000000 (1 ms). 0 means inherit.   # noqa: E501

        :param start_period: The start_period of this HealthConfig.  # noqa: E501
        :type: int
        """

        self._start_period = start_period

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(HealthConfig, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HealthConfig):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HealthConfig):
            return True

        return self.to_dict() != other.to_dict()
