# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class Image(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'repo_tags': 'list[str]',
        'repo_digests': 'list[str]',
        'parent': 'str',
        'comment': 'str',
        'created': 'str',
        'container': 'str',
        'container_config': 'ContainerConfig',
        'docker_version': 'str',
        'author': 'str',
        'config': 'ContainerConfig',
        'architecture': 'str',
        'os': 'str',
        'os_version': 'str',
        'size': 'int',
        'virtual_size': 'int',
        'graph_driver': 'GraphDriverData',
        'root_fs': 'ImageRootFS',
        'metadata': 'ImageMetadata'
    }

    attribute_map = {
        'id': 'Id',
        'repo_tags': 'RepoTags',
        'repo_digests': 'RepoDigests',
        'parent': 'Parent',
        'comment': 'Comment',
        'created': 'Created',
        'container': 'Container',
        'container_config': 'ContainerConfig',
        'docker_version': 'DockerVersion',
        'author': 'Author',
        'config': 'Config',
        'architecture': 'Architecture',
        'os': 'Os',
        'os_version': 'OsVersion',
        'size': 'Size',
        'virtual_size': 'VirtualSize',
        'graph_driver': 'GraphDriver',
        'root_fs': 'RootFS',
        'metadata': 'Metadata'
    }

    def __init__(self, id=None, repo_tags=None, repo_digests=None, parent=None, comment=None, created=None, container=None, container_config=None, docker_version=None, author=None, config=None, architecture=None, os=None, os_version=None, size=None, virtual_size=None, graph_driver=None, root_fs=None, metadata=None, _configuration=None):  # noqa: E501
        """Image - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._id = None
        self._repo_tags = None
        self._repo_digests = None
        self._parent = None
        self._comment = None
        self._created = None
        self._container = None
        self._container_config = None
        self._docker_version = None
        self._author = None
        self._config = None
        self._architecture = None
        self._os = None
        self._os_version = None
        self._size = None
        self._virtual_size = None
        self._graph_driver = None
        self._root_fs = None
        self._metadata = None
        self.discriminator = None

        self.id = id
        if repo_tags is not None:
            self.repo_tags = repo_tags
        if repo_digests is not None:
            self.repo_digests = repo_digests
        self.parent = parent
        self.comment = comment
        self.created = created
        self.container = container
        if container_config is not None:
            self.container_config = container_config
        self.docker_version = docker_version
        self.author = author
        if config is not None:
            self.config = config
        self.architecture = architecture
        self.os = os
        if os_version is not None:
            self.os_version = os_version
        self.size = size
        self.virtual_size = virtual_size
        self.graph_driver = graph_driver
        self.root_fs = root_fs
        if metadata is not None:
            self.metadata = metadata

    @property
    def id(self):
        """Gets the id of this Image.  # noqa: E501


        :return: The id of this Image.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Image.


        :param id: The id of this Image.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def repo_tags(self):
        """Gets the repo_tags of this Image.  # noqa: E501


        :return: The repo_tags of this Image.  # noqa: E501
        :rtype: list[str]
        """
        return self._repo_tags

    @repo_tags.setter
    def repo_tags(self, repo_tags):
        """Sets the repo_tags of this Image.


        :param repo_tags: The repo_tags of this Image.  # noqa: E501
        :type: list[str]
        """

        self._repo_tags = repo_tags

    @property
    def repo_digests(self):
        """Gets the repo_digests of this Image.  # noqa: E501


        :return: The repo_digests of this Image.  # noqa: E501
        :rtype: list[str]
        """
        return self._repo_digests

    @repo_digests.setter
    def repo_digests(self, repo_digests):
        """Sets the repo_digests of this Image.


        :param repo_digests: The repo_digests of this Image.  # noqa: E501
        :type: list[str]
        """

        self._repo_digests = repo_digests

    @property
    def parent(self):
        """Gets the parent of this Image.  # noqa: E501


        :return: The parent of this Image.  # noqa: E501
        :rtype: str
        """
        return self._parent

    @parent.setter
    def parent(self, parent):
        """Sets the parent of this Image.


        :param parent: The parent of this Image.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and parent is None:
            raise ValueError("Invalid value for `parent`, must not be `None`")  # noqa: E501

        self._parent = parent

    @property
    def comment(self):
        """Gets the comment of this Image.  # noqa: E501


        :return: The comment of this Image.  # noqa: E501
        :rtype: str
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """Sets the comment of this Image.


        :param comment: The comment of this Image.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and comment is None:
            raise ValueError("Invalid value for `comment`, must not be `None`")  # noqa: E501

        self._comment = comment

    @property
    def created(self):
        """Gets the created of this Image.  # noqa: E501


        :return: The created of this Image.  # noqa: E501
        :rtype: str
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this Image.


        :param created: The created of this Image.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")  # noqa: E501

        self._created = created

    @property
    def container(self):
        """Gets the container of this Image.  # noqa: E501


        :return: The container of this Image.  # noqa: E501
        :rtype: str
        """
        return self._container

    @container.setter
    def container(self, container):
        """Sets the container of this Image.


        :param container: The container of this Image.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and container is None:
            raise ValueError("Invalid value for `container`, must not be `None`")  # noqa: E501

        self._container = container

    @property
    def container_config(self):
        """Gets the container_config of this Image.  # noqa: E501


        :return: The container_config of this Image.  # noqa: E501
        :rtype: ContainerConfig
        """
        return self._container_config

    @container_config.setter
    def container_config(self, container_config):
        """Sets the container_config of this Image.


        :param container_config: The container_config of this Image.  # noqa: E501
        :type: ContainerConfig
        """

        self._container_config = container_config

    @property
    def docker_version(self):
        """Gets the docker_version of this Image.  # noqa: E501


        :return: The docker_version of this Image.  # noqa: E501
        :rtype: str
        """
        return self._docker_version

    @docker_version.setter
    def docker_version(self, docker_version):
        """Sets the docker_version of this Image.


        :param docker_version: The docker_version of this Image.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and docker_version is None:
            raise ValueError("Invalid value for `docker_version`, must not be `None`")  # noqa: E501

        self._docker_version = docker_version

    @property
    def author(self):
        """Gets the author of this Image.  # noqa: E501


        :return: The author of this Image.  # noqa: E501
        :rtype: str
        """
        return self._author

    @author.setter
    def author(self, author):
        """Sets the author of this Image.


        :param author: The author of this Image.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and author is None:
            raise ValueError("Invalid value for `author`, must not be `None`")  # noqa: E501

        self._author = author

    @property
    def config(self):
        """Gets the config of this Image.  # noqa: E501


        :return: The config of this Image.  # noqa: E501
        :rtype: ContainerConfig
        """
        return self._config

    @config.setter
    def config(self, config):
        """Sets the config of this Image.


        :param config: The config of this Image.  # noqa: E501
        :type: ContainerConfig
        """

        self._config = config

    @property
    def architecture(self):
        """Gets the architecture of this Image.  # noqa: E501


        :return: The architecture of this Image.  # noqa: E501
        :rtype: str
        """
        return self._architecture

    @architecture.setter
    def architecture(self, architecture):
        """Sets the architecture of this Image.


        :param architecture: The architecture of this Image.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and architecture is None:
            raise ValueError("Invalid value for `architecture`, must not be `None`")  # noqa: E501

        self._architecture = architecture

    @property
    def os(self):
        """Gets the os of this Image.  # noqa: E501


        :return: The os of this Image.  # noqa: E501
        :rtype: str
        """
        return self._os

    @os.setter
    def os(self, os):
        """Sets the os of this Image.


        :param os: The os of this Image.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and os is None:
            raise ValueError("Invalid value for `os`, must not be `None`")  # noqa: E501

        self._os = os

    @property
    def os_version(self):
        """Gets the os_version of this Image.  # noqa: E501


        :return: The os_version of this Image.  # noqa: E501
        :rtype: str
        """
        return self._os_version

    @os_version.setter
    def os_version(self, os_version):
        """Sets the os_version of this Image.


        :param os_version: The os_version of this Image.  # noqa: E501
        :type: str
        """

        self._os_version = os_version

    @property
    def size(self):
        """Gets the size of this Image.  # noqa: E501


        :return: The size of this Image.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this Image.


        :param size: The size of this Image.  # noqa: E501
        :type: int
        """
        if self._configuration.client_side_validation and size is None:
            raise ValueError("Invalid value for `size`, must not be `None`")  # noqa: E501

        self._size = size

    @property
    def virtual_size(self):
        """Gets the virtual_size of this Image.  # noqa: E501


        :return: The virtual_size of this Image.  # noqa: E501
        :rtype: int
        """
        return self._virtual_size

    @virtual_size.setter
    def virtual_size(self, virtual_size):
        """Sets the virtual_size of this Image.


        :param virtual_size: The virtual_size of this Image.  # noqa: E501
        :type: int
        """
        if self._configuration.client_side_validation and virtual_size is None:
            raise ValueError("Invalid value for `virtual_size`, must not be `None`")  # noqa: E501

        self._virtual_size = virtual_size

    @property
    def graph_driver(self):
        """Gets the graph_driver of this Image.  # noqa: E501


        :return: The graph_driver of this Image.  # noqa: E501
        :rtype: GraphDriverData
        """
        return self._graph_driver

    @graph_driver.setter
    def graph_driver(self, graph_driver):
        """Sets the graph_driver of this Image.


        :param graph_driver: The graph_driver of this Image.  # noqa: E501
        :type: GraphDriverData
        """
        if self._configuration.client_side_validation and graph_driver is None:
            raise ValueError("Invalid value for `graph_driver`, must not be `None`")  # noqa: E501

        self._graph_driver = graph_driver

    @property
    def root_fs(self):
        """Gets the root_fs of this Image.  # noqa: E501


        :return: The root_fs of this Image.  # noqa: E501
        :rtype: ImageRootFS
        """
        return self._root_fs

    @root_fs.setter
    def root_fs(self, root_fs):
        """Sets the root_fs of this Image.


        :param root_fs: The root_fs of this Image.  # noqa: E501
        :type: ImageRootFS
        """
        if self._configuration.client_side_validation and root_fs is None:
            raise ValueError("Invalid value for `root_fs`, must not be `None`")  # noqa: E501

        self._root_fs = root_fs

    @property
    def metadata(self):
        """Gets the metadata of this Image.  # noqa: E501


        :return: The metadata of this Image.  # noqa: E501
        :rtype: ImageMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this Image.


        :param metadata: The metadata of this Image.  # noqa: E501
        :type: ImageMetadata
        """

        self._metadata = metadata

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Image, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Image):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Image):
            return True

        return self.to_dict() != other.to_dict()
